/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsIHelperAppLauncher;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

class Download {
    XPCOMObject supports;
    XPCOMObject download;
    XPCOMObject progressDialog;
    XPCOMObject webProgressListener;
    nsIHelperAppLauncher helperAppLauncher;
    int refCount = 0;
    Shell shell;
    Label status;
    Button cancel;

    Download() {
        this.createCOMInterfaces();
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    void createCOMInterfaces() {
        this.supports = new XPCOMObject(new int[]{2, 0, 0}){

            @Override
            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return Download.this.Release();
            }
        };
        this.download = new XPCOMObject(new int[]{2, 0, 0, 7, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1}){

            @Override
            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return Download.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return Download.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            @Override
            public long method4(long[] args) {
                return Download.this.GetSource(args[0]);
            }

            @Override
            public long method5(long[] args) {
                return Download.this.GetTarget(args[0]);
            }

            @Override
            public long method6(long[] args) {
                return Download.this.GetPersist(args[0]);
            }

            @Override
            public long method7(long[] args) {
                return Download.this.GetPercentComplete(args[0]);
            }

            @Override
            public long method8(long[] args) {
                return Download.this.GetDisplayName(args[0]);
            }

            @Override
            public long method9(long[] args) {
                return Download.this.SetDisplayName(args[0]);
            }

            @Override
            public long method10(long[] args) {
                return Download.this.GetStartTime(args[0]);
            }

            @Override
            public long method11(long[] args) {
                return Download.this.GetMIMEInfo(args[0]);
            }

            @Override
            public long method12(long[] args) {
                return Download.this.GetListener(args[0]);
            }

            @Override
            public long method13(long[] args) {
                return Download.this.SetListener(args[0]);
            }

            @Override
            public long method14(long[] args) {
                return Download.this.GetObserver(args[0]);
            }

            @Override
            public long method15(long[] args) {
                return Download.this.SetObserver(args[0]);
            }
        };
        this.progressDialog = new XPCOMObject(new int[]{2, 0, 0, 7, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1}){

            @Override
            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return Download.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return Download.this.Init(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
            }

            @Override
            public long method4(long[] args) {
                return Download.this.GetSource(args[0]);
            }

            @Override
            public long method5(long[] args) {
                return Download.this.GetTarget(args[0]);
            }

            @Override
            public long method6(long[] args) {
                return Download.this.GetPersist(args[0]);
            }

            @Override
            public long method7(long[] args) {
                return Download.this.GetPercentComplete(args[0]);
            }

            @Override
            public long method8(long[] args) {
                return Download.this.GetDisplayName(args[0]);
            }

            @Override
            public long method9(long[] args) {
                return Download.this.SetDisplayName(args[0]);
            }

            @Override
            public long method10(long[] args) {
                return Download.this.GetStartTime(args[0]);
            }

            @Override
            public long method11(long[] args) {
                return Download.this.GetMIMEInfo(args[0]);
            }

            @Override
            public long method12(long[] args) {
                return Download.this.GetListener(args[0]);
            }

            @Override
            public long method13(long[] args) {
                return Download.this.SetListener(args[0]);
            }

            @Override
            public long method14(long[] args) {
                return Download.this.GetObserver(args[0]);
            }

            @Override
            public long method15(long[] args) {
                return Download.this.SetObserver(args[0]);
            }

            @Override
            public long method16(long[] args) {
                return Download.this.Open(args[0]);
            }

            @Override
            public long method17(long[] args) {
                return Download.this.GetCancelDownloadOnClose(args[0]);
            }

            @Override
            public long method18(long[] args) {
                return Download.this.SetCancelDownloadOnClose((int)args[0]);
            }

            @Override
            public long method19(long[] args) {
                return Download.this.GetDialog(args[0]);
            }

            @Override
            public long method20(long[] args) {
                return Download.this.SetDialog(args[0]);
            }
        };
        this.webProgressListener = new XPCOMObject(new int[]{2, 0, 0, 4, 6, 3, 4, 3}){

            @Override
            public long method0(long[] args) {
                return Download.this.QueryInterface(args[0], args[1]);
            }

            @Override
            public long method1(long[] args) {
                return Download.this.AddRef();
            }

            @Override
            public long method2(long[] args) {
                return Download.this.Release();
            }

            @Override
            public long method3(long[] args) {
                return Download.this.OnStateChange(args[0], args[1], (int)args[2], (int)args[3]);
            }

            @Override
            public long method4(long[] args) {
                return Download.this.OnProgressChange(args[0], args[1], (int)args[2], (int)args[3], (int)args[4], (int)args[5]);
            }

            @Override
            public long method5(long[] args) {
                return Download.this.OnLocationChange(args[0], args[1], args[2]);
            }

            @Override
            public long method6(long[] args) {
                return Download.this.OnStatusChange(args[0], args[1], (int)args[2], args[3]);
            }

            @Override
            public long method7(long[] args) {
                return Download.this.OnSecurityChange(args[0], args[1], (int)args[2]);
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.download != null) {
            this.download.dispose();
            this.download = null;
        }
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
            this.progressDialog = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
    }

    long getAddress() {
        return this.progressDialog.getAddress();
    }

    int QueryInterface(long riid, long ppvObject) {
        if (riid == 0L || ppvObject == 0L) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(XPCOM.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.supports.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IDOWNLOAD_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.download.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(XPCOM.NS_IPROGRESSDIALOG_IID)) {
            XPCOM.memmove(ppvObject, new long[]{this.progressDialog.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(IIDStore.GetIID(nsIWebProgressListener.class))) {
            XPCOM.memmove(ppvObject, new long[]{this.webProgressListener.getAddress()}, (long)C.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new long[]{0L}, (long)C.PTR_SIZEOF);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int Init(long aSource, long aTarget, long aDisplayName, long aMIMEInfo, long startTime1, long startTime2, long aPersist) {
        nsISupports target;
        nsIURI source = new nsIURI(aSource);
        long aSpec = XPCOM.nsEmbedCString_new();
        int rc = source.GetHost(aSpec);
        if (rc != 0) {
            Mozilla.error(rc);
        }
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        long buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, (long)length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String url = new String(dest);
        String filename = null;
        nsISupports supports = new nsISupports(aTarget);
        long[] result = new long[1];
        rc = supports.QueryInterface(IIDStore.GetIID(nsIURI.class), result);
        if (rc == 0) {
            target = new nsIURI(result[0]);
            result[0] = 0L;
            long aPath = XPCOM.nsEmbedCString_new();
            rc = ((nsIURI)target).GetPath(aPath);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            length = XPCOM.nsEmbedCString_Length(aPath);
            buffer = XPCOM.nsEmbedCString_get(aPath);
            dest = new byte[length];
            XPCOM.memmove(dest, buffer, (long)length);
            XPCOM.nsEmbedCString_delete(aPath);
            filename = new String(dest);
            int separator = filename.lastIndexOf(System.getProperty("file.separator"));
            filename = filename.substring(separator + 1);
            target.Release();
        } else {
            target = new nsILocalFile(aTarget);
            nsEmbedString aNativeTarget = new nsEmbedString();
            rc = ((nsIFile)target).GetLeafName(aNativeTarget.getAddress());
            if (rc != 0) {
                Mozilla.error(rc);
            }
            filename = aNativeTarget.toString();
            aNativeTarget.dispose();
        }
        Listener listener = event -> {
            if (event.widget == this.cancel) {
                this.shell.close();
            }
            if (this.helperAppLauncher != null) {
                this.helperAppLauncher.Cancel();
                this.helperAppLauncher.Release();
            }
            this.shell = null;
            this.helperAppLauncher = null;
        };
        this.shell = new Shell(2144);
        String msg = Compatibility.getMessage("SWT_Download_File", new Object[]{filename});
        this.shell.setText(msg);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 15;
        gridLayout.marginWidth = 15;
        gridLayout.verticalSpacing = 20;
        this.shell.setLayout(gridLayout);
        msg = Compatibility.getMessage("SWT_Download_Location", new Object[]{filename, url});
        new Label(this.shell, 64).setText(msg);
        this.status = new Label(this.shell, 64);
        msg = Compatibility.getMessage("SWT_Download_Started");
        this.status.setText(msg);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.status.setLayoutData(data);
        this.cancel = new Button(this.shell, 8);
        this.cancel.setText(SWT.getMessage("SWT_Cancel"));
        data = new GridData();
        data.horizontalAlignment = 2;
        this.cancel.setLayoutData(data);
        this.cancel.addListener(13, listener);
        this.shell.addListener(21, listener);
        this.shell.pack();
        this.shell.open();
        return 0;
    }

    int GetSource(long aSource) {
        return -2147467263;
    }

    int GetTarget(long aTarget) {
        return -2147467263;
    }

    int GetPersist(long aPersist) {
        return -2147467263;
    }

    int GetPercentComplete(long aPercentComplete) {
        return -2147467263;
    }

    int GetDisplayName(long aDisplayName) {
        return -2147467263;
    }

    int SetDisplayName(long aDisplayName) {
        return -2147467263;
    }

    int GetStartTime(long aStartTime) {
        return -2147467263;
    }

    int GetMIMEInfo(long aMIMEInfo) {
        return -2147467263;
    }

    int GetListener(long aListener) {
        return -2147467263;
    }

    int SetListener(long aListener) {
        return -2147467263;
    }

    int GetObserver(long aObserver) {
        return -2147467263;
    }

    int SetObserver(long aObserver) {
        if (aObserver != 0L) {
            nsISupports supports = new nsISupports(aObserver);
            long[] result = new long[1];
            int rc = supports.QueryInterface(IIDStore.GetIID(nsIHelperAppLauncher.class), result);
            if (rc != 0) {
                Mozilla.error(rc);
            }
            if (result[0] == 0L) {
                Mozilla.error(-2147467262);
            }
            this.helperAppLauncher = new nsIHelperAppLauncher(result[0]);
        }
        return 0;
    }

    int Open(long aParent) {
        return -2147467263;
    }

    int GetCancelDownloadOnClose(long aCancelDownloadOnClose) {
        return -2147467263;
    }

    int SetCancelDownloadOnClose(int aCancelDownloadOnClose) {
        return -2147467263;
    }

    int GetDialog(long aDialog) {
        return -2147467263;
    }

    int SetDialog(long aDialog) {
        return -2147467263;
    }

    int OnStateChange(long aWebProgress, long aRequest, int aStateFlags, int aStatus) {
        if ((aStateFlags & 0x10) != 0) {
            if (this.helperAppLauncher != null) {
                this.helperAppLauncher.Release();
            }
            this.helperAppLauncher = null;
            if (this.shell != null && !this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.shell = null;
        }
        return 0;
    }

    int OnProgressChange(long aWebProgress, long aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        int currentKBytes = aCurTotalProgress / 1024;
        int totalKBytes = aMaxTotalProgress / 1024;
        if (this.shell != null && !this.shell.isDisposed()) {
            Object[] arguments = new Object[]{new Integer(currentKBytes), new Integer(totalKBytes)};
            String statusMsg = Compatibility.getMessage("SWT_Download_Status", arguments);
            this.status.setText(statusMsg);
            this.shell.layout(true);
            this.shell.getDisplay().update();
        }
        return 0;
    }

    int OnLocationChange(long aWebProgress, long aRequest, long aLocation) {
        return 0;
    }

    int OnStatusChange(long aWebProgress, long aRequest, int aStatus, long aMessage) {
        return 0;
    }

    int OnSecurityChange(long aWebProgress, long aRequest, int state) {
        return 0;
    }
}

