/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkImage;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TypedListener;

public class TrayItem
extends Item {
    Tray parent;
    ToolTip toolTip;
    String toolTipText;
    long imageHandle;
    long tooltipsHandle;
    ImageList imageList;
    Image highlightImage;

    public TrayItem(Tray parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.parent.createItem(this, index);
    }

    @Override
    void createHandle(int index) {
        this.state |= 8;
        this.handle = OS.gtk_status_icon_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        this.imageHandle = OS.gtk_image_new();
        OS.gtk_status_icon_set_visible(this.handle, true);
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.imageHandle);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Tray getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Image getHighlightImage() {
        this.checkWidget();
        return this.highlightImage;
    }

    public ToolTip getToolTip() {
        this.checkWidget();
        return this.toolTip;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    long gtk_activate(long widget) {
        this.sendSelectionEvent(13);
        long nextEvent = OS.gdk_event_peek();
        if (nextEvent != 0L) {
            int nextEventType = OS.GDK_EVENT_TYPE(nextEvent);
            long currEvent = OS.gtk_get_current_event();
            int currEventType = 0;
            if (currEvent != 0L) {
                currEventType = OS.GDK_EVENT_TYPE(currEvent);
                OS.gdk_event_free(currEvent);
            }
            OS.gdk_event_free(nextEvent);
            if (currEventType == 4 && nextEventType == 5) {
                this.sendSelectionEvent(14);
            }
        }
        return 0L;
    }

    @Override
    long gtk_button_press_event(long widget, long eventPtr) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
        if (gdkEvent.type == 6) {
            return 0L;
        }
        if (gdkEvent.button == 3 && gdkEvent.type == 4) {
            this.sendEvent(35);
            return 0L;
        }
        if (gdkEvent.type == 5) {
            this.sendSelectionEvent(14);
        } else {
            this.sendSelectionEvent(13);
        }
        return 0L;
    }

    @Override
    long gtk_size_allocate(long widget, long allocation) {
        if (this.image != null && this.image.mask != 0L && OS.gdk_drawable_get_depth(this.image.mask) == 1) {
            GtkAllocation widgetAllocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(widget, widgetAllocation);
            int xoffset = (int)Math.floor((double)widgetAllocation.x + (double)(widgetAllocation.width - OS.GTK_WIDGET_REQUISITION_WIDTH(widget)) * 0.5 + 0.5);
            int yoffset = (int)Math.floor((double)widgetAllocation.y + (double)(widgetAllocation.height - OS.GTK_WIDGET_REQUISITION_HEIGHT(widget)) * 0.5 + 0.5);
            Rectangle b = this.image.getBoundsInPixels();
            long gdkImagePtr = OS.gdk_drawable_get_image(this.image.mask, 0, 0, b.width, b.height);
            if (gdkImagePtr == 0L) {
                this.error(2);
            }
            GdkImage gdkImage = new GdkImage();
            OS.memmove(gdkImage, gdkImagePtr);
            byte[] maskData = new byte[gdkImage.bpl * gdkImage.height];
            OS.memmove(maskData, gdkImage.mem, (long)maskData.length);
            OS.g_object_unref(gdkImagePtr);
            Region region = new Region(this.display);
            for (int y = 0; y < b.height; ++y) {
                for (int x = 0; x < b.width; ++x) {
                    int index = y * gdkImage.bpl + (x >> 3);
                    int theByte = maskData[index] & 0xFF;
                    int mask = 1 << (x & 7);
                    if ((theByte & mask) == 0) continue;
                    Rectangle rect = DPIUtil.autoScaleDown(new Rectangle(xoffset + x, yoffset + y, 1, 1));
                    region.add(rect.x, rect.y, rect.width, rect.height);
                }
            }
            OS.gtk_widget_realize(this.handle);
            long window = this.gtk_widget_get_window(this.handle);
            OS.gdk_window_shape_combine_region(window, region.handle, 0, 0);
            region.dispose();
        }
        return 0L;
    }

    @Override
    long gtk_status_icon_popup_menu(long widget, long button, long activate_time) {
        Display display = this.display;
        display.currentTrayItem = this;
        this.sendEvent(35);
        if (!this.isDisposed()) {
            display.runPopups();
        }
        display.currentTrayItem = null;
        return 0L;
    }

    @Override
    void hookEvents() {
        OS.g_signal_connect_closure(this.handle, OS.activate, this.display.getClosure(1), false);
        OS.g_signal_connect_closure(this.handle, OS.popup_menu, this.display.getClosure(63), false);
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.gtk_status_icon_get_visible(this.handle);
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.imageHandle, this);
    }

    @Override
    void releaseHandle() {
        if (this.handle != 0L) {
            OS.g_object_unref(this.handle);
        }
        this.imageHandle = 0L;
        this.handle = 0L;
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.tooltipsHandle != 0L) {
            OS.g_object_unref(this.tooltipsHandle);
        }
        this.tooltipsHandle = 0L;
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        this.toolTipText = null;
        this.highlightImage = null;
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setHighlightImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.highlightImage = image;
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            int imageIndex;
            if (this.imageList == null) {
                this.imageList = new ImageList();
            }
            if ((imageIndex = this.imageList.indexOf(image)) == -1) {
                imageIndex = this.imageList.add(image);
            } else {
                this.imageList.put(imageIndex, image);
            }
            long pixbuf = this.imageList.getPixbuf(imageIndex);
            OS.gtk_status_icon_set_from_pixbuf(this.handle, pixbuf);
            OS.gtk_status_icon_set_visible(this.handle, true);
        } else {
            OS.gtk_widget_set_size_request(this.handle, 1, 1);
            OS.gtk_status_icon_set_from_pixbuf(this.handle, 0L);
            OS.gtk_status_icon_set_visible(this.handle, false);
        }
    }

    public void setToolTip(ToolTip toolTip) {
        this.checkWidget();
        ToolTip oldTip = this.toolTip;
        ToolTip newTip = toolTip;
        if (oldTip != null) {
            oldTip.item = null;
        }
        this.toolTip = newTip;
        if (newTip != null) {
            newTip.item = this;
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        byte[] buffer = null;
        if (string != null && string.length() > 0) {
            buffer = Converter.wcsToMbcs(string, true);
        }
        OS.gtk_status_icon_set_tooltip_text(this.handle, buffer);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (OS.gtk_status_icon_get_visible(this.handle) == visible) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.gtk_status_icon_set_visible(this.handle, visible);
        } else {
            OS.gtk_status_icon_set_visible(this.handle, visible);
            this.sendEvent(23);
        }
    }
}

