/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.FileUtil;
import java.util.concurrent.atomic.AtomicLong;

public interface CoreOperationTask {
    public String getName();

    public DownloadManager getDownload();

    default public String[] getAffectedFileSystems() {
        DownloadManager dm = this.getDownload();
        if (dm != null) {
            return FileUtil.getFileStoreNames(dm.getAbsoluteSaveLocation());
        }
        return null;
    }

    public boolean runOperation(CoreOperation var1);

    public ProgressCallback getProgressCallback();

    public static interface ProgressCallback
    extends Comparable<ProgressCallback> {
        public static final int ST_NONE = 0;
        public static final int ST_PAUSE = 1;
        public static final int ST_RESUME = 2;
        public static final int ST_CANCEL = 4;
        public static final int ST_SUBTASKS = 8;
        public static final int ST_QUEUED = 16;
        public static final int ST_MINIMIZE = 32;
        public static final int ST_BUTTONS = 7;
        public static final int STYLE_NONE = 0;
        public static final int STYLE_NO_CLOSE = 1;
        public static final int STYLE_MODAL = 2;
        public static final int STYLE_MINIMIZE = 4;

        default public long getAllocID() {
            return 0L;
        }

        default public long getSortParam() {
            return -1L;
        }

        default public int getStyle() {
            return 0;
        }

        public int getProgress();

        default public void setProgress(int thousandths) {
        }

        public long getSize();

        public void setSize(long var1);

        public String getSubTaskName();

        default public void setSubTaskName(String name) {
        }

        default public int getDelay() {
            return 0;
        }

        public boolean isAutoPause();

        public void setAutoPause(boolean var1);

        public int getIndicativeOrder();

        public void setIndicativeOrder(int var1);

        public int getSupportedTaskStates();

        public int getTaskState();

        public void setTaskState(int var1);
    }

    public static class ProgressCallbackAdapter
    implements ProgressCallback {
        public static final int SORT_ALLOC_ORDER = 1;
        public static final int SORT_SIZE = 2;
        public static final int SORT_EXPLICIT_ORDER = 3;
        private static final AtomicLong alloc_id_next = new AtomicLong();
        private final long alloc_id = alloc_id_next.incrementAndGet();
        private final int sort_type;
        private final long sort_param;
        private volatile int thousandths;
        private volatile long size;
        private volatile int state = 0;
        private volatile String subtask;
        private volatile boolean auto_pause;
        private volatile int order;

        public ProgressCallbackAdapter() {
            this(1);
        }

        public ProgressCallbackAdapter(int _sort_type) {
            this.sort_type = _sort_type;
            this.sort_param = -1L;
        }

        public ProgressCallbackAdapter(int _sort_type, long _sort_param) {
            this.sort_type = _sort_type;
            this.sort_param = _sort_param;
        }

        @Override
        public long getAllocID() {
            return this.alloc_id;
        }

        @Override
        public long getSortParam() {
            return this.sort_param;
        }

        @Override
        public int getProgress() {
            return this.thousandths;
        }

        @Override
        public void setProgress(int _thousandths) {
            this.thousandths = _thousandths;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public void setSize(long _size) {
            this.size = _size;
        }

        @Override
        public String getSubTaskName() {
            return this.subtask;
        }

        @Override
        public void setSubTaskName(String name) {
            this.subtask = name;
        }

        @Override
        public boolean isAutoPause() {
            return this.auto_pause;
        }

        @Override
        public void setAutoPause(boolean b) {
            this.auto_pause = b;
        }

        @Override
        public int getIndicativeOrder() {
            return this.order;
        }

        @Override
        public void setIndicativeOrder(int _order) {
            this.order = _order;
        }

        @Override
        public int getSupportedTaskStates() {
            return this.state;
        }

        @Override
        public void setTaskState(int _state) {
            if (_state == 2) {
                _state = 0;
            }
            this.state = _state;
        }

        @Override
        public int getTaskState() {
            return this.state;
        }

        @Override
        public int compareTo(ProgressCallback o) {
            long metric;
            if (this.sort_type == 2) {
                metric = this.getSize() - o.getSize();
            } else if (this.sort_type == 1) {
                metric = this.getAllocID() - o.getAllocID();
            } else {
                long s1 = this.getSortParam();
                long s2 = o.getSortParam();
                metric = s1 == -1L && s2 == -1L ? this.getAllocID() - o.getAllocID() : (s1 == -1L ? 1L : (s2 == -1L ? -1L : s1 - s2));
            }
            if (metric < 0L) {
                return -1;
            }
            if (metric > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

