/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.config;

import com.biglybt.core.config.COConfigurationListener;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.protocol.AzURLStreamHandlerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class COConfigurationManager {
    public static final int CONFIG_DEFAULT_MIN_MAX_UPLOAD_SPEED = 5;
    public static final int CONFIG_DEFAULT_MAX_DOWNLOAD_SPEED = 0;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_PER_TORRENT = 50;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_GLOBAL = 250;
    public static final int CONFIG_CACHE_SIZE_MAX_MB;
    public static final boolean ENABLE_MULTIPLE_UDP_PORTS = false;
    public static final int MAX_DATA_SOCKS_PROXIES = 3;
    private static boolean pre_initialised;
    private static boolean pre_initialising;

    static {
        long mb_1;
        long mb_32;
        long max_mem_bytes = Runtime.getRuntime().maxMemory();
        int size = (int)((max_mem_bytes - (mb_32 = 32L * (mb_1 = 0x100000L))) / mb_1);
        if (size > 2000) {
            size = 2000;
        }
        if (size < 1) {
            size = 1;
        }
        CONFIG_CACHE_SIZE_MAX_MB = size;
    }

    public static synchronized void preInitialise() {
        if (!pre_initialised) {
            pre_initialised = true;
            try {
                try {
                    block36: {
                        pre_initialising = true;
                        if (System.getProperty(SystemProperties.SYSPROP_PORTABLE_ENABLE, "false").equalsIgnoreCase("true")) {
                            try {
                                boolean write_file;
                                String root_relative;
                                String str;
                                File root_file;
                                block34: {
                                    File portable_root;
                                    if (File.separatorChar != '\\') {
                                        throw new Exception("Portable only supported on Windows");
                                    }
                                    try {
                                        portable_root = new File(".").getCanonicalFile();
                                    }
                                    catch (Throwable e) {
                                        portable_root = new File(".").getAbsoluteFile();
                                    }
                                    if (!portable_root.canWrite()) {
                                        throw new Exception("can't write to " + portable_root);
                                    }
                                    root_file = new File(portable_root, "portable.dat");
                                    str = portable_root.getAbsolutePath();
                                    if (str.length() < 2 || str.charAt(1) != ':') {
                                        throw new Exception("drive letter missing in '" + str + "'");
                                    }
                                    root_relative = str.substring(2);
                                    write_file = true;
                                    if (root_file.exists()) {
                                        try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)FileUtil.newFileInputStream(root_file), "UTF-8"));){
                                            String line = lnr.readLine();
                                            if (line == null) break block34;
                                            if ((line = line.trim()).equalsIgnoreCase(root_relative)) {
                                                write_file = false;
                                                break block34;
                                            }
                                            throw new Exception("root changed - old='" + line + "', new='" + root_relative);
                                        }
                                    }
                                }
                                if (write_file) {
                                    try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)FileUtil.newFileOutputStream(root_file), "UTF-8"));){
                                        pw.println(root_relative);
                                    }
                                }
                                System.setProperty(SystemProperties.SYSPROP_INSTALL_PATH, str);
                                System.setProperty(SystemProperties.SYSPROP_CONFIG_PATH, str);
                                System.setProperty(SystemProperties.SYSPROP_PORTABLE_ROOT, str);
                                System.out.println("Portable setup OK - root=" + root_relative + " (current=" + str + ")");
                            }
                            catch (Throwable e) {
                                System.err.println("Portable setup failed: " + e.getMessage());
                                System.setProperty(SystemProperties.SYSPROP_PORTABLE_ENABLE, "false");
                                System.setProperty(SystemProperties.SYSPROP_PORTABLE_ROOT, "");
                            }
                        } else {
                            System.setProperty(SystemProperties.SYSPROP_PORTABLE_ROOT, "");
                        }
                        String handlers = System.getProperty(SystemProperties.SYSPROP_JAVA_PROTOCOL_HANDLER_PKGS);
                        handlers = handlers == null ? "com.biglybt.core.util.protocol" : String.valueOf(handlers) + "|com.biglybt.core.util.protocol";
                        System.setProperty(SystemProperties.SYSPROP_JAVA_PROTOCOL_HANDLER_PKGS, handlers);
                        try {
                            Security.setProperty("crypto.policy", "unlimited");
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        System.setProperty("sun.net.maxDatagramSockets", "4096");
                        URL.setURLStreamHandlerFactory(new AzURLStreamHandlerFactory());
                        System.setProperty("sun.net.inetaddr.ttl", "60");
                        System.setProperty("networkaddress.cache.ttl", "60");
                        System.setProperty("sun.net.inetaddr.negative.ttl", "300");
                        System.setProperty("networkaddress.cache.negative.ttl", "300");
                        System.setProperty("sun.net.client.defaultConnectTimeout", "120000");
                        System.setProperty("sun.net.client.defaultReadTimeout", "60000");
                        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
                        if (Constants.isJava9OrHigher) {
                            try {
                                if (Constants.isJava18OrHigher) {
                                    Class.forName("com.biglybt.core.util.spi.AENameServiceJava18").getMethod("init", new Class[0]).invoke(null, new Object[0]);
                                    break block36;
                                }
                                if (Constants.isJava12OrHigher) {
                                    Class.forName("com.biglybt.core.util.spi.AENameServiceJava12").getMethod("init", new Class[0]).invoke(null, new Object[0]);
                                    break block36;
                                }
                                Class.forName("com.biglybt.core.util.spi.AENameServiceJava9").getMethod("init", new Class[0]).invoke(null, new Object[0]);
                            }
                            catch (Throwable throwable) {}
                        } else {
                            System.setProperty("sun.net.spi.nameservice.provider.1", "dns,aednsproxy");
                        }
                    }
                    SystemProperties.determineApplicationName();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    pre_initialising = false;
                }
            }
            finally {
                pre_initialising = false;
            }
        } else if (pre_initialising) {
            new Exception("Recursion during pre-init").printStackTrace();
        }
    }

    public static ConfigurationManager initialise() {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance();
    }

    public static ConfigurationManager initialiseFromMap(Map data) {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance(data);
    }

    public static boolean isNewInstall() {
        return ConfigurationManager.getInstance().isNewInstall();
    }

    public static String getStringParameter(String _name) {
        return ConfigurationManager.getInstance().getStringParameter(_name);
    }

    public static String getStringParameter(String _name, String _default) {
        return ConfigurationManager.getInstance().getStringParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, String value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static boolean verifyParameter(String parameter, String value) {
        return ConfigurationManager.getInstance().verifyParameter(parameter, value);
    }

    public static boolean getBooleanParameter(String _name) {
        return ConfigurationManager.getInstance().getBooleanParameter(_name);
    }

    public static boolean getBooleanParameter(String _name, boolean _default) {
        return ConfigurationManager.getInstance().getBooleanParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, boolean value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static int getIntParameter(String _name) {
        return ConfigurationManager.getInstance().getIntParameter(_name);
    }

    public static int getIntParameter(String _name, int _default) {
        return ConfigurationManager.getInstance().getIntParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, int value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static boolean setParameter(String parameter, long value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static long getLongParameter(String _name) {
        return ConfigurationManager.getInstance().getLongParameter(_name);
    }

    public static long getLongParameter(String _name, long _def) {
        return ConfigurationManager.getInstance().getLongParameter(_name, _def);
    }

    public static byte[] getByteParameter(String _name) {
        return ConfigurationManager.getInstance().getByteParameter(_name);
    }

    public static byte[] getByteParameter(String _name, byte[] _default) {
        return ConfigurationManager.getInstance().getByteParameter(_name, _default);
    }

    public static boolean setParameter(String parameter, byte[] value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static String getDirectoryParameter(String _name) throws IOException {
        return ConfigurationManager.getInstance().getDirectoryParameter(_name);
    }

    public static boolean setRGBParameter(String parameter, int red, int green, int blue, Boolean override) {
        return ConfigurationManager.getInstance().setRGBParameter(parameter, red, green, blue, override);
    }

    public static void setRGBDefault(String parameter, int red, int green, int blue) {
        ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
        defaults.addParameter(String.valueOf(parameter) + ".red", red);
        defaults.addParameter(String.valueOf(parameter) + ".green", green);
        defaults.addParameter(String.valueOf(parameter) + ".blue", blue);
    }

    public static boolean setRGBParameter(String parameter, int[] rgb, Boolean override) {
        return ConfigurationManager.getInstance().setRGBParameter(parameter, rgb, override);
    }

    public static int[] getRGBParameter(String parameter) {
        return ConfigurationManager.getInstance().getRGBParameter(parameter);
    }

    public static float getFloatParameter(String _name) {
        return ConfigurationManager.getInstance().getFloatParameter(_name);
    }

    public static float getFloatParameter(String _name, float _def) {
        return ConfigurationManager.getInstance().getFloatParameter(_name, _def);
    }

    public static boolean setParameter(String parameter, float value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static List<String> getStringListParameter(String parameter) {
        return ConfigurationManager.getInstance().getStringListParameter(parameter);
    }

    public static boolean setParameter(String parameter, List value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static List getListParameter(String parameter, List def) {
        return ConfigurationManager.getInstance().getListParameter(parameter, def);
    }

    public static boolean setParameter(String parameter, Map value) {
        return ConfigurationManager.getInstance().setParameter(parameter, value);
    }

    public static Map getMapParameter(String parameter, Map def) {
        return ConfigurationManager.getInstance().getMapParameter(parameter, def);
    }

    public static boolean hasParameter(String parameter, boolean explicit) {
        return ConfigurationManager.getInstance().hasParameter(parameter, explicit);
    }

    public static void save() {
        ConfigurationManager.getInstance().save();
    }

    public static void setDirty() {
        ConfigurationManager.getInstance().setDirty();
    }

    public static void addListener(COConfigurationListener listener) {
        ConfigurationManager.getInstance().addListener(listener);
    }

    public static void addAndFireListener(COConfigurationListener listener) {
        ConfigurationManager.getInstance().addAndFireListener(listener);
    }

    public static void addWeakParameterListener(ParameterListener listener, boolean fireImmediately, String ... parameter) {
        String[] stringArray = parameter;
        int n = parameter.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ConfigurationManager.getInstance().addWeakParameterListener(id, listener);
            ++n2;
        }
        if (fireImmediately) {
            try {
                listener.parameterChanged(parameter.length == 1 ? parameter[0] : null);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void removeWeakParameterListener(ParameterListener listener, String ... parameter) {
        String[] stringArray = parameter;
        int n = parameter.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            ConfigurationManager.getInstance().removeWeakParameterListener(id, listener);
            ++n2;
        }
    }

    public static void addParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().addParameterListener(parameter, listener);
    }

    public static void addParameterListener(String[] ids, ParameterListener listener) {
        ConfigurationManager instance = ConfigurationManager.getInstance();
        int i = 0;
        while (i < ids.length) {
            instance.addParameterListener(ids[i], listener);
            ++i;
        }
    }

    public static void addAndFireParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().addParameterListener(parameter, listener);
        try {
            listener.parameterChanged(parameter);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void addAndFireParameterListeners(String[] parameters, ParameterListener listener) {
        int i = 0;
        while (i < parameters.length) {
            ConfigurationManager.getInstance().addParameterListener(parameters[i], listener);
            ++i;
        }
        try {
            listener.parameterChanged(null);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void removeParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().removeParameterListener(parameter, listener);
    }

    public static void removeParameterListeners(String[] parameters, ParameterListener listener) {
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            ConfigurationManager.getInstance().removeParameterListener(parameter, listener);
            ++n2;
        }
    }

    public static void addAndFireWeakParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().addWeakParameterListener(parameter, listener);
        try {
            listener.parameterChanged(parameter);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void addAndFireWeakParameterListeners(String[] parameters, ParameterListener listener) {
        int i = 0;
        while (i < parameters.length) {
            ConfigurationManager.getInstance().addWeakParameterListener(parameters[i], listener);
            ++i;
        }
        try {
            listener.parameterChanged(null);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static void removeWeakParameterListener(String parameter, ParameterListener listener) {
        ConfigurationManager.getInstance().removeWeakParameterListener(parameter, listener);
    }

    public static void removeWeakParameterListeners(String[] parameters, ParameterListener listener) {
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            ConfigurationManager.getInstance().removeWeakParameterListener(parameter, listener);
            ++n2;
        }
    }

    public static void removeListener(COConfigurationListener listener) {
        ConfigurationManager.getInstance().removeListener(listener);
    }

    public static Set<String> getAllowedParameters() {
        return ConfigurationDefaults.getInstance().getAllowedParameters();
    }

    public static Set<String> getDefinedParameters() {
        return ConfigurationManager.getInstance().getDefinedParameters();
    }

    public static Object getParameter(String name) {
        return ConfigurationManager.getInstance().getParameter(name);
    }

    public static boolean doesParameterDefaultExist(String parameter) {
        return ConfigurationDefaults.getInstance().doesParameterDefaultExist(parameter);
    }

    public static boolean doesParameterNonDefaultExist(String parameter) {
        return ConfigurationManager.getInstance().doesParameterNonDefaultExist(parameter);
    }

    public static void registerExternalDefaults(Map addmap) {
        ConfigurationDefaults.getInstance().registerExternalDefaults(addmap);
    }

    public static void setBooleanDefault(String parameter, boolean _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setFloatDefault(String parameter, float _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setIntDefault(String parameter, int _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setLongDefault(String parameter, long _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setStringDefault(String parameter, String _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static void setByteDefault(String parameter, byte[] _default) {
        ConfigurationDefaults.getInstance().addParameter(parameter, _default);
    }

    public static Object getDefault(String parameter) {
        return ConfigurationDefaults.getInstance().getParameter(parameter);
    }

    public static boolean removeParameter(String parameter) {
        return ConfigurationManager.getInstance().removeParameter(parameter);
    }

    public static boolean removeRGBParameter(String parameter) {
        return ConfigurationManager.getInstance().removeRGBParameter(parameter);
    }

    public static void registerExportedParameter(String name, String key) {
        ConfigurationManager.getInstance().registerExportedParameter(name, key);
    }

    public static void resetToDefaults() {
        ConfigurationManager.getInstance().resetToDefaults();
    }

    public static void addResetToDefaultsListener(ResetToDefaultsListener l) {
        ConfigurationManager.getInstance().addResetToDefaultsListener(l);
    }

    public static void dumpConfigChanges(IndentWriter writer) {
        ConfigurationManager.getInstance().dumpConfigChanges(writer);
    }

    public static interface ParameterVerifier {
        public boolean verify(String var1, Object var2);
    }

    public static interface ResetToDefaultsListener {
        public void reset();
    }
}

