/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.content.ContentDownload;
import com.biglybt.core.content.ContentFile;
import com.biglybt.core.content.PlatformContentDirectory;
import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceUPnP;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.TranscodeTargetListener;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.DeviceManagerImpl;
import com.biglybt.core.devices.impl.DeviceManagerUPnPImpl;
import com.biglybt.core.devices.impl.TranscodeFileImpl;
import com.biglybt.core.devices.impl.TranscodeJobImpl;
import com.biglybt.core.devices.impl.TranscodeJobOutputLeecher;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagListener;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.UUIDGenerator;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPDeviceImage;
import com.biglybt.net.upnp.UPnPRootDevice;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.util.PlayUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DeviceUPnPImpl
extends DeviceImpl
implements DeviceUPnP,
TranscodeTargetListener {
    private static final Object UPNPAV_FILE_KEY = new Object();
    private static final Map<String, ContentFile> acf_map = new WeakHashMap<String, ContentFile>();
    final String MY_ACF_KEY;
    final DeviceManagerUPnPImpl upnp_manager;
    private volatile UPnPDevice device_may_be_null;
    private IPCInterface upnpav_ipc;
    private TranscodeProfile dynamic_transcode_profile;
    private Map<String, ContentFile> dynamic_xcode_map;

    protected static String getDisplayName(UPnPDevice device) {
        String dn;
        UPnPDevice root = device.getRootDevice().getDevice();
        String fn = root.getFriendlyName();
        if (fn == null || fn.length() == 0) {
            fn = device.getFriendlyName();
        }
        if ((dn = root.getModelName()) == null || dn.length() == 0) {
            dn = device.getModelName();
        }
        if (dn != null && dn.length() > 0 && !fn.contains(dn)) {
            fn = String.valueOf(fn) + " (" + dn + ")";
        }
        return fn;
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, UPnPDevice _device, int _type) {
        super(_manager, _type, String.valueOf(_type) + "/" + _device.getRootDevice().getUSN(), DeviceUPnPImpl.getDisplayName(_device), false);
        this.upnp_manager = _manager.getUPnPManager();
        this.setUPnPDevice(_device);
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _classification) {
        super(_manager, _type, UUIDGenerator.generateUUIDString(), _classification, true);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _uuid, String _classification, boolean _manual, String _name) {
        super(_manager, _type, _uuid == null ? UUIDGenerator.generateUUIDString() : _uuid, _classification, _manual, _name);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, int _type, String _uuid, String _classification, boolean _manual) {
        super(_manager, _type, _uuid, _classification, _manual);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected DeviceUPnPImpl(DeviceManagerImpl _manager, Map _map) throws IOException {
        super(_manager, _map);
        this.upnp_manager = _manager.getUPnPManager();
        this.MY_ACF_KEY = this.getACFKey();
    }

    protected String getACFKey() {
        return "DeviceUPnPImpl:device:" + this.getID();
    }

    @Override
    protected boolean updateFrom(DeviceImpl _other, boolean _is_alive) {
        if (!super.updateFrom(_other, _is_alive)) {
            return false;
        }
        if (!(_other instanceof DeviceUPnPImpl)) {
            Debug.out("Inconsistent");
            return false;
        }
        DeviceUPnPImpl other = (DeviceUPnPImpl)_other;
        this.setUPnPDevice(other.device_may_be_null);
        return true;
    }

    @Override
    protected void initialise() {
        super.initialise();
    }

    protected void UPnPInitialised() {
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    protected DeviceManagerUPnPImpl getUPnPDeviceManager() {
        return this.upnp_manager;
    }

    @Override
    public UPnPDevice getUPnPDevice() {
        return this.device_may_be_null;
    }

    protected void setUPnPDevice(UPnPDevice device) {
        this.device_may_be_null = device;
        if (device != null) {
            this.setAddress(this.getAddress());
        }
        this.setDirty(false);
    }

    @Override
    public boolean isBrowsable() {
        return true;
    }

    @Override
    public Device.browseLocation[] getBrowseLocations() {
        ArrayList<DeviceImpl.browseLocationImpl> locs = new ArrayList<DeviceImpl.browseLocationImpl>();
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            int userMode;
            URL presentation = this.getPresentationURL(device);
            if (presentation != null) {
                locs.add(new DeviceImpl.browseLocationImpl("device.upnp.present_url", presentation));
            }
            if ((userMode = COConfigurationManager.getIntParameter("User Mode")) > 1) {
                locs.add(new DeviceImpl.browseLocationImpl("device.upnp.desc_url", device.getRootDevice().getLocation()));
            }
        }
        return locs.toArray(new Device.browseLocation[locs.size()]);
    }

    public boolean canFilterFilesView() {
        return true;
    }

    public void setFilterFilesView(boolean filter2) {
        boolean existing = this.getFilterFilesView();
        if (existing != filter2) {
            this.setPersistentBooleanProperty("rend_filter", filter2);
            IPCInterface ipc = this.upnpav_ipc;
            if (ipc != null) {
                try {
                    ipc.invoke("invalidateDirectory", new Object[0]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getFilterFilesView() {
        return this.getPersistentBooleanProperty("rend_filter", true);
    }

    @Override
    public boolean isLivenessDetectable() {
        return true;
    }

    protected URL getLocation() {
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            UPnPRootDevice root = device.getRootDevice();
            return root.getLocation();
        }
        return null;
    }

    public boolean canAssociate() {
        return true;
    }

    public void associate(DeviceManager.UnassociatedDevice assoc) {
        if (this.isAlive()) {
            return;
        }
        this.setAddress(assoc.getAddress());
        this.alive();
    }

    @Override
    public InetAddress getAddress() {
        try {
            UPnPDevice device = this.device_may_be_null;
            if (device != null) {
                UPnPRootDevice root = device.getRootDevice();
                URL location = root.getLocation();
                return InetAddress.getByName(location.getHost());
            }
            InetAddress address = (InetAddress)this.getTransientProperty("DeviceUPnPImpl:ip");
            if (address != null) {
                return address;
            }
            String last = this.getPersistentStringProperty("rend_ip");
            if (last != null && last.length() > 0) {
                return InetAddress.getByName(last);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    @Override
    public void setAddress(InetAddress address) {
        this.setTransientProperty("DeviceUPnPImpl:ip", address);
        this.setPersistentStringProperty("rend_ip", address.getHostAddress());
    }

    public boolean canRestrictAccess() {
        return true;
    }

    public String getAccessRestriction() {
        return this.getPersistentStringProperty("restrict_access", "");
    }

    public void setAccessRestriction(String str) {
        this.setPersistentStringProperty("restrict_access", str);
    }

    protected URL getStreamURL(TranscodeFileImpl file) {
        return this.getStreamURL(file, null);
    }

    @Override
    protected URL getStreamURL(TranscodeFileImpl file, String host) {
        this.browseReceived();
        return super.getStreamURL(file, host);
    }

    @Override
    protected String getMimeType(TranscodeFileImpl file) {
        this.browseReceived();
        return super.getMimeType(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void browseReceived() {
        int n;
        int n2;
        Object object;
        Object profiles;
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc == null) {
            return;
        }
        TranscodeProfile default_profile = this.getDefaultTranscodeProfile();
        if (default_profile == null) {
            object = profiles = this.getTranscodeProfiles();
            n2 = ((TranscodeProfile[])profiles).length;
            n = 0;
            while (n < n2) {
                TranscodeProfile p = object[n];
                if (p.isStreamable()) {
                    default_profile = p;
                    break;
                }
                ++n;
            }
        }
        profiles = this;
        synchronized (profiles) {
            if (this.upnpav_ipc != null) {
                return;
            }
            this.upnpav_ipc = ipc;
            if (default_profile != null && default_profile.isStreamable()) {
                this.dynamic_transcode_profile = default_profile;
            }
        }
        this.addListener(this);
        TranscodeFileImpl[] transcode_files = this.getFiles();
        object = transcode_files;
        n2 = transcode_files.length;
        n = 0;
        while (n < n2) {
            TranscodeProfile file = object[n];
            this.fileAdded((TranscodeFile)((Object)file), false);
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetUPNPAV() {
        HashSet<String> to_remove = new HashSet<String>();
        Object object = this;
        synchronized (object) {
            TranscodeFileImpl[] transcode_files;
            if (this.upnpav_ipc == null) {
                return;
            }
            this.upnpav_ipc = null;
            this.dynamic_transcode_profile = null;
            this.dynamic_xcode_map = null;
            this.removeListener(this);
            TranscodeFileImpl[] transcodeFileImplArray = transcode_files = this.getFiles();
            int n = transcode_files.length;
            int n2 = 0;
            while (n2 < n) {
                TranscodeFileImpl file = transcodeFileImplArray[n2];
                file.setTransientProperty(UPNPAV_FILE_KEY, null);
                to_remove.add(file.getKey());
                ++n2;
            }
        }
        object = acf_map;
        synchronized (object) {
            for (String key : to_remove) {
                acf_map.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setupStreamXCode(TranscodeFileImpl transcode_file) {
        ContentFile acf;
        TranscodeJobImpl job = transcode_file.getJob();
        if (job == null) {
            return transcode_file.isComplete();
        }
        final String tf_key = transcode_file.getKey();
        Map<String, ContentFile> map = acf_map;
        synchronized (map) {
            acf = acf_map.get(tf_key);
        }
        if (acf != null) {
            return true;
        }
        IPCInterface ipc = this.upnpav_ipc;
        if (ipc == null) {
            return false;
        }
        if (transcode_file.getDurationMillis() == 0L) {
            return false;
        }
        try {
            final TranscodeJobOutputLeecher stream_file = new TranscodeJobOutputLeecher(job, transcode_file);
            acf = new ContentFile(){

                @Override
                public DiskManagerFileInfo getFile() {
                    return stream_file;
                }

                @Override
                public Object getProperty(String name) {
                    if (name.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                        return new Object[]{DeviceUPnPImpl.this, tf_key};
                    }
                    if (name.equals("percent")) {
                        return new Long(1000L);
                    }
                    if (name.equals("eta")) {
                        return new Long(0L);
                    }
                    return null;
                }
            };
            Map<String, ContentFile> map2 = acf_map;
            synchronized (map2) {
                acf_map.put(tf_key, acf);
            }
            ipc.invoke("addContent", new Object[]{acf});
            this.log("Set up stream-xcode for " + transcode_file.getName());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected boolean isVisible(ContentDownload file) {
        if (this.getFilterFilesView() || file == null) {
            return false;
        }
        Download download = file.getDownload();
        if (download == null) {
            return false;
        }
        if (download.isComplete()) {
            return true;
        }
        int numFiles = download.getDiskManagerFileCount();
        int i = 0;
        while (i < numFiles) {
            DiskManagerFileInfo fileInfo2 = download.getDiskManagerFileInfo(i);
            if (fileInfo2 != null && !fileInfo2.isDeleted() && !fileInfo2.isSkipped()) {
                if (fileInfo2.getLength() == fileInfo2.getDownloaded()) {
                    return true;
                }
                if (PlayUtils.canUseEMP(fileInfo2)) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    protected boolean isVisible(ContentFile file) {
        if (this.getFilterFilesView()) {
            Object[] x = (Object[])file.getProperty(this.MY_ACF_KEY);
            if (x != null && x[0] == this) {
                String tf_key = (String)x[1];
                return this.getTranscodeFile(tf_key) != null;
            }
            return false;
        }
        if (file == null) {
            return false;
        }
        DiskManagerFileInfo fileInfo2 = file.getFile();
        if (fileInfo2 == null || fileInfo2.isDeleted() || fileInfo2.isSkipped()) {
            return false;
        }
        if (fileInfo2.getLength() == fileInfo2.getDownloaded()) {
            return true;
        }
        return PlayUtils.canUseEMP(fileInfo2);
    }

    @Override
    public void fileAdded(TranscodeFile _transcode_file) {
        this.fileAdded(_transcode_file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileAdded(TranscodeFile _transcode_file, boolean _new_file) {
        TranscodeFileImpl transcode_file = (TranscodeFileImpl)_transcode_file;
        IPCInterface ipc = this.upnpav_ipc;
        DeviceUPnPImpl deviceUPnPImpl = this;
        synchronized (deviceUPnPImpl) {
            if (ipc == null) {
                return;
            }
            if (!transcode_file.isComplete()) {
                this.syncCategoriesAndTags(transcode_file, _new_file);
                return;
            }
            ContentFile acf = (ContentFile)transcode_file.getTransientProperty(UPNPAV_FILE_KEY);
            if (acf != null) {
                return;
            }
            final String tf_key = transcode_file.getKey();
            Map<String, ContentFile> map = acf_map;
            synchronized (map) {
                acf = acf_map.get(tf_key);
            }
            if (acf != null) {
                return;
            }
            try {
                final DiskManagerFileInfo f = transcode_file.getTargetFile();
                acf = new ContentFile(){

                    @Override
                    public DiskManagerFileInfo getFile() {
                        return f;
                    }

                    @Override
                    public Object getProperty(String name) {
                        if (name.equals(DeviceUPnPImpl.this.MY_ACF_KEY)) {
                            return new Object[]{DeviceUPnPImpl.this, tf_key};
                        }
                        if (name.equals("cats")) {
                            TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                            if (tf != null) {
                                return tf.getCategories();
                            }
                            return new String[0];
                        }
                        if (name.equals("tags")) {
                            TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                            if (tf != null) {
                                return tf.getTags(true);
                            }
                            return new String[0];
                        }
                        if (name.equals("title")) {
                            TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                            if (tf != null) {
                                return tf.getName();
                            }
                        } else {
                            TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                            if (tf != null) {
                                long res = 0L;
                                if (name.equals("duration")) {
                                    res = tf.getDurationMillis();
                                } else if (name.equals("video_width")) {
                                    res = tf.getVideoWidth();
                                } else if (name.equals("video_height")) {
                                    res = tf.getVideoHeight();
                                } else if (name.equals("date")) {
                                    res = tf.getCreationDateMillis();
                                } else {
                                    if (name.equals("percent")) {
                                        TranscodeJobImpl job;
                                        res = tf.isComplete() ? 1000L : ((job = tf.getJob()) == null ? 0L : (long)(10 * job.getPercentComplete()));
                                        return res;
                                    }
                                    if (name.equals("eta")) {
                                        TranscodeJobImpl job;
                                        res = tf.isComplete() ? 0L : ((job = tf.getJob()) == null ? Long.MAX_VALUE : job.getETASecs());
                                        return res;
                                    }
                                }
                                if (res > 0L) {
                                    return new Long(res);
                                }
                            }
                        }
                        return null;
                    }
                };
                transcode_file.setTransientProperty(UPNPAV_FILE_KEY, acf);
                Map<String, ContentFile> map2 = acf_map;
                synchronized (map2) {
                    acf_map.put(tf_key, acf);
                }
                this.syncCategoriesAndTags(transcode_file, _new_file);
                try {
                    ipc.invoke("addContent", new Object[]{acf});
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            catch (TranscodeException transcodeException) {
                // empty catch block
            }
        }
    }

    protected void syncCategoriesAndTags(TranscodeFileImpl tf, boolean inherit_from_download) {
        try {
            final Download dl = tf.getSourceFile().getDownload();
            if (dl != null) {
                if (inherit_from_download) {
                    this.setCategories(tf, dl);
                    this.setTags(tf, dl);
                }
                final String tf_key = tf.getKey();
                dl.addAttributeListener(new DownloadAttributeListener(){

                    @Override
                    public void attributeEventOccurred(Download download, TorrentAttribute attribute, int eventType) {
                        TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                        if (tf != null) {
                            DeviceUPnPImpl.this.setCategories(tf, download);
                        } else {
                            dl.removeAttributeListener(this, DeviceUPnPImpl.this.upnp_manager.getCategoryAttibute(), 1);
                        }
                    }
                }, this.upnp_manager.getCategoryAttibute(), 1);
                TagManagerFactory.getTagManager().getTagType(3).addTagListener(PluginCoreUtils.unwrap(dl), new TagListener(){

                    @Override
                    public void taggableSync(Tag tag) {
                    }

                    @Override
                    public void taggableRemoved(Tag tag, Taggable tagged) {
                        this.update(tagged);
                    }

                    @Override
                    public void taggableAdded(Tag tag, Taggable tagged) {
                        this.update(tagged);
                    }

                    private void update(Taggable tagged) {
                        TranscodeFileImpl tf = DeviceUPnPImpl.this.getTranscodeFile(tf_key);
                        if (tf != null) {
                            DeviceUPnPImpl.this.setTags(tf, dl);
                        } else {
                            TagManagerFactory.getTagManager().getTagType(3).removeTagListener(tagged, this);
                        }
                    }
                });
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setCategories(TranscodeFileImpl tf, Download dl) {
        String cat = dl.getCategoryName();
        if (cat != null && cat.length() > 0 && !cat.equals("Categories.uncategorized")) {
            tf.setCategories(new String[]{cat});
        } else {
            tf.setCategories(new String[0]);
        }
    }

    protected void setTags(TranscodeFileImpl tf, Download dl) {
        List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(PluginCoreUtils.unwrap(dl));
        ArrayList<String> tag_names = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag.getTagType().getTagType() != 3) continue;
            tag_names.add(String.valueOf(tag.getTagUID()));
        }
        tf.setTags(tag_names.toArray(new String[tag_names.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(TranscodeFile file, int type, Object data) {
        if (file.isComplete()) {
            this.fileAdded(file, false);
        }
        if (type == 1 && (data == "cat" || data == "tags")) {
            ContentFile acf;
            Map<String, ContentFile> map = acf_map;
            synchronized (map) {
                acf = acf_map.get(((TranscodeFileImpl)file).getKey());
            }
            if (acf != null) {
                if (data == "tags") {
                    PlatformContentDirectory.fireTagsChanged(acf);
                } else {
                    PlatformContentDirectory.fireCatsChanged(acf);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileRemoved(TranscodeFile file) {
        IPCInterface ipc = this.upnp_manager.getUPnPAVIPC();
        if (ipc == null) {
            return;
        }
        Object object = this;
        synchronized (object) {
            ContentFile acf = (ContentFile)file.getTransientProperty(UPNPAV_FILE_KEY);
            if (acf == null) {
                return;
            }
            file.setTransientProperty(UPNPAV_FILE_KEY, null);
            try {
                ipc.invoke("removeContent", new Object[]{acf});
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        object = acf_map;
        synchronized (object) {
            acf_map.remove(((TranscodeFileImpl)file).getKey());
        }
    }

    protected URL getPresentationURL(UPnPDevice device) {
        String presentation = device.getRootDevice().getDevice().getPresentation();
        if (presentation != null) {
            try {
                URL url = new URL(presentation);
                return url;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected void getDisplayProperties(List<String[]> dp) {
        super.getDisplayProperties(dp);
        UPnPDevice device = this.device_may_be_null;
        if (device != null) {
            UPnPRootDevice root = device.getRootDevice();
            URL location = root.getLocation();
            this.addDP(dp, "dht.reseed.ip", String.valueOf(location.getHost()) + ":" + location.getPort());
            String model_details = device.getModelName();
            String model_url = device.getModelURL();
            if (model_url != null && model_url.length() > 0) {
                model_details = String.valueOf(model_details) + " (" + model_url + ")";
            }
            String manu_details = device.getManufacturer();
            String manu_url = device.getManufacturerURL();
            if (manu_url != null && manu_url.length() > 0) {
                manu_details = String.valueOf(manu_details) + " (" + manu_url + ")";
            }
            this.addDP(dp, "device.model.desc", device.getModelDescription());
            this.addDP(dp, "device.model.name", model_details);
            this.addDP(dp, "device.model.num", device.getModelNumber());
            this.addDP(dp, "device.manu.desc", manu_details);
        } else {
            InetAddress ia = this.getAddress();
            if (ia != null) {
                this.addDP(dp, "dht.reseed.ip", ia.getHostAddress());
            }
        }
        this.addDP(dp, "!Is Liveness Detectable!", this.isLivenessDetectable());
        if (this.isManual()) {
            this.addDP(dp, "azbuddy.ui.table.online", this.isAlive());
            this.addDP(dp, "device.lastseen", this.getLastSeen() == 0L ? "" : DisplayFormatters.formatDateYMDHM(this.getLastSeen()));
        }
    }

    @Override
    public void generate(IndentWriter writer) {
        super.generate(writer);
        try {
            writer.indent();
            UPnPDevice device = this.device_may_be_null;
            if (device == null) {
                writer.println("upnp_device=null");
            } else {
                writer.println("upnp_device=" + device.getFriendlyName());
            }
            writer.println("dyn_xcode=" + (this.dynamic_transcode_profile == null ? "null" : this.dynamic_transcode_profile.getName()));
        }
        finally {
            writer.exdent();
        }
    }

    @Override
    public String getImageID() {
        URL location;
        UPnPDeviceImage[] images;
        String imageID = super.getImageID();
        if (this.device_may_be_null != null && this.isAlive() && (images = this.device_may_be_null.getImages()).length > 0 && (location = this.getLocation()) != null) {
            String url = "http://" + location.getHost() + ":" + location.getPort();
            String imageUrl = images[0].getLocation();
            UPnPDeviceImage[] uPnPDeviceImageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                UPnPDeviceImage imageInfo = uPnPDeviceImageArray[n2];
                String mime = imageInfo.getLocation();
                if (mime != null && mime.contains("png")) {
                    imageUrl = imageInfo.getLocation();
                    break;
                }
                ++n2;
            }
            if (!imageUrl.startsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            url = String.valueOf(url) + imageUrl;
            return url;
        }
        return imageID;
    }

    @Override
    public List<String> getImageIDs() {
        URL location;
        UPnPDeviceImage[] images;
        List<String> imageIDs = super.getImageIDs();
        if (this.device_may_be_null != null && this.isAlive() && (images = this.device_may_be_null.getImages()).length > 0 && (location = this.getLocation()) != null) {
            ArrayList<String> urls = new ArrayList<String>();
            String url = "http://" + location.getHost() + ":" + location.getPort();
            String imageUrl = images[0].getLocation();
            UPnPDeviceImage[] uPnPDeviceImageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                UPnPDeviceImage imageInfo = uPnPDeviceImageArray[n2];
                String mime = imageInfo.getLocation();
                if (mime != null && mime.contains("png")) {
                    imageUrl = imageInfo.getLocation();
                    break;
                }
                ++n2;
            }
            if (!imageUrl.startsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            url = String.valueOf(url) + imageUrl;
            urls.add(url);
            String loc_str = location.toExternalForm();
            int pos = loc_str.lastIndexOf(47);
            if (pos != -1) {
                loc_str = loc_str.substring(0, pos + 1);
                if (imageUrl.startsWith("/")) {
                    imageUrl = imageUrl.substring(1);
                }
                if (!urls.contains(loc_str = String.valueOf(loc_str) + imageUrl)) {
                    urls.add(loc_str);
                }
            }
            return urls;
        }
        return imageIDs;
    }
}

