/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.devices.impl;

import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeProviderAnalysis;
import com.biglybt.core.devices.impl.DeviceImpl;
import com.biglybt.core.devices.impl.TranscodeJobImpl;
import com.biglybt.core.download.DiskManagerFileInfoDelegate;
import com.biglybt.core.download.DiskManagerFileInfoFile;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

class TranscodeFileImpl
implements TranscodeFile {
    protected static final String KEY_FILE = "file";
    private static final TagManager tag_manager = TagManagerFactory.getTagManager();
    private static final String KEY_PROFILE_NAME = "pn";
    private static final String KEY_SOURCE_FILE_HASH = "sf_hash";
    private static final String KEY_SOURCE_FILE_INDEX = "sf_index";
    private static final String KEY_SOURCE_FILE_LINK = "sf_link";
    private static final String KEY_NO_XCODE = "no_xcode";
    private static final String KEY_FOR_JOB = "fj";
    private static final String KEY_DURATION = "at_dur";
    private static final String KEY_VIDEO_WIDTH = "at_vw";
    private static final String KEY_VIDEO_HEIGHT = "at_vh";
    private static final String KEY_XCODE_SIZE = "at_xs";
    private static final String KEY_DATE = "at_dt";
    private static final String KEY_CATEGORIES = "cat";
    private static final String KEY_TAGS = "tags";
    private static final String KEY_COPY_TO_OVERRIDE = "ct_over";
    private static final String KEY_COPYING = "copying";
    private DeviceImpl device;
    private String key;
    private Map<String, Map<String, ?>> files_map;

    protected TranscodeFileImpl(DeviceImpl _device, String _key, String _profile_name, Map<String, Map<String, ?>> _files_map, File _file, boolean _for_job) {
        this.device = _device;
        this.key = _key;
        this.files_map = _files_map;
        this.getMap(true);
        this.setString(KEY_FILE, _file.getAbsolutePath());
        this.setString(KEY_PROFILE_NAME, _profile_name);
        this.setLong(KEY_DATE, SystemTime.getCurrentTime());
        this.setBoolean(KEY_FOR_JOB, _for_job);
        this.setBoolean(KEY_COPYING, false);
    }

    protected TranscodeFileImpl(DeviceImpl _device, String _key, Map<String, Map<String, ?>> _map) throws IOException {
        this.device = _device;
        this.key = _key;
        this.files_map = _map;
        Map<String, ?> map = this.getMap();
        if (map == null || !map.containsKey(KEY_FILE)) {
            throw new IOException("File has been deleted");
        }
    }

    protected String getKey() {
        return this.key;
    }

    @Override
    public String getName() {
        String text;
        TranscodeJobImpl job = this.getJob();
        if (job == null) {
            try {
                DiskManagerFileInfo sourceFile = this.getSourceFile();
                try {
                    Download download = sourceFile.getDownload();
                    if (download == null) {
                        text = sourceFile.getFile().getName();
                    } else {
                        text = download.getName();
                        DiskManagerFileInfo[] fileInfo2 = download.getDiskManagerFileInfo();
                        if (fileInfo2.length > 1) {
                            text = String.valueOf(text) + ": " + sourceFile.getFile(true).getName();
                        }
                    }
                }
                catch (DownloadException e) {
                    text = sourceFile.getFile().getName();
                }
            }
            catch (Throwable e) {
                text = "";
            }
        } else {
            text = job.getName();
        }
        return text;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public TranscodeJobImpl getJob() {
        if (this.isComplete()) {
            return null;
        }
        return this.device.getManager().getTranscodeManager().getQueue().getJob(this);
    }

    public File getCacheFile() throws TranscodeException {
        String file_str = this.getString(KEY_FILE);
        if (file_str == null) {
            throw new TranscodeException("File has been deleted");
        }
        return new File(file_str);
    }

    protected void setCacheFile(File file) {
        this.setString(KEY_FILE, file.getAbsolutePath());
    }

    protected void checkDeleted() throws TranscodeException {
        if (this.isDeleted()) {
            throw new TranscodeException("File has been deleted");
        }
    }

    @Override
    public DiskManagerFileInfo getSourceFile() throws TranscodeException {
        File link_file;
        String link;
        this.checkDeleted();
        String hash = this.getString(KEY_SOURCE_FILE_HASH);
        if (hash != null) {
            try {
                Download download = PluginInitializer.getDefaultInterface().getDownloadManager().getDownload(Base32.decode(hash));
                if (download != null) {
                    int index = (int)this.getLong(KEY_SOURCE_FILE_INDEX);
                    return download.getDiskManagerFileInfo(index);
                }
            }
            catch (Throwable download) {
                // empty catch block
            }
        }
        if ((link = this.getString(KEY_SOURCE_FILE_LINK)) != null && ((link_file = new File(link)).exists() || this.getBoolean(KEY_NO_XCODE))) {
            return new DiskManagerFileInfoFile(link_file);
        }
        return new DiskManagerFileInfoFile(this.getCacheFile());
    }

    protected void setSourceFile(DiskManagerFileInfo file) {
        try {
            Download download = file.getDownload();
            if (download != null && download.getTorrent() != null) {
                this.setString(KEY_SOURCE_FILE_HASH, Base32.encode(download.getTorrent().getHash()));
                this.setLong(KEY_SOURCE_FILE_INDEX, file.getIndex());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setString(KEY_SOURCE_FILE_LINK, file.getFile().getAbsolutePath());
    }

    @Override
    public DiskManagerFileInfo getTargetFile() throws TranscodeException {
        File cache_file = this.getCacheFile();
        if (cache_file.exists() && cache_file.length() > 0L) {
            return new DiskManagerFileInfoFile(cache_file);
        }
        if (this.getBoolean(KEY_NO_XCODE)) {
            DiskManagerFileInfo res = this.getSourceFile();
            if (res instanceof DiskManagerFileInfoFile) {
                return res;
            }
            try {
                return new DiskManagerFileInfoDelegate(res);
            }
            catch (Throwable e) {
                Debug.out(e);
                return res;
            }
        }
        return new DiskManagerFileInfoFile(cache_file);
    }

    protected void setTranscodeRequired(boolean required) throws TranscodeException {
        this.setBoolean(KEY_NO_XCODE, !required);
        if (!required) {
            this.device.revertFileName(this);
        }
    }

    @Override
    public boolean getTranscodeRequired() {
        return !this.getBoolean(KEY_NO_XCODE);
    }

    protected void setComplete(boolean b) {
        this.setBoolean("comp", b);
    }

    @Override
    public boolean isComplete() {
        return this.getBoolean("comp");
    }

    @Override
    public boolean isTemplate() {
        return !this.getBoolean(KEY_FOR_JOB);
    }

    protected void setCopiedToDevice(boolean b) {
        this.setBoolean("copied", b);
        this.setLong("copy_fail", 0L);
        this.setCopyingToDevice(false);
    }

    protected void setCopyToDeviceFailed() {
        this.setLong("copy_fail", this.getLong("copy_fail") + 1L);
        this.setCopyingToDevice(false);
    }

    @Override
    public long getCopyToDeviceFails() {
        return this.getLong("copy_fail");
    }

    @Override
    public boolean isCopiedToDevice() {
        return this.getBoolean("copied");
    }

    @Override
    public void retryCopyToDevice() {
        if (this.isCopiedToDevice()) {
            this.setCopiedToDevice(false);
        } else {
            this.setLong("copy_fail", 0L);
        }
    }

    protected void setProfileName(String s) {
        this.setString(KEY_PROFILE_NAME, s);
    }

    @Override
    public String getProfileName() {
        String s = this.getString(KEY_PROFILE_NAME);
        if (s == null) {
            s = "Unknown";
        }
        return s;
    }

    protected void setCopyToFolderOverride(String s) {
        this.setString(KEY_COPY_TO_OVERRIDE, s);
    }

    public String getCopyToFolderOverride() {
        return this.getString(KEY_COPY_TO_OVERRIDE);
    }

    protected void update(TranscodeProviderAnalysis analysis) throws TranscodeException {
        this.checkDeleted();
        long duration = analysis.getLongProperty(2);
        long video_width = analysis.getLongProperty(3);
        long video_height = analysis.getLongProperty(4);
        long xcode_size = analysis.getLongProperty(7);
        if (duration > 0L) {
            this.setLong(KEY_DURATION, duration);
        }
        if (video_width > 0L && video_height > 0L) {
            this.setLong(KEY_VIDEO_WIDTH, video_width);
            this.setLong(KEY_VIDEO_HEIGHT, video_height);
        }
        if (xcode_size > 0L) {
            this.setLong(KEY_XCODE_SIZE, xcode_size);
        }
    }

    protected void setResolution(int video_width, int video_height) {
        if (video_width > 0 && video_height > 0) {
            this.setLong(KEY_VIDEO_WIDTH, video_width);
            this.setLong(KEY_VIDEO_HEIGHT, video_height);
        }
    }

    @Override
    public long getDurationMillis() {
        return this.getLong(KEY_DURATION);
    }

    @Override
    public long getVideoWidth() {
        return this.getLong(KEY_VIDEO_WIDTH);
    }

    @Override
    public long getVideoHeight() {
        return this.getLong(KEY_VIDEO_HEIGHT);
    }

    @Override
    public long getEstimatedTranscodeSize() {
        return this.getLong(KEY_XCODE_SIZE);
    }

    @Override
    public String[] getCategories() {
        String cats = this.getString(KEY_CATEGORIES);
        if (cats == null || cats.length() == 0) {
            return new String[0];
        }
        return RegExUtil.PAT_SPLIT_COMMA.split(cats);
    }

    @Override
    public void setCategories(String[] cats) {
        String[] existing = this.getCategories();
        if (existing.length == 0 && existing.length == cats.length) {
            return;
        }
        String str = "";
        String[] stringArray = cats;
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            if ((cat = cat.replaceAll(",", "").trim()).length() > 0) {
                str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + cat;
            }
            ++n2;
        }
        this.setString(KEY_CATEGORIES, str);
    }

    @Override
    public String[] getTags(boolean localize) {
        String tags_str = this.getString(KEY_TAGS);
        if (tags_str == null || tags_str.length() == 0) {
            return new String[0];
        }
        String[] tags = RegExUtil.PAT_SPLIT_COMMA.split(tags_str);
        if (localize) {
            ArrayList<String> derp = null;
            int pos = 0;
            String[] stringArray = tags;
            int n = tags.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    String s = stringArray[n2];
                    try {
                        Tag tag = tag_manager.lookupTagByUID(Long.parseLong(s));
                        if (tag == null) {
                            throw new Exception();
                        }
                        String tag_name = tag.getTagName(true);
                        if (derp == null) {
                            tags[pos++] = tag_name;
                        } else {
                            derp.add(tag_name);
                        }
                    }
                    catch (Throwable e) {
                        if (derp != null) break block9;
                        derp = new ArrayList<String>();
                        derp.addAll(Arrays.asList(tags).subList(0, pos));
                    }
                }
                ++n2;
            }
            if (derp == null) {
                return tags;
            }
            return derp.toArray(new String[derp.size()]);
        }
        return tags;
    }

    @Override
    public void setTags(String[] tags) {
        String[] existing = this.getTags(false);
        if (existing.length == 0 && existing.length == tags.length) {
            return;
        }
        String str = "";
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if ((tag = tag.replaceAll(",", "").trim()).length() > 0) {
                str = String.valueOf(str) + (str.length() == 0 ? "" : ",") + tag;
            }
            ++n2;
        }
        this.setString(KEY_TAGS, str);
    }

    @Override
    public long getCreationDateMillis() {
        return this.getLong(KEY_DATE);
    }

    @Override
    public File getCacheFileIfExists() {
        try {
            return this.getCacheFile();
        }
        catch (Throwable e) {
            return null;
        }
    }

    @Override
    public URL getStreamURL() {
        return this.device.getStreamURL(this, null);
    }

    @Override
    public URL getStreamURL(String host) {
        return this.device.getStreamURL(this, host);
    }

    public String getMimeType() {
        return this.device.getMimeType(this);
    }

    @Override
    public void delete(boolean delete_contents) throws TranscodeException {
        this.device.deleteFile(this, delete_contents, true);
    }

    protected void deleteCacheFile() throws TranscodeException {
        this.device.deleteFile(this, true, false);
    }

    @Override
    public boolean isDeleted() {
        return this.getMap() == null;
    }

    private Map<String, ?> getMap() {
        return this.getMap(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> getMap(boolean create) {
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            Map<String, ?> map2 = this.files_map.get(this.key);
            if (map2 == null && create) {
                map2 = new HashMap();
                this.files_map.put(this.key, map2);
            }
            return map2;
        }
    }

    protected boolean getBoolean(String key) {
        return this.getLong(key) == 1L;
    }

    protected void setBoolean(String key, boolean b) {
        this.setLong(key, b ? 1 : 0);
    }

    protected long getLong(String key) {
        try {
            Map<String, ?> map = this.getMap();
            return MapUtils.importLong(map, key, 0L);
        }
        catch (Throwable e) {
            Debug.out(e);
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setLong(String key, long value) {
        if (this.getLong(key) == value) {
            return;
        }
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            try {
                Map<String, ?> map2 = this.getMap();
                MapUtils.exportLong(map2, key, value);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.device.fileDirty(this, 1, key);
    }

    protected String getString(String key) {
        try {
            Map<String, ?> map = this.getMap();
            return MapUtils.getMapString(map, key, null);
        }
        catch (Throwable e) {
            Debug.out(e);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setString(String key, String value) {
        String existing = this.getString(key);
        if (existing == null && value == null) {
            return;
        }
        if (existing != null && value != null && existing.equals(value)) {
            return;
        }
        Map<String, Map<String, ?>> map = this.files_map;
        synchronized (map) {
            Map<String, ?> map2 = this.getMap();
            try {
                MapUtils.setMapString(map2, key, value);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        this.device.fileDirty(this, 1, key);
    }

    @Override
    public void setTransientProperty(Object key2, Object value) {
        this.device.setTransientProperty(this.key, key2, value);
    }

    @Override
    public Object getTransientProperty(Object key2) {
        return this.device.getTransientProperty(this.key, key2);
    }

    public boolean equals(Object other) {
        if (other instanceof TranscodeFileImpl) {
            return this.key.equals(((TranscodeFileImpl)other).key);
        }
        return false;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    protected String getString() {
        Map<String, ?> map = this.getMap();
        if (map == null) {
            return String.valueOf(this.key) + ": deleted";
        }
        return String.valueOf(this.key) + ": " + map;
    }

    public void setCopyingToDevice(boolean b) {
        this.setBoolean(KEY_COPYING, b);
    }

    @Override
    public boolean isCopyingToDevice() {
        return this.getBoolean(KEY_COPYING);
    }
}

