/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.SystemTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DHTTransportAlternativeContactImpl
implements DHTTransportAlternativeContact {
    private final byte network_type;
    private final byte version;
    private final int seen_secs;
    private final byte[] encoded;
    private final int id;

    protected DHTTransportAlternativeContactImpl(byte _network_type, byte _version, short _age, byte[] _encoded) {
        this.network_type = _network_type;
        this.version = _version;
        this.encoded = _encoded;
        this.seen_secs = (int)(SystemTime.getMonotonousTime() / 1000L) - (_age < 0 ? Short.MAX_VALUE : (int)_age);
        this.id = Arrays.hashCode(this.encoded);
    }

    @Override
    public int getNetworkType() {
        return this.network_type & 0xFF;
    }

    @Override
    public int getVersion() {
        return this.version & 0xFF;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getLastAlive() {
        return this.seen_secs;
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            return BDecoder.decode(this.encoded);
        }
        catch (Throwable e) {
            return new HashMap<String, Object>();
        }
    }
}

