/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.transport.DHTTransportAlternativeContact;
import com.biglybt.core.dht.transport.DHTTransportAlternativeNetwork;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DHTTransportAlternativeNetworkImpl
implements DHTTransportAlternativeNetwork {
    private static final int LIVE_AGE_SECS = 1200;
    private static final int LIVEISH_AGE_SECS = 2400;
    private static final int MAX_CONTACTS_PUB = 64;
    private static final int MAX_CONTACTS_ANON = 16;
    private static final boolean TRACE = false;
    private final int network;
    private final int max_contacts;
    private final TreeSet<DHTTransportAlternativeContact> contacts = new TreeSet<DHTTransportAlternativeContact>(new Comparator<DHTTransportAlternativeContact>(){

        @Override
        public int compare(DHTTransportAlternativeContact o1, DHTTransportAlternativeContact o2) {
            int res = o2.getLastAlive() - o1.getLastAlive();
            if (res == 0) {
                res = o1.getID() - o2.getID();
            }
            return res;
        }
    });
    private long last_expiry_check = -1L;
    private long last_churn = -1L;

    protected DHTTransportAlternativeNetworkImpl(int _net) {
        this.network = _net;
        this.max_contacts = this.network == 3 || this.network == 6 ? 16 : 64;
    }

    @Override
    public int getNetworkType() {
        return this.network;
    }

    @Override
    public List<DHTTransportAlternativeContact> getContacts(int max) {
        return this.getContacts(max, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<DHTTransportAlternativeContact> getContacts(int real_max, boolean live_only) {
        List<DHTTransportAlternativeContact> result;
        if (real_max == 0) {
            real_max = this.max_contacts;
        }
        int temp_max = real_max < 3 ? 3 : real_max;
        ArrayList<DHTTransportAlternativeContact> temp_result = new ArrayList<DHTTransportAlternativeContact>(temp_max);
        HashSet<Integer> used_ids = new HashSet<Integer>();
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            for (DHTTransportAlternativeContact contact : this.contacts) {
                if (live_only && contact.getAge() > 2400) break;
                Integer id = contact.getID();
                if (used_ids.contains(id)) continue;
                used_ids.add(id);
                temp_result.add(contact);
                if (temp_result.size() == temp_max) break;
            }
        }
        if (temp_result.size() > real_max) {
            Collections.shuffle(temp_result);
            result = temp_result.subList(0, real_max);
        } else {
            result = temp_result;
        }
        return result;
    }

    private void trim() {
        Iterator<DHTTransportAlternativeContact> it = this.contacts.iterator();
        int pos = 0;
        while (it.hasNext()) {
            it.next();
            if (++pos <= this.max_contacts) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContactsForSend(List<DHTTransportAlternativeContact> new_contacts) {
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            for (DHTTransportAlternativeContact new_contact : new_contacts) {
                this.contacts.add(new_contact);
            }
            if (this.contacts.size() > this.max_contacts) {
                this.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addContactFromReply(DHTTransportAlternativeContact new_contact) {
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            this.contacts.add(new_contact);
            if (this.contacts.size() > this.max_contacts) {
                this.trim();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRequiredContactCount(boolean force) {
        long now = SystemTime.getMonotonousTime();
        TreeSet<DHTTransportAlternativeContact> treeSet = this.contacts;
        synchronized (treeSet) {
            int num_contacts = this.contacts.size();
            int result = 0;
            if (num_contacts < this.max_contacts) {
                result = this.max_contacts - num_contacts;
            } else if (force || this.last_expiry_check == -1L || now - this.last_expiry_check > 5000L) {
                this.last_expiry_check = now;
                Iterator<DHTTransportAlternativeContact> it = this.contacts.iterator();
                int pos = 0;
                DHTTransportAlternativeContact last = null;
                while (it.hasNext()) {
                    DHTTransportAlternativeContact contact;
                    last = contact = it.next();
                    if (contact.getAge() > 1200) {
                        result = this.max_contacts - pos;
                        break;
                    }
                    ++pos;
                }
                if (result == 0 && (this.last_churn == -1L || now - this.last_churn > (long)(30000 + RandomUtils.nextInt(10000)))) {
                    this.last_churn = now;
                    this.contacts.remove(last);
                    result = 1;
                }
            }
            return result;
        }
    }

    private String getString(DHTTransportAlternativeContact contact) {
        return contact.getProperties() + ", age=" + contact.getAge();
    }
}

