/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.udp.impl;

import com.biglybt.core.dht.impl.DHTLog;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPContactImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPPacketRequest;
import com.biglybt.core.dht.transport.udp.impl.DHTUDPUtils;
import com.biglybt.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketData
extends DHTUDPPacketRequest {
    public static final byte PT_READ_REQUEST = 0;
    public static final byte PT_READ_REPLY = 1;
    public static final byte PT_WRITE_REQUEST = 2;
    public static final byte PT_WRITE_REPLY = 3;
    private byte packet_type;
    private byte[] transfer_key;
    private byte[] key;
    private byte[] data;
    private int start_position;
    private int length;
    private int total_length;
    public static final int MAX_DATA_SIZE = 1317;

    public DHTUDPPacketData(DHTTransportUDPImpl _transport, long _connection_id, DHTTransportUDPContactImpl _local_contact, DHTTransportUDPContactImpl _remote_contact) {
        super(_transport, 1035, _connection_id, _local_contact, _remote_contact);
    }

    protected DHTUDPPacketData(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, long con_id, int trans_id) throws IOException {
        super(network_handler, is, 1035, con_id, trans_id);
        this.packet_type = is.readByte();
        this.transfer_key = DHTUDPUtils.deserialiseByteArray(is, 64);
        int max_key_size = this.getProtocolVersion() >= 24 ? 255 : 64;
        this.key = DHTUDPUtils.deserialiseByteArray(is, max_key_size);
        this.start_position = is.readInt();
        this.length = is.readInt();
        this.total_length = is.readInt();
        this.data = DHTUDPUtils.deserialiseByteArray(is, 65535);
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.writeByte(this.packet_type);
        DHTUDPUtils.serialiseByteArray(os, this.transfer_key, 64);
        int max_key_size = this.getProtocolVersion() >= 24 ? 255 : 64;
        DHTUDPUtils.serialiseByteArray(os, this.key, max_key_size);
        os.writeInt(this.start_position);
        os.writeInt(this.length);
        os.writeInt(this.total_length);
        if (this.data.length > 0) {
            DHTUDPUtils.serialiseByteArray(os, this.data, this.start_position, this.length, 65535);
        } else {
            DHTUDPUtils.serialiseByteArray(os, this.data, 65535);
        }
    }

    public void setDetails(byte _packet_type, byte[] _transfer_key, byte[] _key, byte[] _data, int _start_pos, int _length, int _total_length) {
        this.packet_type = _packet_type;
        this.transfer_key = _transfer_key;
        this.key = _key;
        this.data = _data;
        this.start_position = _start_pos;
        this.length = _length;
        this.total_length = _total_length;
    }

    public byte getPacketType() {
        return this.packet_type;
    }

    public byte[] getTransferKey() {
        return this.transfer_key;
    }

    public byte[] getRequestKey() {
        return this.key;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStartPosition() {
        return this.start_position;
    }

    public int getLength() {
        return this.length;
    }

    public int getTotalLength() {
        return this.total_length;
    }

    @Override
    public String getString() {
        return String.valueOf(super.getString()) + "tk=" + DHTLog.getString2(this.transfer_key) + ",rk=" + DHTLog.getString2(this.key) + ",data=" + this.data.length + ",st=" + this.start_position + ",len=" + this.length + ",tot=" + this.total_length;
    }
}

