/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.dht.transport.util;

import com.biglybt.core.dht.transport.DHTTransportContact;
import com.biglybt.core.dht.transport.DHTTransportFindValueReply;
import com.biglybt.core.dht.transport.DHTTransportFullStats;
import com.biglybt.core.dht.transport.DHTTransportQueryStoreReply;
import com.biglybt.core.dht.transport.DHTTransportRequestHandler;
import com.biglybt.core.dht.transport.DHTTransportStoreReply;
import com.biglybt.core.dht.transport.DHTTransportValue;
import com.biglybt.core.dht.transport.util.DHTTransportStatsImpl;
import java.util.List;

public class DHTTransportRequestCounter
implements DHTTransportRequestHandler {
    private final DHTTransportRequestHandler delegate;
    private final DHTTransportStatsImpl stats;

    public DHTTransportRequestCounter(DHTTransportRequestHandler _delegate, DHTTransportStatsImpl _stats) {
        this.delegate = _delegate;
        this.stats = _stats;
    }

    @Override
    public void pingRequest(DHTTransportContact contact) {
        this.stats.pingReceived();
        this.delegate.pingRequest(contact);
    }

    @Override
    public void keyBlockRequest(DHTTransportContact contact, byte[] key_block_request, byte[] key_block_signature) {
        this.stats.keyBlockReceived();
        this.delegate.keyBlockRequest(contact, key_block_request, key_block_signature);
    }

    @Override
    public DHTTransportFullStats statsRequest(DHTTransportContact contact) {
        this.stats.statsReceived();
        return this.delegate.statsRequest(contact);
    }

    @Override
    public DHTTransportStoreReply storeRequest(DHTTransportContact contact, byte[][] keys, DHTTransportValue[][] value_sets) {
        this.stats.storeReceived();
        return this.delegate.storeRequest(contact, keys, value_sets);
    }

    @Override
    public DHTTransportQueryStoreReply queryStoreRequest(DHTTransportContact contact, int header_len, List<Object[]> keys) {
        this.stats.queryStoreReceived();
        return this.delegate.queryStoreRequest(contact, header_len, keys);
    }

    @Override
    public DHTTransportContact[] findNodeRequest(DHTTransportContact contact, byte[] id) {
        this.stats.findNodeReceived();
        return this.delegate.findNodeRequest(contact, id);
    }

    @Override
    public DHTTransportFindValueReply findValueRequest(DHTTransportContact contact, byte[] key, int max, short flags) {
        this.stats.findValueReceived();
        return this.delegate.findValueRequest(contact, key, max, flags);
    }

    @Override
    public void contactImported(DHTTransportContact contact, boolean is_bootstrap) {
        this.delegate.contactImported(contact, is_bootstrap);
    }

    @Override
    public void contactRemoved(DHTTransportContact contact) {
        this.delegate.contactRemoved(contact);
    }

    @Override
    public int getTransportEstimatedDHTSize() {
        return this.delegate.getTransportEstimatedDHTSize();
    }

    @Override
    public void setTransportEstimatedDHTSize(int size) {
        this.delegate.setTransportEstimatedDHTSize(size);
    }
}

