/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk;

import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.IndentWriter;
import java.io.File;

public interface DiskManager {
    public static final int SNAPSHOT = 0;
    public static final int INITIALIZING = 1;
    public static final int ALLOCATING = 2;
    public static final int CHECKING = 3;
    public static final int READY = 4;
    public static final int FAULTY = 10;
    public static final int ET_NONE = 0;
    public static final int ET_OTHER = 1;
    public static final int ET_INSUFFICIENT_SPACE = 2;
    public static final int ET_STOP_DURING_INIT = 3;
    public static final int ET_FILE_MISSING = 4;
    public static final int ET_READ_ERROR = 5;
    public static final int ET_WRITE_ERROR = 6;
    public static final int BLOCK_SIZE_KB = 16;
    public static final int BLOCK_SIZE = 16384;

    public DownloadManager getDownload();

    public void start();

    public boolean stop(boolean var1);

    public boolean isStopped();

    public boolean filesExist();

    public DirectByteBuffer readBlock(int var1, int var2, int var3);

    public DiskManagerWriteRequest createWriteRequest(int var1, int var2, DirectByteBuffer var3, Object var4);

    public void enqueueWriteRequest(DiskManagerWriteRequest var1, DiskManagerWriteRequestListener var2);

    public boolean hasOutstandingWriteRequestForPiece(int var1);

    public DiskManagerReadRequest createReadRequest(int var1, int var2, int var3);

    public void enqueueReadRequest(DiskManagerReadRequest var1, DiskManagerReadRequestListener var2);

    public boolean hasOutstandingReadRequestForPiece(int var1);

    public DiskManagerCheckRequest createCheckRequest(int var1, Object var2);

    public void enqueueCheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public boolean hasOutstandingCheckRequestForPiece(int var1);

    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest var1, DiskManagerCheckRequestListener var2);

    public void setPieceCheckingEnabled(boolean var1);

    public void saveResumeData(boolean var1) throws Exception;

    public DiskManagerPiece[] getPieces();

    public int getNbPieces();

    public BitFlags getAvailability();

    public DiskManagerFileInfo[] getFiles();

    public DiskManagerFileInfoSet getFileSet();

    public DiskManagerPiece getPiece(int var1);

    public DMPieceMap getPieceMap();

    public DMPieceList getPieceList(int var1);

    public int getState();

    public long getTotalLength();

    public int getPieceLength();

    public int getPieceLength(int var1);

    public long getRemaining();

    public long getRemainingExcludingDND();

    public int getPercentDone();

    public int getPercentAllocated();

    default public long[] getLatency() {
        return new long[2];
    }

    default public String getAllocationTask() {
        return null;
    }

    public String getErrorMessage();

    public int getErrorType();

    public DownloadEndedProgress downloadEnded(boolean var1);

    public void downloadRemoved();

    public void moveDataFiles(File var1, String var2);

    public int getCompleteRecheckStatus();

    public boolean getRecheckCancelled();

    public long[] getMoveProgress();

    public String getMoveSubTask();

    public void setMoveState(int var1);

    public boolean checkBlockConsistencyForWrite(String var1, int var2, int var3, DirectByteBuffer var4);

    public boolean checkBlockConsistencyForRead(String var1, boolean var2, int var3, int var4, int var5);

    public boolean checkBlockConsistencyForHint(String var1, int var2, int var3, int var4);

    public TOTorrent getTorrent();

    public File getSaveLocation();

    public void addListener(DiskManagerListener var1);

    public void removeListener(DiskManagerListener var1);

    public boolean hasListener(DiskManagerListener var1);

    public void saveState(boolean var1);

    public boolean isInteresting(int var1);

    public boolean isDone(int var1);

    public int getCacheMode();

    public long[] getReadStats();

    public long[] getWriteStats();

    public void generateEvidence(IndentWriter var1);

    public long getSizeExcludingDND();

    public int getPercentDoneExcludingDND();

    public long getPriorityChangeMarker();

    public void rateLimitChanged();

    public static interface DownloadEndedProgress {
        public boolean isComplete();
    }
}

