/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.cache.CacheFileOwner;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.average.AverageFactory;
import java.io.File;
import java.io.IOException;

public class DiskManagerFileInfoImpl
implements DiskManagerFileInfo,
CacheFileOwner {
    private File root_dir;
    private final StringInterner.FileKey relative_file;
    final int file_index;
    CacheFile cache_file;
    private String extension;
    private long downloaded;
    final DiskManagerHelper diskManager;
    final TOTorrentFile torrent_file;
    private int priority = 0;
    protected boolean skipped_internal = false;
    private volatile Boolean skipping;
    private String last_error = null;
    private volatile CopyOnWriteList<DiskManagerFileInfoListener> listeners;
    volatile AverageFactory.LazyMovingImmediateAverageState read_average_state;
    volatile AverageFactory.LazyMovingImmediateAverageState write_average_state;
    volatile AverageFactory.LazyMovingImmediateAverageState eta_average_state;
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> read_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.read_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.read_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesRead();
        }
    };
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> write_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.write_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.write_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesWritten();
        }
    };
    private static final AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl> eta_adapter = new AverageFactory.LazyMovingImmediateAverageAdapter<DiskManagerFileInfoImpl>(){

        @Override
        public AverageFactory.LazyMovingImmediateAverageState getCurrent(DiskManagerFileInfoImpl instance) {
            return instance.eta_average_state;
        }

        @Override
        public void setCurrent(DiskManagerFileInfoImpl instance, AverageFactory.LazyMovingImmediateAverageState average) {
            instance.eta_average_state = average;
        }

        @Override
        public long getValue(DiskManagerFileInfoImpl instance) {
            return instance.cache_file.getSessionBytesWritten();
        }
    };

    public DiskManagerFileInfoImpl(DiskManagerHelper _disk_manager, File _root_dir, StringInterner.FileKey _relative_file, int _file_index, TOTorrentFile _torrent_file, int _storage_type) throws CacheFileManagerException {
        this.diskManager = _disk_manager;
        this.torrent_file = _torrent_file;
        this.root_dir = _root_dir;
        this.relative_file = _relative_file;
        this.file_index = _file_index;
        int cache_st = DiskManagerUtil.convertDMStorageTypeToCache(_storage_type);
        this.cache_file = CacheFileManagerFactory.getSingleton().createFile(this, new StringInterner.FileKey(this.root_dir, this.relative_file.toString()), cache_st, false);
        if (cache_st == 2 || cache_st == 4) {
            this.skipped_internal = true;
        }
    }

    protected void load(int _priority, boolean _skipped) {
        this.priority = _priority;
        this.skipped_internal = _skipped;
    }

    @Override
    public String getCacheFileOwnerName() {
        return this.diskManager.getInternalName();
    }

    @Override
    public TOTorrentFile getCacheFileTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public File getCacheFileControlFileDir() {
        return this.diskManager.getDownloadState().getStateDir();
    }

    @Override
    public int getCacheMode() {
        return this.diskManager.getCacheMode();
    }

    @Override
    public StringInterner.FileKey getCacheFileLink(StringInterner.FileKey file) {
        return this.diskManager.getDownloadState().getFileLink(this.file_index, file);
    }

    @Override
    public void flushCache() throws Exception {
        this.cache_file.flushCache();
    }

    @Override
    public boolean exists() {
        return this.cache_file.exists();
    }

    public void moveFile(File new_root_dir, File new_absolute_file, boolean link_only, FileUtil.ProgressListener pl) throws CacheFileManagerException {
        if (!link_only) {
            this.cache_file.moveFile(new_absolute_file, pl);
        }
        this.root_dir = new_root_dir;
    }

    public void renameFile(String new_name) throws CacheFileManagerException {
        this.cache_file.renameFile(new_name);
    }

    public CacheFile getCacheFile() {
        return this.cache_file;
    }

    public void setAccessMode(int mode) throws CacheFileManagerException {
        this.cache_file.setAccessMode(mode == 1 ? 1 : 2);
    }

    @Override
    public int getAccessMode() {
        int mode = this.cache_file.getAccessMode();
        return mode == 1 ? 1 : 2;
    }

    @Override
    public long getDownloaded() {
        return this.downloaded;
    }

    @Override
    public long getLastModified() {
        return this.cache_file.getLastModified();
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public File getFile(boolean follow_link) {
        File file = FileUtil.newFile(this.root_dir, this.relative_file.toString());
        if (!follow_link) {
            return file;
        }
        File res = this.diskManager.getDownloadState().getFileLink(this.file_index);
        return res == null ? file : res;
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    @Override
    public boolean setLink(File link_destination, boolean no_delete) {
        this.last_error = "download must be stopped";
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public String getLastError() {
        return this.last_error;
    }

    @Override
    public boolean setLinkAtomic(File link_destination, boolean no_delete) {
        this.last_error = "download must be stopped";
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
        this.last_error = "download must be stopped";
        Debug.out("setLink: download must be stopped");
        return false;
    }

    @Override
    public File getLink() {
        return this.diskManager.getDownloadState().getFileLink(this.file_index);
    }

    @Override
    public boolean setStorageType(int type, boolean force) {
        DiskManagerFileInfoSet set = this.diskManager.getFileSet();
        boolean[] toSet = new boolean[set.nbFiles()];
        toSet[this.file_index] = true;
        return set.setStorageTypes(toSet, type, force)[this.file_index];
    }

    @Override
    public int getStorageType() {
        return DiskManagerUtil.convertDMStorageTypeFromString(this.diskManager.getStorageType(this.file_index));
    }

    @Override
    public int getFirstPieceNumber() {
        return this.torrent_file.getFirstPieceNumber();
    }

    @Override
    public int getLastPieceNumber() {
        return this.torrent_file.getLastPieceNumber();
    }

    @Override
    public long getLength() {
        return this.torrent_file.getLength();
    }

    @Override
    public int getIndex() {
        return this.file_index;
    }

    @Override
    public int getNbPieces() {
        return this.torrent_file.getNumberOfPieces();
    }

    public void setDownloaded(long l) {
        this.downloaded = l;
    }

    public void setExtension(String string) {
        this.extension = string.startsWith(".") ? StringInterner.intern(string) : string;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int b) {
        this.priority = b;
        this.diskManager.priorityChanged(this);
    }

    @Override
    public boolean isSkipped() {
        return this.skipped_internal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setSkipped(boolean skipped) {
        Object object = DiskManagerUtil.skip_lock;
        synchronized (object) {
            try {
                this.skipping = skipped;
                int existing_st = this.getStorageType();
                if (!skipped && existing_st == 2 && !this.setStorageType(1)) {
                    return;
                }
                if (!skipped && existing_st == 4 && !this.setStorageType(3)) {
                    return;
                }
                this.setSkippedInternal(skipped);
                this.diskManager.skippedFileSetChanged(this);
                boolean[] toCheck = new boolean[this.diskManager.getFileSet().nbFiles()];
                toCheck[this.file_index] = true;
                DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this.diskManager.getFileSet(), toCheck, skipped, this.diskManager.getDownloadState().getDownloadManager());
            }
            finally {
                this.skipping = null;
            }
            return;
        }
    }

    @Override
    public Boolean isSkipping() {
        return this.skipping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSkippedInternal(boolean _skipped) {
        Object object = DiskManagerUtil.skip_lock;
        synchronized (object) {
            this.skipped_internal = _skipped;
            DownloadManager dm = this.getDownloadManager();
            if (dm != null && !dm.isDestroyed()) {
                DiskManagerUtil.setSkippedInternalSupport(dm, this, this.cache_file, _skipped);
            }
        }
    }

    @Override
    public DiskManager getDiskManager() {
        return this.diskManager;
    }

    @Override
    public DownloadManager getDownloadManager() {
        DownloadManagerState state = this.diskManager.getDownloadState();
        if (state == null) {
            return null;
        }
        return state.getDownloadManager();
    }

    public void dataWritten(long offset, long size, Object originator) {
        CopyOnWriteList<DiskManagerFileInfoListener> l_ref = this.listeners;
        if (l_ref != null) {
            for (DiskManagerFileInfoListener listener : l_ref) {
                try {
                    listener.dataWritten(offset, size, originator);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void dataChecked(long offset, long size) {
        CopyOnWriteList<DiskManagerFileInfoListener> l_ref = this.listeners;
        if (l_ref != null) {
            for (DiskManagerFileInfoListener listener : l_ref) {
                try {
                    listener.dataChecked(offset, size);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public DirectByteBuffer read(long offset, int length) throws IOException {
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
        try {
            this.cache_file.read(buffer, offset, (short)1);
        }
        catch (Throwable e) {
            buffer.returnToPool();
            Debug.printStackTrace(e);
            throw new IOException(e.getMessage());
        }
        return buffer;
    }

    @Override
    public int getReadBytesPerSecond() {
        return (int)AverageFactory.LazyMovingImmediateAverage(10, 1, read_adapter, this);
    }

    @Override
    public int getWriteBytesPerSecond() {
        return (int)AverageFactory.LazyMovingImmediateAverage(10, 1, write_adapter, this);
    }

    @Override
    public long getETA() {
        if (this.isSkipped()) {
            return -1L;
        }
        long rem = this.getLength() - this.getDownloaded();
        if (rem == 0L) {
            return -1L;
        }
        long speed = AverageFactory.LazySmoothMovingImmediateAverage(eta_adapter, this);
        if (speed == 0L) {
            return 1827387392L;
        }
        long eta = rem / speed;
        if (eta == 0L) {
            return 1L;
        }
        return eta;
    }

    @Override
    public void recheck() {
        DiskManagerFactory.recheckFile(this.getDownloadManager(), this);
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final DiskManagerFileInfoListener listener) {
        DiskManagerFileInfoImpl diskManagerFileInfoImpl = this;
        synchronized (diskManagerFileInfoImpl) {
            if (this.listeners == null) {
                this.listeners = new CopyOnWriteList();
            }
        }
        if (!this.listeners.addIfNotPresent(listener)) {
            return;
        }
        new Runnable(){
            private long file_start;
            private long file_end;
            private long current_write_start = -1L;
            private long current_write_end = -1L;
            private long current_check_start = -1L;
            private long current_check_end = -1L;

            @Override
            public void run() {
                long torrent_offset;
                this.file_start = torrent_offset = DiskManagerFileInfoImpl.this.torrent_file.getOffsetInTorrent();
                this.file_end = this.file_start + DiskManagerFileInfoImpl.this.torrent_file.getLength();
                DiskManagerPiece[] pieces = DiskManagerFileInfoImpl.this.diskManager.getPieces();
                int first_piece = DiskManagerFileInfoImpl.this.getFirstPieceNumber();
                int last_piece = DiskManagerFileInfoImpl.this.getLastPieceNumber();
                long piece_size = DiskManagerFileInfoImpl.this.torrent_file.getTorrent().getPieceLength();
                int i = first_piece;
                while (i <= last_piece) {
                    long piece_offset = piece_size * (long)i;
                    DiskManagerPiece piece = pieces[i];
                    if (piece.isDone()) {
                        long bit_start = piece_offset;
                        long bit_end = bit_start + (long)piece.getLength();
                        this.bitWritten(bit_start, bit_end, true);
                    } else {
                        int block_offset = 0;
                        int j = 0;
                        while (j < piece.getNbBlocks()) {
                            int block_size = piece.getBlockSize(j);
                            if (piece.isWritten(j)) {
                                long bit_start = piece_offset + (long)block_offset;
                                long bit_end = bit_start + (long)block_size;
                                this.bitWritten(bit_start, bit_end, false);
                            }
                            block_offset += block_size;
                            ++j;
                        }
                    }
                    ++i;
                }
                this.bitWritten(-1L, -1L, false);
            }

            protected void bitWritten(long bit_start, long bit_end, boolean checked) {
                if (this.current_write_start == -1L) {
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                } else if (this.current_write_end == bit_start) {
                    this.current_write_end = bit_end;
                } else {
                    if (this.current_write_start < this.file_start) {
                        this.current_write_start = this.file_start;
                    }
                    if (this.current_write_end > this.file_end) {
                        this.current_write_end = this.file_end;
                    }
                    if (this.current_write_start < this.current_write_end) {
                        try {
                            listener.dataWritten(this.current_write_start - this.file_start, this.current_write_end - this.current_write_start, null);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    this.current_write_start = bit_start;
                    this.current_write_end = bit_end;
                }
                if (checked && this.current_check_start == -1L) {
                    this.current_check_start = bit_start;
                    this.current_check_end = bit_end;
                } else if (checked && this.current_check_end == bit_start) {
                    this.current_check_end = bit_end;
                } else {
                    if (this.current_check_start < this.file_start) {
                        this.current_check_start = this.file_start;
                    }
                    if (this.current_check_end > this.file_end) {
                        this.current_check_end = this.file_end;
                    }
                    if (this.current_check_start < this.current_check_end) {
                        try {
                            listener.dataChecked(this.current_check_start - this.file_start, this.current_check_end - this.current_check_start);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (checked) {
                        this.current_check_start = bit_start;
                        this.current_check_end = bit_end;
                    } else {
                        this.current_check_start = -1L;
                        this.current_check_end = -1L;
                    }
                }
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DiskManagerFileInfoListener listener) {
        DiskManagerFileInfoImpl diskManagerFileInfoImpl = this;
        synchronized (diskManagerFileInfoImpl) {
            if (this.listeners != null) {
                this.listeners.remove(listener);
            }
        }
    }
}

