/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationListener;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.TimerEventPeriodic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DiskManagerOperationScheduler
implements CoreOperationListener {
    private static boolean enabled;
    private final Core core;
    private List<Operation> operations = new ArrayList<Operation>();
    private TimerEventPeriodic timer;
    private boolean concurrent_reads;
    private static final AtomicLong fakeNumber;

    static {
        fakeNumber = new AtomicLong();
    }

    public static void initialise(Core core) {
        new DiskManagerOperationScheduler(core);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private DiskManagerOperationScheduler(Core _core) {
        this.core = _core;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.one.op.per.fs", "diskmanager.one.op.per.fs.conc.read"}, n -> this.checkConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfig() {
        DiskManagerOperationScheduler diskManagerOperationScheduler = this;
        synchronized (diskManagerOperationScheduler) {
            boolean _enabled = COConfigurationManager.getBooleanParameter("diskmanager.one.op.per.fs");
            this.concurrent_reads = COConfigurationManager.getBooleanParameter("diskmanager.one.op.per.fs.conc.read");
            if (enabled != _enabled) {
                enabled = _enabled;
                if (enabled) {
                    this.core.addOperationListener(this);
                    if (this.timer == null) {
                        this.timer = SimpleTimer.addPeriodicEvent("dmos:timer", 500L, ev -> {
                            DiskManagerOperationScheduler diskManagerOperationScheduler = this;
                            synchronized (diskManagerOperationScheduler) {
                                this.schedule();
                            }
                        });
                    }
                } else {
                    this.core.removeOperationListener(this);
                    if (this.timer != null) {
                        this.timer.cancel();
                        this.timer = null;
                    }
                }
            }
        }
    }

    private void schedule() {
        Object cb;
        int n;
        if (this.operations.isEmpty()) {
            return;
        }
        for (Operation op : this.operations) {
            if ((op.cb.getTaskState() & 1) == 0) {
                op.we_paused_it = false;
                continue;
            }
            op.we_resumed_it = false;
        }
        boolean conc_read = this.concurrent_reads;
        HashMap<Object, Operation> first_check_per_fs = new HashMap<Object, Operation>();
        for (Operation op : this.operations) {
            if (op.op.getOperationType() != 6) continue;
            String[] stringArray = conc_read ? op.unique_fs_for_conc_read : op.unique_fs_normal;
            n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fs = stringArray[n2];
                if (first_check_per_fs.get(fs) == null) {
                    first_check_per_fs.put(fs, op);
                } else {
                    cb = op.cb;
                    if ((cb.getTaskState() & 1) == 0 && op.we_resumed_it) {
                        cb.setTaskState(1);
                        cb.setAutoPause(true);
                        op.we_paused_it = true;
                        op.we_resumed_it = false;
                    }
                }
                ++n2;
            }
        }
        HashMap<Object, int[]> fs_queue_pos = new HashMap<Object, int[]>();
        for (Operation op : this.operations) {
            if ((op.cb.getTaskState() & 1) != 0) continue;
            op.cb.setAutoPause(false);
            cb = conc_read ? op.unique_fs_for_conc_read : op.unique_fs_normal;
            int n3 = ((String[])cb).length;
            n = 0;
            while (n < n3) {
                Object fs = cb[n];
                int[] x = (int[])fs_queue_pos.get(fs);
                if (x == null) {
                    fs_queue_pos.put(fs, new int[]{1});
                }
                ++n;
            }
        }
        IdentityHashSet<DownloadManager> active_downloads = conc_read ? new IdentityHashSet<DownloadManager>() : null;
        for (Operation op : this.operations) {
            DownloadManager dm;
            CoreOperationTask.ProgressCallback cb2 = op.cb;
            if ((cb2.getTaskState() & 1) != 0) {
                DownloadManager dm2;
                if (!cb2.isAutoPause()) continue;
                if (active_downloads != null && active_downloads.contains(dm2 = op.op.getTask().getDownload())) {
                    cb2.setIndicativeOrder(0);
                    continue;
                }
                int pos = 0;
                String[] stringArray = conc_read ? op.unique_fs_for_conc_read : op.unique_fs_normal;
                int n4 = stringArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    String fs = stringArray[n5];
                    int[] count = (int[])fs_queue_pos.get(fs);
                    if (count != null) {
                        pos = Math.max(pos, count[0]);
                        count[0] = count[0] + 1;
                    } else {
                        fs_queue_pos.put(fs, new int[]{1});
                    }
                    ++n5;
                }
                if (pos == 0) {
                    cb2.setTaskState(2);
                    cb2.setAutoPause(false);
                    op.we_resumed_it = true;
                    op.we_paused_it = false;
                    continue;
                }
                cb2.setIndicativeOrder(pos);
                continue;
            }
            if (active_downloads == null || (dm = op.op.getTask().getDownload()) == null) continue;
            active_downloads.add(dm);
        }
    }

    @Override
    public boolean operationExecuteRequest(CoreOperation operation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationAdded(CoreOperation operation) {
        String[] fs;
        CoreOperationTask task2 = operation.getTask();
        CoreOperationTask.ProgressCallback cb = task2.getProgressCallback();
        if (cb != null && (cb.getSupportedTaskStates() & 1) != 0 && (fs = task2.getAffectedFileSystems()) != null && fs.length > 0) {
            DiskManagerOperationScheduler diskManagerOperationScheduler = this;
            synchronized (diskManagerOperationScheduler) {
                this.operations.add(new Operation(operation, cb, fs));
                int i = 0;
                while (i < 10) {
                    try {
                        Collections.sort(this.operations);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                this.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void operationRemoved(CoreOperation operation) {
        DiskManagerOperationScheduler diskManagerOperationScheduler = this;
        synchronized (diskManagerOperationScheduler) {
            Iterator<Operation> it = this.operations.iterator();
            while (it.hasNext()) {
                if (it.next().op != operation) continue;
                it.remove();
                this.schedule();
                break;
            }
        }
    }

    private static class Operation
    implements Comparable<Operation> {
        private final CoreOperation op;
        private final CoreOperationTask.ProgressCallback cb;
        private final String[] unique_fs_normal;
        private final String[] unique_fs_for_conc_read;
        private boolean we_paused_it;
        private boolean we_resumed_it;

        Operation(CoreOperation _op, CoreOperationTask.ProgressCallback _cb, String[] _fs) {
            this.op = _op;
            this.cb = _cb;
            HashSet<String> temp_fs = new HashSet<String>();
            temp_fs.addAll(Arrays.asList(_fs));
            this.unique_fs_normal = temp_fs.toArray(new String[temp_fs.size()]);
            switch (this.op.getOperationType()) {
                case 2: 
                case 4: 
                case 7: {
                    if (_fs.length != 2) {
                        Debug.out("2 file systems expected");
                        this.unique_fs_for_conc_read = this.unique_fs_normal;
                        break;
                    }
                    this.unique_fs_for_conc_read = new String[]{"::fake::" + fakeNumber.incrementAndGet(), _fs[1]};
                    break;
                }
                case 5: {
                    this.unique_fs_for_conc_read = this.unique_fs_normal;
                    break;
                }
                case 6: {
                    this.unique_fs_for_conc_read = new String[]{"::fake::" + fakeNumber.incrementAndGet()};
                    break;
                }
                default: {
                    Debug.out("Unknown operation type");
                    this.unique_fs_for_conc_read = this.unique_fs_normal;
                }
            }
            this.cb.setTaskState(1);
            this.cb.setAutoPause(true);
            this.we_paused_it = true;
        }

        @Override
        public int compareTo(Operation other) {
            int t2;
            int t1 = this.op.getOperationType();
            if (t1 == (t2 = other.op.getOperationType())) {
                return this.cb.compareTo(other.cb);
            }
            return CoreOperation.OP_SORT_ORDER[t1] - CoreOperation.OP_SORT_ORDER[t2];
        }
    }
}

