/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;

public class DiskManagerPieceImpl
implements DiskManagerPiece {
    private static final byte PIECE_STATUS_NEEDED = 1;
    private static final byte PIECE_STATUS_WRITTEN = 2;
    private static final byte PIECE_STATUS_CHECKING = 4;
    private static final byte PIECE_STATUS2_MERGE_READ = 1;
    private static final byte PIECE_STATUS2_MERGE_WRITE = 2;
    private static final byte PIECE_STATUS_MASK_DOWNLOADABLE = 7;
    private static final byte PIECE_STATUS_MASK_NEEDS_CHECK = 6;
    private final DiskManagerHelper diskManager;
    private final int pieceNumber;
    private final short nbBlocks;
    protected volatile boolean[] written;
    private byte statusFlags;
    private byte statusFlags2;
    private short read_count;
    private boolean done;

    public DiskManagerPieceImpl(DiskManagerHelper _disk_manager, int pieceIndex, int length) {
        this.diskManager = _disk_manager;
        this.pieceNumber = pieceIndex;
        this.nbBlocks = (short)((length + 16384 - 1) / 16384);
        this.statusFlags = 1;
    }

    @Override
    public DiskManager getManager() {
        return this.diskManager;
    }

    @Override
    public int getPieceNumber() {
        return this.pieceNumber;
    }

    @Override
    public int getLength() {
        return this.diskManager.getPieceLength(this.pieceNumber);
    }

    @Override
    public int getNbBlocks() {
        return this.nbBlocks;
    }

    @Override
    public short getReadCount() {
        return this.read_count;
    }

    @Override
    public void setReadCount(short c) {
        this.read_count = c;
    }

    @Override
    public int getBlockSize(int blockNumber) {
        int len;
        if (blockNumber == this.nbBlocks - 1 && (len = this.getLength() % 16384) != 0) {
            return len;
        }
        return 16384;
    }

    @Override
    public boolean isSkipped() {
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        int i = 0;
        while (i < pieceList2.size()) {
            DiskManagerFileInfo file = pieceList2.get(i).getFile();
            if (file == null) {
                return false;
            }
            if (!file.isSkipped()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isNeeded() {
        return (this.statusFlags & 1) != 0;
    }

    @Override
    public boolean calcNeeded() {
        boolean filesNeeded = false;
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        int i = 0;
        while (i < pieceList2.size()) {
            DiskManagerFileInfo file = pieceList2.get(i).getFile();
            long fileLength = file.getLength();
            filesNeeded |= fileLength > 0L && file.getDownloaded() < fileLength && !file.isSkipped();
            ++i;
        }
        if (filesNeeded) {
            this.statusFlags = (byte)(this.statusFlags | 1);
            return true;
        }
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
        return false;
    }

    @Override
    public boolean spansFiles() {
        DMPieceList pieceList2 = this.diskManager.getPieceList(this.pieceNumber);
        return pieceList2.size() > 1;
    }

    @Override
    public DMPieceList getPieceList() {
        return this.diskManager.getPieceList(this.pieceNumber);
    }

    @Override
    public void clearNeeded() {
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    @Override
    public void setNeeded() {
        this.statusFlags = (byte)(this.statusFlags | 1);
    }

    @Override
    public void setNeeded(boolean b) {
        this.statusFlags = b ? (byte)(this.statusFlags | 1) : (byte)(this.statusFlags & 0xFFFFFFFE);
    }

    @Override
    public boolean isWritten() {
        return (this.statusFlags & 2) != 0;
    }

    @Override
    public boolean[] getWritten() {
        return this.written;
    }

    @Override
    public boolean isWritten(int blockNumber) {
        if (this.done) {
            return true;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return false;
        }
        return writtenRef[blockNumber];
    }

    @Override
    public int getNbWritten() {
        if (this.done) {
            return this.nbBlocks;
        }
        boolean[] writtenRef = this.written;
        if (writtenRef == null) {
            return 0;
        }
        int res = 0;
        int i = 0;
        while (i < this.nbBlocks) {
            if (writtenRef[i]) {
                ++res;
            }
            ++i;
        }
        return res;
    }

    @Override
    public void setWritten(int blockNumber) {
        if (this.written == null) {
            this.written = new boolean[this.nbBlocks];
        }
        boolean[] written_ref = this.written;
        written_ref[blockNumber] = true;
        int i = 0;
        while (i < this.nbBlocks) {
            if (!written_ref[i]) {
                return;
            }
            ++i;
        }
        this.statusFlags = (byte)(this.statusFlags | 2);
    }

    @Override
    public void clearWritten(int blockNumber) {
        boolean[] written_ref = this.written;
        if (written_ref != null) {
            written_ref[blockNumber] = false;
            this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFFD);
        }
    }

    @Override
    public boolean isChecking() {
        return (this.statusFlags & 4) != 0;
    }

    @Override
    public void setChecking() {
        this.statusFlags = (byte)(this.statusFlags | 4);
    }

    @Override
    public boolean isNeedsCheck() {
        return !this.done && (this.statusFlags & 6) == 2;
    }

    @Override
    public boolean calcDone() {
        return this.done;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public void setDone(boolean b) {
        if (b != this.done) {
            this.diskManager.setPieceDone(this, b);
        }
    }

    public void setDoneSupport(boolean b) {
        this.done = b;
        if (this.done) {
            this.written = null;
        }
    }

    @Override
    public void setDownloadable() {
        this.setDone(false);
        this.statusFlags = (byte)(this.statusFlags & 0xFFFFFFF8);
        this.calcNeeded();
    }

    @Override
    public boolean isDownloadable() {
        return !this.done && (this.statusFlags & 7) == 1;
    }

    @Override
    public boolean isInteresting() {
        return !this.done && (this.statusFlags & 1) != 0;
    }

    @Override
    public int getRemaining() {
        if (this.done || !this.isNeeded()) {
            return 0;
        }
        boolean[] w = this.written;
        if (w == null) {
            return this.getLength();
        }
        int size = 0;
        int i = 0;
        while (i < w.length) {
            if (!w[i]) {
                size += this.getBlockSize(i);
            }
            ++i;
        }
        return size;
    }

    @Override
    public void reset() {
        this.setDownloadable();
        this.written = null;
    }

    @Override
    public void reDownloadBlock(int blockNumber) {
        boolean[] written_ref = this.written;
        if (written_ref != null) {
            written_ref[blockNumber] = false;
            this.setDownloadable();
        }
    }

    @Override
    public void setMergeRead() {
        this.statusFlags2 = (byte)(this.statusFlags2 | 1);
    }

    @Override
    public boolean isMergeRead() {
        return (this.statusFlags2 & 1) != 0;
    }

    @Override
    public void setMergeWrite() {
        this.statusFlags2 = (byte)(this.statusFlags2 | 2);
    }

    @Override
    public boolean isMergeWrite() {
        return (this.statusFlags2 & 2) != 0;
    }

    @Override
    public String getString() {
        String text = "";
        text = String.valueOf(text) + (this.isNeeded() ? "needed," : "");
        text = String.valueOf(text) + (this.isDone() ? "done," : "");
        if (!this.isDone()) {
            text = String.valueOf(text) + (this.isDownloadable() ? "downable," : "");
            text = String.valueOf(text) + (this.isWritten() ? "written" : "written " + this.getNbWritten()) + ",";
            text = String.valueOf(text) + (this.isChecking() ? "checking" : "");
        }
        if (text.endsWith(",")) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }
}

