/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.RealTimeInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class DiskManagerRecheckScheduler {
    private static Core core = CoreFactory.getSingleton();
    static int strategy;
    static boolean smallest_first;
    static int max_active;
    private static AsyncDispatcher async;
    private final Object lock = new Object();
    private final List<DiskManagerRecheckInstance> entries = new ArrayList<DiskManagerRecheckInstance>();

    static {
        async = new AsyncDispatcher(2000);
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                strategy = COConfigurationManager.getIntParameter("diskmanager.hashchecking.strategy");
                smallest_first = COConfigurationManager.getBooleanParameter("diskmanager.hashchecking.smallestfirst");
                max_active = COConfigurationManager.getIntParameter("diskmanager.hashchecking.maxactive");
                if (max_active <= 0) {
                    max_active = Integer.MAX_VALUE;
                }
            }
        };
        COConfigurationManager.addAndFireParameterListeners(new String[]{"diskmanager.hashchecking.strategy", "diskmanager.hashchecking.smallestfirst", "diskmanager.hashchecking.maxactive"}, param_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskManagerRecheckInstance register(DiskManagerHelper helper, boolean low_priority) {
        DiskManagerRecheckInstance instance = new DiskManagerRecheckInstance(helper, low_priority);
        Object object = this.lock;
        synchronized (object) {
            this.entries.add(instance);
            for (DiskManagerRecheckInstance inst : this.entries) {
                inst.updateMetric();
            }
            Collections.sort(this.entries, new Comparator<DiskManagerRecheckInstance>(){

                @Override
                public int compare(DiskManagerRecheckInstance o1, DiskManagerRecheckInstance o2) {
                    long comp2 = o1.getMetric() - o2.getMetric();
                    if (comp2 < 0L) {
                        return -1;
                    }
                    if (comp2 == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        core.addOperation(instance.getOperation());
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPermission(DiskManagerRecheckInstance instance) {
        boolean result = false;
        int delay = 250;
        Object object = this.lock;
        synchronized (object) {
            int to_process = max_active;
            if (to_process <= 0) {
                to_process = Integer.MAX_VALUE;
            }
            int i = 0;
            while (to_process > 0 && i < this.entries.size()) {
                DiskManagerRecheckInstance this_inst = this.entries.get(i);
                if (!this_inst.isPaused()) {
                    --to_process;
                    if (this_inst == instance) {
                        boolean low_priority = instance.isLowPriority();
                        if (low_priority && RealTimeInfo.isRealTimeTaskActive()) {
                            result = false;
                        } else {
                            if (strategy == 0) {
                                delay = 0;
                            } else if (strategy != 1 || !low_priority) {
                                delay = 1;
                            } else {
                                delay = instance.getPieceLength() / 1024 / 10;
                                delay = Math.min(delay, 409);
                                delay = Math.max(delay, 12);
                            }
                            result = true;
                        }
                        instance.setActive(result);
                        break;
                    }
                }
                ++i;
            }
        }
        if (delay > 0) {
            try {
                Thread.sleep(delay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregister(DiskManagerRecheckInstance instance) {
        CoreOperation to_remove = null;
        try {
            Object object = this.lock;
            synchronized (object) {
                Iterator<DiskManagerRecheckInstance> it = this.entries.iterator();
                while (it.hasNext()) {
                    DiskManagerRecheckInstance entry = it.next();
                    if (entry != instance) continue;
                    it.remove();
                    to_remove = entry.getOperation();
                    break;
                }
            }
        }
        finally {
            if (to_remove != null) {
                core.removeOperation(to_remove);
            }
        }
    }

    public class DiskManagerRecheckInstance {
        private final DiskManagerHelper helper;
        private final Callback progress;
        private final CoreOperation op;
        private final int piece_length;
        private final boolean low_priority;
        private final AESemaphore slot_sem;
        private long metric;
        private volatile boolean active;
        private volatile boolean paused;

        protected DiskManagerRecheckInstance(DiskManagerHelper _helper, boolean _low_priority) {
            this.helper = _helper;
            TOTorrent torrent = this.helper.getTorrent();
            this.piece_length = (int)torrent.getPieceLength();
            this.low_priority = _low_priority;
            this.slot_sem = new AESemaphore("DiskManagerRecheckInstance::slotsem", this.getPieceConcurrency());
            this.progress = new Callback();
            final CoreOperationTask task2 = new CoreOperationTask(){

                @Override
                public String getName() {
                    return DiskManagerRecheckInstance.this.helper.getDisplayName();
                }

                @Override
                public DownloadManager getDownload() {
                    return DiskManagerRecheckInstance.this.helper.getDownload();
                }

                @Override
                public CoreOperationTask.ProgressCallback getProgressCallback() {
                    return DiskManagerRecheckInstance.this.progress;
                }

                @Override
                public boolean runOperation(CoreOperation operation) {
                    return true;
                }
            };
            this.op = new CoreOperation.CoreOperationAdapter(){

                @Override
                public int getOperationType() {
                    return 6;
                }

                @Override
                public CoreOperationTask getTask() {
                    return task2;
                }
            };
            this.updateMetric();
        }

        private void updateMetric() {
            long _metric;
            long l = _metric = this.low_priority ? 0x7000000000000000L : 0L;
            if (smallest_first) {
                int progress;
                TOTorrent torrent = this.helper.getTorrent();
                long size_remaining = torrent.getSize();
                if (this.helper.getDownload().getState() == 30 && (progress = this.op.getTask().getProgressCallback().getProgress()) > 0) {
                    size_remaining = size_remaining * (long)(1000 - progress) / 1000L;
                }
                _metric += size_remaining;
            }
            this.metric = _metric;
        }

        private int getPieceConcurrency() {
            int piece_length = this.getPieceLength();
            if (strategy <= 1) {
                return piece_length > 0x2000000 ? 1 : 2;
            }
            int num = 0x2000000 / piece_length;
            return Math.min(8, num);
        }

        protected CoreOperation getOperation() {
            return this.op;
        }

        protected long getMetric() {
            return this.metric;
        }

        protected int getPieceLength() {
            return this.piece_length;
        }

        protected boolean isLowPriority() {
            return this.low_priority;
        }

        public void reserveSlot() {
            this.slot_sem.reserve();
        }

        public void releaseSlot() {
            this.slot_sem.release();
        }

        public boolean getPermission() {
            return DiskManagerRecheckScheduler.this.getPermission(this);
        }

        protected boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean b) {
            this.active = b;
        }

        protected boolean isPaused() {
            return this.paused;
        }

        protected void setPaused(boolean b) {
            this.paused = b;
        }

        public boolean isCancelled() {
            return this.progress.getTaskState() == 4;
        }

        public void unregister() {
            DiskManagerRecheckScheduler.this.unregister(this);
        }

        class Callback
        extends CoreOperationTask.ProgressCallbackAdapter {
            final DiskManagerRecheckInstance inst;
            final DownloadManager dm;
            volatile boolean cancelled;

            Callback() {
                this.inst = DiskManagerRecheckInstance.this;
                this.dm = DiskManagerRecheckInstance.this.helper.getDownload();
            }

            @Override
            public int getProgress() {
                int complete_recheck_status = DiskManagerRecheckInstance.this.helper.getCompleteRecheckStatus();
                if (complete_recheck_status != -1) {
                    return complete_recheck_status;
                }
                return this.dm == null ? -1 : this.dm.getStats().getCompleted();
            }

            @Override
            public int getSupportedTaskStates() {
                return 7;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getTaskState() {
                if (this.cancelled) {
                    return 4;
                }
                Object object = DiskManagerRecheckScheduler.this.lock;
                synchronized (object) {
                    block7: {
                        block6: {
                            if (!DiskManagerRecheckInstance.this.isPaused()) break block6;
                            return 1;
                        }
                        if (!DiskManagerRecheckInstance.this.isActive()) break block7;
                        return 0;
                    }
                    return 16;
                }
            }

            @Override
            public void setTaskState(int state) {
                if (state == 4) {
                    this.cancelled = true;
                    if (this.dm != null) {
                        async.dispatch(AERunnable.create(() -> this.dm.stopIt(70, false, false)));
                    }
                } else if (state == 1) {
                    DiskManagerRecheckInstance.this.setPaused(true);
                } else if (state == 2) {
                    DiskManagerRecheckInstance.this.setPaused(false);
                }
            }

            @Override
            public long getSize() {
                return DiskManagerRecheckInstance.this.helper.getSizeExcludingDND();
            }

            @Override
            public int compareTo(CoreOperationTask.ProgressCallback o) {
                if (o instanceof Callback) {
                    Callback other = (Callback)o;
                    long l = DiskManagerRecheckInstance.this.getMetric() - other.inst.getMetric();
                    if (l < 0L) {
                        return -1;
                    }
                    if (l > 0L) {
                        return 1;
                    }
                    return 0;
                }
                return 0;
            }
        }
    }
}

