/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl;

import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFactory;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoListener;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerFileInfoHelper;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerFileInfoSetImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerPieceImpl;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFactory;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFile;
import com.biglybt.core.disk.impl.resume.RDResumeHandler;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerFactory;
import com.biglybt.core.diskmanager.cache.CacheFileOwner;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerStatsImpl;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.StringInterner;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;
    protected static final Object skip_lock;
    static final AEMonitor cache_read_mon;
    private static List<CoreOperationTask> move_tasks;
    private static boolean move_smallest_first;

    static {
        skip_lock = new Object();
        ParameterListener param_listener = new ParameterListener(){

            @Override
            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
        cache_read_mon = new AEMonitor("DiskManager:cacheRead");
        move_tasks = new ArrayList<CoreOperationTask>();
        COConfigurationManager.addAndFireParameterListener("diskmanager.move.smallestfirst", n -> {
            move_smallest_first = COConfigurationManager.getBooleanParameter(n);
        });
    }

    public static boolean checkBlockConsistencyForHint(DiskManager dm, String originator, int pieceNumber, int offset, int length) {
        if (length <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " length=" + length + " <= 0"));
            }
            return false;
        }
        if (pieceNumber < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " < 0"));
            }
            return false;
        }
        if (pieceNumber >= dm.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " pieceNumber=" + pieceNumber + " >= this.nbPieces=" + dm.getNbPieces()));
            }
            return false;
        }
        int pLength = dm.getPieceLength(pieceNumber);
        if (offset < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " < 0"));
            }
            return false;
        }
        if (offset > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " > pLength=" + pLength));
            }
            return false;
        }
        if (offset + length > pLength) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Hint invalid: " + originator + " offset=" + offset + " + length=" + length + " > pLength=" + pLength));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager dm, String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(dm, originator, pieceNumber, offset, length)) {
            return false;
        }
        if (length > max_read_block_size && peer_request) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " length=" + length + " > " + max_read_block_size));
            }
            return false;
        }
        if (!dm.getPiece(pieceNumber).isDone()) {
            Logger.log(new LogEvent((Object)dm, LOGID, 3, "Read invalid: " + originator + " piece #" + pieceNumber + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecksAfterSkipChange(DiskManagerFileInfoSet fileSet, boolean[] toCheck, boolean isSkipped, DownloadManager dm) {
        if (!dm.isConstructed()) {
            return;
        }
        DiskManagerFileInfo[] files = fileSet.getFiles();
        boolean[] interesting = new boolean[files.length];
        int i = 0;
        while (i < files.length) {
            DiskManagerFileInfo file = files[i];
            if (toCheck[i]) {
                interesting[i] = true;
                int firstPiece = file.getFirstPieceNumber();
                int j = i - 1;
                while (j >= 0) {
                    if (files[j].getLastPieceNumber() != firstPiece) break;
                    interesting[j] = true;
                    --j;
                }
                int lastPiece = file.getLastPieceNumber();
                int j2 = i + 1;
                while (j2 < files.length) {
                    if (files[j2].getFirstPieceNumber() != lastPiece) break;
                    interesting[j2] = true;
                    ++j2;
                }
            }
            ++i;
        }
        ArrayList<DiskManagerFileInfo> reallocs = new ArrayList<DiskManagerFileInfo>();
        String[] types = DiskManagerImpl.getStorageTypes(dm);
        int i2 = 0;
        while (i2 < interesting.length) {
            if (interesting[i2]) {
                File currentFile;
                int st;
                DiskManagerFileInfo file = files[i2];
                if (RDResumeHandler.fileMustExist(dm, fileSet, file)) {
                    if (!isSkipped && !file.exists()) {
                        reallocs.add(file);
                    }
                } else if (isSkipped && ((st = DiskManagerUtil.convertDMStorageTypeFromString(types[i2])) == 2 || st == 4) && FileUtil.exists(currentFile = file.getFile(true))) {
                    FileUtil.log("Deleting \"" + currentFile.getAbsolutePath() + "\" as no longer required", true);
                    boolean no_recycle = true;
                    FileUtil.deleteWithRecycle(currentFile, dm.getDownloadState().getFlag(16L) || no_recycle);
                }
            }
            ++i2;
        }
        if (!reallocs.isEmpty()) {
            dm.requestAllocation(reallocs);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static String setFileLink(DownloadManager download_manager, DiskManagerFileInfo[] info, DiskManagerFileInfo file_info, File from_file, File to_link, boolean dont_delete_existing, FileUtil.ProgressListener pl) {
        block10: {
            File existing_file;
            block12: {
                block13: {
                    block11: {
                        if (to_link == null) break block10;
                        existing_file = file_info.getFile(true);
                        if (!to_link.equals(existing_file)) break block11;
                        if (!FileUtil.areFilePathsIdentical(to_link, existing_file) && FileUtil.exists(existing_file) && !FileUtil.renameFile(existing_file, to_link)) {
                            String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                            Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                            return error;
                        }
                        break block10;
                    }
                    int i = 0;
                    while (i < info.length) {
                        if (to_link.equals(info[i].getFile(true))) {
                            String error = "Attempt to link to existing file '" + info[i].getFile(true) + "'";
                            Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                            return error;
                        }
                        ++i;
                    }
                    if (!FileUtil.exists(to_link)) break block12;
                    if (FileUtil.exists(existing_file)) break block13;
                    download_manager.recheckFile(file_info);
                    break block10;
                }
                if (to_link.getParent().equals(existing_file.getParent()) && to_link.getName().equalsIgnoreCase(existing_file.getName())) {
                    if (!FileUtil.renameFile(existing_file, to_link)) {
                        String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                        Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                        return error;
                    }
                    break block10;
                } else if (dont_delete_existing) {
                    download_manager.recheckFile(file_info);
                    break block10;
                } else {
                    int st = file_info.getStorageType();
                    boolean no_recycle = st == 2 || st == 4;
                    FileUtil.log("Deleting \"" + existing_file.getAbsolutePath() + "\" as no longer required", true);
                    if (!FileUtil.deleteWithRecycle(existing_file, download_manager.getDownloadState().getFlag(16L) || no_recycle)) {
                        String error = "Failed to delete '" + existing_file.toString() + "'";
                        Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                        return error;
                    }
                    download_manager.recheckFile(file_info);
                }
                break block10;
            }
            if (FileUtil.exists(existing_file) && !FileUtil.renameFile(existing_file, to_link, pl)) {
                String error = "Failed to rename '" + existing_file.toString() + "' to '" + to_link.toString() + "'";
                Logger.log(new LogAlert((Object)download_manager, true, 3, error));
                return error;
            }
        }
        DownloadManagerState state = download_manager.getDownloadState();
        state.setFileLink(file_info.getIndex(), from_file, to_link);
        return null;
    }

    public static DiskManagerFileInfoSet getFileInfoSkeleton(final DownloadManager download_manager, DiskManagerListener listener) {
        TOTorrent torrent = download_manager.getTorrent();
        if (torrent == null) {
            return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
        }
        File tempRootDir = download_manager.getAbsoluteSaveLocation().getParentFile();
        if (tempRootDir == null) {
            tempRootDir = download_manager.getAbsoluteSaveLocation();
        }
        if (!torrent.isSimpleTorrent()) {
            tempRootDir = FileUtil.newFile(tempRootDir, download_manager.getAbsoluteSaveLocation().getName());
        }
        boolean[] loading = new boolean[]{true};
        File root_dir = tempRootDir;
        try {
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            TOTorrentFile[] torrent_files = torrent.getFiles();
            DiskManagerFileInfoHelper[] res = new FileSkeleton[torrent_files.length];
            String incomplete_suffix = download_manager.getDownloadState().getAttribute("incompfilesuffix");
            DiskManagerFileInfoSet fileSetSkeleton = new DiskManagerFileInfoSet((FileSkeleton[])res, loading, download_manager, listener){
                private final /* synthetic */ FileSkeleton[] val$res;
                private final /* synthetic */ boolean[] val$loading;
                private final /* synthetic */ DownloadManager val$download_manager;
                private final /* synthetic */ DiskManagerListener val$listener;
                {
                    this.val$res = fileSkeletonArray;
                    this.val$loading = blArray;
                    this.val$download_manager = downloadManager;
                    this.val$listener = diskManagerListener;
                }

                @Override
                public void load(int[] priorities, boolean[] skipped) {
                    int i = 0;
                    while (i < priorities.length) {
                        this.val$res[i].load(priorities[i], skipped[i]);
                        ++i;
                    }
                }

                @Override
                public DiskManagerFileInfo[] getFiles() {
                    return this.val$res;
                }

                private DiskManager getDiskManager() {
                    return null;
                }

                @Override
                public int nbFiles() {
                    return this.val$res.length;
                }

                @Override
                public void setPriority(int[] newPriorities) {
                    if (newPriorities.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    ArrayList<DiskManagerFileInfo> priorityChanged = new ArrayList<DiskManagerFileInfo>(this.val$res.length);
                    int i = 0;
                    while (i < this.val$res.length) {
                        FileSkeleton file = this.val$res[i];
                        int np = newPriorities[i];
                        if (np != Integer.MIN_VALUE && file.priority != np) {
                            file.priority = np;
                            priorityChanged.add(file);
                        }
                        ++i;
                    }
                    if (!this.val$loading[0]) {
                        DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                    }
                    if (!priorityChanged.isEmpty()) {
                        this.val$listener.filePriorityChanged(this.getDiskManager(), priorityChanged);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void setSkipped(boolean[] toChange, boolean setSkipped) {
                    Object object = skip_lock;
                    synchronized (object) {
                        int i;
                        if (toChange.length != this.val$res.length) {
                            throw new IllegalArgumentException("array length mismatches the number of files");
                        }
                        if (!setSkipped) {
                            String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                            boolean[] toLinear = new boolean[toChange.length];
                            boolean[] toReorder = new boolean[toChange.length];
                            int num_linear = 0;
                            int num_reorder = 0;
                            i = 0;
                            while (i < toChange.length) {
                                if (toChange[i]) {
                                    int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                                    if (old_type == 2) {
                                        toLinear[i] = true;
                                        ++num_linear;
                                    } else if (old_type == 4) {
                                        toReorder[i] = true;
                                        ++num_reorder;
                                    }
                                }
                                ++i;
                            }
                            if (num_linear > 0 && !Arrays.equals(toLinear, this.setStorageTypes(toLinear, 1))) {
                                return;
                            }
                            if (num_reorder > 0 && !Arrays.equals(toReorder, this.setStorageTypes(toReorder, 3))) {
                                return;
                            }
                        }
                        File[] to_link = new File[this.val$res.length];
                        int i2 = 0;
                        while (i2 < this.val$res.length) {
                            if (toChange[i2]) {
                                to_link[i2] = this.val$res[i2].setSkippedInternal(setSkipped);
                            }
                            ++i2;
                        }
                        if (!this.val$loading[0]) {
                            DiskManagerImpl.storeFilePriorities(this.val$download_manager, this.val$res);
                        }
                        ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                        ArrayList<File> from_links = new ArrayList<File>();
                        ArrayList<File> to_links = new ArrayList<File>();
                        int i3 = 0;
                        while (i3 < this.val$res.length) {
                            if (to_link[i3] != null) {
                                from_indexes.add(i3);
                                from_links.add(this.val$res[i3].getFile(false));
                                to_links.add(to_link[i3]);
                            }
                            ++i3;
                        }
                        if (from_links.size() > 0) {
                            this.val$download_manager.getDownloadState().setFileLinks(from_indexes, from_links, to_links);
                        }
                        ArrayList<DiskManagerFileInfo> priority_change = new ArrayList<DiskManagerFileInfo>(this.val$res.length);
                        i = 0;
                        while (i < this.val$res.length) {
                            if (toChange[i]) {
                                priority_change.add(this.val$res[i]);
                            }
                            ++i;
                        }
                        if (!priority_change.isEmpty()) {
                            this.val$listener.filePriorityChanged(this.getDiskManager(), priority_change);
                        }
                        DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this, toChange, setSkipped, this.val$download_manager);
                    }
                }

                @Override
                public boolean[] setStorageTypes(boolean[] toChange, int newStorageType, boolean force) {
                    int i;
                    if (toChange.length != this.val$res.length) {
                        throw new IllegalArgumentException("array length mismatches the number of files");
                    }
                    String[] types = DiskManagerImpl.getStorageTypes(this.val$download_manager);
                    boolean[] modified = new boolean[this.val$res.length];
                    boolean[] toSkip = new boolean[this.val$res.length];
                    int toSkipCount = 0;
                    DownloadManagerState dmState = this.val$download_manager.getDownloadState();
                    try {
                        dmState.suppressStateSave(true);
                        boolean recalc_dl = false;
                        i = 0;
                        while (i < this.val$res.length) {
                            if (toChange[i]) {
                                final int idx = i;
                                int old_type = DiskManagerUtil.convertDMStorageTypeFromString(types[i]);
                                if (newStorageType == old_type) {
                                    modified[i] = true;
                                } else {
                                    try {
                                        File target_file = this.val$res[i].getFile(true);
                                        if (FileUtil.exists(target_file)) {
                                            try (CacheFile cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                                @Override
                                                public String getCacheFileOwnerName() {
                                                    return val$download_manager.getInternalName();
                                                }

                                                @Override
                                                public TOTorrentFile getCacheFileTorrentFile() {
                                                    return val$res[idx].getTorrentFile();
                                                }

                                                @Override
                                                public File getCacheFileControlFileDir() {
                                                    return val$download_manager.getDownloadState().getStateDir();
                                                }

                                                @Override
                                                public int getCacheMode() {
                                                    return 1;
                                                }

                                                @Override
                                                public StringInterner.FileKey getCacheFileLink(StringInterner.FileKey file) {
                                                    return val$download_manager.getDownloadState().getFileLink(idx, file);
                                                }
                                            }, new StringInterner.FileKey(target_file), DiskManagerUtil.convertDMStorageTypeToCache(newStorageType), force);){
                                                cache_file.getLength();
                                            }
                                        }
                                        boolean bl = toSkip[i] = (newStorageType == 2 || newStorageType == 4) && !this.val$res[i].isSkipped();
                                        if (toSkip[i]) {
                                            ++toSkipCount;
                                        }
                                        modified[i] = true;
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                        Logger.log(new LogAlert((Object)this.val$download_manager, true, 3, "Failed to change storage type for '" + this.val$res[i].getFile(true) + "': " + Debug.getNestedExceptionMessage(e)));
                                        RDResumeHandler.recheckFile(this.val$download_manager, this.val$res[i]);
                                    }
                                    types[i] = DiskManagerUtil.convertDMStorageTypeToString(newStorageType);
                                }
                            }
                            ++i;
                        }
                        dmState.setListAttribute("storetypes", types);
                        if (toSkipCount > 0) {
                            this.setSkipped(toSkip, true);
                        }
                        i = 0;
                        while (i < this.val$res.length) {
                            int cleared;
                            if (toChange[i] && (cleared = RDResumeHandler.storageTypeChanged(this.val$download_manager, this.val$res[i])) > 0) {
                                this.val$res[i].downloaded -= (long)cleared * this.val$res[i].getTorrentFile().getTorrent().getPieceLength();
                                if (this.val$res[i].downloaded < 0L) {
                                    this.val$res[i].downloaded = 0L;
                                }
                                recalc_dl = true;
                            }
                            ++i;
                        }
                        if (recalc_dl) {
                            this.val$download_manager.getStats().setDownloadCompletedBytes(-1L);
                        }
                        DiskManagerImpl.storeFileDownloaded(this.val$download_manager, this.val$res, true, false);
                    }
                    finally {
                        dmState.suppressStateSave(false);
                        dmState.save(false);
                    }
                    ArrayList<DiskManagerFileInfo> priorityChanged = new ArrayList<DiskManagerFileInfo>(this.val$res.length);
                    i = 0;
                    while (i < this.val$res.length) {
                        if (toChange[i]) {
                            priorityChanged.add(this.val$res[i]);
                        }
                        ++i;
                    }
                    if (!priorityChanged.isEmpty()) {
                        this.val$listener.filePriorityChanged(this.getDiskManager(), priorityChanged);
                    }
                    return modified;
                }
            };
            int i = 0;
            while (i < res.length) {
                TOTorrentFile torrent_file = torrent_files[i];
                int file_index = i;
                FileSkeleton info = new FileSkeleton((FileSkeleton[])res, listener, file_index, fileSetSkeleton, incomplete_suffix, torrent_file, root_dir, locale_decoder){
                    private volatile CacheFile read_cache_file;
                    private WeakReference<StringInterner.FileKey> dataFile = new WeakReference<Object>(null);
                    private volatile Boolean skipping;
                    private final /* synthetic */ FileSkeleton[] val$res;
                    private final /* synthetic */ DiskManagerListener val$listener;
                    private final /* synthetic */ int val$file_index;
                    private final /* synthetic */ DiskManagerFileInfoSet val$fileSetSkeleton;
                    private final /* synthetic */ String val$incomplete_suffix;
                    private final /* synthetic */ TOTorrentFile val$torrent_file;
                    private final /* synthetic */ File val$root_dir;
                    private final /* synthetic */ LocaleUtilDecoder val$locale_decoder;
                    {
                        this.val$res = fileSkeletonArray;
                        this.val$listener = diskManagerListener;
                        this.val$file_index = n;
                        this.val$fileSetSkeleton = diskManagerFileInfoSet;
                        this.val$incomplete_suffix = string;
                        this.val$torrent_file = tOTorrentFile;
                        this.val$root_dir = file;
                        this.val$locale_decoder = localeUtilDecoder;
                    }

                    @Override
                    public void setPriority(int b) {
                        this.priority = b;
                        DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                        this.val$listener.filePriorityChanged(this.getDiskManager(), this);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void setSkipped(boolean skipped) {
                        Object object = skip_lock;
                        synchronized (object) {
                            try {
                                this.skipping = skipped;
                                if (!skipped && this.getStorageType() == 2 && !this.setStorageType(1)) {
                                    return;
                                }
                                if (!skipped && this.getStorageType() == 4 && !this.setStorageType(3)) {
                                    return;
                                }
                                File to_link = this.setSkippedInternal(skipped);
                                DiskManagerImpl.storeFilePriorities(download_manager, this.val$res);
                                if (to_link != null) {
                                    download_manager.getDownloadState().setFileLink(this.val$file_index, this.getFile(false), to_link);
                                }
                                this.val$listener.filePriorityChanged(this.getDiskManager(), this);
                                boolean[] toCheck = new boolean[this.val$fileSetSkeleton.nbFiles()];
                                toCheck[this.val$file_index] = true;
                                DiskManagerUtil.doFileExistenceChecksAfterSkipChange(this.val$fileSetSkeleton, toCheck, skipped, download_manager);
                            }
                            finally {
                                this.skipping = null;
                            }
                            return;
                        }
                    }

                    @Override
                    public Boolean isSkipping() {
                        return this.skipping;
                    }

                    @Override
                    public int getAccessMode() {
                        return 1;
                    }

                    @Override
                    public long getDownloaded() {
                        return this.downloaded;
                    }

                    @Override
                    public long getLastModified() {
                        return this.getFile(true).lastModified();
                    }

                    @Override
                    public void setDownloaded(long l) {
                        this.downloaded = l;
                    }

                    @Override
                    public String getExtension() {
                        int separator;
                        String ext = this.lazyGetFile().getName();
                        if (this.val$incomplete_suffix != null && ext.endsWith(this.val$incomplete_suffix)) {
                            ext = ext.substring(0, ext.length() - this.val$incomplete_suffix.length());
                        }
                        if ((separator = ext.lastIndexOf(".")) == -1) {
                            separator = 0;
                        }
                        return ext.substring(separator);
                    }

                    @Override
                    public int getFirstPieceNumber() {
                        return this.val$torrent_file.getFirstPieceNumber();
                    }

                    @Override
                    public int getLastPieceNumber() {
                        return this.val$torrent_file.getLastPieceNumber();
                    }

                    @Override
                    public long getLength() {
                        return this.val$torrent_file.getLength();
                    }

                    @Override
                    public int getIndex() {
                        return this.val$file_index;
                    }

                    @Override
                    public int getNbPieces() {
                        return this.val$torrent_file.getNumberOfPieces();
                    }

                    @Override
                    public int getPriority() {
                        return this.priority;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected File setSkippedInternal(boolean _skipped) {
                        Object object = skip_lock;
                        synchronized (object) {
                            this.skipped_internal = _skipped;
                            if (!download_manager.isDestroyed()) {
                                return DiskManagerUtil.setSkippedInternalSupport(download_manager, this, null, _skipped);
                            }
                            return null;
                        }
                    }

                    @Override
                    public boolean isSkipped() {
                        return this.skipped_internal;
                    }

                    @Override
                    public DiskManager getDiskManager() {
                        return null;
                    }

                    @Override
                    public DownloadManager getDownloadManager() {
                        return download_manager;
                    }

                    @Override
                    public boolean exists() {
                        if (this.val$torrent_file.isPadFile()) {
                            return true;
                        }
                        return this.getFile(true).exists();
                    }

                    @Override
                    public File getFile(boolean follow_link) {
                        File link;
                        if (follow_link && (link = this.getLink()) != null) {
                            return link;
                        }
                        return this.lazyGetFile();
                    }

                    private File lazyGetFile() {
                        StringInterner.FileKey fk = (StringInterner.FileKey)this.dataFile.get();
                        if (fk == null) {
                            TOTorrent tor = download_manager.getTorrent();
                            fk = tor == null || tor.isSimpleTorrent() ? new StringInterner.FileKey(download_manager.getAbsoluteSaveLocation()) : new StringInterner.FileKey(this.val$root_dir, this.val$torrent_file.getRelativePath(this.val$locale_decoder));
                            this.dataFile = new WeakReference<StringInterner.FileKey>(fk);
                        }
                        return fk.getFile();
                    }

                    @Override
                    public TOTorrentFile getTorrentFile() {
                        return this.val$torrent_file;
                    }

                    @Override
                    public boolean setLink(File link_destination, boolean no_delete) {
                        this.last_error = null;
                        if (download_manager.getTorrent().isSimpleTorrent()) {
                            try {
                                download_manager.moveDataFiles(link_destination.getParentFile(), link_destination.getName());
                                return true;
                            }
                            catch (DownloadManagerException e) {
                                Debug.out(e);
                                this.last_error = Debug.getNestedExceptionMessage(e);
                                return false;
                            }
                        }
                        return this.setLinkAtomic(link_destination, no_delete);
                    }

                    @Override
                    public String getLastError() {
                        return this.last_error;
                    }

                    @Override
                    public boolean setLinkAtomic(File link_destination, boolean no_delete) {
                        this.last_error = DiskManagerUtil.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination, no_delete, null);
                        return this.last_error == null;
                    }

                    @Override
                    public boolean setLinkAtomic(File link_destination, boolean no_delete, FileUtil.ProgressListener pl) {
                        this.last_error = DiskManagerUtil.setFileLink(download_manager, this.val$res, this, this.lazyGetFile(), link_destination, no_delete, pl);
                        return this.last_error == null;
                    }

                    @Override
                    public File getLink() {
                        return download_manager.getDownloadState().getFileLink(this.val$file_index);
                    }

                    @Override
                    public boolean setStorageType(int type, boolean force) {
                        boolean[] change = new boolean[this.val$res.length];
                        change[this.val$file_index] = true;
                        return this.val$fileSetSkeleton.setStorageTypes(change, type, force)[this.val$file_index];
                    }

                    @Override
                    public int getStorageType() {
                        return DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                    }

                    @Override
                    public void flushCache() {
                    }

                    @Override
                    public DirectByteBuffer read(long offset, int length) throws IOException {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            if (this.read_cache_file == null) {
                                try {
                                    int type = DiskManagerUtil.convertDMStorageTypeFromString(DiskManagerImpl.getStorageType(download_manager, this.val$file_index));
                                    this.read_cache_file = CacheFileManagerFactory.getSingleton().createFile(new CacheFileOwner(){

                                        @Override
                                        public String getCacheFileOwnerName() {
                                            return download_manager.getInternalName();
                                        }

                                        @Override
                                        public TOTorrentFile getCacheFileTorrentFile() {
                                            return val$torrent_file;
                                        }

                                        @Override
                                        public File getCacheFileControlFileDir() {
                                            return download_manager.getDownloadState().getStateDir();
                                        }

                                        @Override
                                        public int getCacheMode() {
                                            return 1;
                                        }

                                        @Override
                                        public StringInterner.FileKey getCacheFileLink(StringInterner.FileKey file) {
                                            return download_manager.getDownloadState().getFileLink(val$file_index, file);
                                        }
                                    }, new StringInterner.FileKey(this.getFile(true)), DiskManagerUtil.convertDMStorageTypeToCache(type), false);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                    throw new IOException(e.getMessage());
                                }
                            }
                            temp = this.read_cache_file;
                        }
                        finally {
                            cache_read_mon.exit();
                        }
                        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)6, length);
                        try {
                            temp.read(buffer, offset, (short)1);
                        }
                        catch (Throwable e) {
                            buffer.returnToPool();
                            Debug.printStackTrace(e);
                            throw new IOException(e.getMessage());
                        }
                        return buffer;
                    }

                    @Override
                    public int getReadBytesPerSecond() {
                        CacheFile temp = this.read_cache_file;
                        if (temp == null) {
                            return 0;
                        }
                        return 0;
                    }

                    @Override
                    public int getWriteBytesPerSecond() {
                        return 0;
                    }

                    @Override
                    public long getETA() {
                        return -1L;
                    }

                    @Override
                    public void recheck() {
                        DiskManagerFactory.recheckFile(this.getDownloadManager(), this);
                    }

                    @Override
                    public void close() {
                        CacheFile temp;
                        try {
                            cache_read_mon.enter();
                            temp = this.read_cache_file;
                            this.read_cache_file = null;
                        }
                        finally {
                            cache_read_mon.exit();
                        }
                        if (temp != null) {
                            try {
                                temp.close();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    @Override
                    public void addListener(DiskManagerFileInfoListener listener) {
                        if (this.getDownloaded() == this.getLength()) {
                            try {
                                listener.dataWritten(0L, this.getLength(), null);
                                listener.dataChecked(0L, this.getLength());
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }

                    @Override
                    public void removeListener(DiskManagerFileInfoListener listener) {
                    }
                };
                res[i] = info;
                ++i;
            }
            DiskManagerUtil.loadFilePriorities(download_manager, fileSetSkeleton);
            DiskManagerUtil.loadFileDownloaded(download_manager, res);
            DiskManagerFileInfoSet diskManagerFileInfoSet = fileSetSkeleton;
            loading[0] = false;
            return diskManagerFileInfoSet;
        }
        catch (Throwable throwable) {
            try {
                loading[0] = false;
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return new DiskManagerFileInfoSetImpl(new DiskManagerFileInfoImpl[0], null);
            }
        }
    }

    public static int convertDMStorageTypeFromString(String str) {
        char c = str.charAt(0);
        switch (c) {
            case 'L': {
                return 1;
            }
            case 'C': {
                return 2;
            }
            case 'R': {
                return 3;
            }
            case 'X': {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    public static String convertDMStorageTypeToString(int dm_type) {
        switch (dm_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static String convertCacheStorageTypeToString(int cache_type) {
        switch (cache_type) {
            case 1: {
                return "L";
            }
            case 2: {
                return "C";
            }
            case 3: {
                return "R";
            }
            case 4: {
                return "X";
            }
        }
        Debug.out("eh?");
        return "?";
    }

    public static int convertDMStorageTypeToCache(int dm_type) {
        switch (dm_type) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        Debug.out("eh?");
        return 1;
    }

    protected static void storeFilePriorities(DownloadManager download_manager, DiskManagerFileInfo[] files) {
        if (files == null) {
            return;
        }
        ArrayList<Long> file_priorities = new ArrayList<Long>(files.length);
        int i = 0;
        while (i < files.length) {
            int value;
            DiskManagerFileInfo file = files[i];
            if (file == null) {
                return;
            }
            boolean skipped = file.isSkipped();
            int priority = file.getPriority();
            if (skipped) {
                value = 0;
            } else if (priority > 0) {
                value = priority;
            } else {
                value = priority - 1;
                if (value > 0) {
                    value = Integer.MIN_VALUE;
                }
            }
            file_priorities.add(i, Long.valueOf(value));
            ++i;
        }
        download_manager.setUserData("file_priorities", file_priorities);
        if (files.length > 0 && !(files[0] instanceof DiskManagerFileInfoImpl)) {
            long skipped_file_set_size = 0L;
            long skipped_but_downloaded = 0L;
            int i2 = 0;
            while (i2 < files.length) {
                DiskManagerFileInfo file = files[i2];
                if (file.isSkipped()) {
                    skipped_file_set_size += file.getLength();
                    skipped_but_downloaded += file.getDownloaded();
                }
                ++i2;
            }
            DownloadManagerStats stats2 = download_manager.getStats();
            if (stats2 instanceof DownloadManagerStatsImpl) {
                ((DownloadManagerStatsImpl)stats2).setSkippedFileStats(skipped_file_set_size, skipped_but_downloaded);
            }
        }
    }

    static void loadFilePriorities(DownloadManager download_manager, DiskManagerFileInfoSet fileSet) {
        try {
            DiskManagerFileInfo[] files = fileSet.getFiles();
            if (files == null) {
                return;
            }
            List file_priorities = (List)download_manager.getUserData("file_priorities");
            if (file_priorities == null) {
                return;
            }
            boolean[] toSkip = new boolean[files.length];
            int[] prio = new int[files.length];
            int i = 0;
            while (i < files.length) {
                DiskManagerFileInfo file = files[i];
                if (file == null) {
                    return;
                }
                try {
                    int priority = ((Long)file_priorities.get(i)).intValue();
                    if (priority == 0) {
                        toSkip[i] = true;
                    } else {
                        if (priority < 0) {
                            // empty if block
                        }
                        prio[i] = ++priority;
                    }
                }
                catch (Throwable t2) {
                    Debug.printStackTrace(t2);
                }
                ++i;
            }
            fileSet.load(prio, toSkip);
        }
        catch (Throwable t) {
            Debug.printStackTrace(t);
        }
    }

    protected static void loadFileDownloaded(DownloadManager download_manager, DiskManagerFileInfoHelper[] files) {
        DownloadManagerState state = download_manager.getDownloadState();
        Map details = state.getMapAttribute("filedownloaded");
        if (details == null) {
            return;
        }
        List downloaded = (List)details.get("downloaded");
        if (downloaded == null) {
            return;
        }
        try {
            int i = 0;
            int max = Math.min(files.length, downloaded.size());
            while (i < max) {
                files[i].setDownloaded((Long)downloaded.get(i));
                ++i;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public static boolean isNoSpaceException(Throwable e) {
        String exception_str = Debug.getNestedExceptionMessage(e);
        String lc = exception_str.toLowerCase(Locale.US);
        return lc.contains(" space");
    }

    public static boolean isFileWriteException(Throwable e) {
        while (e != null) {
            if (e instanceof FMFileManagerException && ((FMFileManagerException)e).getOperation() == 4) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    public static DiskManagerPiece[] getDiskManagerPiecesSnapshot(final DownloadManager dm, DiskManagerFileInfoSet file_set) {
        try {
            TOTorrent torrent = dm.getTorrent();
            if (torrent == null) {
                return new DiskManagerPiece[0];
            }
            DMPieceMapper piece_mapper = DMPieceMapperFactory.create(torrent);
            final int nbPieces = torrent.getNumberOfPieces();
            final int pieceLength = (int)torrent.getPieceLength();
            final int lastPieceLength = piece_mapper.getLastPieceLength();
            final DiskManagerPiece[] pieces = new DiskManagerPiece[nbPieces];
            DiskManagerFileInfo[] files = file_set.getFiles();
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            piece_mapper.construct(locale_decoder, dm.getAbsoluteSaveLocation().getName());
            DMPieceMapperFile[] pm_files = piece_mapper.getFiles();
            int i = 0;
            while (i < pm_files.length) {
                pm_files[i].setFileInfo(files[i]);
                ++i;
            }
            final DMPieceMap piece_map = piece_mapper.getPieceMap();
            DiskManagerHelper disk_manager = new DiskManagerHelper(){

                @Override
                public String getDisplayName() {
                    return "";
                }

                @Override
                public DownloadManager getDownload() {
                    return dm;
                }

                @Override
                public boolean stop(boolean closing) {
                    return false;
                }

                @Override
                public void start() {
                }

                @Override
                public void setPieceCheckingEnabled(boolean enabled) {
                }

                @Override
                public void setMoveState(int state) {
                }

                @Override
                public void saveState(boolean interim) {
                }

                @Override
                public void saveResumeData(boolean interim_save) throws Exception {
                }

                @Override
                public void removeListener(DiskManagerListener l) {
                }

                @Override
                public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
                    return null;
                }

                @Override
                public void moveDataFiles(File new_parent_dir, String dl_name) {
                }

                @Override
                public void rateLimitChanged() {
                }

                @Override
                public boolean isStopped() {
                    return true;
                }

                @Override
                public boolean isInteresting(int pieceNumber) {
                    return false;
                }

                @Override
                public boolean isDone(int pieceNumber) {
                    return false;
                }

                @Override
                public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasOutstandingReadRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
                    return false;
                }

                @Override
                public boolean hasListener(DiskManagerListener l) {
                    return false;
                }

                @Override
                public long getTotalLength() {
                    return 0L;
                }

                @Override
                public int getState() {
                    return 0;
                }

                @Override
                public long getSizeExcludingDND() {
                    return 0L;
                }

                @Override
                public File getSaveLocation() {
                    return null;
                }

                @Override
                public long getRemainingExcludingDND() {
                    return 0L;
                }

                @Override
                public long getRemaining() {
                    return 0L;
                }

                @Override
                public long[] getReadStats() {
                    return null;
                }

                @Override
                public long[] getWriteStats() {
                    return null;
                }

                @Override
                public long getPriorityChangeMarker() {
                    return 0L;
                }

                @Override
                public DiskManagerPiece[] getPieces() {
                    return pieces;
                }

                @Override
                public DMPieceMap getPieceMap() {
                    return piece_map;
                }

                @Override
                public BitFlags getAvailability() {
                    return null;
                }

                @Override
                public int getPieceLength(int piece_number) {
                    return piece_number == nbPieces - 1 ? lastPieceLength : pieceLength;
                }

                @Override
                public int getPieceLength() {
                    return pieceLength;
                }

                @Override
                public DiskManagerPiece getPiece(int piece_number) {
                    return pieces[piece_number];
                }

                @Override
                public int getPercentDoneExcludingDND() {
                    return 0;
                }

                @Override
                public int getPercentDone() {
                    return 0;
                }

                @Override
                public int getPercentAllocated() {
                    return 0;
                }

                @Override
                public int getNbPieces() {
                    return pieces.length;
                }

                @Override
                public String getMoveSubTask() {
                    return null;
                }

                @Override
                public long[] getMoveProgress() {
                    return null;
                }

                @Override
                public DiskManagerFileInfo[] getFiles() {
                    return null;
                }

                @Override
                public DiskManagerFileInfoSet getFileSet() {
                    return null;
                }

                @Override
                public int getErrorType() {
                    return 0;
                }

                @Override
                public String getErrorMessage() {
                    return null;
                }

                @Override
                public int getCompleteRecheckStatus() {
                    return 0;
                }

                @Override
                public boolean getRecheckCancelled() {
                    return false;
                }

                @Override
                public int getCacheMode() {
                    return 0;
                }

                @Override
                public void generateEvidence(IndentWriter writer) {
                }

                @Override
                public boolean filesExist() {
                    return false;
                }

                @Override
                public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
                }

                @Override
                public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
                }

                @Override
                public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
                }

                @Override
                public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
                }

                @Override
                public void downloadRemoved() {
                }

                @Override
                public DiskManager.DownloadEndedProgress downloadEnded(boolean start_of_day) {
                    return new DiskManager.DownloadEndedProgress(){

                        @Override
                        public boolean isComplete() {
                            return true;
                        }
                    };
                }

                @Override
                public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
                    return null;
                }

                @Override
                public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
                    return null;
                }

                @Override
                public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
                    return null;
                }

                @Override
                public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
                    return false;
                }

                @Override
                public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
                    return false;
                }

                @Override
                public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
                    return false;
                }

                @Override
                public void addListener(DiskManagerListener l) {
                }

                @Override
                public void skippedFileSetChanged(DiskManagerFileInfo file) {
                }

                @Override
                public void setPieceDone(DiskManagerPieceImpl piece, boolean done) {
                    piece.setDoneSupport(done);
                }

                @Override
                public void setFailedAndRecheck(DiskManagerFileInfo file, String reason) {
                }

                @Override
                public boolean isUploadOnly() {
                    return false;
                }

                @Override
                public void setFailed(int type, String reason, Throwable cause, boolean can_continue) {
                }

                @Override
                public void priorityChanged(DiskManagerFileInfo file) {
                }

                @Override
                public void storageTypeChanged(DiskManagerFileInfo file) {
                }

                @Override
                public TOTorrent getTorrent() {
                    return null;
                }

                @Override
                public String[] getStorageTypes() {
                    return null;
                }

                @Override
                public String getStorageType(int fileIndex) {
                    return null;
                }

                @Override
                public DiskManagerRecheckScheduler getRecheckScheduler() {
                    return null;
                }

                @Override
                public DMPieceList getPieceList(int piece_number) {
                    return piece_map.getPieceList(piece_number);
                }

                @Override
                public byte[] getPieceHash(int piece_number) throws TOTorrentException {
                    return null;
                }

                @Override
                public String getInternalName() {
                    return null;
                }

                @Override
                public DownloadManagerState getDownloadState() {
                    return null;
                }

                @Override
                public DiskAccessController getDiskAccessController() {
                    return null;
                }
            };
            int i2 = 0;
            while (i2 < nbPieces) {
                pieces[i2] = new DiskManagerPieceImpl(disk_manager, i2, i2 == nbPieces - 1 ? lastPieceLength : pieceLength);
                ++i2;
            }
            RDResumeHandler.setupPieces(dm.getDownloadState(), pieces);
            i2 = 0;
            while (i2 < nbPieces) {
                pieces[i2].calcNeeded();
                ++i2;
            }
            return pieces;
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public static void runMoveTask(final DownloadManager download_manager, final File destination, final Runnable target, MoveTaskAapter adapter) throws DownloadManagerException {
        try {
            DownloadManagerStats stats2 = download_manager.getStats();
            if (stats2.getTotalDataBytesReceived() == 0L && stats2.getPercentDoneExcludingDND() == 0) {
                boolean found_file = false;
                DiskManagerFileInfo[] diskManagerFileInfoArray = download_manager.getDiskManagerFileInfoSet().getFiles();
                int n = diskManagerFileInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DiskManagerFileInfo info = diskManagerFileInfoArray[n2];
                    if (!info.getTorrentFile().isPadFile() && info.exists()) {
                        found_file = true;
                        break;
                    }
                    ++n2;
                }
                if (!found_file) {
                    target.run();
                    return;
                }
            }
            FileUtil.runAsTask(new CoreOperationTask(adapter){
                private boolean added_to_tasks = false;
                private boolean queued = true;
                private CoreOperationTask.ProgressCallback callback;
                {
                    this.callback = new CoreOperationTask.ProgressCallbackAdapter(move_smallest_first ? 2 : 1){
                        private volatile int current_state;
                        {
                            super($anonymous0);
                            this.current_state = 0;
                        }

                        @Override
                        public int getProgress() {
                            long[] mp = moveTaskAapter.getMoveProgress();
                            return mp == null ? 0 : (int)mp[0];
                        }

                        @Override
                        public long getSize() {
                            long[] mp = moveTaskAapter.getMoveProgress();
                            return mp == null ? downloadManager.getStats().getSizeExcludingDND() : mp[1];
                        }

                        @Override
                        public String getSubTaskName() {
                            return moveTaskAapter.getMoveSubTask();
                        }

                        @Override
                        public int getSupportedTaskStates() {
                            return 15;
                        }

                        @Override
                        public void setTaskState(int state) {
                            if (this.current_state == 4) {
                                return;
                            }
                            if (state == 1) {
                                moveTaskAapter.setMoveState(2);
                                this.current_state = state;
                            } else if (state == 2) {
                                moveTaskAapter.setMoveState(1);
                                this.current_state = 0;
                            } else if (state == 4) {
                                moveTaskAapter.setMoveState(3);
                                this.current_state = 4;
                            }
                        }

                        @Override
                        public int getTaskState() {
                            if (this.current_state == 0 && queued) {
                                return 16;
                            }
                            return this.current_state;
                        }
                    };
                }

                @Override
                public String getName() {
                    return download_manager.getDisplayName();
                }

                @Override
                public DownloadManager getDownload() {
                    return download_manager;
                }

                @Override
                public String[] getAffectedFileSystems() {
                    File save_loc = download_manager.getAbsoluteSaveLocation();
                    return FileUtil.getFileStoreNames(save_loc, destination == null ? save_loc : destination);
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public boolean runOperation(CoreOperation operation) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 28[DOLOOP]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public CoreOperationTask.ProgressCallback getProgressCallback() {
                    return this.callback;
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DownloadManagerException) {
                throw (DownloadManagerException)cause;
            }
            throw e;
        }
    }

    protected static File setSkippedInternalSupport(DownloadManager dm, DiskManagerFileInfo dm_file, CacheFile cache_file, boolean skipped) {
        DownloadManagerState dm_state = dm.getDownloadState();
        int file_index = dm_file.getIndex();
        String dnd_sf = dm_state.getAttribute("dnd_sf");
        if (dnd_sf != null) {
            File new_parent;
            File link_parent;
            File link = dm_file.getLink();
            File base_file = dm_file.getFile(false);
            if (skipped) {
                boolean file_ok;
                File base_parent = base_file.getParentFile();
                boolean bl = file_ok = base_parent != null;
                if (file_ok) {
                    boolean bl2 = file_ok = link == null || link.equals(base_file);
                    if (!file_ok && base_parent != null && base_parent.equals(link.getParentFile())) {
                        file_ok = true;
                    }
                }
                if (file_ok) {
                    File new_parent2;
                    File new_file;
                    boolean incomplete;
                    String new_name = link == null ? base_file.getName() : link.getName();
                    String prefix = dm_state.getAttribute("dnd_pfx");
                    String incomp_ext = dm_state.getAttribute("incompfilesuffix");
                    boolean bl3 = incomplete = dm_file.getDownloaded() != dm_file.getLength();
                    if (prefix != null && incomplete && !new_name.startsWith(prefix)) {
                        new_name = String.valueOf(prefix) + new_name;
                    }
                    if (incomp_ext != null && incomplete && !new_name.endsWith(incomp_ext)) {
                        new_name = String.valueOf(new_name) + incomp_ext;
                    }
                    if (!FileUtil.exists(new_file = FileUtil.newFile(new_parent2 = FileUtil.newFile(base_parent, dnd_sf), new_name))) {
                        if (!FileUtil.exists(new_parent2)) {
                            new_parent2.mkdirs();
                        }
                        if (new_parent2.canWrite()) {
                            if (cache_file == null) {
                                boolean ok;
                                File source;
                                File file = source = link == null ? base_file : link;
                                if (FileUtil.exists(source)) {
                                    ok = FileUtil.renameFile(source, new_file);
                                } else {
                                    ok = true;
                                    File[] files = new_parent2.listFiles();
                                    if (files != null && files.length == 0) {
                                        new_parent2.delete();
                                    }
                                }
                                if (ok) {
                                    return new_file;
                                }
                            } else {
                                boolean ok;
                                try {
                                    dm_state.setFileLink(file_index, base_file, new_file);
                                    cache_file.moveFile(new_file, null);
                                    ok = true;
                                }
                                catch (Throwable e) {
                                    ok = false;
                                    Debug.out(e);
                                }
                                if (!ok) {
                                    dm_state.setFileLink(file_index, base_file, link);
                                }
                            }
                        }
                    }
                }
            } else if (link != null && (link_parent = link.getParentFile()) != null && link_parent.getName().equals(dnd_sf) && (new_parent = link_parent.getParentFile()) != null) {
                boolean ok;
                File new_file = FileUtil.newFile(new_parent, link.getName());
                if (cache_file == null) {
                    File[] files;
                    File result = null;
                    if (FileUtil.exists(link)) {
                        if (FileUtil.renameFile(link, new_file)) {
                            result = new_file;
                        }
                    } else {
                        result = new_file;
                    }
                    if (FileUtil.exists(link_parent) && (files = link_parent.listFiles()) != null && files.length == 0) {
                        link_parent.delete();
                    }
                    return result;
                }
                try {
                    dm_state.setFileLink(file_index, base_file, new_file);
                    cache_file.moveFile(new_file, null);
                    File[] files = link_parent.listFiles();
                    if (files != null && files.length == 0) {
                        link_parent.delete();
                    }
                    ok = true;
                }
                catch (Throwable e) {
                    ok = false;
                    Debug.out(e);
                }
                if (!ok) {
                    dm_state.setFileLink(file_index, base_file, link);
                }
            }
            return null;
        }
        String dnd_al = dm_state.getAttribute("dnd_al");
        if (dnd_al != null) {
            File new_parent;
            File dnd_root = FileUtil.newFile(dnd_al, new String[0]);
            String save_location_path = dm.getSaveLocation().getAbsolutePath();
            File link = dm_file.getLink();
            File base_file = dm_file.getFile(false);
            if (skipped) {
                boolean file_ok;
                File base_parent = base_file.getParentFile();
                boolean bl = file_ok = base_parent != null && base_file.getAbsolutePath().startsWith(save_location_path);
                if (file_ok) {
                    boolean bl4 = file_ok = link == null || link.equals(base_file);
                    if (!file_ok && base_parent != null && base_parent.equals(link.getParentFile())) {
                        file_ok = true;
                    }
                }
                if (file_ok) {
                    File new_parent3;
                    File new_file;
                    boolean incomplete;
                    String new_name = link == null ? base_file.getName() : link.getName();
                    String prefix = dm_state.getAttribute("dnd_pfx");
                    String incomp_ext = dm_state.getAttribute("incompfilesuffix");
                    boolean bl5 = incomplete = dm_file.getDownloaded() != dm_file.getLength();
                    if (prefix != null && incomplete && !new_name.startsWith(prefix)) {
                        new_name = String.valueOf(prefix) + new_name;
                    }
                    if (incomp_ext != null && incomplete && !new_name.endsWith(incomp_ext)) {
                        new_name = String.valueOf(new_name) + incomp_ext;
                    }
                    if (!FileUtil.exists(new_file = FileUtil.newFile(new_parent3 = FileUtil.newFile(dnd_root, base_parent.getAbsolutePath().substring(save_location_path.length())), new_name))) {
                        if (!FileUtil.exists(new_parent3)) {
                            new_parent3.mkdirs();
                        }
                        if (new_parent3.canWrite()) {
                            if (cache_file == null) {
                                boolean ok;
                                File source;
                                File file = source = link == null ? base_file : link;
                                if (FileUtil.exists(source)) {
                                    ok = FileUtil.renameFile(source, new_file);
                                } else {
                                    ok = true;
                                    File[] files = new_parent3.listFiles();
                                    if (files != null && files.length == 0) {
                                        new_parent3.delete();
                                    }
                                }
                                if (ok) {
                                    return new_file;
                                }
                            } else {
                                boolean ok;
                                try {
                                    dm_state.setFileLink(file_index, base_file, new_file);
                                    cache_file.moveFile(new_file, null);
                                    ok = true;
                                }
                                catch (Throwable e) {
                                    ok = false;
                                    Debug.out(e);
                                }
                                if (!ok) {
                                    dm_state.setFileLink(file_index, base_file, link);
                                }
                            }
                        }
                    }
                }
            } else if (link != null && link.getAbsolutePath().startsWith(dnd_root.getAbsolutePath()) && (new_parent = base_file.getParentFile()) != null) {
                boolean ok;
                File new_file = FileUtil.newFile(new_parent, link.getName());
                if (cache_file == null) {
                    File result = null;
                    if (FileUtil.exists(link)) {
                        if (FileUtil.renameFile(link, new_file)) {
                            result = new_file;
                        }
                    } else {
                        result = new_file;
                    }
                    return result;
                }
                try {
                    dm_state.setFileLink(file_index, base_file, new_file);
                    cache_file.moveFile(new_file, null);
                    ok = true;
                }
                catch (Throwable e) {
                    ok = false;
                    Debug.out(e);
                }
                if (!ok) {
                    dm_state.setFileLink(file_index, base_file, link);
                }
            }
        }
        return null;
    }

    static /* synthetic */ List access$1() {
        return move_tasks;
    }

    static abstract class FileSkeleton
    implements DiskManagerFileInfoHelper {
        protected int priority;
        protected boolean skipped_internal;
        protected long downloaded;
        protected String last_error;

        FileSkeleton() {
        }

        protected void load(int _priority, boolean _skipped) {
            this.priority = _priority;
            this.skipped_internal = _skipped;
        }

        protected abstract File setSkippedInternal(boolean var1);
    }

    public static interface MoveTaskAapter {
        public long[] getMoveProgress();

        public String getMoveSubTask();

        public void setMoveState(int var1);
    }
}

