/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.disk.impl.access.impl;

import com.biglybt.core.disk.DiskManagerException;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerAllocationScheduler;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.access.DMWriter;
import com.biglybt.core.disk.impl.access.impl.DiskManagerWriteRequestImpl;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapEntry;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.diskmanager.access.DiskAccessRequest;
import com.biglybt.core.diskmanager.access.DiskAccessRequestListener;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DMWriterImpl
implements DMWriter {
    static final LogIDs LOGID = LogIDs.DISK;
    private static final int MIN_ZERO_BLOCK = 0x100000;
    private final DiskManagerHelper disk_manager;
    private final DiskAccessController disk_access;
    private final ConcurrentHashMap<DiskAccessRequest, String> active_requests = new ConcurrentHashMap();
    private int async_writes;
    private long async_writes_bytes;
    private final Set<DiskManagerWriteRequest> write_requests = new HashSet<DiskManagerWriteRequest>();
    private final AESemaphore async_write_sem = new AESemaphore("DMWriter::asyncWrite");
    private boolean started;
    volatile boolean stopped;
    private final int pieceLength;
    private boolean complete_recheck_in_progress;
    final AEMonitor this_mon = new AEMonitor("DMWriter");
    private long total_write_ops;
    private long total_write_bytes;
    private volatile long latency;

    public DMWriterImpl(DiskManagerHelper _disk_manager) {
        this.disk_manager = _disk_manager;
        this.disk_access = this.disk_manager.getDiskAccessController();
        this.pieceLength = this.disk_manager.getPieceLength();
    }

    @Override
    public void start() {
        try {
            this.this_mon.enter();
            if (this.started) {
                throw new RuntimeException("DMWWriter: start while started");
            }
            if (this.stopped) {
                throw new RuntimeException("DMWWriter: start after stopped");
            }
            this.started = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void stop() {
        int write_wait;
        try {
            this.this_mon.enter();
            if (this.stopped || !this.started) {
                return;
            }
            this.stopped = true;
            write_wait = this.async_writes;
        }
        finally {
            this.this_mon.exit();
        }
        long log_time = SystemTime.getCurrentTime();
        int i = 0;
        while (i < write_wait) {
            long now = SystemTime.getCurrentTime();
            if (now < log_time) {
                log_time = now;
            } else if (now - log_time > 1000L) {
                log_time = now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.disk_manager, LOGID, "Waiting for writes to complete - " + (write_wait - i) + " remaining"));
                }
            }
            this.async_write_sem.reserve();
            ++i;
        }
    }

    public boolean isChecking() {
        return this.complete_recheck_in_progress;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean zeroFile(DiskManagerAllocationScheduler.AllocationInstance allocation_instance, DiskManagerFileInfoImpl file, long start_from, long overall_length, DMWriter.ProgressListener listener) throws DiskManagerException {
        CacheFile cache_file = file.getCacheFile();
        try {
            if (overall_length == 0L) {
                cache_file.setLength(0L);
            } else {
                int buffer_size = this.pieceLength < 0x100000 ? 0x100000 : this.pieceLength;
                buffer_size = (buffer_size + 1023) / 1024 * 1024;
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)7, buffer_size);
                long remainder = overall_length;
                long written = 0L;
                if (start_from > 0L) {
                    remainder -= start_from;
                    written += start_from;
                    listener.allocated(start_from);
                }
                try {
                    byte[] blanks = new byte[1024];
                    int i = 0;
                    while (i < buffer_size / 1024) {
                        buffer.put((byte)8, blanks);
                        ++i;
                    }
                    buffer.position((byte)8, 0);
                    long time = SystemTime.getMonotonousTime();
                    while (remainder > 0L && !this.stopped) {
                        int write_size;
                        long now = SystemTime.getMonotonousTime();
                        if (now - time >= 250L) {
                            time = now;
                            while (!this.stopped) {
                                if (allocation_instance.getPermission()) break;
                            }
                            if (this.stopped) break;
                        }
                        if (remainder < (long)(write_size = buffer_size)) {
                            write_size = (int)remainder;
                            buffer.limit((byte)8, write_size);
                        }
                        final AESemaphore sem = new AESemaphore("DMW&C:zeroFile");
                        final Throwable[] op_failed = new Throwable[1];
                        this.disk_access.queueWriteRequest(cache_file, written, buffer, false, new DiskAccessRequestListener(){

                            @Override
                            public void requestQueued(DiskAccessRequest request2) {
                                DMWriterImpl.this.active_requests.put(request2, "");
                            }

                            @Override
                            public void requestComplete(DiskAccessRequest request2) {
                                DMWriterImpl.this.latency = SystemTime.getMonotonousTime() - request2.getCreateMonoTime();
                                DMWriterImpl.this.active_requests.remove(request2);
                                sem.release();
                            }

                            @Override
                            public void requestCancelled(DiskAccessRequest request2) {
                                DMWriterImpl.this.active_requests.remove(request2);
                                op_failed[0] = new Throwable("Request cancelled");
                                sem.release();
                            }

                            @Override
                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                DMWriterImpl.this.active_requests.remove(request2);
                                op_failed[0] = cause;
                                sem.release();
                            }

                            @Override
                            public int getPriority() {
                                return -1;
                            }

                            @Override
                            public Object getUserData() {
                                return null;
                            }

                            @Override
                            public void requestExecuted(long bytes) {
                            }
                        });
                        sem.reserve();
                        if (op_failed[0] != null) {
                            throw op_failed[0];
                        }
                        buffer.position((byte)8, 0);
                        written += (long)write_size;
                        remainder -= (long)write_size;
                        listener.allocated(write_size);
                    }
                }
                finally {
                    buffer.returnToPool();
                }
                cache_file.flushCache();
            }
            if (!this.stopped) return true;
            return false;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new DiskManagerException(e);
        }
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer buffer, Object user_data) {
        return new DiskManagerWriteRequestImpl(pieceNumber, offset, buffer, user_data);
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        try {
            this.this_mon.enter();
            for (DiskManagerWriteRequest request2 : this.write_requests) {
                if (request2.getPieceNumber() != piece_number) continue;
                return true;
            }
            return false;
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void writeBlock(final DiskManagerWriteRequest request2, final DiskManagerWriteRequestListener _listener) {
        block12: {
            request2.requestStarts();
            final DiskManagerWriteRequestListener listener = new DiskManagerWriteRequestListener(){

                @Override
                public void writeCompleted(DiskManagerWriteRequest request2) {
                    request2.requestEnds(true);
                    _listener.writeCompleted(request2);
                }

                @Override
                public void writeFailed(DiskManagerWriteRequest request2, Throwable cause) {
                    request2.requestEnds(false);
                    _listener.writeFailed(request2, cause);
                }
            };
            try {
                int pieceNumber = request2.getPieceNumber();
                DirectByteBuffer buffer = request2.getBuffer();
                int offset = request2.getOffset();
                final DiskManagerPiece dmPiece = this.disk_manager.getPieces()[pieceNumber];
                if (dmPiece.isDone()) {
                    buffer.returnToPool();
                    listener.writeCompleted(request2);
                    break block12;
                }
                int buffer_position = buffer.position((byte)8);
                int buffer_limit = buffer.limit((byte)8);
                final long write_length = buffer_limit - buffer_position;
                int previousFilesLength = 0;
                int currentFile = 0;
                DMPieceList pieceList2 = this.disk_manager.getPieceList(pieceNumber);
                DMPieceMapEntry current_piece = pieceList2.get(currentFile);
                long fileOffset = current_piece.getOffset();
                while (previousFilesLength + current_piece.getLength() < offset) {
                    previousFilesLength += current_piece.getLength();
                    fileOffset = 0L;
                    current_piece = pieceList2.get(++currentFile);
                }
                ArrayList<Object[]> chunks = new ArrayList<Object[]>();
                while (buffer_position < buffer_limit) {
                    current_piece = pieceList2.get(currentFile);
                    long file_limit = (long)buffer_position + (current_piece.getFile().getLength() - current_piece.getOffset() - (long)(offset - previousFilesLength));
                    if (file_limit > (long)buffer_limit) {
                        file_limit = buffer_limit;
                    }
                    if (file_limit > (long)buffer_position) {
                        long file_pos = fileOffset + (long)(offset - previousFilesLength);
                        chunks.add(new Object[]{current_piece.getFile(), new Long(file_pos), new Integer((int)file_limit)});
                        buffer_position = (int)file_limit;
                    }
                    ++currentFile;
                    fileOffset = 0L;
                    previousFilesLength = offset;
                }
                DispatcherListener l = new DispatcherListener(){

                    @Override
                    public void writeCompleted(DiskManagerWriteRequest request22) {
                        this.complete();
                        listener.writeCompleted(request22);
                    }

                    @Override
                    public void writeFailed(DiskManagerWriteRequest request22, DiskAccessRequest da_request, Throwable cause) {
                        this.complete();
                        if (dmPiece.isDone()) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Piece " + dmPiece.getPieceNumber() + " write failed but already marked as done"));
                            }
                            listener.writeCompleted(request22);
                        } else {
                            int error = 6;
                            if (da_request != null && !da_request.getFile().exists()) {
                                error = 4;
                            }
                            DMWriterImpl.this.disk_manager.setFailed(error, "Disk write error", cause, true);
                            Debug.printStackTrace(cause);
                            listener.writeFailed(request22, cause);
                        }
                    }

                    protected void complete() {
                        try {
                            DMWriterImpl.this.this_mon.enter();
                            DMWriterImpl dMWriterImpl = DMWriterImpl.this;
                            dMWriterImpl.async_writes = dMWriterImpl.async_writes - 1;
                            DMWriterImpl dMWriterImpl2 = DMWriterImpl.this;
                            dMWriterImpl2.async_writes_bytes = dMWriterImpl2.async_writes_bytes - write_length;
                            if (!DMWriterImpl.this.write_requests.remove(request2)) {
                                Debug.out("request not found");
                            }
                            DMWriterImpl dMWriterImpl3 = DMWriterImpl.this;
                            dMWriterImpl3.total_write_ops = dMWriterImpl3.total_write_ops + 1L;
                            DMWriterImpl dMWriterImpl4 = DMWriterImpl.this;
                            dMWriterImpl4.total_write_bytes = dMWriterImpl4.total_write_bytes + write_length;
                            if (DMWriterImpl.this.stopped) {
                                DMWriterImpl.this.async_write_sem.release();
                            }
                        }
                        finally {
                            DMWriterImpl.this.this_mon.exit();
                        }
                    }
                };
                try {
                    this.this_mon.enter();
                    if (this.stopped) {
                        buffer.returnToPool();
                        listener.writeFailed(request2, new Exception("Disk writer has been stopped"));
                        return;
                    }
                    ++this.async_writes;
                    this.async_writes_bytes += write_length;
                    this.write_requests.add(request2);
                }
                finally {
                    this.this_mon.exit();
                }
                new requestDispatcher(request2, l, buffer, chunks);
            }
            catch (Throwable e) {
                request2.getBuffer().returnToPool();
                this.disk_manager.setFailed(6, "Disk write error", e, true);
                Debug.printStackTrace(e);
                listener.writeFailed(request2, e);
            }
        }
    }

    @Override
    public long[] getStats() {
        return new long[]{this.total_write_ops, this.total_write_bytes, this.async_writes, this.async_writes_bytes};
    }

    @Override
    public long getLatency() {
        long result = this.latency;
        long now = SystemTime.getMonotonousTime();
        for (DiskAccessRequest req : this.active_requests.keySet()) {
            result = Math.max(result, now - req.getCreateMonoTime());
        }
        return result;
    }

    static interface DispatcherListener {
        public void writeCompleted(DiskManagerWriteRequest var1);

        public void writeFailed(DiskManagerWriteRequest var1, DiskAccessRequest var2, Throwable var3);
    }

    protected class requestDispatcher
    implements DiskAccessRequestListener {
        private final DiskManagerWriteRequest request;
        private final DispatcherListener listener;
        private final DirectByteBuffer buffer;
        private final List chunks;
        private int chunk_index;

        protected requestDispatcher(DiskManagerWriteRequest _request, DispatcherListener _listener, DirectByteBuffer _buffer, List _chunks) {
            this.request = _request;
            this.listener = _listener;
            this.buffer = _buffer;
            this.chunks = _chunks;
            this.dispatch();
        }

        protected void dispatch() {
            final DiskAccessRequest[] error_request = new DiskAccessRequest[1];
            try {
                if (this.chunk_index == this.chunks.size()) {
                    this.listener.writeCompleted(this.request);
                } else if (this.chunk_index == 1 && this.chunks.size() > 32) {
                    int i = 1;
                    while (i < this.chunks.size()) {
                        final AESemaphore sem = new AESemaphore("DMW&C:dispatch:asyncReq");
                        final Throwable[] error = new Throwable[1];
                        this.doRequest(new DiskAccessRequestListener(){

                            @Override
                            public void requestQueued(DiskAccessRequest request2) {
                            }

                            @Override
                            public void requestComplete(DiskAccessRequest request2) {
                                sem.release();
                            }

                            @Override
                            public void requestCancelled(DiskAccessRequest request2) {
                                Debug.out("shouldn't get here");
                            }

                            @Override
                            public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                                error_request[0] = request2;
                                error[0] = cause;
                                sem.release();
                            }

                            @Override
                            public int getPriority() {
                                return -1;
                            }

                            @Override
                            public Object getUserData() {
                                return requestDispatcher.this.request.getUserData();
                            }

                            @Override
                            public void requestExecuted(long bytes) {
                            }
                        });
                        sem.reserve();
                        if (error[0] != null) {
                            throw error[0];
                        }
                        ++i;
                    }
                    this.listener.writeCompleted(this.request);
                } else {
                    this.doRequest(this);
                }
            }
            catch (Throwable e) {
                this.failed(error_request[0], e);
            }
        }

        protected void doRequest(final DiskAccessRequestListener l) throws CacheFileManagerException {
            Object[] stuff = (Object[])this.chunks.get(this.chunk_index++);
            final DiskManagerFileInfoImpl file = (DiskManagerFileInfoImpl)stuff[0];
            this.buffer.limit((byte)7, (Integer)stuff[2]);
            if (file.getAccessMode() == 1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(DMWriterImpl.this.disk_manager, LOGID, "Changing " + file.getFile(true).getName() + " to read/write"));
                }
                file.setAccessMode(2);
            }
            boolean handover_buffer = this.chunk_index == this.chunks.size();
            DiskAccessRequestListener delegate_listener = new DiskAccessRequestListener(){

                @Override
                public void requestQueued(DiskAccessRequest request2) {
                    DMWriterImpl.this.active_requests.put(request2, "");
                }

                @Override
                public void requestComplete(DiskAccessRequest request2) {
                    DMWriterImpl.this.latency = SystemTime.getMonotonousTime() - request2.getCreateMonoTime();
                    DMWriterImpl.this.active_requests.remove(request2);
                    l.requestComplete(request2);
                    file.dataWritten(request2.getOffset(), request2.getSize(), request2.getUserData());
                }

                @Override
                public void requestCancelled(DiskAccessRequest request2) {
                    DMWriterImpl.this.active_requests.remove(request2);
                    l.requestCancelled(request2);
                }

                @Override
                public void requestFailed(DiskAccessRequest request2, Throwable cause) {
                    DMWriterImpl.this.active_requests.remove(request2);
                    l.requestFailed(request2, cause);
                }

                @Override
                public int getPriority() {
                    return -1;
                }

                @Override
                public Object getUserData() {
                    return requestDispatcher.this.request.getUserData();
                }

                @Override
                public void requestExecuted(long bytes) {
                }
            };
            DMWriterImpl.this.disk_access.queueWriteRequest(file.getCacheFile(), (Long)stuff[1], this.buffer, handover_buffer, delegate_listener);
        }

        @Override
        public void requestQueued(DiskAccessRequest request2) {
        }

        @Override
        public void requestComplete(DiskAccessRequest request2) {
            this.dispatch();
        }

        @Override
        public void requestCancelled(DiskAccessRequest request2) {
            Debug.out("shouldn't get here");
        }

        @Override
        public void requestFailed(DiskAccessRequest request2, Throwable cause) {
            this.failed(request2, cause);
        }

        @Override
        public int getPriority() {
            return -1;
        }

        @Override
        public Object getUserData() {
            return this.request.getUserData();
        }

        @Override
        public void requestExecuted(long bytes) {
        }

        protected void failed(DiskAccessRequest da_request, Throwable cause) {
            this.buffer.returnToPool();
            this.listener.writeFailed(this.request, da_request, cause);
        }
    }
}

