/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.cache.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.diskmanager.cache.CacheFile;
import com.biglybt.core.diskmanager.cache.CacheFileManagerException;
import com.biglybt.core.diskmanager.cache.impl.CacheEntry;
import com.biglybt.core.diskmanager.cache.impl.CacheFileManagerImpl;
import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class CacheFileWithCache
implements CacheFile {
    private static final byte SS_CACHE = 3;
    private static final LogIDs LOGID = LogIDs.CACHE;
    protected static final Comparator<CacheEntry> comparator = new Comparator<CacheEntry>(){

        @Override
        public int compare(CacheEntry o1, CacheEntry o2) {
            if (o1 == o2) {
                return 0;
            }
            long offset1 = o1.getFilePosition();
            int length1 = o1.getLength();
            long offset2 = o2.getFilePosition();
            int length2 = o2.getLength();
            if (offset1 + (long)length1 > offset2 && offset2 + (long)length2 > offset1 && length1 != 0 && length2 != 0) {
                Debug.out("Overlapping cache entries - " + o1.getString() + "/" + o2.getString());
            }
            return offset1 - offset2 < 0L ? -1 : 1;
        }
    };
    protected static boolean TRACE = false;
    protected static final boolean TRACE_CACHE_CONTENTS = false;
    protected static final int READAHEAD_LOW_LIMIT = 65536;
    protected static final int READAHEAD_HIGH_LIMIT = 262144;
    protected static final int READAHEAD_HISTORY = 32;
    protected final CacheFileManagerImpl manager;
    protected final FMFile file;
    protected int access_mode = 1;
    protected TOTorrentFile torrent_file;
    protected TOTorrent torrent;
    protected long file_offset_in_torrent;
    protected long[] read_history;
    protected int read_history_next = 0;
    protected final TreeSet<CacheEntry> cache = new TreeSet<CacheEntry>(comparator);
    protected int current_read_ahead_size = 0;
    protected static final int READ_AHEAD_STATS_WAIT_TICKS = 10;
    protected int read_ahead_stats_wait = 10;
    protected final Average read_ahead_made_average = Average.getInstance(1000, 5);
    protected final Average read_ahead_used_average = Average.getInstance(1000, 5);
    protected long read_ahead_bytes_made;
    protected long last_read_ahead_bytes_made;
    protected long read_ahead_bytes_used;
    protected long last_read_ahead_bytes_used;
    protected int piece_size = 0;
    protected int piece_offset = 0;
    protected final AEMonitor this_mon = new AEMonitor("CacheFile");
    protected volatile CacheFileManagerException pending_exception;
    private long bytes_written;
    private long bytes_read;

    static {
        TRACE = COConfigurationManager.getBooleanParameter("diskmanager.perf.cache.trace");
        if (TRACE) {
            System.out.println("**** Disk Cache tracing enabled ****");
        }
    }

    protected CacheFileWithCache(CacheFileManagerImpl _manager, FMFile _file, TOTorrentFile _torrent_file) {
        this.manager = _manager;
        this.file = _file;
        if (_torrent_file != null) {
            this.torrent_file = _torrent_file;
            this.torrent = this.torrent_file.getTorrent();
            this.piece_size = (int)this.torrent.getPieceLength();
            this.file_offset_in_torrent = this.torrent_file.getOffsetInTorrent();
            this.piece_offset = this.piece_size - (int)(this.file_offset_in_torrent % (long)this.piece_size);
            if (this.piece_offset == this.piece_size) {
                this.piece_offset = 0;
            }
            this.current_read_ahead_size = Math.min(65536, this.piece_size);
        }
    }

    @Override
    public TOTorrentFile getTorrentFile() {
        return this.torrent_file;
    }

    protected void updateStats() {
        long made = this.read_ahead_bytes_made;
        long used = this.read_ahead_bytes_used;
        long made_diff = made - this.last_read_ahead_bytes_made;
        long used_diff = used - this.last_read_ahead_bytes_used;
        this.read_ahead_made_average.addValue(made_diff);
        this.read_ahead_used_average.addValue(used_diff);
        this.last_read_ahead_bytes_made = made;
        this.last_read_ahead_bytes_used = used;
        if (--this.read_ahead_stats_wait == 0) {
            this.read_ahead_stats_wait = 10;
            double made_average = this.read_ahead_made_average.getAverage();
            double used_average = this.read_ahead_used_average.getAverage();
            double ratio = used_average * 100.0 / made_average;
            if (ratio > 0.75) {
                this.current_read_ahead_size += 16384;
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, this.piece_size);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, 262144);
                this.current_read_ahead_size = Math.min(this.current_read_ahead_size, (int)(this.manager.getCacheSize() / 16L));
            } else if (ratio < 0.5) {
                this.current_read_ahead_size -= 16384;
                this.current_read_ahead_size = Math.max(this.current_read_ahead_size, 65536);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readCache(DirectByteBuffer file_buffer, long file_position, boolean recursive, boolean disable_read_cache) throws CacheFileManagerException {
        block52: {
            this.checkPendingException();
            file_buffer_position = file_buffer.position((byte)3);
            file_buffer_limit = file_buffer.limit((byte)3);
            read_length = file_buffer_limit - file_buffer_position;
            if (!this.manager.isCacheEnabled()) break block52;
            if (CacheFileWithCache.TRACE) {
                Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "readCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)read_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit));
            }
            if (read_length == 0) {
                return;
            }
            writing_file_position = file_position;
            writing_left = read_length;
            ok = true;
            used_entries = 0;
            used_read_ahead = 0L;
            try {
                this.this_mon.enter();
                if (this.read_history == null) {
                    this.read_history = new long[32];
                    Arrays.fill(this.read_history, -1L);
                }
                this.read_history[this.read_history_next++] = file_position + (long)read_length;
                if (this.read_history_next == 32) {
                    this.read_history_next = 0;
                }
                it = this.cache.iterator();
                while (ok && writing_left > 0 && it.hasNext()) {
                    entry = it.next();
                    entry_file_position = entry.getFilePosition();
                    entry_length = entry.getLength();
                    if (entry_file_position > writing_file_position) {
                        ok = false;
                        break;
                    }
                    if (entry_file_position + (long)entry_length <= writing_file_position) continue;
                    skip = (int)(writing_file_position - entry_file_position);
                    available = entry_length - skip;
                    if (available > writing_left) {
                        available = writing_left;
                    }
                    entry_buffer = entry.getBuffer();
                    entry_buffer_position = entry_buffer.position((byte)3);
                    entry_buffer_limit = entry_buffer.limit((byte)3);
                    try {
                        entry_buffer.limit((byte)3, entry_buffer_position + skip + available);
                        entry_buffer.position((byte)3, entry_buffer_position + skip);
                        if (CacheFileWithCache.TRACE) {
                            Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "cacheRead: using " + entry.getString() + "[" + entry_buffer.position((byte)3) + "/" + entry_buffer.limit((byte)3) + "]" + "to write to [" + file_buffer.position((byte)3) + "/" + file_buffer.limit((byte)3) + "]"));
                        }
                        ++used_entries;
                        file_buffer.put((byte)3, entry_buffer);
                        this.manager.cacheEntryUsed(entry);
                    }
                    finally {
                        entry_buffer.limit((byte)3, entry_buffer_limit);
                        entry_buffer.position((byte)3, entry_buffer_position);
                    }
                    writing_file_position += (long)available;
                    writing_left -= available;
                    if (entry.getType() != 1) continue;
                    used_read_ahead += (long)available;
                }
            }
            finally {
                if (ok) {
                    this.read_ahead_bytes_used += used_read_ahead;
                }
                this.this_mon.exit();
            }
            if (ok && writing_left == 0) {
                if (!recursive) {
                    this.manager.cacheBytesRead(read_length);
                    this.bytes_read += (long)read_length;
                }
                if (CacheFileWithCache.TRACE == false) return;
                Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "cacheRead: cache use ok [entries = " + used_entries + "]"));
                return;
            }
            if (CacheFileWithCache.TRACE) {
                Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "cacheRead: cache use fails, reverting to plain read"));
            }
            file_buffer.position((byte)3, file_buffer_position);
            i = 0;
            ** GOTO lbl87
        }
        try {
            this.getFMFile().read(file_buffer, file_position);
            this.manager.fileBytesRead(read_length);
            this.bytes_read += (long)read_length;
            return;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return;
lbl87:
            // 1 sources

            if (true) ** GOTO lbl165
        }
        do {
            block51: {
                try {
                    v0 = do_read_ahead = i == 0 && recursive == false && disable_read_cache == false && this.read_history != null && this.manager.isReadCacheEnabled() != false && read_length < this.current_read_ahead_size && file_position + (long)this.current_read_ahead_size <= this.file.getLength();
                    if (do_read_ahead) {
                        do_read_ahead = false;
                        j = 0;
                        while (j < 32) {
                            if (this.read_history[j] == file_position) {
                                do_read_ahead = true;
                                break;
                            }
                            ++j;
                        }
                    }
                    actual_read_ahead = this.current_read_ahead_size;
                    if (do_read_ahead) {
                        request_piece_offset = (int)((file_position - (long)this.piece_offset) % (long)this.piece_size);
                        if (request_piece_offset < 0) {
                            request_piece_offset += this.piece_size;
                        }
                        if ((data_left = this.piece_size - request_piece_offset) < actual_read_ahead && (actual_read_ahead = data_left) <= read_length) {
                            do_read_ahead = false;
                        }
                    }
                    if (do_read_ahead) {
                        if (CacheFileWithCache.TRACE) {
                            Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "\tperforming read-ahead"));
                        }
                        cache_buffer = DirectByteBufferPool.getBuffer((byte)5, actual_read_ahead);
                        buffer_cached = false;
                        try {
                            entry = this.manager.allocateCacheSpace(1, this, cache_buffer, file_position, actual_read_ahead);
                            entry.setClean();
                            try {
                                this.this_mon.enter();
                                this.flushCache(file_position, actual_read_ahead, true, -1L, 0L, -1L);
                                this.getFMFile().read(cache_buffer, file_position);
                                this.read_ahead_bytes_made += (long)actual_read_ahead;
                                this.manager.fileBytesRead(actual_read_ahead);
                                this.bytes_read += (long)actual_read_ahead;
                                cache_buffer.position((byte)3, 0);
                                this.cache.add(entry);
                                this.manager.addCacheSpace(entry);
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            buffer_cached = true;
                        }
                        finally {
                            if (!buffer_cached) {
                                cache_buffer.returnToPool();
                            }
                        }
                        this.readCache(file_buffer, file_position, true, disable_read_cache);
                        return;
                    }
                    if (CacheFileWithCache.TRACE) {
                        Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "\tnot performing read-ahead"));
                    }
                    try {
                        this.this_mon.enter();
                        this.flushCache(file_position, read_length, true, -1L, 0L, -1L);
                        this.getFMFile().read(file_buffer, file_position);
                    }
                    finally {
                        this.this_mon.exit();
                    }
                    this.manager.fileBytesRead(read_length);
                    this.bytes_read += (long)read_length;
                    return;
                }
                catch (CacheFileManagerException e) {
                    if (i == 1) {
                        throw e;
                    }
                }
                catch (FMFileManagerException e) {
                    if (i != 1) break block51;
                    this.manager.rethrow(this, e);
                }
            }
            ++i;
lbl165:
            // 2 sources

        } while (i < 2);
    }

    protected void writeCache(DirectByteBuffer file_buffer, long file_position, boolean buffer_handed_over) throws CacheFileManagerException {
        block22: {
            this.checkPendingException();
            boolean buffer_cached = false;
            boolean failed = false;
            try {
                int file_buffer_position = file_buffer.position((byte)3);
                int file_buffer_limit = file_buffer.limit((byte)3);
                int write_length = file_buffer_limit - file_buffer_position;
                if (write_length == 0) {
                    return;
                }
                try {
                    if (this.manager.isWriteCacheEnabled()) {
                        if (TRACE) {
                            Logger.log(new LogEvent(this.torrent, LOGID, "writeCache: " + this.getName() + ", " + file_position + " - " + (file_position + (long)write_length - 1L) + ":" + file_buffer_position + "/" + file_buffer_limit));
                        }
                        if (!buffer_handed_over && write_length < this.piece_size) {
                            if (TRACE) {
                                Logger.log(new LogEvent(this.torrent, LOGID, "    making copy of non-handedover buffer"));
                            }
                            DirectByteBuffer cache_buffer = DirectByteBufferPool.getBuffer((byte)10, write_length);
                            cache_buffer.put((byte)3, file_buffer);
                            cache_buffer.position((byte)3, 0);
                            file_buffer = cache_buffer;
                            file_buffer_position = 0;
                            file_buffer_limit = write_length;
                            buffer_handed_over = true;
                        }
                        if (buffer_handed_over) {
                            CacheEntry entry = this.manager.allocateCacheSpace(0, this, file_buffer, file_position, write_length);
                            try {
                                this.this_mon.enter();
                                if (this.access_mode != 2) {
                                    throw new CacheFileManagerException(this, "Write failed - cache file is read only");
                                }
                                this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                                this.cache.add(entry);
                                this.manager.addCacheSpace(entry);
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            this.manager.cacheBytesWritten(write_length);
                            this.bytes_written += (long)write_length;
                            buffer_cached = true;
                            break block22;
                        }
                        try {
                            this.this_mon.enter();
                            this.flushCache(file_position, write_length, true, -1L, 0L, -1L);
                            this.getFMFile().write(file_buffer, file_position);
                        }
                        finally {
                            this.this_mon.exit();
                        }
                        this.manager.fileBytesWritten(write_length);
                        this.bytes_written += (long)write_length;
                        break block22;
                    }
                    this.getFMFile().write(file_buffer, file_position);
                    this.manager.fileBytesWritten(write_length);
                    this.bytes_written += (long)write_length;
                }
                catch (CacheFileManagerException e) {
                    failed = true;
                    throw e;
                }
                catch (FMFileManagerException e) {
                    failed = true;
                    this.manager.rethrow(this, e);
                }
            }
            finally {
                if (buffer_handed_over && !failed && !buffer_cached) {
                    file_buffer.returnToPool();
                }
            }
        }
    }

    protected void flushCache(long file_position, long length, boolean release_entries, long minimum_to_release, long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        try {
            this.flushCacheSupport(file_position, length, release_entries, minimum_to_release, oldest_dirty_time, min_chunk_size);
        }
        catch (CacheFileManagerException e) {
            if (!release_entries) {
                this.flushCacheSupport(0L, -1L, true, -1L, 0L, -1L);
            }
            throw e;
        }
    }

    protected void flushCacheSupport(long file_position, long length, boolean release_entries, long minimum_to_release, long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        try {
            this.this_mon.enter();
            if (this.cache.size() == 0) {
                return;
            }
            Iterator<CacheEntry> it = this.cache.iterator();
            Throwable last_failure = null;
            long entry_total_released = 0L;
            ArrayList<CacheEntry> multi_block_entries = new ArrayList<CacheEntry>();
            long multi_block_start = -1L;
            long multi_block_next = -1L;
            while (it.hasNext()) {
                int entry_length;
                CacheEntry entry = it.next();
                long entry_file_position = entry.getFilePosition();
                if (entry_file_position + (long)(entry_length = entry.getLength()) <= file_position) continue;
                if (length != -1L && file_position + length <= entry_file_position) break;
                boolean dirty = entry.isDirty();
                try {
                    try {
                        if (dirty && (oldest_dirty_time == 0L || entry.getLastUsed() < oldest_dirty_time)) {
                            if (multi_block_start == -1L) {
                                multi_block_start = entry_file_position;
                                multi_block_next = entry_file_position + (long)entry_length;
                                multi_block_entries.add(entry);
                            } else if (multi_block_next == entry_file_position) {
                                multi_block_next = entry_file_position + (long)entry_length;
                                multi_block_entries.add(entry);
                            } else {
                                boolean skip_chunk = false;
                                if (min_chunk_size != -1L) {
                                    if (release_entries) {
                                        Debug.out("CacheFile: can't use min chunk with release option");
                                    } else {
                                        skip_chunk = multi_block_next - multi_block_start < min_chunk_size;
                                    }
                                }
                                ArrayList<CacheEntry> f_multi_block_entries = multi_block_entries;
                                long f_multi_block_start = multi_block_start;
                                long f_multi_block_next = multi_block_next;
                                multi_block_start = entry_file_position;
                                multi_block_next = entry_file_position + (long)entry_length;
                                multi_block_entries = new ArrayList();
                                multi_block_entries.add(entry);
                                if (skip_chunk) {
                                    if (TRACE) {
                                        Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: skipping " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "] as too small"));
                                    }
                                } else {
                                    this.multiBlockFlush(f_multi_block_entries, f_multi_block_start, f_multi_block_next, release_entries);
                                }
                            }
                        }
                    }
                    catch (Throwable e) {
                        last_failure = e;
                        if (!release_entries) continue;
                        it.remove();
                        if (!dirty) {
                            this.manager.releaseCacheSpace(entry);
                        }
                        if (minimum_to_release == -1L || (entry_total_released += (long)entry.getLength()) <= minimum_to_release) continue;
                        break;
                    }
                }
                catch (Throwable throwable) {
                    if (release_entries) {
                        it.remove();
                        if (!dirty) {
                            this.manager.releaseCacheSpace(entry);
                        }
                        if (minimum_to_release != -1L && (entry_total_released += (long)entry.getLength()) > minimum_to_release) break;
                    }
                    throw throwable;
                }
                if (!release_entries) continue;
                it.remove();
                if (!dirty) {
                    this.manager.releaseCacheSpace(entry);
                }
                if (minimum_to_release != -1L && (entry_total_released += (long)entry.getLength()) > minimum_to_release) break;
            }
            if (multi_block_start != -1L) {
                boolean skip_chunk = false;
                if (min_chunk_size != -1L) {
                    if (release_entries) {
                        Debug.out("CacheFile: can't use min chunk with release option");
                    } else {
                        boolean bl = skip_chunk = multi_block_next - multi_block_start < min_chunk_size;
                    }
                }
                if (skip_chunk) {
                    if (TRACE) {
                        Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: skipping " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "] as too small"));
                    }
                } else {
                    this.multiBlockFlush(multi_block_entries, multi_block_start, multi_block_next, release_entries);
                }
            }
            if (last_failure != null) {
                if (last_failure instanceof CacheFileManagerException) {
                    throw (CacheFileManagerException)last_failure;
                }
                throw new CacheFileManagerException(this, "cache flush failed", last_failure);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void multiBlockFlush(List<CacheEntry> multi_block_entries, long multi_block_start, long multi_block_next, boolean release_entries) throws CacheFileManagerException {
        write_ok = false;
        try {
            try {
                if (CacheFileWithCache.TRACE) {
                    Logger.log(new LogEvent(this.torrent, CacheFileWithCache.LOGID, "multiBlockFlush: writing " + multi_block_entries.size() + " entries, [" + multi_block_start + "," + multi_block_next + "," + release_entries + "]"));
                }
                buffers = new DirectByteBuffer[multi_block_entries.size()];
                expected_per_entry_write = 0L;
                i = 0;
                while (i < buffers.length) {
                    entry = multi_block_entries.get(i);
                    buffer = entry.getBuffer();
                    if (buffer.limit((byte)3) - buffer.position((byte)3) != entry.getLength()) {
                        throw new CacheFileManagerException(this, "flush: inconsistent entry length, position wrong");
                    }
                    expected_per_entry_write += (long)entry.getLength();
                    buffers[i] = buffer;
                    ++i;
                }
                expected_overall_write = multi_block_next - multi_block_start;
                if (expected_per_entry_write != expected_overall_write) {
                    throw new CacheFileManagerException(this, "flush: inconsistent write length, entrys = " + expected_per_entry_write + " overall = " + expected_overall_write);
                }
                this.getFMFile().write(buffers, multi_block_start);
                this.manager.fileBytesWritten(expected_overall_write);
                write_ok = true;
            }
            catch (FMFileManagerException e) {
                throw new CacheFileManagerException(this, "flush fails", e);
            }
        }
        finally {
            i = 0;
            ** while (i < multi_block_entries.size())
        }
lbl-1000:
        // 1 sources

        {
            entry = multi_block_entries.get(i);
            if (release_entries) {
                this.manager.releaseCacheSpace(entry);
            } else {
                entry.resetBufferPosition();
                if (write_ok) {
                    entry.setClean();
                }
            }
            ++i;
            continue;
        }
lbl39:
        // 1 sources

    }

    protected void flushCache(long file_start_position, boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushCache: " + this.getName() + ", rel = " + release_entries + ", min = " + minumum_to_release));
            }
            this.flushCache(file_start_position, -1L, release_entries, minumum_to_release, 0L, -1L);
        }
    }

    protected void flushCachePublic(boolean release_entries, long minumum_to_release) throws CacheFileManagerException {
        this.checkPendingException();
        this.flushCache(0L, release_entries, minumum_to_release);
    }

    protected void flushOldDirtyData(long oldest_dirty_time, long min_chunk_size) throws CacheFileManagerException {
        if (this.manager.isCacheEnabled()) {
            if (TRACE) {
                Logger.log(new LogEvent(this.torrent, LOGID, "flushOldDirtyData: " + this.getName()));
            }
            this.flushCache(0L, -1L, false, -1L, oldest_dirty_time, min_chunk_size);
        }
    }

    protected void flushOldDirtyData(long oldest_dirty_time) throws CacheFileManagerException {
        this.flushOldDirtyData(oldest_dirty_time, -1L);
    }

    /*
     * Unable to fully structure code
     */
    protected void getBytesInCache(boolean[] result, long[] absolute_offsets, long[] lengths) {
        num_entries = absolute_offsets.length;
        file_start = this.file_offset_in_torrent;
        file_end = file_start + this.torrent_file.getLength();
        while (num_entries > 0) {
            if (absolute_offsets[num_entries - 1] < file_end) break;
            --num_entries;
        }
        if (num_entries == 0) {
            return;
        }
        current_index = 0;
        while (absolute_offsets[current_index] + lengths[current_index] < file_start) {
            if (++current_index != num_entries) continue;
            return;
        }
        overall_start = absolute_offsets[current_index];
        overall_end_exclusive = absolute_offsets[num_entries - 1] + lengths[num_entries - 1];
        if (!this.this_mon.enter(250)) {
            Debug.outNoStack("Failed to lock stats, abandoning");
            return;
        }
        try {
            sub_map = this.cache.subSet(new CacheEntry(overall_start - file_start - (long)this.piece_size), new CacheEntry(overall_end_exclusive - file_start));
            it = sub_map.iterator();
            current_start = absolute_offsets[current_index];
            current_end_exclusive = current_start + lengths[current_index];
            if (true) ** GOTO lbl53
            do {
                entry = (CacheEntry)it.next();
                cache_start = entry.getFilePosition() + file_start;
                cache_end_exclusive = cache_start + (long)entry.getLength();
                do {
                    next_cache = false;
                    if (cache_end_exclusive <= current_start) {
                        next_cache = true;
                        continue;
                    }
                    next_chunk = false;
                    if (current_start < cache_start) {
                        result[current_index] = false;
                        next_chunk = true;
                    } else if (cache_end_exclusive > current_end_exclusive) {
                        next_chunk = true;
                    } else if (cache_end_exclusive == current_end_exclusive) {
                        next_chunk = true;
                        next_cache = true;
                    } else {
                        current_start = cache_end_exclusive;
                        next_cache = true;
                    }
                    if (!next_chunk) continue;
                    if (++current_index == num_entries) break;
                    current_start = absolute_offsets[current_index];
                    current_end_exclusive = current_start + lengths[current_index];
                } while (!next_cache);
lbl53:
                // 3 sources

                if (current_index >= num_entries) ** GOTO lbl61
            } while (it.hasNext());
            if (true) ** GOTO lbl61
        }
        finally {
            this.this_mon.exit();
        }
        do {
            result[current_index++] = false;
lbl61:
            // 3 sources

        } while (current_index < num_entries);
    }

    protected void checkPendingException() throws CacheFileManagerException {
        if (this.pending_exception != null) {
            throw this.pending_exception;
        }
    }

    protected void setPendingException(CacheFileManagerException e) {
        this.pending_exception = e;
    }

    protected String getName() {
        return this.file.getName();
    }

    protected FMFile getFMFile() {
        return this.file;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public void moveFile(File new_file, FileUtil.ProgressListener pl) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.moveFile(new_file, pl);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void renameFile(String new_name) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.renameFile(new_name);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setAccessMode(int mode) throws CacheFileManagerException {
        try {
            try {
                this.this_mon.enter();
                if (this.access_mode != mode) {
                    this.flushCachePublic(false, -1L);
                }
                this.file.setAccessMode(mode == 1 ? 1 : 2);
                this.access_mode = mode;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                this.this_mon.exit();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getAccessMode() {
        return this.access_mode;
    }

    @Override
    public void setStorageType(int type, boolean force) throws CacheFileManagerException {
        try {
            try {
                this.this_mon.enter();
                if (this.getStorageType() != type) {
                    this.flushCachePublic(false, -1L);
                }
                this.file.setStorageType(CacheFileManagerImpl.convertCacheToFileType(type), force);
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                this.this_mon.exit();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getStorageType() {
        return CacheFileManagerImpl.convertFileToCacheType(this.file.getStorageType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long getLength() throws CacheFileManagerException {
        try {
            if (this.manager.isCacheEnabled()) {
                try {
                    this.this_mon.enter();
                    long physical_size = this.file.getLength();
                    Iterator<CacheEntry> it = this.cache.iterator();
                    while (true) {
                        int entry_length;
                        long entry_file_position;
                        long logical_size;
                        if (!it.hasNext()) {
                            long l = physical_size;
                            return l;
                        }
                        CacheEntry entry = it.next();
                        if (it.hasNext() || (logical_size = (entry_file_position = entry.getFilePosition()) + (long)(entry_length = entry.getLength())) <= physical_size) continue;
                        physical_size = logical_size;
                    }
                }
                finally {
                    this.this_mon.exit();
                }
            }
            if (!this.file.exists()) return 0L;
            long l = this.file.getLength();
            return l;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    @Override
    public long compareLength(long compare_to) throws CacheFileManagerException {
        try {
            long physical_length = this.file.exists() ? this.file.getLength() : 0L;
            long res = physical_length - compare_to;
            if (res >= 0L) {
                return res;
            }
            return this.getLength() - compare_to;
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
            return 0L;
        }
    }

    @Override
    public void setLength(long length) throws CacheFileManagerException {
        try {
            this.flushCachePublic(true, -1L);
            this.file.setLength(length);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws CacheFileManagerException {
        try {
            this.file.setPieceComplete(piece_number, piece_data);
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long position, short policy) throws CacheFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffer.remaining((byte)3);
            try {
                this.read(buffer, position, policy);
                position += (long)len;
            }
            catch (CacheFileManagerException e) {
                throw new CacheFileManagerException(this, e.getMessage(), e, i);
            }
            ++i;
        }
    }

    @Override
    public void read(DirectByteBuffer buffer, long position, short policy) throws CacheFileManagerException {
        boolean flush;
        boolean read_cache = (policy & 1) != 0;
        boolean bl = flush = (policy & 2) != 0;
        if (flush) {
            int file_buffer_position = buffer.position((byte)3);
            int file_buffer_limit = buffer.limit((byte)3);
            int read_length = file_buffer_limit - file_buffer_position;
            this.flushCache(position, read_length, false, -1L, 0L, -1L);
        }
        this.readCache(buffer, position, false, !read_cache);
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, false);
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffer.remaining((byte)3);
            try {
                this.write(buffer, position);
                position += (long)len;
            }
            catch (CacheFileManagerException e) {
                throw new CacheFileManagerException(this, e.getMessage(), e, i);
            }
            ++i;
        }
    }

    @Override
    public void writeAndHandoverBuffer(DirectByteBuffer buffer, long position) throws CacheFileManagerException {
        this.writeCache(buffer, position, true);
    }

    @Override
    public void writeAndHandoverBuffers(DirectByteBuffer[] buffers, long position) throws CacheFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffer.remaining((byte)3);
            try {
                this.writeAndHandoverBuffer(buffer, position);
                position += (long)len;
            }
            catch (CacheFileManagerException e) {
                throw new CacheFileManagerException(this, e.getMessage(), e, i);
            }
            ++i;
        }
    }

    @Override
    public void flushCache() throws CacheFileManagerException {
        try {
            this.flushCachePublic(false, -1L);
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void flushCache(long file_position, int length) throws CacheFileManagerException {
        try {
            this.flushCache(file_position, length, false, -1L, 0L, -1L);
            this.file.flush();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }

    @Override
    public void clearCache() throws CacheFileManagerException {
        this.flushCachePublic(true, -1L);
    }

    @Override
    public void close() throws CacheFileManagerException {
        boolean fm_file_closed = false;
        try {
            try {
                this.flushCachePublic(true, -1L);
                this.file.close();
                fm_file_closed = true;
            }
            catch (FMFileManagerException e) {
                this.manager.rethrow(this, e);
                if (!fm_file_closed) {
                    try {
                        this.file.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.manager.closeFile(this);
            }
        }
        finally {
            if (!fm_file_closed) {
                try {
                    this.file.close();
                }
                catch (Throwable throwable) {}
            }
            this.manager.closeFile(this);
        }
    }

    @Override
    public boolean isOpen() {
        return this.file.isOpen();
    }

    @Override
    public long getSessionBytesRead() {
        return this.bytes_read;
    }

    @Override
    public long getSessionBytesWritten() {
        return this.bytes_written;
    }

    @Override
    public long getLastModified() {
        return this.file.getLastModified();
    }

    @Override
    public void delete() throws CacheFileManagerException {
        try {
            this.file.delete();
        }
        catch (FMFileManagerException e) {
            this.manager.rethrow(this, e);
        }
    }
}

