/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class FMFileAccessCompact
implements FMFileAccess {
    private static final byte SS = 4;
    private final File controlFileDir;
    private final String controlFileName;
    private final FMFileAccess delegate;
    private volatile long current_length_in_state;
    private static final long version = 0L;
    private final boolean state_required;
    private volatile boolean write_required;
    private long first_piece_start;
    private long first_piece_length;
    private long last_piece_start;
    private long last_piece_length;

    protected static boolean isCompact(FMFileImpl file, TOTorrentFile torrent_file, File control_dir, String control_file_name, int target_type) {
        if (target_type == 2) {
            long first_piece_length;
            int piece_size = (int)torrent_file.getTorrent().getPieceLength();
            long torrent_file_length = torrent_file.getLength();
            long file_offset_in_torrent = torrent_file.getOffsetInTorrent();
            int piece_offset = piece_size - (int)(file_offset_in_torrent % (long)piece_size);
            if (piece_offset == piece_size) {
                piece_offset = 0;
            }
            if ((first_piece_length = (long)piece_offset) >= torrent_file_length && target_type == 2) {
                return true;
            }
            if (FileUtil.existsWithCache(control_dir, control_file_name)) {
                return true;
            }
            long last_piece_length = (torrent_file_length - (long)piece_offset) % (long)piece_size;
            long actual_file_length = file.getFile().length();
            if (actual_file_length > 0L && (actual_file_length == first_piece_length || actual_file_length == first_piece_length + last_piece_length)) {
                try {
                    HashMap<String, Long> data = new HashMap<String, Long>();
                    data.put("version", 0L);
                    data.put("length", actual_file_length == first_piece_length + last_piece_length ? torrent_file_length : actual_file_length);
                    FileUtil.mkdirs(control_dir);
                    FileUtil.writeResilientFile(control_dir, control_file_name, data, false);
                    FileUtil.existsWithCacheClear(control_dir);
                    return true;
                }
                catch (Throwable e) {
                    Debug.out("Failed to write recovered state file");
                }
            }
            return false;
        }
        return FileUtil.existsWithCache(control_dir, control_file_name);
    }

    protected FMFileAccessCompact(TOTorrentFile torrent_file, File _controlFileDir, String _controlFileName, FMFileAccess _delegate) throws FMFileManagerException {
        this.controlFileDir = _controlFileDir;
        this.controlFileName = _controlFileName;
        this.delegate = _delegate;
        try {
            int piece_size = (int)torrent_file.getTorrent().getPieceLength();
            long file_length = torrent_file.getLength();
            long file_offset_in_torrent = torrent_file.getOffsetInTorrent();
            int piece_offset = piece_size - (int)(file_offset_in_torrent % (long)piece_size);
            if (piece_offset == piece_size) {
                piece_offset = 0;
            }
            this.first_piece_length = piece_offset;
            this.first_piece_start = 0L;
            if (this.first_piece_length >= file_length) {
                this.first_piece_length = file_length;
                this.last_piece_start = file_length;
                this.last_piece_length = 0L;
                this.state_required = false;
            } else {
                this.last_piece_length = (file_length - (long)piece_offset) % (long)piece_size;
                this.last_piece_start = file_length - this.last_piece_length;
                this.state_required = true;
            }
            if (this.state_required) {
                if (!FileUtil.existsWithCache(this.controlFileDir, this.controlFileName)) {
                    if (!this.controlFileDir.isDirectory() && !FileUtil.mkdirs(this.controlFileDir)) {
                        throw new FMFileManagerException(1, "Directory creation failed: " + this.controlFileDir);
                    }
                } else {
                    this.readState();
                }
            }
        }
        catch (Throwable e) {
            throw new FMFileManagerException(1, "Compact file init fail", e);
        }
    }

    protected long getFirstPieceStart() {
        return this.first_piece_start;
    }

    protected long getFirstPieceLength() {
        return this.first_piece_length;
    }

    protected long getLastPieceStart() {
        return this.last_piece_start;
    }

    protected long getLastPieceLength() {
        return this.last_piece_length;
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
        this.delegate.aboutToOpen();
    }

    @Override
    public long getLength(FMFileAccess.FileAccessor fa) throws FMFileManagerException {
        if (this.state_required) {
            return this.current_length_in_state;
        }
        return this.delegate.getLength(fa);
    }

    @Override
    public void setLength(FMFileAccess.FileAccessor fa, long length) throws FMFileManagerException {
        if (this.state_required) {
            if (length != this.current_length_in_state) {
                this.current_length_in_state = length;
                this.write_required = true;
            }
        } else {
            this.delegate.setLength(fa, length);
        }
    }

    protected void read(FMFileAccess.FileAccessor fa, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit = buffer.limit((byte)4);
        try {
            int len = original_limit - buffer.position((byte)4);
            if (position < this.first_piece_start + this.first_piece_length) {
                int available = (int)(this.first_piece_start + this.first_piece_length - position);
                if (available >= len) {
                    this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.limit((byte)4, buffer.position((byte)4) + available);
                    this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position);
                    buffer.limit((byte)4, original_limit);
                    position += (long)available;
                    len -= available;
                }
            }
            if (len == 0) {
                return;
            }
            long space = this.last_piece_start - position;
            if (space > 0L) {
                if (space >= (long)len) {
                    buffer.position((byte)4, original_limit);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                    position += space;
                    len = (int)((long)len - space);
                }
            }
            if (len == 0) {
                return;
            }
            this.delegate.read(fa, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
        }
        finally {
            buffer.limit((byte)4, original_limit);
        }
    }

    @Override
    public void read(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.read(fa, buffer, position);
            int rem = buffers[i].remaining((byte)4);
            position += (long)(len - rem);
            if (rem > 0) break;
            ++i;
        }
        if (this.state_required && position > this.current_length_in_state) {
            this.setLength(fa, position);
        }
    }

    protected void write(FMFileAccess.FileAccessor fa, DirectByteBuffer buffer, long position) throws FMFileManagerException {
        int original_limit = buffer.limit((byte)4);
        try {
            int len = original_limit - buffer.position((byte)4);
            if (position < this.first_piece_start + this.first_piece_length) {
                int available = (int)(this.first_piece_start + this.first_piece_length - position);
                if (available >= len) {
                    this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.limit((byte)4, buffer.position((byte)4) + available);
                    this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position);
                    buffer.limit((byte)4, original_limit);
                    position += (long)available;
                    len -= available;
                }
            }
            if (len == 0) {
                return;
            }
            long space = this.last_piece_start - position;
            if (space > 0L) {
                if (space >= (long)len) {
                    buffer.position((byte)4, original_limit);
                    position += (long)len;
                    len = 0;
                } else {
                    buffer.position((byte)4, buffer.position((byte)4) + (int)space);
                    position += space;
                    len = (int)((long)len - space);
                }
            }
            if (len == 0) {
                return;
            }
            this.delegate.write(fa, new DirectByteBuffer[]{buffer}, position - this.last_piece_start + this.first_piece_length);
        }
        finally {
            buffer.limit((byte)4, original_limit);
        }
    }

    @Override
    public void write(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        int i = 0;
        while (i < buffers.length) {
            DirectByteBuffer buffer = buffers[i];
            int len = buffers[i].limit((byte)4) - buffers[i].position((byte)4);
            this.write(fa, buffer, position);
            position += (long)len;
            ++i;
        }
        if (this.state_required && position > this.current_length_in_state) {
            this.setLength(fa, position);
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.writeState();
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return false;
    }

    @Override
    public void setPieceComplete(FMFileAccess.FileAccessor fa, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    private void readState() throws FMFileManagerException {
        if (this.state_required) {
            try {
                Map data = FileUtil.readResilientFile(this.controlFileDir, this.controlFileName, false);
                if (data != null && data.size() > 0) {
                    Long length = (Long)data.get("length");
                    this.current_length_in_state = length;
                }
            }
            catch (Throwable e) {
                throw new FMFileManagerException(3, "Failed to read control file state", e);
            }
        }
    }

    protected void writeState() throws FMFileManagerException {
        boolean write;
        if (this.state_required && (write = this.write_required)) {
            this.write_required = false;
            try {
                HashMap<String, Long> data = new HashMap<String, Long>();
                data.put("version", 0L);
                data.put("length", this.current_length_in_state);
                FileUtil.writeResilientFile(this.controlFileDir, this.controlFileName, data, false);
                FileUtil.existsWithCacheClear(this.controlFileDir);
            }
            catch (Throwable e) {
                throw new FMFileManagerException(4, "Failed to write control file state", e);
            }
        }
    }

    @Override
    public FMFileImpl getFile() {
        return this.delegate.getFile();
    }

    @Override
    public String getString() {
        if (this.state_required) {
            return "compact";
        }
        return "compact-opt";
    }
}

