/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileAccessCompact;
import com.biglybt.core.diskmanager.file.impl.FMFileAccessLinear;
import com.biglybt.core.diskmanager.file.impl.FMFileAccessPieceReorderer;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.DirectByteBufferPool;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;

public class FMFileAccessController
implements FMFileAccess {
    private static final String REORDER_SUFFIX = ".2";
    private static final boolean TEST_PIECE_REORDER = System.getProperty(SystemProperties.SYSPROP_FILE_PIECE_REORDER_FORCE, "0").equals("1");
    private static boolean enable_sparse_files;
    private final FMFileImpl owner;
    private int type = 1;
    private File control_dir;
    private String controlFileName;
    private FMFileAccess file_access;

    static {
        if (TEST_PIECE_REORDER) {
            Debug.out("*** Piece reordering storage forced ***");
        }
        COConfigurationManager.addAndFireParameterListener("Enable Sparse Files", n -> {
            enable_sparse_files = COConfigurationManager.getBooleanParameter(n);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FMFileAccessController(FMFileImpl _file, int _target_type, boolean _force) throws FMFileManagerException {
        if (TEST_PIECE_REORDER) {
            _target_type = 3;
        }
        this.owner = _file;
        this.setControlFile();
        if (this.control_dir == null) {
            if (_target_type != 1) throw new FMFileManagerException(1, "Compact storage not supported: no control file available");
            this.file_access = new FMFileAccessLinear(this.owner);
            return;
        } else {
            if (FMFileAccessCompact.isCompact(this.owner, this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, _target_type)) {
                this.type = 2;
            } else if (FileUtil.existsWithCache(this.control_dir, String.valueOf(this.controlFileName) + REORDER_SUFFIX)) {
                this.type = _target_type == 3 ? 3 : 4;
            } else if (_target_type == 3 || _target_type == 4) {
                File target_file = this.owner.getLinkedFile();
                if (FileUtil.exists(target_file)) {
                    FMFileAccessPieceReorderer.recoverConfig(this.owner.getOwner().getTorrentFile(), target_file, FileUtil.newFile(this.control_dir, String.valueOf(this.controlFileName) + REORDER_SUFFIX), _target_type);
                }
                this.type = _target_type;
            } else {
                this.type = 1;
            }
            this.file_access = this.type == 1 ? new FMFileAccessLinear(this.owner) : (this.type == 2 ? new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner)) : new FMFileAccessPieceReorderer(this.owner.getOwner().getTorrentFile(), this.control_dir, String.valueOf(this.controlFileName) + REORDER_SUFFIX, this.type, new FMFileAccessLinear(this.owner)));
            this.convert(_target_type, _force);
        }
    }

    private void convert(int target_type, boolean force) throws FMFileManagerException {
        try {
            this.convertSupport(target_type, force);
        }
        catch (FMFileManagerException error) {
            if (force && (this.type == 3 || this.type == 4) && target_type == 1) {
                FileUtil.newFile(this.control_dir, this.controlFileName).delete();
                FileUtil.newFile(this.control_dir, String.valueOf(this.controlFileName) + REORDER_SUFFIX).delete();
                this.type = 1;
                this.file_access = new FMFileAccessLinear(this.owner);
                return;
            }
            throw error;
        }
    }

    private void convertSupport(int target_type, boolean force) throws FMFileManagerException {
        boolean ok;
        block38: {
            if (this.type == target_type) {
                return;
            }
            if (this.type == 3 || this.type == 4 || target_type == 3 || target_type == 4) {
                if (target_type == 4 && this.type == 3 || target_type == 3 && this.type == 4) {
                    this.type = target_type;
                    return;
                }
                throw new FMFileManagerException(1, "Conversion to/from piece-reorder not supported (current=" + this.type + ", target=" + target_type + ")");
            }
            File file = this.owner.getLinkedFile();
            FMFileAccess.FileAccessor fa = null;
            ok = false;
            try {
                try {
                    FMFileAccess target_access = target_type == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_dir, this.controlFileName, new FMFileAccessLinear(this.owner));
                    if (FileUtil.exists(file)) {
                        fa = FileUtil.newFileAccessor(file, "rw");
                        FMFileAccessCompact compact_access = target_type == 1 ? (FMFileAccessCompact)this.file_access : (FMFileAccessCompact)target_access;
                        long length = this.file_access.getLength(fa);
                        long last_piece_start = compact_access.getLastPieceStart();
                        long last_piece_length = compact_access.getLastPieceLength();
                        if (last_piece_length > 0L && length > last_piece_start) {
                            long data_length = length - last_piece_start;
                            if (data_length > last_piece_length) {
                                Debug.out("data length inconsistent: len=" + data_length + ",limit=" + last_piece_length);
                                data_length = last_piece_length;
                            }
                            DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)25, (int)data_length);
                            try {
                                this.file_access.read(fa, new DirectByteBuffer[]{buffer}, last_piece_start);
                                if (target_type == 2) {
                                    long first_piece_length = compact_access.getFirstPieceLength();
                                    long physical_length = fa.getLength();
                                    if (physical_length > first_piece_length) {
                                        fa.setLength(first_piece_length);
                                    }
                                }
                                buffer.flip((byte)25);
                                target_access.write(fa, new DirectByteBuffer[]{buffer}, last_piece_start);
                            }
                            finally {
                                buffer.returnToPool();
                            }
                        } else if (target_type == 2) {
                            long first_piece_length = compact_access.getFirstPieceLength();
                            long physical_length = fa.getLength();
                            if (physical_length > first_piece_length) {
                                fa.setLength(first_piece_length);
                            }
                        }
                        target_access.setLength(fa, length);
                        target_access.flush();
                    }
                    this.type = target_type;
                    this.file_access = target_access;
                    ok = true;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    throw new FMFileManagerException(1, "convert fails", e);
                }
            }
            catch (Throwable throwable) {
                block37: {
                    try {
                        if (fa == null) break block37;
                        try {
                            fa.close();
                        }
                        catch (Throwable e) {
                            if (ok) {
                                ok = false;
                                throw new FMFileManagerException(1, "convert fails", e);
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (!ok) {
                            this.type = 1;
                            this.file_access = new FMFileAccessLinear(this.owner);
                        }
                        if (this.type == 1) {
                            FileUtil.newFile(this.control_dir, this.controlFileName).delete();
                        }
                        throw throwable2;
                    }
                }
                if (!ok) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    FileUtil.newFile(this.control_dir, this.controlFileName).delete();
                }
                throw throwable;
            }
            try {
                if (fa == null) break block38;
                try {
                    fa.close();
                }
                catch (Throwable e) {
                    if (ok) {
                        ok = false;
                        throw new FMFileManagerException(1, "convert fails", e);
                    }
                }
            }
            catch (Throwable throwable) {
                if (!ok) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    FileUtil.newFile(this.control_dir, this.controlFileName).delete();
                }
                throw throwable;
            }
        }
        if (!ok) {
            this.type = 1;
            this.file_access = new FMFileAccessLinear(this.owner);
        }
        if (this.type == 1) {
            FileUtil.newFile(this.control_dir, this.controlFileName).delete();
        }
    }

    protected void setControlFile() {
        TOTorrentFile tf = this.owner.getOwner().getTorrentFile();
        if (tf == null) {
            this.controlFileName = null;
            this.control_dir = null;
        } else {
            int file_index = tf.getIndex();
            this.control_dir = this.owner.getOwner().getControlFileDir();
            this.controlFileName = "fmfile" + file_index + ".dat";
        }
    }

    public void setStorageType(int new_type, boolean force) throws FMFileManagerException {
        this.convert(new_type, force);
    }

    public int getStorageType() {
        return this.type;
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
        this.file_access.aboutToOpen();
    }

    @Override
    public long getLength(FMFileAccess.FileAccessor fa) throws FMFileManagerException {
        return this.file_access.getLength(fa);
    }

    @Override
    public void setLength(FMFileAccess.FileAccessor fa, long length) throws FMFileManagerException {
        this.file_access.setLength(fa, length);
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return this.file_access.isPieceCompleteProcessingNeeded(piece_number);
    }

    @Override
    public void setPieceComplete(FMFileAccess.FileAccessor fa, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        this.file_access.setPieceComplete(fa, piece_number, piece_data);
    }

    @Override
    public void read(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        this.file_access.read(fa, buffers, offset);
    }

    @Override
    public void write(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        this.file_access.write(fa, buffers, position);
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    @Override
    public FMFileImpl getFile() {
        return this.owner;
    }

    @Override
    public String getString() {
        return "type=" + this.type + ",acc=" + this.file_access.getString();
    }

    public static class FileAccessorFileChannel
    implements FMFileAccess.FileAccessor {
        private FileChannel fc;

        private FileAccessorFileChannel() {
        }

        @Override
        public FileChannel getChannel() {
            return this.fc;
        }

        @Override
        public long getLength() throws IOException {
            return this.fc.size();
        }

        @Override
        public void setLength(long len) throws IOException {
            long size = this.fc.size();
            if (len < size) {
                this.fc.truncate(len);
            } else if (len > size) {
                this.fc.position(len - 1L);
                this.write(0);
            }
        }

        @Override
        public long getPosition() throws IOException {
            return this.fc.position();
        }

        @Override
        public void setPosition(long pos) throws IOException {
            this.fc.position(pos);
        }

        @Override
        public void write(int b) throws IOException {
            this.fc.write(ByteBuffer.wrap(new byte[]{(byte)b}));
        }

        @Override
        public void close() throws IOException {
            this.fc.close();
        }

        @Override
        public String getString() {
            return "fc";
        }
    }

    public static class FileAccessorRAF
    implements FMFileAccess.FileAccessor {
        private RandomAccessFile raf;

        public FileAccessorRAF(File file, String access_mode) throws FileNotFoundException {
            if (enable_sparse_files && !FileUtil.exists(file)) {
                try {
                    HashSet<StandardOpenOption> options = new HashSet<StandardOpenOption>();
                    options.add(StandardOpenOption.WRITE);
                    options.add(StandardOpenOption.CREATE_NEW);
                    options.add(StandardOpenOption.SPARSE);
                    FileChannel fc = FileChannel.open(file.toPath(), options, new FileAttribute[0]);
                    fc.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.raf = new RandomAccessFile(file, access_mode);
        }

        @Override
        public FileChannel getChannel() {
            return this.raf.getChannel();
        }

        @Override
        public long getLength() throws IOException {
            return this.raf.length();
        }

        @Override
        public void setLength(long len) throws IOException {
            this.raf.setLength(len);
        }

        @Override
        public long getPosition() throws IOException {
            return this.raf.getFilePointer();
        }

        @Override
        public void setPosition(long pos) throws IOException {
            this.raf.seek(pos);
        }

        @Override
        public void write(int b) throws IOException {
            this.raf.write(b);
        }

        @Override
        public void close() throws IOException {
            this.raf.close();
        }

        @Override
        public String getString() {
            return "raf";
        }
    }
}

