/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Locale;

public class FMFileAccessLinear
implements FMFileAccess {
    private static final int WRITE_RETRY_LIMIT = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    private static final int READ_RETRY_LIMIT = 10;
    private static final int READ_RETRY_DELAY = 100;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_VERBOSE = false;
    private static final boolean USE_MMAP = System.getProperty(SystemProperties.SYSPROP_IO_USEMMAP, "false") == "true";
    private final FMFileImpl owner;

    protected FMFileAccessLinear(FMFileImpl _owner) {
        this.owner = _owner;
    }

    @Override
    public void aboutToOpen() throws FMFileManagerException {
    }

    @Override
    public long getLength(FMFileAccess.FileAccessor fa) throws FMFileManagerException {
        try {
            return fa.getLength();
        }
        catch (Throwable e) {
            throw new FMFileManagerException(3, "getLength fails", e);
        }
    }

    @Override
    public void setLength(FMFileAccess.FileAccessor fa, long length) throws FMFileManagerException {
        block16: {
            try {
                try {
                    fa.setLength(length);
                }
                catch (IOException e) {
                    if (Constants.isAndroid) {
                        long usable;
                        if (!Debug.getNestedExceptionMessage(e).toUpperCase(Locale.US).contains("EINVAL")) {
                            throw e;
                        }
                        long required = length - fa.getLength();
                        if (required > 0L && (usable = FileUtil.getUsableSpace(this.owner.getLinkedFile().getParentFile())) >= 0L && usable < required) {
                            throw e;
                        }
                        if (required <= 0L) break block16;
                        long old_pos = fa.getPosition();
                        try {
                            try {
                                fa.setPosition(length - 1L);
                                fa.write(0);
                                break block16;
                            }
                            catch (IOException f) {
                                throw e;
                            }
                        }
                        finally {
                            try {
                                fa.setPosition(old_pos);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    throw e;
                }
            }
            catch (Throwable e) {
                throw new FMFileManagerException(4, "setLength fails", e);
            }
        }
    }

    @Override
    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return false;
    }

    @Override
    public void setPieceComplete(FMFileAccess.FileAccessor fa, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    public void read(FMFileAccess.FileAccessor fa, DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        if (fa == null) {
            throw new FMFileManagerException(3, "read failed: accessor is null");
        }
        FileChannel fc = fa.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException(3, "read failed: file is closed");
        }
        try {
            if (USE_MMAP) {
                long remainingInFile = fc.size() - offset;
                long remainingInTargetBuffer = buffer.remaining((byte)4);
                MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, Math.min(remainingInFile, remainingInTargetBuffer));
                buffer.put((byte)4, buf);
            } else {
                fc.position(offset);
                while (fc.position() < fc.size() && buffer.hasRemaining((byte)4)) {
                    buffer.read((byte)4, fc);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException(3, "read failed", e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void read(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        if (fa == null) {
            throw new FMFileManagerException(3, "read failed: accessor is null");
        }
        fc = fa.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException(3, "read failed: file is closed");
        }
        original_positions = new int[buffers.length];
        read_start = SystemTime.getHighPrecisionCounter();
        try {
            try {
                if (FMFileAccessLinear.USE_MMAP) {
                    size = 0L;
                    i = 0;
                    while (i < buffers.length) {
                        size += (long)buffers[i].remaining((byte)4);
                        original_positions[i] = buffers[i].position((byte)4);
                        ++i;
                    }
                    size = Math.min(size, fc.size() - offset);
                    buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, size);
                    var15_13 = buffers;
                    var14_14 = buffers.length;
                    var13_17 = 0;
                    while (var13_17 < var14_14) {
                        b = var15_13[var13_17];
                        buf.limit(buf.position() + b.remaining((byte)4));
                        b.put((byte)4, buf);
                        ++var13_17;
                    }
                    return;
                }
                fc.position(offset);
                bbs = new ByteBuffer[buffers.length];
                last_bb = null;
                i = 0;
                while (i < bbs.length) {
                    bbs[i] = buffers[i].getBuffer((byte)4);
                    bb = bbs[i];
                    original_positions[i] = bb.position();
                    pos = original_positions[i];
                    if (pos != bb.limit()) {
                        last_bb = bbs[i];
                    }
                    ++i;
                }
                if (last_bb == null) return;
                loop = 0;
                if (!Constants.isAndroid) ** GOTO lbl82
                bbs_index = 0;
                if (true) ** GOTO lbl67
                do {
                    if (!(current_bb = bbs[bbs_index]).hasRemaining()) {
                        ++bbs_index;
                    } else {
                        read = fc.read(current_bb);
                        if (read > 0L) {
                            loop = 0;
                        } else {
                            if (++loop == 10) {
                                Debug.out("FMFile::read: zero length read - abandoning");
                                throw new FMFileManagerException(3, "read fails: retry limit exceeded");
                            }
                            try {
                                Thread.sleep(100 * loop);
                            }
                            catch (InterruptedException e) {
                                throw new FMFileManagerException(3, "read fails: interrupted");
                            }
                        }
                    }
lbl67:
                    // 4 sources

                    if (fc.position() >= fc.size()) return;
                } while (last_bb.hasRemaining());
                return;
lbl-1000:
                // 1 sources

                {
                    read = fc.read(bbs);
                    if (read > 0L) {
                        loop = 0;
                    } else {
                        if (++loop == 10) {
                            Debug.out("FMFile::read: zero length read - abandoning");
                            throw new FMFileManagerException(3, "read fails: retry limit exceeded");
                        }
                        try {
                            Thread.sleep(100 * loop);
                        }
                        catch (InterruptedException e) {
                            throw new FMFileManagerException(3, "read fails: interrupted");
                        }
                    }
lbl82:
                    // 3 sources

                    if (fc.position() >= fc.size()) return;
                    ** while (last_bb.hasRemaining())
                }
lbl84:
                // 1 sources

                return;
            }
            catch (Throwable e) {
                try {
                    Debug.out("Read failed: " + this.owner.getString() + ": raf open=" + fa.getChannel().isOpen() + ", len=" + fa.getLength() + ",off=" + offset);
                }
                catch (IOException last_bb) {
                    // empty catch block
                }
                Debug.printStackTrace(e);
                if (original_positions == null) throw new FMFileManagerException(3, "read failed", e);
                try {
                    i = 0;
                    while (i < original_positions.length) {
                        buffers[i].position((byte)4, original_positions[i]);
                        ++i;
                    }
                    throw new FMFileManagerException(3, "read failed", e);
                }
                catch (Throwable e2) {
                    Debug.out(e2);
                }
            }
            throw new FMFileManagerException(3, "read failed", e);
        }
        finally {
            elapsed_millis = (SystemTime.getHighPrecisionCounter() - read_start) / 1000000L;
            if (elapsed_millis > 10000L) {
                System.out.println("read took " + elapsed_millis + " for " + this.owner.getString());
            }
        }
    }

    @Override
    public void write(FMFileAccess.FileAccessor fa, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        block22: {
            Throwable e3;
            block23: {
                if (fa == null) {
                    throw new FMFileManagerException(4, "write failed: accessor is null");
                }
                FileChannel fc = fa.getChannel();
                if (!fc.isOpen()) {
                    Debug.out("FileChannel is closed: " + this.owner.getName());
                    throw new FMFileManagerException(4, "write failed: file is closed");
                }
                int[] original_positions = new int[buffers.length];
                try {
                    if (USE_MMAP) {
                        long size = 0L;
                        int i = 0;
                        while (i < buffers.length) {
                            size += (long)buffers[i].remaining((byte)4);
                            original_positions[i] = buffers[i].position((byte)4);
                            ++i;
                        }
                        if (position + size > fc.size()) {
                            fc.position(position + size - 1L);
                            fc.write(ByteBuffer.allocate(1));
                            fc.force(true);
                        }
                        MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_WRITE, position, size);
                        DirectByteBuffer[] directByteBufferArray = buffers;
                        int n = buffers.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DirectByteBuffer b = directByteBufferArray[n2];
                            buf.put(b.getBuffer((byte)4));
                            ++n2;
                        }
                        buf.force();
                    } else {
                        long expected_write = 0L;
                        long actual_write = 0L;
                        boolean partial_write = false;
                        int i = 0;
                        while (i < buffers.length) {
                            expected_write += (long)(buffers[i].limit((byte)4) - buffers[i].position((byte)4));
                            ++i;
                        }
                        fc.position(position);
                        ByteBuffer[] bbs = new ByteBuffer[buffers.length];
                        Buffer last_bb = null;
                        int i2 = 0;
                        while (i2 < bbs.length) {
                            bbs[i2] = buffers[i2].getBuffer((byte)4);
                            ByteBuffer bb = bbs[i2];
                            original_positions[i2] = bb.position();
                            int pos = original_positions[i2];
                            if (pos != bb.limit()) {
                                last_bb = bbs[i2];
                            }
                            ++i2;
                        }
                        if (last_bb != null) {
                            int loop = 0;
                            while (last_bb.position() != last_bb.limit()) {
                                long written = fc.write(bbs);
                                actual_write += written;
                                if (written > 0L) {
                                    loop = 0;
                                    if (last_bb.position() == last_bb.limit()) continue;
                                    partial_write = true;
                                    continue;
                                }
                                if (++loop == 10) {
                                    Debug.out("FMFile::write: zero length write - abandoning");
                                    throw new FMFileManagerException(4, "write fails: retry limit exceeded");
                                }
                                try {
                                    Thread.sleep(100 * loop);
                                }
                                catch (InterruptedException e2) {
                                    throw new FMFileManagerException(4, "write fails: interrupted");
                                }
                            }
                        }
                        if (expected_write != actual_write) {
                            Debug.out("FMFile::write: **** partial write **** failed: expected = " + expected_write + ", actual = " + actual_write);
                            throw new FMFileManagerException(4, "write fails: expected write/actual write mismatch");
                        }
                    }
                    break block22;
                }
                catch (Throwable e3) {
                    if (original_positions == null) break block23;
                    try {
                        int i = 0;
                        while (i < original_positions.length) {
                            buffers[i].position((byte)4, original_positions[i]);
                            ++i;
                        }
                    }
                    catch (Throwable e2) {
                        Debug.out(e2);
                    }
                }
            }
            throw new FMFileManagerException(4, "write failed", e3);
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
    }

    @Override
    public FMFileImpl getFile() {
        return this.owner;
    }

    @Override
    public String getString() {
        return "linear";
    }
}

