/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.FMFileOwner;
import com.biglybt.core.diskmanager.file.impl.FMFileAccess;
import com.biglybt.core.diskmanager.file.impl.FMFileAccessController;
import com.biglybt.core.diskmanager.file.impl.FMFileManagerImpl;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.StringInterner;
import com.biglybt.core.util.SystemTime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class FMFileImpl
implements FMFile {
    protected static final String READ_ACCESS_MODE = "r";
    protected static final String WRITE_ACCESS_MODE = "rw";
    private static final Map<StringInterner.FileKey, List<Object[]>> file_map = new HashMap<StringInterner.FileKey, List<Object[]>>();
    private static final AEMonitor file_map_mon = new AEMonitor("FMFile:map");
    private static final boolean OUTPUT_REOPEN_RELATED_ERRORS = true;
    static volatile boolean switch_to_upload_only_enable;
    private final FMFileManagerImpl manager;
    private final FMFileOwner owner;
    private int access_mode = 1;
    private StringInterner.FileKey linked_file;
    private long last_modified;
    private StringInterner.FileKey canonical_path;
    private FMFileAccess.FileAccessor fa;
    private FMFileAccessController file_access;
    private File created_dirs_leaf;
    private List<File> created_dirs;
    protected final AEMonitor this_mon = new AEMonitor("FMFile");
    private volatile long length_cache = -1L;
    private boolean clone;

    static {
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            @Override
            public void generate(IndentWriter writer) {
                FMFileImpl.generateEvidence(writer);
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Switch To Upload Only On Write Error Enable"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                switch_to_upload_only_enable = COConfigurationManager.getBooleanParameter("Switch To Upload Only On Write Error Enable");
            }
        });
    }

    protected FMFileImpl(FMFileOwner _owner, FMFileManagerImpl _manager, StringInterner.FileKey _file, int _type, boolean _force) throws FMFileManagerException {
        this.owner = _owner;
        this.manager = _manager;
        this.linked_file = this.owner.getFileLink(_file);
        boolean file_was_created = false;
        boolean file_reserved = false;
        boolean ok = false;
        File lf = this.linked_file.getFile();
        try {
            try {
                String linked_path = lf.getPath();
                try {
                    String cp = FileUtil.getCanonicalPath(lf, true);
                    this.canonical_path = cp.equals(linked_path) ? this.linked_file : new StringInterner.FileKey(cp);
                }
                catch (IOException ioe) {
                    String msg = ioe.getMessage();
                    if (msg != null && msg.contains("There are no more files")) {
                        String abs_path = lf.getAbsolutePath();
                        String error = "Caught 'There are no more files' exception during file.getCanonicalPath(). os=[" + Constants.OSName + "], file.getPath()=[" + linked_path + "], file.getAbsolutePath()=[" + abs_path + "]. ";
                        Debug.out(error, ioe);
                    }
                    throw ioe;
                }
                this.createDirs(lf);
                this.reserveFile();
                file_reserved = true;
                this.file_access = new FMFileAccessController(this, _type, _force);
                ok = true;
            }
            catch (Throwable e) {
                if (file_was_created) {
                    lf.delete();
                }
                this.deleteDirs();
                if (e instanceof FMFileManagerException) {
                    throw (FMFileManagerException)e;
                }
                throw new FMFileManagerException(1, "initialisation failed", e);
            }
        }
        finally {
            if (file_reserved && !ok) {
                this.releaseFile();
            }
        }
    }

    protected FMFileImpl(FMFileImpl basis) throws FMFileManagerException {
        this.owner = basis.owner;
        this.manager = basis.manager;
        this.linked_file = basis.linked_file;
        this.canonical_path = basis.canonical_path;
        this.clone = true;
        try {
            this.file_access = new FMFileAccessController(this, basis.file_access.getStorageType(), false);
        }
        catch (Throwable e) {
            if (e instanceof FMFileManagerException) {
                throw (FMFileManagerException)e;
            }
            throw new FMFileManagerException(1, "initialisation failed", e);
        }
    }

    protected FMFileManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.linked_file.toString();
    }

    @Override
    public boolean exists() {
        File lf = this.linked_file.getFile();
        return FileUtil.exists(lf);
    }

    protected File getFile() {
        return this.linked_file.getFile();
    }

    @Override
    public FMFileOwner getOwner() {
        return this.owner;
    }

    @Override
    public boolean isClone() {
        return this.clone;
    }

    @Override
    public void setStorageType(int new_type, boolean force) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            boolean was_open = this.isOpen();
            if (was_open) {
                this.closeSupport(false);
            }
            try {
                this.file_access.setStorageType(new_type, force);
            }
            finally {
                if (was_open) {
                    this.openSupport("Re-open after storage type change");
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public int getStorageType() {
        return this.file_access.getStorageType();
    }

    @Override
    public int getAccessMode() {
        return this.access_mode;
    }

    protected void setAccessModeSupport(int mode) {
        this.access_mode = mode;
    }

    protected File getLinkedFile() {
        return this.linked_file.getFile();
    }

    @Override
    public void moveFile(File new_linked_file, FileUtil.ProgressListener pl) throws FMFileManagerException {
        block17: {
            try {
                String new_canonical_path;
                this.this_mon.enter();
                this.length_cache = this.getLength();
                try {
                    try {
                        new_canonical_path = new_linked_file.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        String msg = ioe.getMessage();
                        if (msg != null && msg.contains("There are no more files")) {
                            String abs_path = new_linked_file.getAbsolutePath();
                            String error = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + new_linked_file.getPath() + "], new_file.getAbsolutePath()=[" + abs_path + "]. ";
                            Debug.out(error, ioe);
                        }
                        throw ioe;
                    }
                }
                catch (Throwable e) {
                    throw new FMFileManagerException(5, "getCanonicalPath fails", e);
                }
                if (FileUtil.exists(new_linked_file)) {
                    throw new FMFileManagerException(5, "moveFile fails - file '" + new_canonical_path + "' already exists");
                }
                boolean was_open = this.isOpen();
                this.close();
                this.createDirs(new_linked_file);
                File lf = this.linked_file.getFile();
                if (!FileUtil.exists(lf) || FileUtil.renameFile(lf, new_linked_file, pl)) {
                    this.linked_file = new StringInterner.FileKey(new_linked_file);
                    this.canonical_path = new StringInterner.FileKey(new_canonical_path);
                    this.reserveFile();
                    if (was_open) {
                        this.ensureOpen("moveFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                if (was_open) {
                    try {
                        this.ensureOpen("moveFile recovery");
                    }
                    catch (FMFileManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw new FMFileManagerException(5, "moveFile fails");
            }
            finally {
                this.length_cache = -1L;
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void renameFile(String new_name) throws FMFileManagerException {
        block17: {
            try {
                String new_canonical_path;
                this.this_mon.enter();
                File lf = this.linked_file.getFile();
                this.length_cache = this.getLength();
                File new_linked_file = FileUtil.newFile(lf.getParentFile(), new_name);
                try {
                    try {
                        new_canonical_path = new_linked_file.getCanonicalPath();
                    }
                    catch (IOException ioe) {
                        String msg = ioe.getMessage();
                        if (msg != null && msg.contains("There are no more files")) {
                            String abs_path = new_linked_file.getAbsolutePath();
                            String error = "Caught 'There are no more files' exception during new_file.getCanonicalPath(). os=[" + Constants.OSName + "], new_file.getPath()=[" + new_linked_file.getPath() + "], new_file.getAbsolutePath()=[" + abs_path + "]. ";
                            Debug.out(error, ioe);
                        }
                        throw ioe;
                    }
                }
                catch (Throwable e) {
                    throw new FMFileManagerException(5, "getCanonicalPath fails", e);
                }
                if (FileUtil.exists(new_linked_file)) {
                    throw new FMFileManagerException(5, "renameFile fails - new file '" + new_canonical_path + "' already exists (old file='" + lf + "', exists=" + FileUtil.exists(lf) + ")");
                }
                boolean was_open = this.isOpen();
                this.close();
                if (!FileUtil.exists(lf) || lf.renameTo(new_linked_file)) {
                    this.linked_file = new StringInterner.FileKey(new_linked_file);
                    this.canonical_path = new StringInterner.FileKey(new_canonical_path);
                    this.reserveFile();
                    if (was_open) {
                        this.ensureOpen("renameFile target");
                    }
                    break block17;
                }
                try {
                    this.reserveFile();
                }
                catch (FMFileManagerException e) {
                    Debug.printStackTrace(e);
                }
                if (was_open) {
                    try {
                        this.ensureOpen("renameFile recovery");
                    }
                    catch (FMFileManagerException e) {
                        Debug.printStackTrace(e);
                    }
                }
                throw new FMFileManagerException(5, "renameFile fails");
            }
            finally {
                this.length_cache = -1L;
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void ensureOpen(String reason) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (this.isOpen()) {
                return;
            }
            this.openSupport(reason);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected long getLengthCache() {
        return this.length_cache;
    }

    protected long getLengthSupport() throws FMFileManagerException {
        try {
            return this.file_access.getLength(this.fa);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                return this.file_access.getLength(this.fa);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    protected void setLengthSupport(long length) throws FMFileManagerException {
        try {
            this.file_access.setLength(this.fa, length);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.setLength(this.fa, length);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    private void getFileAccessor() throws FileNotFoundException {
        File lf = this.linked_file.getFile();
        try {
            this.fa = FileUtil.newFileAccessor(lf, this.access_mode == 1 ? READ_ACCESS_MODE : WRITE_ACCESS_MODE);
        }
        catch (FileNotFoundException e) {
            if (switch_to_upload_only_enable && this.access_mode == 2 && FileUtil.exists(lf) && lf.canRead()) {
                this.fa = FileUtil.newFileAccessor(lf, READ_ACCESS_MODE);
            }
            throw e;
        }
    }

    protected void reopen(FMFileManagerException cause) throws Throwable {
        if (!cause.isRecoverable()) {
            throw cause;
        }
        if (this.fa != null) {
            try {
                this.fa.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.file_access.aboutToOpen();
        this.getFileAccessor();
        this.last_modified = 0L;
        Debug.outNoStack("Recovered connection to " + this.getName() + " after access failure");
    }

    protected void openSupport(String reason) throws FMFileManagerException {
        if (this.fa != null) {
            throw new FMFileManagerException(1, "file already open");
        }
        this.reserveAccess(reason);
        try {
            this.file_access.aboutToOpen();
            this.getFileAccessor();
            this.last_modified = 0L;
        }
        catch (FileNotFoundException e) {
            int st = this.file_access.getStorageType();
            boolean ok = false;
            try {
                File lf = this.linked_file.getFile();
                lf.getParentFile().mkdirs();
                lf.createNewFile();
                this.getFileAccessor();
                this.last_modified = 0L;
                ok = true;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
            if (!ok) {
                Debug.printStackTrace(e);
                throw new FMFileManagerException(this.access_mode == 1 ? 3 : 4, "open fails for '" + this.linked_file.getFile().getAbsolutePath() + "'", e);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException(this.access_mode == 1 ? 3 : 4, "open fails for '" + this.linked_file.getFile().getAbsolutePath() + "'", e);
        }
    }

    protected void closeSupport(boolean explicit) throws FMFileManagerException {
        FMFileManagerException flush_exception = null;
        try {
            this.flush();
        }
        catch (FMFileManagerException e) {
            flush_exception = e;
        }
        if (this.fa == null) {
            if (explicit) {
                this.releaseFile();
                this.deleteDirs();
            }
        } else {
            try {
                try {
                    this.fa.close();
                }
                catch (Throwable e) {
                    throw new FMFileManagerException(2, "close fails", e);
                }
            }
            finally {
                this.fa = null;
                if (explicit) {
                    this.releaseFile();
                }
            }
        }
        if (flush_exception != null) {
            throw flush_exception;
        }
    }

    @Override
    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    protected boolean isPieceCompleteProcessingNeeded(int piece_number) throws FMFileManagerException {
        return this.file_access.isPieceCompleteProcessingNeeded(piece_number);
    }

    protected void setPieceCompleteSupport(int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        this.file_access.setPieceComplete(this.fa, piece_number, piece_data);
    }

    @Override
    public void delete() throws FMFileManagerException {
        this.close();
        File lf = this.linked_file.getFile();
        if (FileUtil.exists(lf) && !lf.delete()) {
            throw new FMFileManagerException(5, "Failed to delete '" + this.linked_file + "'");
        }
    }

    protected void readSupport(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        this.readSupport(new DirectByteBuffer[]{buffer}, position);
    }

    protected void readSupport(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.file_access.read(this.fa, buffers, position);
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.read(this.fa, buffers, position);
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    protected void writeSupport(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        this.writeSupport(new DirectByteBuffer[]{buffer}, position);
    }

    protected void writeSupport(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.file_access.write(this.fa, buffers, position);
            this.last_modified = SystemTime.getCurrentTime();
        }
        catch (FMFileManagerException e) {
            Debug.printStackTrace(e);
            try {
                this.reopen(e);
                this.file_access.write(this.fa, buffers, position);
                this.last_modified = SystemTime.getCurrentTime();
            }
            catch (Throwable e2) {
                throw e;
            }
        }
    }

    @Override
    public boolean isOpen() {
        return this.fa != null;
    }

    @Override
    public long getLastModified() {
        if (this.last_modified == 0L) {
            this.last_modified = this.linked_file.getFile().lastModified();
        }
        return this.last_modified;
    }

    private void reserveFile() throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List<Object[]> owners = file_map.get(this.canonical_path);
            if (owners == null) {
                owners = new ArrayList<Object[]>(2);
                file_map.put(this.canonical_path, owners);
            } else {
                TOTorrentFile my_torrent_file = this.owner.getTorrentFile();
                TOTorrent my_torrent = my_torrent_file == null ? null : my_torrent_file.getTorrent();
                for (Object[] entry : owners) {
                    TOTorrent this_torrent;
                    TOTorrentFile this_tf;
                    FMFileOwner this_owner = (FMFileOwner)entry[0];
                    if (my_torrent != null && (this_tf = this_owner.getTorrentFile()) != null && (this_torrent = this_tf.getTorrent()) == my_torrent && this_tf != my_torrent_file) {
                        throw new FMFileManagerException(5, "File '" + this.canonical_path + "' occurs more than once in download.\nRename one of the files in Files view via the right-click menu.");
                    }
                    String entry_name = this_owner.getName();
                    if (!this.owner.getName().equals(entry_name)) continue;
                    Debug.out("reserve file - entry already present");
                    entry[1] = Boolean.FALSE;
                    return;
                }
            }
            owners.add(new Object[]{this.owner, Boolean.FALSE, "<reservation>"});
        }
        finally {
            file_map_mon.exit();
        }
    }

    private void reserveAccess(String reason) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List<Object[]> owners = file_map.get(this.canonical_path);
            Object[] my_entry = null;
            if (owners == null) {
                String str = "File '" + this.canonical_path + "' has not been reserved (no entries), '" + this.owner.getName() + "'";
                Debug.out("reserveAccess fail: " + str);
                throw new FMFileManagerException(5, str);
            }
            for (Object[] entry : owners) {
                String entry_name = ((FMFileOwner)entry[0]).getName();
                if (!this.owner.getName().equals(entry_name)) continue;
                my_entry = entry;
            }
            if (my_entry == null) {
                String str = "File '" + this.canonical_path + "' has not been reserved (not found), '" + this.owner.getName() + "'";
                Debug.out("reserveAccess fail: " + str);
                throw new FMFileManagerException(5, str);
            }
            my_entry[1] = this.access_mode == 2;
            my_entry[2] = reason;
            int read_access = 0;
            int write_access = 0;
            int write_access_lax = 0;
            int write_access_hybrid = 0;
            TOTorrentFile my_torrent_file = this.owner.getTorrentFile();
            TOTorrent my_torrent = my_torrent_file == null ? null : my_torrent_file.getTorrent();
            byte[] my_v2_hash = null;
            if (my_torrent != null && my_torrent.getTorrentType() == 2) {
                try {
                    my_v2_hash = my_torrent.getFullHash(3);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            StringBuilder users_sb = owners.size() == 1 ? null : new StringBuilder(128);
            for (Object[] entry : owners) {
                FMFileOwner this_owner = (FMFileOwner)entry[0];
                if (((Boolean)entry[1]).booleanValue()) {
                    ++write_access;
                    TOTorrentFile this_tf = this_owner.getTorrentFile();
                    if (my_torrent_file != null && this_tf != null) {
                        TOTorrent this_torrent;
                        if (my_torrent_file.getLength() == this_tf.getLength()) {
                            ++write_access_lax;
                        }
                        if (my_v2_hash != null && (this_torrent = this_tf.getTorrent()) != null && this_torrent.getTorrentType() == 2) {
                            try {
                                if (Arrays.equals(my_v2_hash, this_torrent.getFullHash(3))) {
                                    ++write_access_hybrid;
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                    if (users_sb == null) continue;
                    if (users_sb.length() > 0) {
                        users_sb.append(",");
                    }
                    users_sb.append(this_owner.getName());
                    users_sb.append(" [write]");
                    continue;
                }
                ++read_access;
                if (users_sb == null) continue;
                if (users_sb.length() > 0) {
                    users_sb.append(",");
                }
                users_sb.append(this_owner.getName());
                users_sb.append(" [read]");
            }
            if (write_access > 1 || write_access == 1 && read_access > 0) {
                if (write_access_hybrid == write_access) {
                    return;
                }
                if (!COConfigurationManager.getBooleanParameter("File.strict.locking") && write_access_lax == write_access) {
                    return;
                }
                String str = "File '" + this.canonical_path + "' is in use by '" + (users_sb == null ? "eh?" : users_sb.toString()) + "'";
                Debug.out("reserveAccess fail: " + str);
                throw new FMFileManagerException(5, str);
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    private void releaseFile() {
        if (this.clone) {
            return;
        }
        try {
            file_map_mon.enter();
            List<Object[]> owners = file_map.get(this.canonical_path);
            if (owners != null) {
                Iterator<Object[]> it = owners.iterator();
                while (it.hasNext()) {
                    Object[] entry = it.next();
                    if (!this.owner.getName().equals(((FMFileOwner)entry[0]).getName())) continue;
                    it.remove();
                    break;
                }
                if (owners.size() == 0) {
                    file_map.remove(this.canonical_path);
                }
            }
        }
        finally {
            file_map_mon.exit();
        }
    }

    protected void createDirs(File target) throws FMFileManagerException {
        if (this.clone) {
            return;
        }
        this.deleteDirs();
        File parent = target.getParentFile();
        if (!FileUtil.existsWithCache(parent)) {
            ArrayList<File> new_dirs = new ArrayList<File>();
            File current = parent;
            while (current != null && !FileUtil.exists(current)) {
                new_dirs.add(current);
                current = current.getParentFile();
            }
            this.created_dirs_leaf = target;
            this.created_dirs = new ArrayList<File>();
            if (FileUtil.mkdirs(parent)) {
                this.created_dirs = new_dirs;
            } else {
                try {
                    Thread.sleep(100 + RandomUtils.nextInt(900));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                FileUtil.mkdirs(parent);
                if (parent.isDirectory()) {
                    this.created_dirs = new_dirs;
                } else {
                    FMFileManagerException error = new FMFileManagerException(5, String.valueOf(MessageText.getString("DownloadManager.error.datamissing")) + ": " + target.getAbsolutePath());
                    error.setType(1);
                    throw error;
                }
            }
        }
    }

    protected void deleteDirs() {
        if (this.clone) {
            return;
        }
        if (this.created_dirs_leaf != null) {
            if (!FileUtil.exists(this.created_dirs_leaf)) {
                for (File dir : this.created_dirs) {
                    File[] entries;
                    if (!FileUtil.exists(dir) || !dir.isDirectory() || (entries = dir.listFiles()) != null && entries.length != 0) break;
                    dir.delete();
                }
            }
            this.created_dirs_leaf = null;
            this.created_dirs = null;
        }
    }

    protected String getString() {
        String cp = this.canonical_path.toString();
        File cPath = this.canonical_path.getFile();
        FMFileAccess.FileAccessor current_fa = this.fa;
        String fa_str = current_fa == null ? "null" : current_fa.getString();
        String sPaths = cPath.equals(this.linked_file) ? "can/link=" + Debug.secretFileName(cp) : "can=" + Debug.secretFileName(cp) + ",link=" + Debug.secretFileName(this.linked_file.toString());
        return String.valueOf(sPaths) + ",fa=" + fa_str + ",acc=" + this.access_mode + ",ctrl={" + this.file_access.getString() + "}";
    }

    protected static void generateEvidence(IndentWriter writer) {
        writer.println(String.valueOf(file_map.size()) + " FMFile Reservations");
        try {
            writer.indent();
            try {
                file_map_mon.enter();
                for (StringInterner.FileKey key : file_map.keySet()) {
                    List<Object[]> owners = file_map.get(key);
                    Iterator<Object[]> it2 = owners.iterator();
                    String str = "";
                    while (it2.hasNext()) {
                        Object[] entry = it2.next();
                        FMFileOwner owner = (FMFileOwner)entry[0];
                        Boolean write = (Boolean)entry[1];
                        String reason = (String)entry[2];
                        str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + owner.getName() + "[" + (write != false ? "write" : "read") + "/" + reason + "]";
                    }
                    writer.println(String.valueOf(Debug.secretFileName(key.toString())) + " -> " + str);
                }
            }
            finally {
                file_map_mon.exit();
            }
            FMFileManagerImpl.generateEvidence(writer);
        }
        finally {
            writer.exdent();
        }
    }
}

