/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.FMFileOwner;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.diskmanager.file.impl.FMFileManagerImpl;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.StringInterner;

public class FMFileLimited
extends FMFileImpl {
    protected FMFileLimited(FMFileOwner owner, FMFileManagerImpl manager, StringInterner.FileKey file, int type, boolean force) throws FMFileManagerException {
        super(owner, manager, file, type, force);
    }

    protected FMFileLimited(FMFileLimited basis) throws FMFileManagerException {
        super(basis);
    }

    @Override
    public FMFile createClone() throws FMFileManagerException {
        return new FMFileLimited(this);
    }

    @Override
    public void ensureOpen(String reason) throws FMFileManagerException {
        block8: {
            try {
                this.this_mon.enter();
                if (this.isOpen()) {
                    this.usedSlot();
                    break block8;
                }
                this.getSlot();
                try {
                    super.ensureOpen(reason);
                }
                finally {
                    if (!this.isOpen()) {
                        this.releaseSlot();
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void getSlot() {
        this.getManager().getSlot(this);
    }

    protected void releaseSlot() {
        this.getManager().releaseSlot(this);
    }

    protected void usedSlot() {
        this.getManager().usedSlot(this);
    }

    @Override
    public void setAccessMode(int mode) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            if (mode != this.getAccessMode()) {
                this.close(false);
            }
            this.setAccessModeSupport(mode);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public long getLength() throws FMFileManagerException {
        boolean got_mon = false;
        try {
            do {
                long length_cache;
                if ((length_cache = this.getLengthCache()) < 0L) continue;
                long l = length_cache;
                return l;
            } while (!this.this_mon.enter(250));
            got_mon = true;
            if (this.isOpen()) {
                long l = this.getLengthSupport();
                return l;
            }
            if (!this.exists()) {
                return 0L;
            }
            this.ensureOpen("FMFileLimited:getLength");
            long l = this.getLengthSupport();
            return l;
        }
        finally {
            if (got_mon) {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void setLength(long length) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen("FMFileLimited:setLength");
            this.setLengthSupport(length);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
        block8: {
            try {
                this.this_mon.enter();
                if (!this.isPieceCompleteProcessingNeeded(piece_number)) break block8;
                this.ensureOpen("FMFileLimited:setPieceComplete");
                boolean switched_mode = false;
                if (this.getAccessMode() != 2) {
                    this.setAccessMode(2);
                    switched_mode = true;
                    this.ensureOpen("FMFileLimited:setPieceComplete2");
                }
                try {
                    this.setPieceCompleteSupport(piece_number, piece_data);
                }
                finally {
                    if (switched_mode) {
                        this.setAccessMode(1);
                    }
                }
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen("FMFileLimited:read");
            this.readSupport(buffers, offset);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void read(DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen("FMFileLimited:read");
            this.readSupport(buffer, offset);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen("FMFileLimited:write");
            this.writeSupport(buffer, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.ensureOpen("FMFileLimited:write");
            this.writeSupport(buffers, position);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void close() throws FMFileManagerException {
        try {
            this.this_mon.enter();
            this.close(true);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void close(boolean explicit) throws FMFileManagerException {
        try {
            this.this_mon.enter();
            boolean was_open = this.isOpen();
            try {
                this.closeSupport(explicit);
            }
            finally {
                if (was_open) {
                    this.releaseSlot();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

