/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManager;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.FMFileOwner;
import com.biglybt.core.diskmanager.file.impl.FMFileImpl;
import com.biglybt.core.diskmanager.file.impl.FMFileLimited;
import com.biglybt.core.diskmanager.file.impl.FMFilePadding;
import com.biglybt.core.diskmanager.file.impl.FMFileUnlimited;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.StringInterner;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class FMFileManagerImpl
implements FMFileManager {
    public static final boolean DEBUG = false;
    protected static FMFileManagerImpl singleton;
    protected static final AEMonitor class_mon;
    protected final LinkedHashMap<FMFileLimited, FMFileLimited> map;
    protected final AEMonitor map_mon = new AEMonitor("FMFileManager:Map");
    protected final boolean limited;
    protected final int limit_size;
    protected AESemaphore close_queue_sem;
    protected List<FMFileLimited> close_queue;
    protected final AEMonitor close_queue_mon = new AEMonitor("FMFileManager:CQ");
    protected List<FMFile> files;
    protected final AEMonitor files_mon = new AEMonitor("FMFileManager:File");

    static {
        class_mon = new AEMonitor("FMFileManager:class");
    }

    public static FMFileManager getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new FMFileManagerImpl();
            }
            FMFileManagerImpl fMFileManagerImpl = singleton;
            return fMFileManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected FMFileManagerImpl() {
        this.limit_size = COConfigurationManager.getIntParameter("File Max Open");
        this.limited = this.limit_size > 0;
        this.map = new LinkedHashMap(this.limit_size, 0.75f, true);
        if (this.limited) {
            this.close_queue_sem = new AESemaphore("FMFileManager::closeqsem");
            this.close_queue = new LinkedList<FMFileLimited>();
            new AEThread2("FMFileManager::closeQueueDispatcher"){

                @Override
                public void run() {
                    FMFileManagerImpl.this.closeQueueDispatch();
                }
            }.start();
        }
    }

    @Override
    public FMFile createFile(FMFileOwner owner, StringInterner.FileKey file, int type, boolean force) throws FMFileManagerException {
        if (owner.getTorrentFile().isPadFile()) {
            return new FMFilePadding(owner, file, false);
        }
        FMFileImpl res = this.limited ? new FMFileLimited(owner, this, file, type, force) : new FMFileUnlimited(owner, this, file, type, force);
        return res;
    }

    protected void getSlot(FMFileLimited file) {
        FMFileLimited oldest_file = null;
        try {
            this.map_mon.enter();
            if (this.map.size() >= this.limit_size) {
                Iterator<FMFileLimited> it = this.map.keySet().iterator();
                oldest_file = it.next();
                it.remove();
            }
            this.map.put(file, file);
        }
        finally {
            this.map_mon.exit();
        }
        if (oldest_file != null) {
            this.closeFile(oldest_file);
        }
    }

    protected void releaseSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            this.map.remove(file);
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void usedSlot(FMFileLimited file) {
        try {
            this.map_mon.enter();
            if (this.map.containsKey(file)) {
                this.map.put(file, file);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    protected void closeFile(FMFileLimited file) {
        try {
            this.close_queue_mon.enter();
            this.close_queue.add(file);
        }
        finally {
            this.close_queue_mon.exit();
        }
        this.close_queue_sem.release();
    }

    protected void closeQueueDispatch() {
        while (true) {
            this.close_queue_sem.reserve();
            FMFileLimited file = null;
            try {
                this.close_queue_mon.enter();
                if (this.close_queue.size() > 0) {
                    file = this.close_queue.remove(0);
                }
            }
            finally {
                this.close_queue_mon.exit();
            }
            if (file == null) continue;
            try {
                file.close(false);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            break;
        }
    }

    protected void generate(IndentWriter writer) {
        writer.println("FMFileManager slots");
        try {
            writer.indent();
            try {
                this.map_mon.enter();
                for (FMFileLimited file : this.map.keySet()) {
                    writer.println(file.getString());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected void generate(IndentWriter writer, TOTorrent torrent) {
        writer.println("FMFileManager slots");
        try {
            HashWrapper hw = torrent.getHashWrapper();
            try {
                writer.indent();
                try {
                    this.map_mon.enter();
                    for (FMFileLimited file : this.map.keySet()) {
                        if (file.getOwner().getTorrentFile().getTorrent().getHashWrapper() != hw) continue;
                        writer.println(file.getString());
                    }
                }
                finally {
                    this.map_mon.exit();
                }
            }
            finally {
                writer.exdent();
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void generateEvidence(IndentWriter writer) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(writer);
    }

    @Override
    public void generateEvidence(IndentWriter writer, TOTorrent torrent) {
        FMFileManagerImpl.getSingleton();
        singleton.generate(writer, torrent);
    }
}

