/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.diskmanager.file.impl;

import com.biglybt.core.diskmanager.file.FMFile;
import com.biglybt.core.diskmanager.file.FMFileManagerException;
import com.biglybt.core.diskmanager.file.FMFileOwner;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.StringInterner;
import java.io.File;

public class FMFilePadding
implements FMFile {
    private static byte[] ZERO_BYTES = new byte[1024];
    private final FMFileOwner owner;
    private final long length;
    private final boolean is_clone;
    private StringInterner.FileKey file;
    private int mode = 1;
    private boolean is_open;

    protected FMFilePadding(FMFileOwner _owner, StringInterner.FileKey _file, boolean _is_clone) {
        this.owner = _owner;
        this.length = this.owner.getTorrentFile().getLength();
        this.is_clone = _is_clone;
        this.file = _file;
    }

    @Override
    public String getName() {
        return this.owner.getName();
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public FMFileOwner getOwner() {
        return this.owner;
    }

    @Override
    public void moveFile(File new_file, FileUtil.ProgressListener pl) throws FMFileManagerException {
        this.file = new StringInterner.FileKey(new_file);
        pl.bytesDone(this.length);
        pl.complete();
    }

    @Override
    public void renameFile(String new_name) throws FMFileManagerException {
        this.file = new StringInterner.FileKey(FileUtil.newFile(this.file.getFile().getParentFile(), new_name));
    }

    @Override
    public void setAccessMode(int _mode) throws FMFileManagerException {
        this.mode = _mode;
    }

    @Override
    public int getAccessMode() {
        return this.mode;
    }

    @Override
    public void setStorageType(int type, boolean force) throws FMFileManagerException {
    }

    @Override
    public int getStorageType() {
        return 1;
    }

    @Override
    public void ensureOpen(String reason) throws FMFileManagerException {
        this.is_open = true;
    }

    @Override
    public long getLength() throws FMFileManagerException {
        return this.length;
    }

    @Override
    public void setLength(long length) throws FMFileManagerException {
    }

    @Override
    public void setPieceComplete(int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    @Override
    public void read(DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        int rem;
        while ((rem = buffer.remaining((byte)4)) != 0) {
            buffer.put((byte)4, ZERO_BYTES, 0, Math.min(rem, ZERO_BYTES.length));
        }
        return;
    }

    @Override
    public void read(DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        DirectByteBuffer[] directByteBufferArray = buffers;
        int n = buffers.length;
        int n2 = 0;
        while (n2 < n) {
            DirectByteBuffer buffer = directByteBufferArray[n2];
            this.read(buffer, 0L);
            ++n2;
        }
    }

    @Override
    public void write(DirectByteBuffer buffer, long position) throws FMFileManagerException {
    }

    @Override
    public void write(DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
    }

    @Override
    public void flush() throws FMFileManagerException {
    }

    @Override
    public void close() throws FMFileManagerException {
        this.is_open = false;
    }

    @Override
    public boolean isOpen() {
        return this.is_open;
    }

    @Override
    public void delete() throws FMFileManagerException {
        this.is_open = false;
    }

    @Override
    public FMFile createClone() throws FMFileManagerException {
        return new FMFilePadding(this.owner, this.file, true);
    }

    @Override
    public boolean isClone() {
        return this.is_clone;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }
}

