/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.security.SEPasswordListener;
import com.biglybt.core.security.SESecurityManager;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SHA1Simple;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.disk.DiskManagerChannel;
import com.biglybt.pif.disk.DiskManagerEvent;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.disk.DiskManagerListener;
import com.biglybt.pif.disk.DiskManagerRandomReadRequest;
import com.biglybt.pif.disk.DiskManagerRequest;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.utils.PooledByteBuffer;
import com.biglybt.pifimpl.local.utils.PooledByteBufferImpl;
import com.biglybt.plugin.extseed.ExternalSeedException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashSet;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

public class DiskManagerFileInfoURL
implements DiskManagerFileInfo,
SEPasswordListener {
    URL url;
    private byte[] hash;
    File file;
    private Object lock = new Object();
    URL redirected_url;
    int consec_redirect_fails;
    private volatile boolean file_cached;

    public DiskManagerFileInfoURL(URL _url) {
        String file_name;
        this.url = _url;
        String url_str = this.url.toExternalForm();
        String id_key = "azcdid=";
        String dn_key = "azcddn=";
        int id_pos = url_str.indexOf(id_key);
        int dn_pos = url_str.indexOf(dn_key);
        int min_pos = id_pos;
        if (min_pos == -1) {
            min_pos = dn_pos;
        } else if (dn_pos != -1) {
            min_pos = Math.min(min_pos, dn_pos);
        }
        if (min_pos > 0) {
            try {
                this.url = new URL(url_str.substring(0, min_pos - 1));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        try {
            this.hash = new SHA1Simple().calculateHash(("DiskManagerFileInfoURL" + this.url.toExternalForm()).getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (dn_pos != -1) {
            String dn = url_str.substring(dn_pos + dn_key.length());
            if ((dn_pos = dn.indexOf(38)) != -1) {
                dn = dn.substring(0, dn_pos);
            }
            file_name = UrlUtils.decode(dn);
        } else {
            String path = this.url.getPath();
            int pos = path.lastIndexOf("/");
            if (pos != -1) {
                path = path.substring(pos + 1);
            }
            path = path.trim();
            file_name = url_str.length() > 0 ? UrlUtils.decode(path) : Base32.encode(this.hash);
        }
        file_name = FileUtil.convertOSSpecificChars(file_name, false);
        try {
            this.file = FileUtil.newFile(AETemporaryFileHandler.createTempDir(), file_name);
        }
        catch (Throwable e) {
            file_name = String.valueOf(file_name) + ".tmp";
            this.file = FileUtil.newFile(AETemporaryFileHandler.getTempDirectory(), file_name);
        }
    }

    public URL getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download() {
        Object object = this.lock;
        synchronized (object) {
            if (this.file_cached) {
                return;
            }
            try {
                channel chan = this.createChannel();
                channel.request req = chan.createRequest();
                req.setAll();
                final FileOutputStream fos = FileUtil.newFileOutputStream(this.file);
                boolean ok = false;
                try {
                    req.addListener(new DiskManagerListener(){

                        @Override
                        public void eventOccurred(DiskManagerEvent event2) {
                            if (event2.getType() == 2) {
                                throw new RuntimeException(event2.getFailure());
                            }
                            PooledByteBuffer buffer = event2.getBuffer();
                            if (buffer == null) {
                                throw new RuntimeException("eh?");
                            }
                            try {
                                try {
                                    fos.write(buffer.toByteArray());
                                }
                                catch (IOException e) {
                                    throw new RuntimeException("Failed to write to " + DiskManagerFileInfoURL.this.file, e);
                                }
                            }
                            finally {
                                buffer.returnToPool();
                            }
                        }
                    });
                    req.run();
                    ok = true;
                }
                finally {
                    try {
                        fos.close();
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    if (!ok) {
                        this.file.delete();
                    } else {
                        this.file_cached = true;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out("Failed to cache file from " + this.url, e);
            }
        }
    }

    @Override
    public void setPriority(boolean b) {
    }

    @Override
    public void setSkipped(boolean b) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public Boolean isSkipping() {
        return null;
    }

    @Override
    public int getNumericPriority() {
        return 0;
    }

    @Override
    public void setNumericPriority(int priority) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public void setDeleted(boolean b) {
    }

    @Override
    public void setLink(File link_destination, boolean no_delete) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public File getLink() {
        return null;
    }

    @Override
    public int getAccessMode() {
        return 1;
    }

    @Override
    public long getDownloaded() {
        return this.getLength();
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public long getLength() {
        long len;
        if (this.file_cached && (len = this.file.length()) > 0L) {
            return len;
        }
        return -1L;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public File getFile(boolean follow_link) {
        return this.file;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public int getFirstPieceNumber() {
        return 0;
    }

    @Override
    public long getPieceSize() {
        return 32768L;
    }

    @Override
    public int getNumPieces() {
        return -1;
    }

    @Override
    public boolean isPriority() {
        return false;
    }

    @Override
    public boolean isSkipped() {
        return false;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public byte[] getDownloadHash() throws DownloadException {
        return this.hash;
    }

    @Override
    public Download getDownload() throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public channel createChannel() throws DownloadException {
        return new channel();
    }

    @Override
    public DiskManagerRandomReadRequest createRandomReadRequest(long file_offset, long length, boolean reverse_order, DiskManagerListener listener) throws DownloadException {
        throw new DownloadException("Not supported");
    }

    @Override
    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        return null;
    }

    @Override
    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    @Override
    public void clearPasswords() {
    }

    protected class channel
    implements DiskManagerChannel {
        volatile boolean channel_destroyed;
        volatile long channel_position;

        protected channel() {
        }

        @Override
        public request createRequest() {
            return new request();
        }

        @Override
        public DiskManagerFileInfo getFile() {
            return DiskManagerFileInfoURL.this;
        }

        @Override
        public long getPosition() {
            return this.channel_position;
        }

        @Override
        public boolean isDestroyed() {
            return this.channel_destroyed;
        }

        @Override
        public void destroy() {
            this.channel_destroyed = true;
        }

        protected class request
        implements DiskManagerRequest {
            private long offset;
            private long length;
            private boolean do_all_file;
            private long position;
            private int max_read_chunk = 131072;
            private volatile boolean request_cancelled;
            private CopyOnWriteList<DiskManagerListener> listeners = new CopyOnWriteList();

            protected request() {
            }

            @Override
            public void setType(int type) {
                if (type != 1) {
                    throw new RuntimeException("Not supported");
                }
            }

            public void setAll() {
                this.do_all_file = true;
                this.offset = 0L;
                this.setLength(-1L);
            }

            @Override
            public void setOffset(long _offset) {
                this.offset = _offset;
            }

            @Override
            public void setLength(long _length) {
                this.length = _length == -1L ? Long.MAX_VALUE : _length;
            }

            @Override
            public void setMaximumReadChunkSize(int size) {
                if (size > 16384) {
                    this.max_read_chunk = size;
                }
            }

            @Override
            public long getAvailableBytes() {
                return this.getRemaining();
            }

            @Override
            public long getRemaining() {
                return this.length == Long.MAX_VALUE ? this.length : this.offset + this.length - this.position;
            }

            @Override
            public void run() {
                try {
                    byte[] buffer = new byte[this.max_read_chunk];
                    long rem = this.length;
                    long pos = this.offset;
                    InputStream is = null;
                    try {
                        HttpURLConnection connection;
                        SESecurityManager.setThreadPasswordHandler(DiskManagerFileInfoURL.this);
                        HashSet<String> redirect_urls = new HashSet<String>();
                        block11: while (true) {
                            URL target = ((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url == null ? ((channel)channel.this).DiskManagerFileInfoURL.this.url : ((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url;
                            int ssl_loop = 0;
                            while (true) {
                                if (ssl_loop >= 2) continue block11;
                                try {
                                    String move_to;
                                    connection = (HttpURLConnection)target.openConnection();
                                    if (connection instanceof HttpsURLConnection) {
                                        HttpsURLConnection ssl_con = (HttpsURLConnection)connection;
                                        ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                            @Override
                                            public boolean verify(String host, SSLSession session) {
                                                return true;
                                            }
                                        });
                                    }
                                    connection.setRequestProperty("Connection", "Keep-Alive");
                                    if (!this.do_all_file) {
                                        connection.setRequestProperty("Range", "bytes=" + this.offset + "-" + (this.offset + this.length - 1L));
                                    }
                                    connection.setConnectTimeout(20000);
                                    connection.connect();
                                    connection.setReadTimeout(10000);
                                    int response = connection.getResponseCode();
                                    if (response == 202 || response == 200 || response == 206) {
                                        if (((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url == null) break block11;
                                        ((channel)channel.this).DiskManagerFileInfoURL.this.consec_redirect_fails = 0;
                                        break block11;
                                    }
                                    if ((response == 302 || response == 301) && (move_to = connection.getHeaderField("location")) != null) {
                                        if (redirect_urls.contains(move_to) || redirect_urls.size() > 32) {
                                            throw new ExternalSeedException("redirect loop");
                                        }
                                        redirect_urls.add(move_to);
                                        ((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url = new URL(move_to);
                                        continue block11;
                                    }
                                    if (((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url == null) break block11;
                                    ++((channel)channel.this).DiskManagerFileInfoURL.this.consec_redirect_fails;
                                    ((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url = null;
                                    continue block11;
                                }
                                catch (SSLException e) {
                                    if (ssl_loop != 0 || SESecurityManager.installServerCertificates(target) == null) {
                                        throw e;
                                    }
                                    ++ssl_loop;
                                }
                            }
                            break;
                        }
                        URL final_url = connection.getURL();
                        if (((channel)channel.this).DiskManagerFileInfoURL.this.consec_redirect_fails < 10 && !((channel)channel.this).DiskManagerFileInfoURL.this.url.toExternalForm().equals(final_url.toExternalForm())) {
                            ((channel)channel.this).DiskManagerFileInfoURL.this.redirected_url = final_url;
                        }
                        is = connection.getInputStream();
                        while (rem > 0L) {
                            if (this.request_cancelled) {
                                throw new Exception("Cancelled");
                            }
                            if (channel.this.channel_destroyed) {
                                throw new Exception("Destroyed");
                            }
                            int len = is.read(buffer);
                            if (len == -1) {
                                if (this.length == Long.MAX_VALUE) {
                                    break;
                                }
                                throw new Exception("Premature end of stream (complete)");
                            }
                            if (len == 0) {
                                this.sendEvent(new event(pos));
                                continue;
                            }
                            this.sendEvent(new event(new PooledByteBufferImpl(buffer, 0, len), pos, len));
                            rem -= (long)len;
                            pos += (long)len;
                        }
                    }
                    finally {
                        SESecurityManager.unsetThreadPasswordHandler();
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
                catch (Throwable e) {
                    this.sendEvent(new event(e));
                }
            }

            @Override
            public void cancel() {
                this.request_cancelled = true;
            }

            @Override
            public void setUserAgent(String agent) {
            }

            protected void sendEvent(event ev) {
                for (DiskManagerListener l : this.listeners) {
                    l.eventOccurred(ev);
                }
            }

            @Override
            public void addListener(DiskManagerListener listener) {
                this.listeners.add(listener);
            }

            @Override
            public void removeListener(DiskManagerListener listener) {
                this.listeners.remove(listener);
            }

            protected class event
            implements DiskManagerEvent {
                private int event_type;
                private Throwable error;
                private PooledByteBuffer buffer;
                private long event_offset;
                private int event_length;

                protected event(Throwable _error) {
                    this.event_type = 2;
                    this.error = _error;
                }

                protected event(long _offset) {
                    this.event_type = 3;
                    this.event_offset = _offset;
                    ((request)request.this).channel.this.channel_position = _offset;
                }

                protected event(PooledByteBuffer _buffer, long _offset, int _length) {
                    this.event_type = 1;
                    this.buffer = _buffer;
                    this.event_offset = _offset;
                    this.event_length = _length;
                    ((request)request.this).channel.this.channel_position = _offset + (long)_length - 1L;
                }

                @Override
                public int getType() {
                    return this.event_type;
                }

                public DiskManagerRequest getRequest() {
                    return request.this;
                }

                @Override
                public long getOffset() {
                    return this.event_offset;
                }

                @Override
                public int getLength() {
                    return this.event_length;
                }

                @Override
                public PooledByteBuffer getBuffer() {
                    return this.buffer;
                }

                @Override
                public Throwable getFailure() {
                    return this.error;
                }
            }
        }
    }
}

