/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download;

import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.download.DownloadManagerActivationListener;
import com.biglybt.core.download.DownloadManagerDiskListener;
import com.biglybt.core.download.DownloadManagerException;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerPeerListener;
import com.biglybt.core.download.DownloadManagerPieceListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.DownloadManagerTPSListener;
import com.biglybt.core.download.DownloadManagerTrackerListener;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadScrapeResult;
import java.io.File;
import java.util.List;

public interface DownloadManager
extends Taggable {
    public static final int STATE_START_OF_DAY = -1;
    public static final int STATE_WAITING = 0;
    public static final int STATE_INITIALIZING = 5;
    public static final int STATE_INITIALIZED = 10;
    public static final int STATE_ALLOCATING = 20;
    public static final int STATE_CHECKING = 30;
    public static final int STATE_READY = 40;
    public static final int STATE_DOWNLOADING = 50;
    public static final int STATE_FINISHING = 55;
    public static final int STATE_SEEDING = 60;
    public static final int STATE_STOPPING = 65;
    public static final int STATE_STOPPED = 70;
    public static final int STATE_CLOSED = 71;
    public static final int STATE_QUEUED = 75;
    public static final int STATE_ERROR = 100;
    public static final int WEALTH_STOPPED = 1;
    public static final int WEALTH_NO_TRACKER = 2;
    public static final int WEALTH_NO_REMOTE = 3;
    public static final int WEALTH_OK = 4;
    public static final int WEALTH_KO = 5;
    public static final int WEALTH_ERROR = 6;
    public static final int ET_NONE = 0;
    public static final int ET_OTHER = 1;
    public static final int ET_INSUFFICIENT_SPACE = 2;
    public static final int ET_STOP_DURING_INIT = 3;
    public static final int ET_FILE_MISSING = 4;
    public static final int EF_WAS_FORCE_START = 1;
    public static final Object UD_KEY_STOP_REASON = Download.UD_KEY_STOP_REASON;

    public void setConstructed();

    public boolean isConstructed();

    public void initialize();

    public int getState();

    public int getSubState();

    public void setStateWaiting();

    public void setStateQueued();

    public void startDownload();

    public boolean canForceRecheck();

    public boolean isForceRechecking();

    public void forceRecheck();

    public void syncGlobalConfig();

    public void resetFile(DiskManagerFileInfo var1);

    public void recheckFile(DiskManagerFileInfo var1);

    public void requestAllocation(List<DiskManagerFileInfo> var1);

    public void setPieceCheckingEnabled(boolean var1);

    public void stopIt(int var1, boolean var2, boolean var3);

    public void setStopReason(String var1);

    public String getStopReason();

    public void stopIt(int var1, boolean var2, boolean var3, boolean var4);

    public boolean pause(boolean var1);

    public boolean pause(boolean var1, long var2);

    public boolean isPaused();

    public boolean stopPausedDownload();

    public void resume();

    public boolean resume(int var1);

    public int getTCPListeningPortNumber();

    public long getAutoResumeTime();

    default public void setAutoResumeTime(long time) {
    }

    public GlobalManager getGlobalManager();

    public DiskManager getDiskManager();

    public DiskManagerPiece[] getDiskManagerPiecesSnapshot();

    public DiskManagerFileInfo[] getDiskManagerFileInfo();

    public DiskManagerFileInfoSet getDiskManagerFileInfoSet();

    public int getNumFileInfos();

    public PEPeerManager getPeerManager();

    public DownloadManagerState getDownloadState();

    public TOTorrent getTorrent();

    public TRTrackerAnnouncer getTrackerClient();

    public void requestTrackerAnnounce(boolean var1);

    public void requestTrackerScrape(boolean var1);

    public TRTrackerScraperResponse getTrackerScrapeResponse();

    public List<TRTrackerScraperResponse> getGoodTrackerScrapeResponses();

    public void setTrackerScrapeResponse(TRTrackerScraperResponse var1);

    public String getDisplayName();

    public String getInternalName();

    public long getSize();

    public String getTorrentFileName();

    public void setTorrentFileName(String var1);

    public File getAbsoluteSaveLocation();

    public File getSaveLocation();

    default public void setTorrentSaveDir(String sPath) {
        this.setTorrentSaveDir(FileUtil.newFile(sPath, new String[0]), false);
    }

    public void setTorrentSaveDir(File var1, boolean var2);

    public boolean isForceStart();

    public void setForceStart(boolean var1);

    public boolean isPersistent();

    public boolean isDownloadComplete(boolean var1);

    public void checkLightSeeding(boolean var1);

    public String getTrackerStatus();

    public int getTrackerTime();

    public String getTorrentComment();

    public String getTorrentCreatedBy();

    public long getTorrentCreationDate();

    public int getNbPieces();

    public String getPieceLength();

    public int getNbSeeds();

    public int getNbPeers();

    default public boolean filesExist(boolean expected_to_be_allocated) {
        return this.filesExist(expected_to_be_allocated, false);
    }

    public boolean filesExist(boolean var1, boolean var2);

    public void setErrorState(int var1, String var2, int var3);

    public String getErrorDetails();

    public int getErrorType();

    public int getErrorFlags();

    public DownloadManagerStats getStats();

    public int getPosition();

    public void setPosition(int var1);

    public boolean getAssumedComplete();

    public boolean requestAssumedCompleteMode();

    public int getHealthStatus();

    public Object[] getNATStatus();

    public void saveResumeData();

    public void saveDownload(boolean var1);

    public Object getUserData(Object var1);

    public void setUserData(Object var1, Object var2);

    public boolean isDataAlreadyAllocated();

    public void setDataAlreadyAllocated(boolean var1);

    public void setSeedingRank(Download.SeedingRank var1);

    public Download.SeedingRank getSeedingRank();

    public boolean isSwarmMerging();

    public String getSwarmMergingInfo();

    public void setMaxUploads(int var1);

    public int getMaxUploads();

    public void updateAutoUploadPriority(Object var1, boolean var2);

    public int getEffectiveUploadPriority();

    public int getEffectiveMaxUploads();

    public int getEffectiveUploadRateLimitBytesPerSecond();

    public void setCryptoLevel(int var1);

    public int getCryptoLevel();

    public long[] getMoveProgress();

    public void moveDataFiles(File var1) throws DownloadManagerException;

    public void moveDataFilesLive(File var1) throws DownloadManagerException;

    public void copyDataFiles(File var1, CoreOperationTask.ProgressCallback var2) throws DownloadManagerException;

    public void renameDownload(String var1) throws DownloadManagerException;

    public void moveDataFiles(File var1, String var2) throws DownloadManagerException;

    public void moveTorrentFile(File var1) throws DownloadManagerException;

    public boolean isInDefaultSaveDir();

    public long getCreationTime();

    public void setCreationTime(long var1);

    public void setAnnounceResult(DownloadAnnounceResult var1);

    public void setScrapeResult(DownloadScrapeResult var1);

    public boolean isUnauthorisedOnTracker();

    public boolean isTrackerError();

    public int getExtendedMessagingMode();

    public void destroy(boolean var1);

    public boolean isDestroyed();

    public PEPiece[] getCurrentPieces();

    public PEPeer[] getCurrentPeers();

    public List<TrackerPeerSource> getTrackerPeerSources();

    public boolean seedPieceRecheck();

    public void addRateLimiter(LimitedRateGroup var1, boolean var2);

    public LimitedRateGroup[] getRateLimiters(boolean var1);

    public void removeRateLimiter(LimitedRateGroup var1, boolean var2);

    public void addListener(DownloadManagerListener var1, boolean var2);

    public void addListener(DownloadManagerListener var1);

    public void removeListener(DownloadManagerListener var1);

    public void addTrackerListener(DownloadManagerTrackerListener var1);

    public void removeTrackerListener(DownloadManagerTrackerListener var1);

    public void addPeerListener(DownloadManagerPeerListener var1);

    public void addPeerListener(DownloadManagerPeerListener var1, boolean var2);

    public void removePeerListener(DownloadManagerPeerListener var1);

    public void addPieceListener(DownloadManagerPieceListener var1);

    public void addPieceListener(DownloadManagerPieceListener var1, boolean var2);

    public void removePieceListener(DownloadManagerPieceListener var1);

    public void addDiskListener(DownloadManagerDiskListener var1);

    public void removeDiskListener(DownloadManagerDiskListener var1);

    public int getActivationCount();

    public void addActivationListener(DownloadManagerActivationListener var1);

    public void removeActivationListener(DownloadManagerActivationListener var1);

    public void addTPSListener(DownloadManagerTPSListener var1);

    public void informTPSChanged();

    public void removeTPSListener(DownloadManagerTPSListener var1);

    public void generateEvidence(IndentWriter var1, boolean var2);

    public int[] getStorageType(DiskManagerFileInfo[] var1);

    public boolean canMoveDataFiles();

    public void rename(String var1) throws DownloadManagerException;

    public void renameTorrent(String var1) throws DownloadManagerException;

    public void renameTorrentSafe(String var1) throws DownloadManagerException;

    public void moveTorrentFile(File var1, String var2) throws DownloadManagerException;

    public void setTorrentFile(File var1, String var2) throws DownloadManagerException;

    public boolean canExportDownload();

    public void exportDownload(File var1) throws DownloadManagerException;

    default public void fireGlobalManagerEvent(int event_type) {
        this.fireGlobalManagerEvent(event_type, null);
    }

    public void fireGlobalManagerEvent(int var1, Object var2);

    public void requestAttention();
}

