/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.download.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.impl.DownloadManagerMoveHandlerUtils;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureFileLocation;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.savelocation.DefaultSaveLocationManager;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pifimpl.local.download.DownloadImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DownloadManagerDefaultPaths
extends DownloadManagerMoveHandlerUtils {
    private static final int REASON_DEFAULTS = 0;
    private static final int REASON_INIT = 1;
    private static final int REASON_COMPLETE = 2;
    private static final int REASON_REMOVE = 3;
    public static final DefaultSaveLocationManager DEFAULT_HANDLER;
    static final MovementInformation COMPLETION_DETAILS;
    static final MovementInformation REMOVAL_DETAILS;
    static final MovementInformation[] UPDATE_FOR_MOVE_DETAILS;
    private static final TargetSpecification[] DEFAULT_DIRS;
    private static final String SUBDIR_PARAM = "File.move.subdir_is_default";

    static {
        MovementInformation mi_1;
        DEFAULT_HANDLER = new DefaultSaveLocationManager(){

            @Override
            public SaveLocationChange onInitialization(Download d, boolean for_move, boolean on_event) {
                if (on_event) {
                    return null;
                }
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                return DownloadManagerDefaultPaths.determinePaths(dm, UPDATE_FOR_MOVE_DETAILS[1], for_move, 1);
            }

            @Override
            public SaveLocationChange onCompletion(Download d, boolean for_move, boolean on_event) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                MovementInformation mi = DownloadManagerDefaultPaths.getDownloadOrTagCompletionMovementInformation(dm, COMPLETION_DETAILS);
                return DownloadManagerDefaultPaths.determinePaths(dm, mi, for_move, 2);
            }

            @Override
            public SaveLocationChange onRemoval(Download d, boolean for_move, boolean on_event) {
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                MovementInformation mi = DownloadManagerDefaultPaths.getDownloadOrTagRemovalMovementInformation(dm, REMOVAL_DETAILS);
                return DownloadManagerDefaultPaths.determinePaths(dm, mi, for_move, 3);
            }

            @Override
            public boolean isInDefaultSaveDir(Download d) {
                Debug.out("Thought this wasn't used...");
                DownloadManager dm = ((DownloadImpl)d).getDownload();
                return DownloadManagerDefaultPaths.isInDefaultDownloadDir(dm);
            }
        };
        DEFAULT_DIRS = new TargetSpecification[3];
        TargetSpecification dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        dest.setContext("default save dir");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[0] = dest;
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default dir", "Move Only When In Default Save Dir");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", false);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "Move Completed When Done");
        dest.setString("target", "Completed Files Directory");
        dest.setContext("completed files dir");
        dest.setBoolean("torrent", "Move Torrent When Done");
        dest.setString("torrent_path", "Move Torrent When Done Directory");
        TransferSpecification trans = new TransferSpecification();
        COMPLETION_DETAILS = mi_1 = new MovementInformation(source, dest, trans, "Move on completion");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[1] = dest;
        source = new SourceSpecification();
        source.setBoolean("default dir", "File.move.download.removed.only_in_default");
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", false);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", "File.move.download.removed.enabled");
        dest.setString("target", "File.move.download.removed.path");
        dest.setContext("removed files dir");
        dest.setBoolean("torrent", "File.move.download.removed.move_torrent");
        dest.setString("torrent_path", "File.move.download.removed.move_torrent_path");
        trans = new TransferSpecification();
        REMOVAL_DETAILS = mi_1 = new MovementInformation(source, dest, trans, "Move on removal");
        DownloadManagerDefaultPaths.DEFAULT_DIRS[2] = dest;
        source = new SourceSpecification();
        source.updateSettings(DownloadManagerDefaultPaths.COMPLETION_DETAILS.source.getSettings());
        source.setBoolean("default dir", true);
        mi_1 = new MovementInformation(source, DownloadManagerDefaultPaths.COMPLETION_DETAILS.target, DownloadManagerDefaultPaths.COMPLETION_DETAILS.transfer, "Update completed download");
        source = new SourceSpecification();
        source.setBoolean("default dir", true);
        source.setBoolean("default subdir", SUBDIR_PARAM);
        source.setBoolean("incomplete dl", true);
        dest = new TargetSpecification();
        dest.setBoolean("enabled", true);
        dest.setString("target", "Default save path");
        dest.setBoolean("torrent", false);
        trans = new TransferSpecification();
        MovementInformation mi_2 = new MovementInformation(source, dest, trans, "Update incomplete download");
        UPDATE_FOR_MOVE_DETAILS = new MovementInformation[]{mi_1, mi_2};
    }

    static MovementInformation getDownloadOrTagCompletionMovementInformation(DownloadManager dm, MovementInformation def_mi) {
        List<Tag> applicable_tags;
        boolean move_data = true;
        boolean move_torrent = false;
        File move_to_target = null;
        String context_str = "";
        String mi_str = "";
        DownloadManagerState state = dm.getDownloadState();
        String explicit_target = state.getAttribute("moc.dir");
        if (explicit_target != null && explicit_target.length() > 0) {
            File move_to = FileUtil.newFile(explicit_target, new String[0]);
            if (!FileUtil.exists(move_to)) {
                move_to.mkdirs();
            }
            if (move_to.isDirectory() && move_to.canWrite()) {
                move_to_target = move_to;
                context_str = "Download-specific move-on-complete directory";
                mi_str = "Download-specific Move on Completion";
            } else {
                DownloadManagerDefaultPaths.logInfo("Ignoring invalid download move-to location: " + move_to, dm);
            }
        }
        if (move_to_target == null && !(applicable_tags = TagUtils.getActiveMoveOnCompleteTags(dm, false, str -> DownloadManagerDefaultPaths.logInfo(str, dm))).isEmpty()) {
            Tag tag_target = applicable_tags.get(0);
            TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag_target);
            move_to_target = fl.getTagMoveOnCompleteFolder();
            long options = fl.getTagMoveOnCompleteOptions();
            move_data = (options & 1L) != 0L;
            move_torrent = (options & 2L) != 0L;
            context_str = "Tag '" + tag_target.getTagName(true) + "' move-on-complete directory";
            mi_str = "Tag Move on Completion";
        }
        if (move_to_target != null) {
            SourceSpecification source = new SourceSpecification();
            if (def_mi.target.getBoolean("enabled", false)) {
                source.setBoolean("default dir", "Move Only When In Default Save Dir");
                source.setBoolean("default subdir", SUBDIR_PARAM);
            } else {
                source.setBoolean("default dir", false);
            }
            source.setBoolean("incomplete dl", false);
            TargetSpecification dest = new TargetSpecification();
            if (move_data) {
                dest.setBoolean("enabled", true);
                dest.setString("target_raw", move_to_target.getAbsolutePath());
            } else {
                dest.setBoolean("enabled", def_mi.target.getBoolean("enabled", false));
            }
            dest.setContext(context_str);
            if (move_torrent) {
                dest.setBoolean("torrent", true);
                dest.setString("torrent_path_raw", move_to_target.getAbsolutePath());
            } else if (def_mi.target.getBoolean("enabled", false)) {
                dest.setBoolean("torrent", "Move Torrent When Done");
                dest.setString("torrent_path", "Move Torrent When Done Directory");
            } else {
                dest.setBoolean("torrent", false);
            }
            TransferSpecification trans = new TransferSpecification();
            MovementInformation mi = new MovementInformation(source, dest, trans, mi_str);
            return mi;
        }
        return def_mi;
    }

    static MovementInformation getDownloadOrTagRemovalMovementInformation(DownloadManager dm, MovementInformation def_mi) {
        boolean move_data = true;
        boolean move_torrent = false;
        String context_str = "";
        String mi_str = "";
        File move_to_target = null;
        List<Tag> dm_tags = TagManagerFactory.getTagManager().getTagsForTaggable(dm);
        if (dm_tags != null) {
            ArrayList<Tag> applicable_tags = new ArrayList<Tag>();
            for (Tag tag : dm_tags) {
                File move_to;
                Object fl;
                if (!tag.getTagType().hasTagTypeFeature(16L) || !(fl = (TagFeatureFileLocation)((Object)tag)).supportsTagMoveOnRemove() || (move_to = fl.getTagMoveOnRemoveFolder()) == null) continue;
                if (!FileUtil.exists(move_to)) {
                    move_to.mkdirs();
                }
                if (move_to.isDirectory() && move_to.canWrite()) {
                    applicable_tags.add(tag);
                    continue;
                }
                DownloadManagerDefaultPaths.logInfo("Ignoring invalid tag move-to location: " + move_to, dm);
            }
            if (!applicable_tags.isEmpty()) {
                if (applicable_tags.size() > 1) {
                    Collections.sort(applicable_tags, new Comparator<Tag>(){

                        @Override
                        public int compare(Tag o1, Tag o2) {
                            return o1.getTagID() - o2.getTagID();
                        }
                    });
                    String str = "";
                    for (Tag tag : applicable_tags) {
                        str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + tag.getTagName(true);
                    }
                    DownloadManagerDefaultPaths.logInfo("Multiple applicable tags found: " + str + " - selecting first", dm);
                }
                Tag tag_target = (Tag)applicable_tags.get(0);
                TagFeatureFileLocation fl = (TagFeatureFileLocation)((Object)tag_target);
                move_to_target = fl.getTagMoveOnRemoveFolder();
                long options = fl.getTagMoveOnRemoveOptions();
                move_data = (options & 1L) != 0L;
                move_torrent = (options & 2L) != 0L;
                context_str = "Tag '" + tag_target.getTagName(true) + "' move-on-remove directory";
                mi_str = "Tag Move on Removal";
            }
        }
        if (move_to_target != null) {
            SourceSpecification source = new SourceSpecification();
            if (def_mi.target.getBoolean("enabled", false)) {
                source.setBoolean("default dir", "File.move.download.removed.only_in_default");
                source.setBoolean("default subdir", SUBDIR_PARAM);
            } else {
                source.setBoolean("default dir", false);
            }
            source.setBoolean("incomplete dl", false);
            TargetSpecification dest = new TargetSpecification();
            if (move_data) {
                dest.setBoolean("enabled", true);
                dest.setString("target_raw", move_to_target.getAbsolutePath());
            } else {
                dest.setBoolean("enabled", def_mi.target.getBoolean("enabled", false));
            }
            dest.setContext(context_str);
            if (move_torrent) {
                dest.setBoolean("torrent", true);
                dest.setString("torrent_path_raw", move_to_target.getAbsolutePath());
            } else if (def_mi.target.getBoolean("enabled", false)) {
                dest.setBoolean("torrent", "File.move.download.removed.move_torrent");
                dest.setString("torrent_path", "File.move.download.removed.move_torrent_path");
            } else {
                dest.setBoolean("torrent", false);
            }
            TransferSpecification trans = new TransferSpecification();
            MovementInformation mi = new MovementInformation(source, dest, trans, mi_str);
            return mi;
        }
        return def_mi;
    }

    private static String normaliseRelativePathPart(String name) {
        if ((name = name.trim()).length() == 0) {
            return "";
        }
        if (name.equals(".") || name.equals("..")) {
            return null;
        }
        return FileUtil.convertOSSpecificChars(name, false).trim();
    }

    public static File normaliseRelativePath(File path) {
        if (path.isAbsolute()) {
            return null;
        }
        File parent = path.getParentFile();
        String child_name = DownloadManagerDefaultPaths.normaliseRelativePathPart(path.getName());
        if (child_name == null) {
            return null;
        }
        if (parent == null) {
            return FileUtil.newFile(child_name, new String[0]);
        }
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(child_name);
        String filepart = null;
        while (parent != null) {
            filepart = DownloadManagerDefaultPaths.normaliseRelativePathPart(parent.getName());
            if (filepart == null) {
                return null;
            }
            if (filepart.length() != 0) {
                parts.add(0, filepart);
            }
            parent = parent.getParentFile();
        }
        StringBuilder sb = new StringBuilder((String)parts.get(0));
        int i = 1;
        while (i < parts.size()) {
            sb.append(File.separatorChar);
            sb.append(parts.get(i));
            ++i;
        }
        return FileUtil.newFile(sb.toString(), new String[0]);
    }

    static File[] getDefaultDirs() {
        ArrayList<File> results = new ArrayList<File>();
        Object location = null;
        TargetSpecification ts = null;
        int i = 0;
        while (i < DEFAULT_DIRS.length) {
            ts = DEFAULT_DIRS[i];
            File[] targets = ts.getTargets(null, ts, 0);
            if (targets[0] != null) {
                results.add(targets[0]);
            }
            ++i;
        }
        return results.toArray(new File[results.size()]);
    }

    static SaveLocationChange determinePaths(DownloadManager dm, MovementInformation mi, boolean check_source, int reason) {
        boolean proceed;
        boolean bl = proceed = !check_source || mi.source.matchesDownload(dm, mi);
        if (!proceed) {
            DownloadManagerDefaultPaths.logInfo("Cannot consider " + DownloadManagerDefaultPaths.describe(dm, mi) + " - does not match source criteria.", dm);
            return null;
        }
        File[] target_paths = mi.target.getTargets(dm, mi, reason);
        if (target_paths[0] == null && target_paths[1] == null) {
            DownloadManagerDefaultPaths.logInfo("Unable to determine an appropriate target for " + DownloadManagerDefaultPaths.describe(dm, mi) + ".", dm);
            return null;
        }
        DownloadManagerDefaultPaths.logInfo("Determined path for " + DownloadManagerDefaultPaths.describe(dm, mi) + " - " + target_paths[0] + ";" + target_paths[1] + ", reason=" + reason + ".", dm);
        return mi.transfer.getTransferDetails(dm, mi, target_paths);
    }

    static boolean isInDefaultDownloadDir(DownloadManager dm) {
        SourceSpecification source = new SourceSpecification();
        source.setBoolean("default subdir", SUBDIR_PARAM);
        return source.checkDefaultDir(dm.getSaveLocation().getParentFile(), DownloadManagerDefaultPaths.getDefaultDirs());
    }

    static String describe(DownloadManager dm, ContextDescriptor cs) {
        if (cs == null) {
            return DownloadManagerDefaultPaths.describe(dm);
        }
        if (dm == null) {
            return "\"" + cs.getContext() + "\"";
        }
        return "\"" + dm.getDisplayName() + "\" with regard to \"" + cs.getContext() + "\"";
    }

    private static interface ContextDescriptor {
        public String getContext();
    }

    private static class MovementInformation
    implements ContextDescriptor {
        final SourceSpecification source;
        final TargetSpecification target;
        final TransferSpecification transfer;
        final String title;

        MovementInformation(SourceSpecification source, TargetSpecification target, TransferSpecification transfer, String title) {
            this.source = source;
            this.target = target;
            this.transfer = transfer;
            this.title = title;
        }

        @Override
        public String getContext() {
            return this.title;
        }
    }

    private static abstract class ParameterHelper
    implements ContextDescriptor {
        private final Map settings = new HashMap();
        private String context = null;

        private ParameterHelper() {
        }

        protected boolean getBoolean(String key, boolean def) {
            Object result = this.settings.get(key);
            if (result == null) {
                return def;
            }
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            return COConfigurationManager.getBooleanParameter((String)result);
        }

        protected void setBoolean(String key, boolean value) {
            this.settings.put(key, value);
        }

        protected void setBoolean(String key, String param) {
            this.settings.put(key, param);
        }

        protected void setString(String key, String param) {
            this.settings.put(key, param);
        }

        protected String getStringRaw(String key) {
            return (String)this.settings.get(key);
        }

        protected String getString(String key, String def) {
            String result = (String)this.settings.get(key);
            if (result == null) {
                return def;
            }
            return COConfigurationManager.getStringParameter(result);
        }

        public Map getSettings() {
            return this.settings;
        }

        public void updateSettings(Map settings) {
            this.settings.putAll(settings);
        }

        @Override
        public String getContext() {
            return this.context;
        }

        public void setContext(String context2) {
            this.context = context2;
        }
    }

    private static class SourceSpecification
    extends ParameterHelper {
        private SourceSpecification() {
        }

        public boolean matchesDownload(DownloadManager dm, ContextDescriptor context2) {
            if (this.getBoolean("default dir", false)) {
                DownloadManagerDefaultPaths.logInfo("Checking if " + DownloadManagerDefaultPaths.describe(dm, context2) + " is inside default dirs.", dm);
                File[] default_dirs = DownloadManagerDefaultPaths.getDefaultDirs();
                File current_location = dm.getSaveLocation().getParentFile();
                if (current_location == null) {
                    DownloadManagerDefaultPaths.logWarn(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " appears to have a malformed save directory, skipping.", dm);
                    return false;
                }
                if (!this.checkDefaultDir(current_location, default_dirs)) {
                    DownloadManagerDefaultPaths.logWarn(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " doesn't exist in any of the following default directories" + " (current dir: " + current_location + ", subdirectories checked: " + this.getBoolean("default subdir", false) + ") - " + Arrays.asList(default_dirs), dm);
                    return false;
                }
                DownloadManagerDefaultPaths.logInfo(String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " does exist inside default dirs.", dm);
            }
            if (!dm.isDownloadComplete(false)) {
                boolean can_move = this.getBoolean("incomplete dl", false);
                String log_message = String.valueOf(DownloadManagerDefaultPaths.describe(dm, context2)) + " is incomplete which is " + (can_move ? "" : "not ") + "an appropriate state.";
                if (!can_move) {
                    DownloadManagerDefaultPaths.logInfo(log_message, dm);
                    return false;
                }
            }
            return true;
        }

        public boolean checkDefaultDir(File location, File[] default_dirs) {
            location = FileUtil.getCanonicalFile(location);
            boolean subdir = this.getBoolean("default subdir", false);
            int i = 0;
            while (i < default_dirs.length) {
                if (subdir ? FileUtil.isAncestorOf(default_dirs[i], location) : default_dirs[i].equals(location)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class TargetSpecification
    extends ParameterHelper {
        private TargetSpecification() {
        }

        public File[] getTargets(DownloadManager dm, ContextDescriptor cd, int reason) {
            File[] targets = this.getTargetsSupport(dm, cd);
            if (dm != null && (reason == 2 || reason == 3) && COConfigurationManager.getBooleanParameter("File.move.add.sub.dir")) {
                File data_dir;
                String name = dm.getDisplayName();
                if (!(name = FileUtil.convertOSSpecificChars(name, true)).isEmpty() && (data_dir = targets[0]) != null) {
                    targets[0] = new File(data_dir, name);
                    File torrent_dir = targets[1];
                    if (torrent_dir != null && torrent_dir.equals(data_dir)) {
                        targets[1] = new File(torrent_dir, name);
                    }
                }
            }
            return targets;
        }

        public File[] getTargetsSupport(DownloadManager dm, ContextDescriptor cd) {
            File torrent_target;
            File data_target;
            String location;
            boolean data_enabled = this.getBoolean("enabled", false);
            if (!data_enabled) {
                DownloadManagerDefaultPaths.logInfo("Data target for " + DownloadManagerDefaultPaths.describe(dm, cd) + " is not enabled.", dm);
            }
            if ((location = this.getStringRaw("target_raw")) == null && (location = this.getString("target", null)) != null) {
                location = location.trim();
            }
            if (location == null || location.length() == 0) {
                DownloadManagerDefaultPaths.logInfo("No explicit data target for " + DownloadManagerDefaultPaths.describe(dm, cd) + ".", dm);
                data_target = null;
            } else {
                data_target = FileUtil.newFile(FileUtil.getCanonicalFileName(location), new String[0]);
                String relative_path = null;
                if (dm != null && dm.getDownloadState() != null) {
                    relative_path = dm.getDownloadState().getRelativeSavePath();
                }
                if (relative_path != null && relative_path.length() > 0) {
                    DownloadManagerDefaultPaths.logInfo("Consider relative save path: " + relative_path, dm);
                    data_target = FileUtil.newFile(data_target.getPath(), relative_path);
                }
            }
            boolean torrent_enabled = this.getBoolean("torrent", false);
            if (!torrent_enabled) {
                torrent_target = null;
            } else {
                torrent_target = data_target;
                String torrent_path = this.getStringRaw("torrent_path_raw");
                if (torrent_path == null) {
                    torrent_path = this.getString("torrent_path", null);
                }
                if (torrent_path != null && torrent_path.trim().length() > 0) {
                    File temp = FileUtil.newFile(torrent_path, new String[0]);
                    if (temp.isDirectory()) {
                        torrent_target = temp;
                    } else if (!FileUtil.exists(temp) && temp.mkdirs()) {
                        torrent_target = temp;
                    }
                }
            }
            return new File[]{data_enabled ? data_target : null, torrent_enabled ? torrent_target : null};
        }
    }

    private static class TransferSpecification {
        private TransferSpecification() {
        }

        public SaveLocationChange getTransferDetails(DownloadManager dm, ContextDescriptor cd, File[] target_paths) {
            SaveLocationChange result = new SaveLocationChange();
            File data_target = target_paths[0];
            File torrent_target = target_paths[1];
            if (data_target != null) {
                result.download_location = data_target;
            }
            if (torrent_target != null) {
                result.torrent_location = torrent_target;
            }
            return result;
        }
    }
}

