/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.global.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationListener;
import com.biglybt.core.CoreOperationTask;
import com.biglybt.core.category.Category;
import com.biglybt.core.category.CategoryManager;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.TransferSpeedValidator;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerFactory;
import com.biglybt.core.download.DownloadManagerInitialisationAdapter;
import com.biglybt.core.download.DownloadManagerListener;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.download.DownloadManagerStats;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.global.GlobalManagerDownloadRemovalVetoException;
import com.biglybt.core.global.GlobalManagerDownloadWillBeRemovedListener;
import com.biglybt.core.global.GlobalManagerEvent;
import com.biglybt.core.global.GlobalManagerEventListener;
import com.biglybt.core.global.GlobalManagerListener;
import com.biglybt.core.global.GlobalManagerStats;
import com.biglybt.core.global.GlobalMangerProgressListener;
import com.biglybt.core.global.impl.GlobalManagerFileMerger;
import com.biglybt.core.global.impl.GlobalManagerHostSupport;
import com.biglybt.core.global.impl.GlobalManagerStatsImpl;
import com.biglybt.core.global.impl.GlobalManagerStatsWriter;
import com.biglybt.core.helpers.TorrentFolderWatcher;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.util.PeerUtils;
import com.biglybt.core.peermanager.control.PeerControlSchedulerFactory;
import com.biglybt.core.speedmanager.SpeedManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.tag.TaggableLifecycleHandler;
import com.biglybt.core.tag.TaggableResolver;
import com.biglybt.core.tag.impl.TagDownloadWithState;
import com.biglybt.core.tag.impl.TagTypeBase;
import com.biglybt.core.tag.impl.TagTypeWithState;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.tracker.AllTrackersManager;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.tracker.client.TRTrackerScraper;
import com.biglybt.core.tracker.client.TRTrackerScraperClientResolver;
import com.biglybt.core.tracker.client.TRTrackerScraperFactory;
import com.biglybt.core.tracker.client.TRTrackerScraperListener;
import com.biglybt.core.tracker.client.TRTrackerScraperResponse;
import com.biglybt.core.tracker.util.TRTrackerUtils;
import com.biglybt.core.tracker.util.TRTrackerUtilsListener;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DataSourceResolver;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.ListenerManagerDispatcherWithException;
import com.biglybt.core.util.NonDaemonTask;
import com.biglybt.core.util.NonDaemonTaskRunner;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemProperties;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.pif.dht.mainline.MainlineDHTProvider;
import com.biglybt.util.MapUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalManagerImpl
extends DownloadManagerAdapter
implements GlobalManager,
AEDiagnosticsEvidenceGenerator {
    static final LogIDs LOGID = LogIDs.CORE;
    private static final int LDT_MANAGER_ADDED = 1;
    private static final int LDT_MANAGER_REMOVED = 2;
    private static final int LDT_DESTROY_INITIATED = 3;
    private static final int LDT_DESTROYED = 4;
    private static final int LDT_SEEDING_ONLY = 5;
    private static final int LDT_EVENT = 6;
    private final ListenerManager<Object> listeners_and_event_listeners = ListenerManager.createAsyncManager("GM:ListenDispatcher", new ListenerManagerDispatcher<Object>(){

        @Override
        public void dispatch(Object _listener, int type, Object value) {
            if (type == 6) {
                if (_listener instanceof GlobalManagerEventListener) {
                    ((GlobalManagerEventListener)_listener).eventOccurred((GlobalManagerEvent)value);
                }
            } else if (_listener instanceof GlobalManagerListener) {
                GlobalManagerListener target = (GlobalManagerListener)_listener;
                if (type == 1) {
                    target.downloadManagerAdded((DownloadManager)value);
                } else if (type == 2) {
                    target.downloadManagerRemoved((DownloadManager)value);
                } else if (type == 3) {
                    GlobalMangerProgressListener progress = (GlobalMangerProgressListener)value;
                    target.destroyInitiated(progress);
                } else if (type == 4) {
                    target.destroyed();
                } else if (type == 5) {
                    boolean[] temp = (boolean[])value;
                    target.seedingStatusChanged(temp[0], temp[1]);
                }
            }
        }
    });
    private static final int LDT_MANAGER_WBR = 1;
    private final ListenerManager<GlobalManagerDownloadWillBeRemovedListener> removal_listeners = ListenerManager.createManager("GM:DLWBRMListenDispatcher", new ListenerManagerDispatcherWithException<GlobalManagerDownloadWillBeRemovedListener>(){

        @Override
        public void dispatchWithException(GlobalManagerDownloadWillBeRemovedListener target, int type, Object value) throws GlobalManagerDownloadRemovalVetoException {
            DownloadManager dm = (DownloadManager)((Object[])value)[0];
            boolean remove_torrent = (Boolean)((Object[])value)[1];
            boolean remove_data = (Boolean)((Object[])value)[2];
            target.downloadWillBeRemoved(dm, remove_torrent, remove_data);
        }
    });
    static boolean enable_stopped_scrapes;
    static boolean disable_never_started_scrapes;
    static int no_space_dl_restart_check_period_millis;
    static long no_space_dl_pause_min_bytes;
    static int missing_file_dl_restart_check_period_millis;
    static final Object missing_file_dl_restart_key;
    static final Object ACTIVE_KEY;
    private Object create_dm_lock = new Object();
    private Object managers_lock = new Object();
    private volatile DownloadManager[] managers_list_cow = new DownloadManager[0];
    final Map<HashWrapper, DownloadManager> manager_hash_map = new ConcurrentHashMap<HashWrapper, DownloadManager>();
    final Map<DownloadManager, DownloadManager> manager_id_set = new HashMap<DownloadManager, DownloadManager>();
    private final GlobalMangerProgressListener progress_listener;
    private long lastListenerUpdate;
    private final Checker checker;
    private final GlobalManagerStatsImpl stats;
    private long last_swarm_stats_calc_time = 0L;
    private long last_swarm_stats = 0L;
    private final boolean cripple_downloads_config;
    private final TRTrackerScraper trackerScraper;
    private GlobalManagerStatsWriter stats_writer;
    private GlobalManagerHostSupport host_support;
    private Object download_history_manager;
    private final Map<HashWrapper, Map> saved_download_manager_state = new HashMap<HashWrapper, Map>();
    private final Map<HashWrapper, Boolean> paused_list_initial = new HashMap<HashWrapper, Boolean>();
    private Map<TaggableResolver.LifecycleControlListener, GlobalManagerDownloadWillBeRemovedListener> lcl_map = new HashMap<TaggableResolver.LifecycleControlListener, GlobalManagerDownloadWillBeRemovedListener>();
    private int next_seed_piece_recheck_index;
    private final TorrentFolderWatcher torrent_folder_watcher;
    private final Map<HashWrapper, Boolean> paused_list = new HashMap<HashWrapper, Boolean>();
    private final AEMonitor paused_list_mon = new AEMonitor("GlobalManager:PL");
    private final GlobalManagerFileMerger file_merger;
    private volatile boolean isStopping;
    private volatile boolean destroyed;
    volatile long needsSavingCozStateChanged;
    private boolean seeding_only_mode = false;
    private boolean potentially_seeding_only_mode = false;
    private final AllTrackersManager.AllTrackers all_trackers = AllTrackersManager.getAllTrackers();
    private long all_trackers_options_mut = this.all_trackers.getOptionsMutationCount();
    private final FrequencyLimitedDispatcher check_seeding_only_state_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            GlobalManagerImpl.this.checkSeedingOnlyStateSupport();
        }
    }, 5000);
    private boolean force_start_non_seed_exists;
    private int nat_status = 0;
    private String nat_info_prefix;
    private String nat_info;
    private long nat_status_last_good = -1L;
    private boolean nat_status_probably_ok;
    private final CopyOnWriteList<DownloadManagerInitialisationAdapter> dm_adapters = new CopyOnWriteList();
    DelayedEvent loadTorrentsDelay = null;
    boolean loadingComplete = false;
    final AESemaphore loadingSem = new AESemaphore("Loading Torrents");
    private MainlineDHTProvider provider = null;
    private boolean auto_resume_on_start = COConfigurationManager.getBooleanParameter("Resume Downloads On Start");
    private TimerEvent auto_resume_timer;
    private boolean auto_resume_disabled = COConfigurationManager.getBooleanParameter("Pause Downloads On Exit") && !this.auto_resume_on_start;
    private final TaggableLifecycleHandler taggable_life_manager = TagManagerFactory.getTagManager().registerTaggableResolver(this);
    private DownloadStateTagger ds_tagger;
    private static final Object MOVE_POS_KEY;

    static {
        missing_file_dl_restart_key = new Object();
        ACTIVE_KEY = new Object();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Tracker Client Scrape Stopped Enable", "Tracker Client Scrape Never Started Disable", "Insufficient Space Download Restart Enable", "Insufficient Space Download Restart Period", "Missing File Download Restart Enable", "Missing File Download Restart Period"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                enable_stopped_scrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Stopped Enable");
                disable_never_started_scrapes = COConfigurationManager.getBooleanParameter("Tracker Client Scrape Never Started Disable");
                boolean enable_no_space_dl_restarts = COConfigurationManager.getBooleanParameter("Insufficient Space Download Restart Enable");
                if (enable_no_space_dl_restarts) {
                    int mins = COConfigurationManager.getIntParameter("Insufficient Space Download Restart Period");
                    no_space_dl_restart_check_period_millis = Math.max(1, mins) * 60 * 1000;
                } else {
                    no_space_dl_restart_check_period_millis = 0;
                }
                boolean enable_missing_file_dl_restarts = COConfigurationManager.getBooleanParameter("Missing File Download Restart Enable");
                if (enable_missing_file_dl_restarts) {
                    int mins = COConfigurationManager.getIntParameter("Missing File Download Restart Period");
                    missing_file_dl_restart_check_period_millis = Math.max(1, mins) * 60 * 1000;
                } else {
                    missing_file_dl_restart_check_period_millis = 0;
                }
            }
        });
        MOVE_POS_KEY = new Object();
    }

    public GlobalManagerImpl(Core core, GlobalMangerProgressListener listener) {
        this.progress_listener = listener;
        this.cripple_downloads_config = "1".equals(System.getProperty(SystemProperties.SYSPROP_DISABLEDOWNLOADS));
        AEDiagnostics.addWeakEvidenceGenerator(this);
        DataSourceResolver.registerExporter(this);
        PeerUtils.initialise();
        this.stats = new GlobalManagerStatsImpl(this);
        try {
            this.stats_writer = new GlobalManagerStatsWriter(core, this.stats);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Stats unavailable", e));
        }
        try {
            try {
                Class<?> impl_class = GlobalManagerImpl.class.getClassLoader().loadClass("com.biglybt.core.history.impl.DownloadHistoryManagerImpl");
                this.download_history_manager = impl_class.newInstance();
            }
            catch (ClassNotFoundException impl_class) {}
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Download History unavailable", e));
        }
        try {
            if (TagManagerFactory.getTagManager().isEnabled()) {
                this.ds_tagger = new DownloadStateTagger(core);
            }
            this.loadDownloads();
        }
        finally {
            if (this.ds_tagger != null) {
                this.ds_tagger.initialise();
            }
            this.taggable_life_manager.initialized(this.getResolvedTaggables());
        }
        if (this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.initializeGM"));
        }
        this.trackerScraper = TRTrackerScraperFactory.getSingleton();
        this.trackerScraper.setClientResolver(new TRTrackerScraperClientResolver(){

            @Override
            public boolean isScrapable(HashWrapper torrent_hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(torrent_hash);
                if (dm == null) {
                    return false;
                }
                int dm_state = dm.getState();
                if (dm_state == 75) {
                    return true;
                }
                if (dm_state == 50 || dm_state == 60) {
                    return true;
                }
                if (!enable_stopped_scrapes) {
                    return false;
                }
                DownloadManagerStats stats2 = dm.getStats();
                return stats2.getTotalDataBytesReceived() != 0L || stats2.getPercentDoneExcludingDND() != 0 || !disable_never_started_scrapes;
            }

            @Override
            public boolean isNetworkEnabled(HashWrapper hash, URL url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return false;
                }
                String nw = AENetworkClassifier.categoriseAddress(url.getHost());
                String[] networks = dm.getDownloadState().getNetworks();
                int i = 0;
                while (i < networks.length) {
                    if (networks[i] == nw) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public String[] getEnabledNetworks(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                return dm.getDownloadState().getNetworks();
            }

            @Override
            public int[] getCachedScrape(HashWrapper hash) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    return null;
                }
                long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                if (cache == -1L) {
                    return null;
                }
                int cache_src = dm.getDownloadState().getIntAttribute("scsrc");
                if (cache_src == 0) {
                    int seeds = (int)(cache >> 32 & 0xFFFFFFL);
                    int leechers = (int)(cache & 0xFFFFFFL);
                    return new int[]{seeds, leechers};
                }
                return null;
            }

            @Override
            public Object[] getExtensions(HashWrapper hash) {
                Character state;
                String ext;
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null) {
                    ext = "";
                    state = TRTrackerScraperClientResolver.FL_NONE;
                } else {
                    ext = dm.getDownloadState().getTrackerClientExtensions();
                    if (ext == null) {
                        ext = "";
                    }
                    boolean comp2 = dm.isDownloadComplete(false);
                    int dm_state = dm.getState();
                    state = dm_state == 100 || dm_state == 70 || dm_state == 65 && dm.getSubState() != 75 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_STOPPED : TRTrackerScraperClientResolver.FL_INCOMPLETE_STOPPED) : (dm_state == 50 || dm_state == 60 ? (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_RUNNING : TRTrackerScraperClientResolver.FL_INCOMPLETE_RUNNING) : (comp2 ? TRTrackerScraperClientResolver.FL_COMPLETE_QUEUED : TRTrackerScraperClientResolver.FL_INCOMPLETE_QUEUED));
                }
                return new Object[]{ext, state};
            }

            @Override
            public boolean redirectTrackerUrl(HashWrapper hash, URL old_url, URL new_url) {
                DownloadManager dm = GlobalManagerImpl.this.getDownloadManager(hash);
                if (dm == null || dm.getTorrent() == null) {
                    return false;
                }
                return TorrentUtils.replaceAnnounceURL(dm.getTorrent(), old_url, new_url);
            }
        });
        this.trackerScraper.addListener(new TRTrackerScraperListener(){

            @Override
            public void scrapeReceived(TRTrackerScraperResponse response) {
                HashWrapper hash = response.getHash();
                DownloadManager manager = GlobalManagerImpl.this.manager_hash_map.get(hash);
                if (manager != null) {
                    manager.setTrackerScrapeResponse(response);
                }
            }
        });
        try {
            this.host_support = new GlobalManagerHostSupport(this);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LOGID, "Hosting unavailable", e));
        }
        this.checker = new Checker();
        this.checker.start();
        this.torrent_folder_watcher = new TorrentFolderWatcher(this);
        this.torrent_folder_watcher.start();
        TRTrackerUtils.addListener(new TRTrackerUtilsListener(){

            @Override
            public void announceDetailsChanged() {
                DownloadManager[] managers;
                Logger.log(new LogEvent(LOGID, "Announce details have changed, updating trackers"));
                DownloadManager[] downloadManagerArray = managers = GlobalManagerImpl.this.managers_list_cow;
                int n = managers.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager manager = downloadManagerArray[n2];
                    manager.requestTrackerAnnounce(true);
                    ++n2;
                }
            }
        });
        TorrentUtils.addTorrentURLChangeListener(new TorrentUtils.TorrentAnnounceURLChangeListener(){

            @Override
            public void changed() {
                DownloadManager[] managers;
                Logger.log(new LogEvent(LOGID, "Announce URL details have changed, updating trackers"));
                DownloadManager[] downloadManagerArray = managers = GlobalManagerImpl.this.managers_list_cow;
                int n = managers.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager manager = downloadManagerArray[n2];
                    TRTrackerAnnouncer client = manager.getTrackerClient();
                    if (client != null) {
                        client.resetTrackerUrl(false);
                    }
                    ++n2;
                }
            }
        });
        this.file_merger = new GlobalManagerFileMerger(this);
        COConfigurationManager.addParameterListener("Set File Priority Remaining Pieces", n -> {
            DownloadManager[] downloadManagerArray = this.managers_list_cow;
            int n2 = this.managers_list_cow.length;
            int n3 = 0;
            while (n3 < n2) {
                DownloadManager dm = downloadManagerArray[n3];
                try {
                    dm.syncGlobalConfig();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                ++n3;
            }
        });
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, String savePath) {
        return this.addDownloadManager(fileName, null, savePath, 0, true);
    }

    @Override
    public DownloadManager addDownloadManager(String fileName, byte[] optionalHash, String savePath, int initialState, boolean persistent) {
        return this.addDownloadManager(fileName, optionalHash, savePath, initialState, persistent, false, null);
    }

    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        return this.addDownloadManager(torrent_file_name, optionalHash, savePath, null, initialState, persistent, for_seeding, _adapter);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public DownloadManager addDownloadManager(String torrent_file_name, byte[] optionalHash, String savePath, String saveFile, int initialState, boolean persistent, boolean for_seeding, DownloadManagerInitialisationAdapter _adapter) {
        block55: {
            block53: {
                block51: {
                    block52: {
                        needsFixup = false;
                        this.loadingSem.reserve(60000L);
                        adapter = this.getDMAdapter(_adapter);
                        file_priorities = null;
                        if (!persistent) {
                            hw = new HashWrapper(optionalHash);
                            save_download_state = this.saved_download_manager_state.get(hw);
                            if (save_download_state != null) {
                                if (save_download_state.containsKey("state") && (saved_state = ((Long)save_download_state.get("state")).intValue()) == 70) {
                                    initialState = saved_state;
                                }
                                file_priorities = (List)save_download_state.get("file_priorities");
                                lPosition = (Long)save_download_state.get("position");
                                if (lPosition != null && lPosition != -1L) {
                                    needsFixup = true;
                                }
                            }
                            try {
                                this.paused_list_mon.enter();
                                force = this.paused_list_initial.remove(hw);
                                if (force != null) {
                                    if (this.auto_resume_on_start) {
                                        if (initialState == 70) {
                                            initialState = 75;
                                        }
                                        if (save_download_state != null) {
                                            save_download_state.put("forceStart", new Long(force != false ? 1 : 0));
                                        }
                                    } else {
                                        this.paused_list.put(hw, force);
                                    }
                                }
                            }
                            finally {
                                this.paused_list_mon.exit();
                            }
                        }
                        torrentDir = null;
                        fDest = null;
                        hash = null;
                        deleteDest = false;
                        deleteDestExistingDM = null;
                        thisIsMagnet = false;
                        f = FileUtil.newFile(torrent_file_name, new String[0]);
                        if (!f.exists()) {
                            throw new IOException("Torrent file '" + torrent_file_name + "' doesn't exist");
                        }
                        if (!f.isFile()) {
                            throw new IOException("Torrent '" + torrent_file_name + "' is not a file");
                        }
                        fDest = TorrentUtils.copyTorrentFileToSaveDir(f, persistent);
                        fName = fDest.getCanonicalPath();
                        torrentHash = null;
                        try {
                            torrent = TorrentUtils.readFromFile(fDest, false);
                            thisIsMagnet = TorrentUtils.getFlag(torrent, 2);
                            torrentHash = torrent.getHashWrapper();
                        }
                        catch (Throwable torrent) {
                            // empty catch block
                        }
                        hash = optionalHash != null ? new HashWrapper(optionalHash) : torrentHash;
                        if (hash == null) ** GOTO lbl85
                        existingDM = this.getDownloadManager(hash);
                        if (existingDM == null) break block51;
                        existingIsMagnet = existingDM.getDownloadState().getFlag(512L);
                        FileUtil.log("addDownload: " + ByteFormatter.encodeString(hash.getBytes()) + ": isMagnet=" + thisIsMagnet + ", existingIsMagnet=" + existingIsMagnet);
                        if (thisIsMagnet != existingIsMagnet && (!thisIsMagnet || existingIsMagnet)) ** GOTO lbl85
                        deleteDest = true;
                        deleteDestExistingDM = existingDM;
                        var26_30 = existingDM;
                        if (!deleteDest) break block52;
                        try {
                            v0 = skip = deleteDestExistingDM != null && FileUtil.newFile(deleteDestExistingDM.getTorrentFileName(), new String[0]).equals(fDest) == false;
                            if (!skip) {
                                fDest.delete();
                                backupFile = FileUtil.newFile(String.valueOf(fDest.getCanonicalPath()) + ".bak", new String[0]);
                                if (backupFile.exists()) {
                                    backupFile.delete();
                                }
                            }
                        }
                        catch (Throwable skip) {
                            // empty catch block
                        }
                    }
                    return var26_30;
                }
                try {
                    FileUtil.log("addDownload: " + ByteFormatter.encodeString(hash.getBytes()) + ": isMagnet=" + thisIsMagnet);
lbl85:
                    // 3 sources

                    moc = null;
                    if (persistent && !for_seeding && COConfigurationManager.getBooleanParameter("file.use.temp.path.and.move.enable") && !(path = COConfigurationManager.getStringParameter("file.use.temp.path.and.move.path", "")).isEmpty()) {
                        temp = FileUtil.newFile(path, new String[0]);
                        if (!temp.isDirectory()) {
                            temp.mkdirs();
                        }
                        if (temp.isDirectory()) {
                            FileUtil.log("addDownload: temporary save path '" + path + "' substituted for '" + savePath + "'");
                            moc = FileUtil.newFile(savePath, new String[0]);
                            savePath = temp.getAbsolutePath();
                        }
                    }
                    if ((manager = this.createAndAddNewDownloadManager(optionalHash, fName, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter, thisIsMagnet, is_existing = new boolean[1])) == null || is_existing[0]) {
                        deleteDest = true;
                        deleteDestExistingDM = manager;
                        break block53;
                    }
                    if (moc != null) {
                        dms = manager.getDownloadState();
                        dms.setAttribute("moc.dir", moc.getAbsolutePath());
                    }
                    if (initialState == 70 && COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped Auto Pause")) {
                        try {
                            this.paused_list_mon.enter();
                            this.paused_list.put(manager.getTorrent().getHashWrapper(), false);
                        }
                        finally {
                            this.paused_list_mon.exit();
                        }
                    }
                    if (!TorrentUtils.shouldDeleteTorrentFileAfterAdd(fDest, persistent)) break block53;
                    deleteDest = true;
                }
                catch (IOException e) {
                    System.err.println("DownloadManager::addDownloadManager: fails - td = " + torrentDir + ", fd = " + fDest + ": " + Debug.getNestedExceptionMessage(e));
                    System.err.println(Debug.getCompressedStackTrace());
                    manager = this.createAndAddNewDownloadManager(optionalHash, torrent_file_name, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter, thisIsMagnet, new boolean[1]);
                    if (!deleteDest) ** GOTO lbl177
                    try {
                        v1 = skip = deleteDestExistingDM != null && FileUtil.newFile(deleteDestExistingDM.getTorrentFileName(), new String[0]).equals(fDest) == false;
                        if (skip) ** GOTO lbl177
                        fDest.delete();
                        backupFile = FileUtil.newFile(String.valueOf(fDest.getCanonicalPath()) + ".bak", new String[0]);
                        if (!backupFile.exists()) ** GOTO lbl177
                        backupFile.delete();
                    }
                    catch (Throwable skip) {}
                }
                catch (Exception e) {
                    try {
                        manager = this.createAndAddNewDownloadManager(optionalHash, torrent_file_name, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, adapter, thisIsMagnet, new boolean[1]);
                        if (!deleteDest) ** GOTO lbl177
                    }
                    catch (Throwable var25_49) {
                        if (deleteDest) {
                            try {
                                v2 = skip = deleteDestExistingDM != null && FileUtil.newFile(deleteDestExistingDM.getTorrentFileName(), new String[0]).equals(fDest) == false;
                                if (!skip) {
                                    fDest.delete();
                                    backupFile = FileUtil.newFile(String.valueOf(fDest.getCanonicalPath()) + ".bak", new String[0]);
                                    if (backupFile.exists()) {
                                        backupFile.delete();
                                    }
                                }
                            }
                            catch (Throwable skip) {
                                // empty catch block
                            }
                        }
                        throw var25_49;
                    }
                    try {
                        v3 = skip = deleteDestExistingDM != null && FileUtil.newFile(deleteDestExistingDM.getTorrentFileName(), new String[0]).equals(fDest) == false;
                        if (skip) ** GOTO lbl177
                        fDest.delete();
                        backupFile = FileUtil.newFile(String.valueOf(fDest.getCanonicalPath()) + ".bak", new String[0]);
                        if (!backupFile.exists()) ** GOTO lbl177
                        backupFile.delete();
                    }
                    catch (Throwable skip) {}
                }
            }
            if (!deleteDest) break block55;
            try {
                v4 = skip = deleteDestExistingDM != null && FileUtil.newFile(deleteDestExistingDM.getTorrentFileName(), new String[0]).equals(fDest) == false;
                if (!skip) {
                    fDest.delete();
                    backupFile = FileUtil.newFile(String.valueOf(fDest.getCanonicalPath()) + ".bak", new String[0]);
                    if (backupFile.exists()) {
                        backupFile.delete();
                    }
                }
            }
            catch (Throwable var27_40) {
                // empty catch block
            }
        }
        if (needsFixup && manager != null && manager.getPosition() <= this.downloadManagerCount(manager.isDownloadComplete(false))) {
            this.fixUpDownloadManagerPositions();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadManager createAndAddNewDownloadManager(byte[] torrent_hash, String torrentFileName, String savePath, String saveFile, int initialState, boolean persistent, boolean for_seeding, List file_priorities, DownloadManagerInitialisationAdapter adapter, boolean thisIsMagnet, boolean[] is_existing) {
        Object object = this.create_dm_lock;
        synchronized (object) {
            DownloadManager manager = this.createNewDownloadManager(torrent_hash, torrentFileName, savePath, saveFile, initialState, persistent, for_seeding, file_priorities, thisIsMagnet, is_existing);
            if (!is_existing[0]) {
                manager = this.addDownloadManager(manager, true, adapter, for_seeding, is_existing, false);
            }
            return manager;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadManager createNewDownloadManager(byte[] torrent_hash, String torrentFileName, String savePath, String saveFile, int initialState, boolean persistent, boolean for_seeding, List file_priorities, boolean thisIsMagnet, boolean[] is_existing) {
        FileUtil.log("createNewDownload: starts for " + ByteFormatter.encodeString(torrent_hash) + ", " + torrentFileName + "," + savePath + ", " + saveFile);
        int loop = 0;
        boolean debug_on = false;
        try {
            while (true) {
                ++loop;
                DownloadManager new_manager = DownloadManagerFactory.create(this, torrent_hash, torrentFileName, savePath, saveFile, initialState, persistent, false, for_seeding, false, file_priorities);
                if (thisIsMagnet || torrent_hash == null) {
                    FileUtil.log("createNewDownload: " + ByteFormatter.encodeString(torrent_hash) + ": isMagnet=true");
                    DownloadManager downloadManager = new_manager;
                    return downloadManager;
                }
                boolean newIsMagnet = new_manager.getDownloadState().getFlag(512L);
                if (!newIsMagnet) {
                    FileUtil.log("createNewDownload: " + ByteFormatter.encodeString(torrent_hash) + ": isMagnet=false, newIsMagnet=false");
                    DownloadManager downloadManager = new_manager;
                    return downloadManager;
                }
                if (loop > 10) {
                    DownloadManager downloadManager = new_manager;
                    return downloadManager;
                }
                DownloadManager existing = this.getDownloadManager(new HashWrapper(torrent_hash));
                if (existing != null) {
                    boolean existingIsMagnet = existing.getDownloadState().getFlag(512L);
                    FileUtil.log("createNewDownload: " + ByteFormatter.encodeString(torrent_hash) + ": isMagnet=false, newIsMagnet=true, existingIsMagnet=" + existingIsMagnet);
                    if (!existingIsMagnet) {
                        is_existing[0] = true;
                        DownloadManager downloadManager = existing;
                        return downloadManager;
                    }
                    try {
                        this.removeDownloadManager(existing, true, true);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                } else {
                    try {
                        DownloadManagerStateFactory.deleteDownloadState(torrent_hash, true);
                    }
                    catch (Throwable e) {
                        FileUtil.log("createNewDownload: failed to delete existing state", e);
                    }
                    if (!debug_on) {
                        debug_on = true;
                        DownloadManagerStateFactory.setDebugOn(true);
                        try {
                            FileUtil.copyFile(new File(torrentFileName), FileUtil.getUserFile(String.valueOf(ByteFormatter.encodeString(torrent_hash)) + ".log"));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    FileUtil.log("createNewDownload: " + ByteFormatter.encodeString(torrent_hash) + ": isMagnet=false, newIsMagnet=true, existing=null");
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            if (debug_on) {
                DownloadManagerStateFactory.setDebugOn(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadManager addDownloadManager(DownloadManager download_manager, boolean notifyListeners, DownloadManagerInitialisationAdapter adapter, boolean for_seeding, boolean[] is_existing, boolean initial_load) {
        if (!this.isStopping) {
            Object object = this.managers_lock;
            synchronized (object) {
                DownloadManager existing = this.manager_id_set.get(download_manager);
                if (existing != null) {
                    download_manager.destroy(true);
                    try {
                        FileUtil.log("addDownloadManager: " + ByteFormatter.encodeString(download_manager.getTorrent().getHash()) + ": returning  existing");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    is_existing[0] = true;
                    return existing;
                }
                try {
                    if (!initial_load) {
                        FileUtil.log("addDownloadManager: " + ByteFormatter.encodeString(download_manager.getTorrent().getHash()) + ": actually adding");
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (adapter != null && download_manager.getTorrent() != null) {
                try {
                    adapter.initialised(download_manager, for_seeding);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            download_manager.setConstructed();
            object = this.managers_lock;
            synchronized (object) {
                DownloadManagerStats dm_stats = download_manager.getStats();
                HashWrapper hashwrapper = null;
                try {
                    TOTorrent torrent = download_manager.getTorrent();
                    if (torrent != null) {
                        hashwrapper = torrent.getHashWrapper();
                    }
                }
                catch (Exception torrent) {
                    // empty catch block
                }
                Map save_download_state = this.saved_download_manager_state.remove(hashwrapper);
                long saved_data_bytes_downloaded = 0L;
                long saved_data_bytes_uploaded = 0L;
                long saved_discarded = 0L;
                long saved_hashfails = 0L;
                long saved_SecondsDownloading = 0L;
                long saved_SecondsOnlySeeding = 0L;
                if (save_download_state != null) {
                    long ct;
                    Long creation_time;
                    Long already_allocated;
                    Long lSecondsOnlySeeding;
                    Long lSecondsDLing;
                    Category cat;
                    TOTorrent torrent;
                    int maxUploads;
                    int maxDL = save_download_state.get("maxdl") == null ? 0 : ((Long)save_download_state.get("maxdl")).intValue();
                    int maxUL = save_download_state.get("maxul") == null ? 0 : ((Long)save_download_state.get("maxul")).intValue();
                    Long lDownloaded = (Long)save_download_state.get("downloaded");
                    Long lUploaded = (Long)save_download_state.get("uploaded");
                    Long lCompletedBytes = (Long)save_download_state.get("completedbytes");
                    Long lDiscarded = (Long)save_download_state.get("discarded");
                    Long lHashFailsCount = (Long)save_download_state.get("hashfails");
                    Long lHashFailsBytes = (Long)save_download_state.get("hashfailbytes");
                    Long nbUploads = (Long)save_download_state.get("uploads");
                    if (nbUploads != null && (maxUploads = nbUploads.intValue()) != 4 && download_manager.getMaxUploads() == 4) {
                        download_manager.setMaxUploads(maxUploads);
                    }
                    dm_stats.setDownloadRateLimitBytesPerSecond(maxDL);
                    dm_stats.setUploadRateLimitBytesPerSecond(maxUL);
                    if (lCompletedBytes != null) {
                        dm_stats.setDownloadCompletedBytes(lCompletedBytes);
                    }
                    if (lDiscarded != null) {
                        saved_discarded = lDiscarded;
                    }
                    if (lHashFailsBytes != null) {
                        saved_hashfails = lHashFailsBytes;
                    } else if (lHashFailsCount != null && (torrent = download_manager.getTorrent()) != null) {
                        saved_hashfails = lHashFailsCount * torrent.getPieceLength();
                    }
                    Long lPosition = (Long)save_download_state.get("position");
                    String sCategory = null;
                    if (save_download_state.containsKey("category")) {
                        sCategory = new String((byte[])save_download_state.get("category"), Constants.DEFAULT_ENCODING_CHARSET);
                    }
                    if (sCategory != null && (cat = CategoryManager.getCategory(sCategory)) != null) {
                        download_manager.getDownloadState().setCategory(cat);
                    }
                    download_manager.requestAssumedCompleteMode();
                    if (lDownloaded != null && lUploaded != null) {
                        boolean bCompleted = download_manager.isDownloadComplete(false);
                        long lUploadedValue = lUploaded;
                        long lDownloadedValue = lDownloaded;
                        if (bCompleted && lDownloadedValue == 0L) {
                            int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                            lDownloadedValue = download_manager.getSize() * (long)dl_copies;
                            download_manager.getDownloadState().setFlag(1L, true);
                        }
                        saved_data_bytes_downloaded = lDownloadedValue;
                        saved_data_bytes_uploaded = lUploadedValue;
                    }
                    if (lPosition != null) {
                        download_manager.setPosition(lPosition.intValue());
                    }
                    if ((lSecondsDLing = (Long)save_download_state.get("secondsDownloading")) != null) {
                        saved_SecondsDownloading = lSecondsDLing;
                    }
                    if ((lSecondsOnlySeeding = (Long)save_download_state.get("secondsOnlySeeding")) != null) {
                        saved_SecondsOnlySeeding = lSecondsOnlySeeding;
                    }
                    if ((already_allocated = (Long)save_download_state.get("allocated")) != null && already_allocated.intValue() == 1) {
                        download_manager.setDataAlreadyAllocated(true);
                    }
                    if ((creation_time = (Long)save_download_state.get("creationTime")) != null && (ct = creation_time.longValue()) < SystemTime.getCurrentTime()) {
                        download_manager.setCreationTime(ct);
                    }
                } else if (dm_stats.getDownloadCompleted(false) == 1000) {
                    int dl_copies = COConfigurationManager.getIntParameter("StartStopManager_iAddForSeedingDLCopyCount");
                    saved_data_bytes_downloaded = download_manager.getSize() * (long)dl_copies;
                }
                dm_stats.restoreSessionTotals(saved_data_bytes_downloaded, saved_data_bytes_uploaded, saved_discarded, saved_hashfails, saved_SecondsDownloading, saved_SecondsOnlySeeding);
                boolean isCompleted = download_manager.isDownloadComplete(false);
                if (download_manager.getPosition() == -1) {
                    int endPosition = 0;
                    DownloadManager[] downloadManagerArray = this.managers_list_cow;
                    int lCompletedBytes = this.managers_list_cow.length;
                    int lUploaded = 0;
                    while (lUploaded < lCompletedBytes) {
                        DownloadManager dm = downloadManagerArray[lUploaded];
                        boolean dmIsCompleted = dm.isDownloadComplete(false);
                        if (dmIsCompleted == isCompleted) {
                            ++endPosition;
                        }
                        ++lUploaded;
                    }
                    download_manager.setPosition(endPosition + 1);
                }
                download_manager.requestAssumedCompleteMode();
                int len = this.managers_list_cow.length;
                DownloadManager[] new_download_managers = new DownloadManager[len + 1];
                System.arraycopy(this.managers_list_cow, 0, new_download_managers, 0, len);
                new_download_managers[len] = download_manager;
                this.managers_list_cow = new_download_managers;
                this.manager_id_set.put(download_manager, download_manager);
                if (hashwrapper != null) {
                    this.manager_hash_map.put(hashwrapper, download_manager);
                }
                if (COConfigurationManager.getBooleanParameter("Set Completion Flag For Completed Downloads On Start") && download_manager.isDownloadComplete(true)) {
                    download_manager.getDownloadState().setFlag(8L, true);
                }
                if (notifyListeners) {
                    this.listeners_and_event_listeners.dispatch(1, download_manager);
                    this.taggable_life_manager.taggableCreated(download_manager);
                    if (this.host_support != null) {
                        this.host_support.torrentAdded(download_manager);
                    }
                }
                download_manager.addListener(this);
                if (save_download_state != null) {
                    Long lStartStopLocked;
                    Long lForceStart = (Long)save_download_state.get("forceStart");
                    if (lForceStart == null && (lStartStopLocked = (Long)save_download_state.get("startStopLocked")) != null) {
                        lForceStart = lStartStopLocked;
                    }
                    if (lForceStart != null && lForceStart.intValue() == 1) {
                        download_manager.setForceStart(true);
                    }
                }
            }
            return download_manager;
        }
        Logger.log(new LogEvent(LOGID, 3, "Tried to add a DownloadManager after shutdown of GlobalManager."));
        return null;
    }

    @Override
    public void clearNonPersistentDownloadState(byte[] hash) {
        this.saved_download_manager_state.remove(new HashWrapper(hash));
    }

    @Override
    public List<DownloadManager> getDownloadManagers() {
        List<DownloadManager> result = Arrays.asList(this.managers_list_cow);
        if (Constants.isCVSVersion()) {
            return Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public DownloadManager getDownloadManager(TOTorrent torrent) {
        if (torrent == null) {
            return null;
        }
        try {
            return this.getDownloadManager(torrent.getHashWrapper());
        }
        catch (TOTorrentException e) {
            return null;
        }
    }

    @Override
    public DownloadManager getDownloadManager(HashWrapper hw) {
        return this.manager_hash_map.get(hw);
    }

    @Override
    public void canDownloadManagerBeRemoved(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        if (manager.getDownloadState().getFlag(512L)) {
            return;
        }
        try {
            this.removal_listeners.dispatchWithException(1, new Object[]{manager, remove_torrent, remove_data});
        }
        catch (Throwable e) {
            if (e instanceof GlobalManagerDownloadRemovalVetoException) {
                throw (GlobalManagerDownloadRemovalVetoException)e;
            }
            GlobalManagerDownloadRemovalVetoException gmv = new GlobalManagerDownloadRemovalVetoException("Error running veto check");
            gmv.initCause(e);
            Debug.out(e);
            throw gmv;
        }
    }

    @Override
    public void removeDownloadManager(DownloadManager manager) throws GlobalManagerDownloadRemovalVetoException {
        this.removeDownloadManager(manager, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadManager(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
        TOTorrent torrent = null;
        HashWrapper hash = null;
        try {
            torrent = manager.getTorrent();
            hash = torrent == null ? null : torrent.getHashWrapper();
            boolean isMagnet = manager.getDownloadState().getFlag(512L);
            FileUtil.log("removeDownload: " + (hash == null ? manager.getDisplayName() : ByteFormatter.encodeString(hash.getBytes())) + ": isMagnet=" + isMagnet);
        }
        catch (Throwable isMagnet) {
            // empty catch block
        }
        Object isMagnet = this.managers_lock;
        synchronized (isMagnet) {
            if (!this.manager_id_set.containsKey(manager)) {
                return;
            }
        }
        this.canDownloadManagerBeRemoved(manager, remove_torrent, remove_data);
        if (this.ds_tagger != null) {
            this.ds_tagger.removeInitiated(manager);
        }
        manager.stopIt(70, remove_torrent, remove_data, true);
        isMagnet = this.managers_lock;
        synchronized (isMagnet) {
            if (!this.manager_id_set.containsKey(manager)) {
                return;
            }
            int len = this.managers_list_cow.length;
            int i = 0;
            while (i < len) {
                if (this.managers_list_cow[i].equals(manager)) {
                    DownloadManager[] new_download_managers = new DownloadManager[len - 1];
                    if (i > 0) {
                        System.arraycopy(this.managers_list_cow, 0, new_download_managers, 0, i);
                    }
                    if (new_download_managers.length - i > 0) {
                        System.arraycopy(this.managers_list_cow, i + 1, new_download_managers, i, new_download_managers.length - i);
                    }
                    this.managers_list_cow = new_download_managers;
                    break;
                }
                ++i;
            }
            this.manager_id_set.remove(manager);
            if (hash == null || this.manager_hash_map.remove(hash) == null) {
                Iterator<DownloadManager> it = this.manager_hash_map.values().iterator();
                boolean removed = false;
                while (it.hasNext()) {
                    if (it.next() != manager) continue;
                    it.remove();
                    removed = true;
                }
                if (!removed) {
                    Debug.out("Failed to remove download " + manager.getDisplayName() + " from manager hash map");
                }
            }
        }
        if (torrent != null) {
            TorrentUtils.removeCreatedTorrent(torrent);
        }
        manager.destroy(false);
        this.fixUpDownloadManagerPositions();
        this.listeners_and_event_listeners.dispatch(2, manager);
        TorrentUtils.setTorrentDeleted();
        this.taggable_life_manager.taggableDestroyed(manager);
        manager.removeListener(this);
        DownloadManagerState dms = manager.getDownloadState();
        if (dms.getCategory() != null) {
            dms.setCategory(null);
        }
        if (torrent != null) {
            this.trackerScraper.remove(torrent);
        }
        if (this.host_support != null) {
            this.host_support.torrentRemoved(manager, torrent);
        }
        dms.delete();
    }

    @Override
    public boolean isStopping() {
        return this.isStopping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopGlobalManager(GlobalMangerProgressListener listener) {
        Object object = this.managers_lock;
        synchronized (object) {
            if (this.isStopping) {
                return;
            }
            this.isStopping = true;
        }
        this.stats.save();
        this.informDestroyInitiated(listener);
        if (this.host_support != null) {
            this.host_support.destroy();
        }
        this.torrent_folder_watcher.destroy();
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() {
                    return null;
                }

                @Override
                public String getName() {
                    return "Stopping global manager";
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        this.checker.stopIt();
        if (COConfigurationManager.getBooleanParameter("Pause Downloads On Exit")) {
            this.pauseDownloadsInternal(true, true);
            this.stopAllDownloads(true, new GlobalMangerProgressListener.GlobalMangerProgressAdapter(listener, 0, 49));
            this.saveDownloads(false, new GlobalMangerProgressListener.GlobalMangerProgressAdapter(listener, 50, 100));
        } else {
            this.saveDownloads(false, new GlobalMangerProgressListener.GlobalMangerProgressAdapter(listener, 0, 49));
            this.stopAllDownloads(true, new GlobalMangerProgressListener.GlobalMangerProgressAdapter(listener, 50, 100));
        }
        if (this.stats_writer != null) {
            this.stats_writer.destroy();
        }
        TorrentUtils.temporarilyDisableDNSHandling();
        DownloadManagerStateFactory.saveGlobalStateCache();
        object = this.managers_lock;
        synchronized (object) {
            this.managers_list_cow = new DownloadManager[0];
            this.manager_id_set.clear();
            this.manager_hash_map.clear();
        }
        this.informDestroyed();
    }

    @Override
    public void stopAllDownloads() {
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() throws Throwable {
                    GlobalManagerImpl.this.stopAllDownloads(false, new GlobalMangerProgressListener.GlobalMangerProgressAdapter());
                    return null;
                }

                @Override
                public String getName() {
                    return "Manual 'stop all downloads'";
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected void stopAllDownloads(boolean for_close, GlobalMangerProgressListener listener) {
        if (for_close && this.progress_listener != null) {
            this.progress_listener.reportCurrentTask(MessageText.getString("splash.unloadingTorrents"));
        }
        long lastListenerUpdate = 0L;
        List<DownloadManager> managers = this.sortForStop();
        int nbDownloads = managers.size();
        String prefix = MessageText.getString("label.stopping.downloads");
        int i = 0;
        while (i < nbDownloads) {
            int state;
            DownloadManager manager = managers.get(i);
            long now = SystemTime.getCurrentTime();
            if (this.progress_listener != null && now - lastListenerUpdate > 100L) {
                lastListenerUpdate = now;
                int currentDownload = i + 1;
                this.progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                this.progress_listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.unloadingTorrent")) + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + manager.getTorrentFileName());
            }
            if ((state = manager.getState()) != 70 && state != 65) {
                listener.reportCurrentTask(String.valueOf(prefix) + ": " + manager.getDisplayName());
                manager.stopIt(for_close ? 71 : 70, false, false);
                listener.reportPercent(i * 100 / nbDownloads);
            }
            ++i;
        }
        listener.reportPercent(100);
    }

    @Override
    public void startAllDownloads() {
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() throws Throwable {
                    DownloadManager[] managers;
                    DownloadManager[] downloadManagerArray = managers = GlobalManagerImpl.this.managers_list_cow;
                    int n = managers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DownloadManager manager = downloadManagerArray[n2];
                        if (manager.getState() == 70) {
                            manager.stopIt(75, false, false);
                        }
                        ++n2;
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return "Manual 'start all downloads'";
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public boolean pauseDownload(DownloadManager manager, boolean only_if_active) {
        if (manager.getTorrent() == null) {
            return false;
        }
        if (manager.isPaused()) {
            return !only_if_active;
        }
        int state = manager.getState();
        if (state != 100 && state != 65) {
            if (state == 70 && only_if_active) {
                return false;
            }
            try {
                HashWrapper wrapper = manager.getTorrent().getHashWrapper();
                boolean forced = manager.isForceStart();
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.put(wrapper, forced);
                }
                finally {
                    this.paused_list_mon.exit();
                }
                if (state != 70) {
                    manager.stopIt(70, false, false);
                } else if (this.ds_tagger != null) {
                    this.ds_tagger.stateChanged(manager, 70);
                }
                return true;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    @Override
    public boolean stopPausedDownload(DownloadManager dm) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return false;
        }
        boolean state_changed = false;
        try {
            DownloadManager this_manager;
            this.paused_list_mon.enter();
            HashWrapper hw = torrent.getHashWrapper();
            if (this.paused_list.containsKey(hw) && (this_manager = this.getDownloadManager(hw)) == dm) {
                this.paused_list.remove(hw);
                state_changed = true;
                return true;
            }
        }
        catch (Throwable e) {
            return false;
        }
        finally {
            this.paused_list_mon.exit();
            if (state_changed && this.ds_tagger != null) {
                this.ds_tagger.stateChanged(dm, 70);
            }
        }
        return false;
    }

    @Override
    public void pauseDownloadsForPeriod(int seconds) {
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                this.auto_resume_timer.cancel();
            }
            this.auto_resume_timer = SimpleTimer.addEvent("GM:auto-resume", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    GlobalManagerImpl.this.resumeDownloads();
                }
            });
        }
        finally {
            this.paused_list_mon.exit();
        }
        this.pauseDownloads();
    }

    @Override
    public int getPauseDownloadPeriodRemaining() {
        try {
            this.paused_list_mon.enter();
            if (this.auto_resume_timer != null) {
                long rem = this.auto_resume_timer.getWhen() - SystemTime.getCurrentTime();
                int n = Math.max(0, (int)(rem / 1000L));
                return n;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return 0;
    }

    @Override
    public void pauseDownloads(final boolean pause_force_start) {
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() throws Throwable {
                    GlobalManagerImpl.this.pauseDownloadsInternal(false, pause_force_start);
                    return null;
                }

                @Override
                public String getName() {
                    return "Manual 'pause all downloads'";
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private void pauseDownloadsInternal(boolean tag_only, boolean pause_force_start) {
        List<DownloadManager> managers = this.sortForStop();
        for (DownloadManager manager : managers) {
            int state;
            if (manager.getTorrent() == null || (state = manager.getState()) == 70 || state == 100 || state == 65) continue;
            try {
                boolean forced = manager.isForceStart();
                if (forced && !pause_force_start) continue;
                try {
                    this.paused_list_mon.enter();
                    this.paused_list.put(manager.getTorrent().getHashWrapper(), forced);
                }
                finally {
                    this.paused_list_mon.exit();
                }
                if (tag_only) continue;
                manager.stopIt(70, false, false);
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public boolean canPauseDownload(DownloadManager manager) {
        if (manager.getTorrent() == null) {
            return false;
        }
        int state = manager.getState();
        return state != 70 && state != 100 && state != 65;
    }

    @Override
    public boolean isPaused(DownloadManager manager) {
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null || this.paused_list.size() == 0) {
            return false;
        }
        try {
            DownloadManager this_manager;
            this.paused_list_mon.enter();
            HashWrapper hw = torrent.getHashWrapper();
            return this.paused_list.containsKey(hw) && (this_manager = this.getDownloadManager(hw)) == manager;
            {
            }
        }
        catch (Throwable e) {
            return false;
        }
        finally {
            this.paused_list_mon.exit();
        }
    }

    @Override
    public boolean canPauseDownloads(boolean pause_force_start) {
        DownloadManager[] managers;
        DownloadManager[] downloadManagerArray = managers = this.managers_list_cow;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager manager = downloadManagerArray[n2];
            if ((!manager.isForceStart() || pause_force_start) && this.canPauseDownload(manager)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void resumeDownload(DownloadManager manager) {
        boolean resume_ok = false;
        boolean force = false;
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            try {
                this.paused_list_mon.enter();
                HashWrapper hw = torrent.getHashWrapper();
                Boolean forced = this.paused_list.get(hw);
                if (forced != null) {
                    force = forced;
                    DownloadManager this_manager = this.getDownloadManager(hw);
                    if (this_manager == manager) {
                        resume_ok = true;
                        this.paused_list.remove(hw);
                    }
                }
            }
            catch (Throwable e) {
                this.paused_list_mon.exit();
                return;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        if (resume_ok && manager.getState() == 70) {
            if (force) {
                manager.setForceStart(true);
            } else {
                manager.stopIt(75, false, false);
            }
        }
    }

    @Override
    public boolean resumingDownload(DownloadManager manager) {
        TOTorrent torrent = manager.getTorrent();
        if (torrent == null) {
            return false;
        }
        try {
            DownloadManager this_manager;
            this.paused_list_mon.enter();
            HashWrapper hw = torrent.getHashWrapper();
            if (this.paused_list.containsKey(hw) && (this_manager = this.getDownloadManager(hw)) == manager) {
                Boolean force = this.paused_list.remove(hw);
                boolean bl = force != null && force != false;
                return bl;
            }
        }
        catch (Throwable e) {
            return false;
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    @Override
    public void resumeDownloads() {
        try {
            NonDaemonTaskRunner.run(new NonDaemonTask(){

                @Override
                public Object run() throws Throwable {
                    GlobalManagerImpl.this.auto_resume_disabled = false;
                    try {
                        GlobalManagerImpl.this.paused_list_mon.enter();
                        if (GlobalManagerImpl.this.auto_resume_timer != null) {
                            GlobalManagerImpl.this.auto_resume_timer.cancel();
                            GlobalManagerImpl.this.auto_resume_timer = null;
                        }
                        HashMap copy = new HashMap(GlobalManagerImpl.this.paused_list);
                        for (Map.Entry entry : copy.entrySet()) {
                            HashWrapper hash = (HashWrapper)entry.getKey();
                            boolean force = (Boolean)entry.getValue();
                            DownloadManager manager = GlobalManagerImpl.this.getDownloadManager(hash);
                            if (manager == null || manager.getState() != 70) continue;
                            if (force) {
                                manager.setForceStart(true);
                                continue;
                            }
                            manager.stopIt(75, false, false);
                        }
                        GlobalManagerImpl.this.paused_list.clear();
                    }
                    finally {
                        GlobalManagerImpl.this.paused_list_mon.exit();
                    }
                    return null;
                }

                @Override
                public String getName() {
                    return "Manual 'pause all downloads'";
                }
            });
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    @Override
    public boolean resumeDownloads(boolean is_auto_resume) {
        if (is_auto_resume && this.auto_resume_disabled) {
            return false;
        }
        this.resumeDownloads();
        return true;
    }

    @Override
    public boolean canResumeDownloads() {
        try {
            this.paused_list_mon.enter();
            for (HashWrapper hash : this.paused_list.keySet()) {
                DownloadManager manager = this.getDownloadManager(hash);
                if (manager == null || manager.getState() != 70) continue;
                return true;
            }
        }
        finally {
            this.paused_list_mon.exit();
        }
        return false;
    }

    @Override
    public boolean isSwarmMerging(DownloadManager dm) {
        return this.file_merger.isSwarmMergingZ(dm);
    }

    @Override
    public String getSwarmMergingInfo(DownloadManager dm) {
        return this.file_merger.getSwarmMergingInfo(dm);
    }

    private List<DownloadManager> sortForStop() {
        ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(this.getDownloadManagers());
        Collections.sort(managers, new Comparator<DownloadManager>(){

            @Override
            public int compare(DownloadManager o1, DownloadManager o2) {
                int s1 = o1.getState();
                int s2 = o2.getState();
                if (s2 == 75) {
                    return 1;
                }
                if (s1 == 75) {
                    return -1;
                }
                return 0;
            }
        });
        return managers;
    }

    void loadDownloads() {
        if (this.cripple_downloads_config) {
            this.loadingComplete = true;
            this.loadingSem.releaseForever();
            return;
        }
        boolean pause_active = COConfigurationManager.getBooleanParameter("Pause Downloads On Start After Resume", false);
        if (pause_active) {
            COConfigurationManager.removeParameter("Pause Downloads On Start After Resume");
            COConfigurationManager.setParameter("br.restore.autopause", true);
        }
        try {
            DownloadManagerStateFactory.loadGlobalStateCache();
            int triggerOnCount = 2;
            ArrayList<DownloadManager> downloadsAdded = new ArrayList<DownloadManager>();
            this.lastListenerUpdate = 0L;
            try {
                try {
                    HashMap<String, Object> m;
                    int nbDownloads;
                    if (this.progress_listener != null) {
                        this.progress_listener.reportCurrentTask(MessageText.getString("splash.loadingTorrents"));
                    }
                    Map map = FileUtil.readResilientConfigFile("downloads.config");
                    ArrayList pause_data = (ArrayList)map.get("pause_data");
                    boolean debug = Boolean.getBoolean("debug");
                    Iterator<Object> iter = null;
                    List downloads = (List)map.get("downloads");
                    if (downloads == null) {
                        iter = map.values().iterator();
                        nbDownloads = map.size();
                    } else {
                        iter = downloads.iterator();
                        nbDownloads = downloads.size();
                    }
                    int currentDownload = 0;
                    while (iter.hasNext()) {
                        DownloadManager dm;
                        ++currentDownload;
                        Map mDownload = (Map)iter.next();
                        if (pause_active) {
                            try {
                                boolean fs;
                                int state = ((Number)mDownload.get("state")).intValue();
                                boolean bl = fs = ((Number)mDownload.get("forceStart")).intValue() != 0;
                                if (state != 70) {
                                    mDownload.put("state", new Long(70L));
                                    mDownload.remove("forceStart");
                                    byte[] key = (byte[])mDownload.get("torrent_hash");
                                    if (pause_data == null) {
                                        pause_data = new ArrayList();
                                    }
                                    m = new HashMap<String, Object>();
                                    m.put("hash", key);
                                    m.put("force", new Long(fs ? 1 : 0));
                                    pause_data.add(m);
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                        if ((dm = this.loadDownload(mDownload, currentDownload, nbDownloads, this.progress_listener, debug)) == null) continue;
                        downloadsAdded.add(dm);
                        if (downloadsAdded.size() < triggerOnCount) continue;
                        triggerOnCount *= 2;
                        this.triggerAddListener(downloadsAdded);
                        downloadsAdded.clear();
                    }
                    COConfigurationManager.setParameter("Set Completion Flag For Completed Downloads On Start", false);
                    if (pause_data != null) {
                        try {
                            this.paused_list_mon.enter();
                            int i = 0;
                            while (i < pause_data.size()) {
                                boolean force;
                                byte[] key;
                                Object pd = pause_data.get(i);
                                if (pd instanceof byte[]) {
                                    key = (byte[])pause_data.get(i);
                                    force = false;
                                } else {
                                    m = (HashMap<String, Object>)pd;
                                    key = (byte[])m.get("hash");
                                    force = ((Long)m.get("force")).intValue() == 1;
                                }
                                HashWrapper hw = new HashWrapper(key);
                                Boolean b_force = force;
                                this.paused_list.put(hw, b_force);
                                this.paused_list_initial.put(hw, b_force);
                                ++i;
                            }
                        }
                        finally {
                            this.paused_list_mon.exit();
                        }
                    }
                    this.fixUpDownloadManagerPositions();
                    Logger.log(new LogEvent(LOGID, "Loaded " + this.managers_list_cow.length + " torrents"));
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    this.loadingComplete = true;
                    this.triggerAddListener(downloadsAdded);
                    this.loadingSem.releaseForever();
                }
            }
            finally {
                this.loadingComplete = true;
                this.triggerAddListener(downloadsAdded);
                this.loadingSem.releaseForever();
            }
        }
        finally {
            DownloadManagerStateFactory.discardGlobalStateCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void triggerAddListener(List downloadsToAdd) {
        Object object = this.managers_lock;
        synchronized (object) {
            List<Object> listenersCopy = this.listeners_and_event_listeners.getListenersCopy();
            int j = 0;
            while (j < listenersCopy.size()) {
                Object listener = listenersCopy.get(j);
                if (listener instanceof GlobalManagerListener) {
                    GlobalManagerListener gmListener = (GlobalManagerListener)listener;
                    int i = 0;
                    while (i < downloadsToAdd.size()) {
                        DownloadManager dm = (DownloadManager)downloadsToAdd.get(i);
                        gmListener.downloadManagerAdded(dm);
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    @Override
    public void saveState() {
        this.saveDownloads(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveDownloads(boolean interim, GlobalMangerProgressListener listener_maybe_null) {
        if (!this.loadingComplete) {
            return;
        }
        this.needsSavingCozStateChanged = 0L;
        if (this.cripple_downloads_config) {
            return;
        }
        Object object = this.managers_lock;
        synchronized (object) {
            DownloadManager[] managers_temp = (DownloadManager[])this.managers_list_cow.clone();
            Arrays.sort(managers_temp, new Comparator<DownloadManager>(){

                @Override
                public final int compare(DownloadManager a, DownloadManager b) {
                    return a.getPosition() - b.getPosition();
                }
            });
            this.managers_list_cow = managers_temp;
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Saving Download List (" + managers_temp.length + " items)"));
            }
            HashMap map = new HashMap();
            int nbDownloads = managers_temp.length;
            ArrayList<Map> list = new ArrayList<Map>(nbDownloads);
            String prefix = MessageText.getString("label.saving.downloads");
            int i = 0;
            while (i < nbDownloads) {
                DownloadManager dm = managers_temp[i];
                if (listener_maybe_null != null) {
                    listener_maybe_null.reportCurrentTask(String.valueOf(prefix) + ": " + dm.getDisplayName());
                    listener_maybe_null.reportPercent(i * 100 / nbDownloads);
                }
                Map dmMap = this.exportDownloadStateToMapSupport(dm, true, interim);
                list.add(dmMap);
                ++i;
            }
            map.put("downloads", list);
            try {
                this.paused_list_mon.enter();
                if (!this.paused_list.isEmpty()) {
                    ArrayList pause_data = new ArrayList();
                    for (Map.Entry<HashWrapper, Boolean> entry : this.paused_list.entrySet()) {
                        HashWrapper hash = entry.getKey();
                        Boolean force = entry.getValue();
                        HashMap<String, Object> m = new HashMap<String, Object>();
                        m.put("hash", hash.getHash());
                        m.put("force", new Long(force != false ? 1 : 0));
                        pause_data.add(m);
                    }
                    map.put("pause_data", pause_data);
                }
            }
            finally {
                this.paused_list_mon.exit();
            }
            FileUtil.writeResilientConfigFile("downloads.config", map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadManager loadDownload(Map mDownload, int currentDownload, int nbDownloads, GlobalMangerProgressListener progress_listener, boolean debug) {
        block26: {
            try {
                List<Long> file_priorities;
                boolean has_ever_been_started;
                String torrent_save_file;
                String torrent_save_dir;
                byte[] torrent_save_dir_bytes;
                byte[] torrent_hash = (byte[])mDownload.get("torrent_hash");
                Long lPersistent = (Long)mDownload.get("persistent");
                boolean persistent = lPersistent == null || lPersistent == 1L;
                String fileName = new String((byte[])mDownload.get("torrent"), Constants.DEFAULT_ENCODING_CHARSET);
                if (progress_listener != null && SystemTime.getCurrentTime() - this.lastListenerUpdate > 100L) {
                    this.lastListenerUpdate = SystemTime.getCurrentTime();
                    String shortFileName = fileName;
                    try {
                        File f = FileUtil.newFile(fileName, new String[0]);
                        shortFileName = f.getName();
                    }
                    catch (Exception f) {
                        // empty catch block
                    }
                    progress_listener.reportPercent(100 * currentDownload / nbDownloads);
                    progress_listener.reportCurrentTask(String.valueOf(MessageText.getString("splash.loadingTorrent")) + " " + currentDownload + " " + MessageText.getString("splash.of") + " " + nbDownloads + " : " + shortFileName);
                }
                if ((torrent_save_dir_bytes = (byte[])mDownload.get("save_dir")) != null) {
                    byte[] torrent_save_file_bytes = (byte[])mDownload.get("save_file");
                    torrent_save_dir = new String(torrent_save_dir_bytes, Constants.DEFAULT_ENCODING_CHARSET);
                    torrent_save_file = torrent_save_file_bytes != null ? new String(torrent_save_file_bytes, Constants.DEFAULT_ENCODING_CHARSET) : null;
                } else {
                    byte[] savePathBytes = (byte[])mDownload.get("path");
                    torrent_save_dir = new String(savePathBytes, Constants.DEFAULT_ENCODING_CHARSET);
                    torrent_save_file = null;
                }
                int state = 0;
                if (debug) {
                    state = 70;
                } else if (mDownload.containsKey("state")) {
                    state = ((Long)mDownload.get("state")).intValue();
                    if (state != 70 && state != 75 && state != 0) {
                        state = 75;
                    }
                } else {
                    int stopped = ((Long)mDownload.get("stopped")).intValue();
                    if (stopped == 1) {
                        state = 70;
                    }
                }
                Long seconds_downloading = (Long)mDownload.get("secondsDownloading");
                boolean bl = has_ever_been_started = seconds_downloading != null && seconds_downloading > 0L;
                if (torrent_hash != null) {
                    this.saved_download_manager_state.put(new HashWrapper(torrent_hash), mDownload);
                }
                if (!persistent) break block26;
                Map map_file_priorities = (Map)mDownload.get("file_priorities_c");
                if (map_file_priorities != null) {
                    Object[] array_file_priorities = new Long[]{};
                    for (Object key : map_file_priorities.keySet()) {
                        long priority = Long.parseLong(key.toString());
                        String indexRanges = new String((byte[])map_file_priorities.get(key), "utf-8");
                        String[] rangesStrings = indexRanges.split(",");
                        if (array_file_priorities.length == 0 && rangesStrings.length > 1) {
                            array_file_priorities = new Long[rangesStrings.length];
                        }
                        String[] stringArray = rangesStrings;
                        int n = rangesStrings.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int end;
                            String rangeString = stringArray[n2];
                            String[] ranges = rangeString.split("-");
                            int start = Integer.parseInt(ranges[0]);
                            int n3 = end = ranges.length == 1 ? start : Integer.parseInt(ranges[1]);
                            if (end >= array_file_priorities.length) {
                                array_file_priorities = GlobalManagerImpl.enlargeLongArray((Long[])array_file_priorities, end + 1);
                            }
                            Arrays.fill(array_file_priorities, start, end + 1, (Object)priority);
                            ++n2;
                        }
                    }
                    file_priorities = Arrays.asList(array_file_priorities);
                } else {
                    file_priorities = (List<Long>)mDownload.get("file_priorities");
                }
                Object object = this.create_dm_lock;
                synchronized (object) {
                    DownloadManager new_dm = DownloadManagerFactory.create(this, torrent_hash, fileName, torrent_save_dir, torrent_save_file, state, true, true, false, has_ever_been_started, file_priorities);
                    boolean[] existing = new boolean[1];
                    this.addDownloadManager(new_dm, false, null, false, existing, true);
                    if (!existing[0]) {
                        Long errorType = (Long)mDownload.get("errorType");
                        if (errorType != null) {
                            String errorDetails = MapUtils.getMapString(mDownload, "errorDetails", null);
                            Long errorFlags = (Long)mDownload.get("errorFlags");
                            new_dm.setErrorState(errorType.intValue(), errorDetails, errorFlags == null ? 0 : errorFlags.intValue());
                        }
                        return new_dm;
                    }
                }
            }
            catch (UnsupportedEncodingException torrent_hash) {
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Error while loading downloads.  One download may not have been added to the list.", e));
            }
        }
        return null;
    }

    public static Long[] enlargeLongArray(Long[] array, int expandTo) {
        Long[] new_array = new Long[expandTo];
        if (array.length > 0) {
            System.arraycopy(array, 0, new_array, 0, array.length);
        }
        return new_array;
    }

    @Override
    public Map exportDownloadStateToMap(DownloadManager dm) {
        return this.exportDownloadStateToMapSupport(dm, false, false);
    }

    @Override
    public DownloadManager importDownloadStateFromMap(Map map) {
        DownloadManager dm = this.loadDownload(map, 1, 1, null, false);
        if (dm != null) {
            ArrayList<DownloadManager> dms = new ArrayList<DownloadManager>(1);
            dms.add(dm);
            this.triggerAddListener(dms);
            this.taggable_life_manager.taggableCreated(dm);
            if (this.host_support != null) {
                this.host_support.torrentAdded(dm);
            }
        }
        return dm;
    }

    private Map exportDownloadStateToMapSupport(DownloadManager dm, boolean internal_export, boolean interim) {
        DownloadManagerStats dm_stats = dm.getStats();
        HashMap<String, Object> dmMap = new HashMap<String, Object>();
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                dmMap.put("torrent_hash", torrent.getHash());
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        File save_loc = dm.getAbsoluteSaveLocation();
        dmMap.put("persistent", new Long(dm.isPersistent() ? 1 : 0));
        dmMap.put("torrent", dm.getTorrentFileName());
        dmMap.put("save_dir", save_loc.getParent());
        dmMap.put("save_file", save_loc.getName());
        dmMap.put("maxdl", new Long(dm_stats.getDownloadRateLimitBytesPerSecond()));
        dmMap.put("maxul", new Long(dm_stats.getUploadRateLimitBytesPerSecond()));
        int state = dm.getState();
        if (state == 100) {
            int errorType = dm.getErrorType();
            if (errorType != 0) {
                dmMap.put("errorType", errorType);
                dmMap.put("errorFlags", dm.getErrorFlags());
                String errorDetails = dm.getErrorDetails();
                if (errorDetails != null && !errorDetails.isEmpty()) {
                    dmMap.put("errorDetails", errorDetails);
                }
            }
            state = 70;
        } else if (dm.getAssumedComplete() && !dm.isForceStart() && state != 70) {
            state = 75;
        } else if (state != 70 && state != 75 && state != 0) {
            state = 0;
        }
        dmMap.put("state", new Long(state));
        if (internal_export) {
            dmMap.put("position", new Long(dm.getPosition()));
        }
        dmMap.put("downloaded", new Long(dm_stats.getTotalDataBytesReceived()));
        dmMap.put("uploaded", new Long(dm_stats.getTotalDataBytesSent()));
        dmMap.put("completedbytes", new Long(dm_stats.getDownloadCompletedBytes()));
        dmMap.put("discarded", new Long(dm_stats.getDiscarded()));
        dmMap.put("hashfailbytes", new Long(dm_stats.getHashFailBytes()));
        dmMap.put("forceStart", new Long(dm.isForceStart() && dm.getState() != 30 ? 1 : 0));
        dmMap.put("secondsDownloading", new Long(dm_stats.getSecondsDownloading()));
        dmMap.put("secondsOnlySeeding", new Long(dm_stats.getSecondsOnlySeeding()));
        dmMap.put("uploads", new Long(dm.getMaxUploads()));
        dmMap.put("creationTime", new Long(dm.getCreationTime()));
        dm.saveDownload(interim);
        List file_priorities = (List)dm.getUserData("file_priorities");
        if (file_priorities != null) {
            int count = file_priorities.size();
            HashMap<String, String> map_file_priorities = new HashMap<String, String>();
            Long priority = (Long)file_priorities.get(0);
            int posStart = 0;
            int posEnd = 0;
            while (posStart < count) {
                priority = (Long)file_priorities.get(posStart);
                while (posEnd + 1 < count && (Long)file_priorities.get(posEnd + 1) == priority) {
                    ++posEnd;
                }
                String key = priority.toString();
                String val = (String)map_file_priorities.get(key);
                val = val == null ? "" + posStart : String.valueOf(val) + "," + posStart;
                if (posStart != posEnd) {
                    val = String.valueOf(val) + "-" + posEnd;
                }
                map_file_priorities.put(key, val);
                posStart = posEnd + 1;
            }
            dmMap.put("file_priorities_c", map_file_priorities);
        }
        dmMap.put("allocated", new Long(dm.isDataAlreadyAllocated() ? 1 : 0));
        return dmMap;
    }

    @Override
    public TRTrackerScraper getTrackerScraper() {
        return this.trackerScraper;
    }

    @Override
    public GlobalManagerStats getStats() {
        return this.stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(DownloadManager manager) {
        if (manager != null) {
            Object object = this.managers_lock;
            synchronized (object) {
                return this.manager_id_set.containsKey(manager);
            }
        }
        return false;
    }

    @Override
    public boolean isMoveableUp(DownloadManager manager) {
        if (manager.isDownloadComplete(false) && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() > 1;
    }

    @Override
    public int downloadManagerCount(boolean bCompleted) {
        DownloadManager[] managers;
        int numInGroup = 0;
        DownloadManager[] downloadManagerArray = managers = this.managers_list_cow;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager dm = downloadManagerArray[n2];
            if (dm.isDownloadComplete(false) == bCompleted) {
                ++numInGroup;
            }
            ++n2;
        }
        return numInGroup;
    }

    @Override
    public boolean isMoveableDown(DownloadManager manager) {
        boolean isCompleted = manager.isDownloadComplete(false);
        if (isCompleted && COConfigurationManager.getIntParameter("StartStopManager_iRankType") != 0 && COConfigurationManager.getBooleanParameter("StartStopManager_bAutoReposition")) {
            return false;
        }
        return manager.getPosition() < this.downloadManagerCount(isCompleted);
    }

    @Override
    public void moveUp(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() - 1);
    }

    @Override
    public void moveDown(DownloadManager manager) {
        this.moveTo(manager, manager.getPosition() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTop(DownloadManager[] manager) {
        Object object = this.managers_lock;
        synchronized (object) {
            int newPosition = 1;
            int i = 0;
            while (i < manager.length) {
                this.moveTo(manager[i], newPosition++);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveEnd(DownloadManager[] manager) {
        Object object = this.managers_lock;
        synchronized (object) {
            int endPosComplete = 0;
            int endPosIncomplete = 0;
            DownloadManager[] downloadManagerArray = this.managers_list_cow;
            int n = this.managers_list_cow.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                if (dm.isDownloadComplete(false)) {
                    ++endPosComplete;
                } else {
                    ++endPosIncomplete;
                }
                ++n2;
            }
            int i = manager.length - 1;
            while (i >= 0) {
                if (manager[i].isDownloadComplete(false) && endPosComplete > 0) {
                    this.moveTo(manager[i], endPosComplete--);
                } else if (endPosIncomplete > 0) {
                    this.moveTo(manager[i], endPosIncomplete--);
                }
                --i;
            }
        }
    }

    @Override
    public void moveTo(DownloadManager manager, int newPosition) {
        ArrayList<DownloadManager> managers = new ArrayList<DownloadManager>(1);
        ArrayList<Integer> positions = new ArrayList<Integer>(1);
        managers.add(manager);
        positions.add(newPosition);
        this.moveTo(managers, positions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void moveTo(List<DownloadManager> managers, List<Integer> newPositions) {
        int pos;
        if (newPositions.size() > 1) {
            int prev = -1;
            boolean sort = false;
            for (int pos2 : newPositions) {
                if (pos2 >= prev) continue;
                sort = true;
                break;
            }
            if (sort) {
                void var6_9;
                TreeMap<Integer, Object> map = new TreeMap<Integer, Object>();
                boolean bl = false;
                while (var6_9 < managers.size()) {
                    DownloadManager manager = managers.get((int)var6_9);
                    pos = newPositions.get((int)var6_9);
                    if (manager.isDownloadComplete(false)) {
                        pos += 10000000;
                    }
                    map.put(pos, manager);
                    ++var6_9;
                }
                managers = new ArrayList<DownloadManager>(managers.size());
                newPositions = new ArrayList<Integer>(managers.size());
                for (Map.Entry entry : map.entrySet()) {
                    managers.add((DownloadManager)entry.getValue());
                    pos = (Integer)entry.getKey();
                    if (pos >= 10000000) {
                        pos -= 10000000;
                    }
                    newPositions.add(pos);
                }
            }
        }
        Object object = this.managers_lock;
        synchronized (object) {
            int[] manager_entry;
            int newPosition;
            void var6_12;
            DownloadManager[] dms_cow = this.managers_list_cow;
            int num_comp = 0;
            boolean bl = false;
            DownloadManager[] downloadManagerArray = dms_cow;
            int n = dms_cow.length;
            pos = 0;
            while (pos < n) {
                DownloadManager dm = downloadManagerArray[pos];
                boolean comp2 = dm.isDownloadComplete(false);
                if (comp2) {
                    ++num_comp;
                } else {
                    ++var6_12;
                }
                int pos3 = dm.getPosition();
                dm.setUserData(MOVE_POS_KEY, new int[]{pos3, comp2 ? 1 : 0});
                ++pos;
            }
            int i = 0;
            while (i < managers.size()) {
                int limit;
                DownloadManager manager = managers.get(i);
                newPosition = newPositions.get(i);
                manager_entry = (int[])manager.getUserData(MOVE_POS_KEY);
                if (manager_entry == null) {
                    Debug.out("DM not found in global list");
                    return;
                }
                int oldPosition = manager_entry[0];
                boolean curCompleted = manager_entry[1] == 1;
                int n2 = limit = curCompleted ? num_comp : var6_12;
                if (newPosition < 1 || newPosition > limit) {
                    Debug.out("newPosition is invalid: pos=" + newPosition + ", limit=" + limit);
                    return;
                }
                DownloadManager[] downloadManagerArray2 = dms_cow;
                int n3 = dms_cow.length;
                int downloadManagerArray3 = 0;
                while (downloadManagerArray3 < n3) {
                    int dmPosition;
                    boolean dmCompleted;
                    DownloadManager dm = downloadManagerArray2[downloadManagerArray3];
                    int[] dm_entry = (int[])dm.getUserData(MOVE_POS_KEY);
                    boolean bl2 = dmCompleted = dm_entry[1] == 1;
                    if (dmCompleted == curCompleted && (dmPosition = dm_entry[0]) > oldPosition) {
                        dm_entry[0] = dmPosition - 1;
                    }
                    ++downloadManagerArray3;
                }
                ++i;
            }
            i = 0;
            while (i < managers.size()) {
                DownloadManager manager = managers.get(i);
                newPosition = newPositions.get(i);
                manager_entry = (int[])manager.getUserData(MOVE_POS_KEY);
                boolean curCompleted = manager_entry[1] == 1;
                DownloadManager[] downloadManagerArray3 = dms_cow;
                int n4 = dms_cow.length;
                int n5 = 0;
                while (n5 < n4) {
                    int dmPosition;
                    boolean dmCompleted;
                    DownloadManager dm = downloadManagerArray3[n5];
                    int[] dm_entry = (int[])dm.getUserData(MOVE_POS_KEY);
                    boolean bl3 = dmCompleted = dm_entry[1] == 1;
                    if (dmCompleted == curCompleted && (dmPosition = dm_entry[0]) >= newPosition) {
                        dm_entry[0] = dmPosition + 1;
                    }
                    ++n5;
                }
                manager_entry[0] = newPosition;
                ++i;
            }
            downloadManagerArray = dms_cow;
            n = dms_cow.length;
            int n6 = 0;
            while (n6 < n) {
                DownloadManager dm = downloadManagerArray[n6];
                int[] dm_entry = (int[])dm.getUserData(MOVE_POS_KEY);
                int dmPosition = dm_entry[0];
                if (dmPosition != dm.getPosition()) {
                    dm.setPosition(dmPosition);
                }
                ++n6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fixUpDownloadManagerPositions() {
        Object object = this.managers_lock;
        synchronized (object) {
            int posComplete = 1;
            int posIncomplete = 1;
            DownloadManager[] managers_temp = (DownloadManager[])this.managers_list_cow.clone();
            Arrays.sort(managers_temp, new Comparator<DownloadManager>(){

                @Override
                public final int compare(DownloadManager a, DownloadManager b) {
                    int i = a.getPosition() - b.getPosition();
                    if (i != 0) {
                        return i;
                    }
                    if (a.isPersistent()) {
                        return 1;
                    }
                    if (b.isPersistent()) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.managers_list_cow = managers_temp;
            DownloadManager[] downloadManagerArray = managers_temp;
            int n = managers_temp.length;
            int n2 = 0;
            while (n2 < n) {
                DownloadManager dm = downloadManagerArray[n2];
                if (dm.isDownloadComplete(false)) {
                    dm.setPosition(posComplete++);
                } else {
                    dm.setPosition(posIncomplete++);
                }
                ++n2;
            }
        }
    }

    @Override
    public long getResolverTaggableType() {
        return 2L;
    }

    @Override
    public Taggable resolveTaggable(String id) {
        if (id == null) {
            return null;
        }
        return this.getDownloadManager(new HashWrapper(Base32.decode(id)));
    }

    @Override
    public List<Taggable> getResolvedTaggables() {
        return new ArrayList<Taggable>(this.getDownloadManagers());
    }

    public Object importDataSource(Map map) {
        String id = (String)map.get("id");
        return this.resolveTaggable(id);
    }

    @Override
    public String getDisplayName(Taggable taggable) {
        return ((DownloadManager)taggable).getDisplayName();
    }

    @Override
    public void requestAttention(String id) {
        DownloadManager dm = this.getDownloadManager(new HashWrapper(Base32.decode(id)));
        if (dm != null) {
            dm.requestAttention();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLifecycleControlListener(final TaggableResolver.LifecycleControlListener l) {
        Map<TaggableResolver.LifecycleControlListener, GlobalManagerDownloadWillBeRemovedListener> map = this.lcl_map;
        synchronized (map) {
            if (this.lcl_map.containsKey(l)) {
                Debug.out("Listener already added");
            }
            GlobalManagerDownloadWillBeRemovedListener gl = new GlobalManagerDownloadWillBeRemovedListener(){

                @Override
                public void downloadWillBeRemoved(DownloadManager manager, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                    try {
                        l.canTaggableBeRemoved(manager);
                    }
                    catch (Throwable e) {
                        throw new GlobalManagerDownloadRemovalVetoException(Debug.getNestedExceptionMessage(e));
                    }
                }
            };
            this.lcl_map.put(l, gl);
            this.addDownloadWillBeRemovedListener(gl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLifecycleControlListener(TaggableResolver.LifecycleControlListener l) {
        Map<TaggableResolver.LifecycleControlListener, GlobalManagerDownloadWillBeRemovedListener> map = this.lcl_map;
        synchronized (map) {
            GlobalManagerDownloadWillBeRemovedListener gl = this.lcl_map.remove(l);
            if (gl == null) {
                Debug.out("Listener not found");
            } else {
                this.removeDownloadWillBeRemovedListener(gl);
            }
        }
    }

    protected void informDestroyed() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.listeners_and_event_listeners.dispatch(4, null, true);
    }

    private void informDestroyInitiated(GlobalMangerProgressListener progress) {
        this.listeners_and_event_listeners.dispatch(3, progress, true);
    }

    @Override
    public void addListener(GlobalManagerListener listener) {
        this.addListener(listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(GlobalManagerListener listener, boolean trigger) {
        if (this.isStopping) {
            listener.destroyed();
        } else {
            this.listeners_and_event_listeners.addListener(listener);
            if (!trigger) {
                return;
            }
            Object object = this.managers_lock;
            synchronized (object) {
                DownloadManager[] downloadManagerArray = this.managers_list_cow;
                int n = this.managers_list_cow.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager manager = downloadManagerArray[n2];
                    listener.downloadManagerAdded(manager);
                    ++n2;
                }
            }
        }
    }

    @Override
    public void removeListener(GlobalManagerListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void addEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.addListener(listener);
    }

    @Override
    public void removeEventListener(GlobalManagerEventListener listener) {
        this.listeners_and_event_listeners.removeListener(listener);
    }

    @Override
    public void fireGlobalManagerEvent(final int type, final DownloadManager dm, final Object data) {
        this.listeners_and_event_listeners.dispatch(6, new GlobalManagerEvent(){

            @Override
            public int getEventType() {
                return type;
            }

            @Override
            public Object getEventData() {
                return data;
            }

            @Override
            public DownloadManager getDownload() {
                return dm;
            }
        });
    }

    @Override
    public void addDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.addListener(l);
    }

    @Override
    public void removeDownloadWillBeRemovedListener(GlobalManagerDownloadWillBeRemovedListener l) {
        this.removal_listeners.removeListener(l);
    }

    @Override
    public void stateChanged(DownloadManager manager, int new_state) {
        if (this.needsSavingCozStateChanged == 0L) {
            this.needsSavingCozStateChanged = SystemTime.getMonotonousTime();
        }
        PEPeerManager pm_manager = manager.getPeerManager();
        if (new_state == 50 && pm_manager != null && pm_manager.hasDownloadablePiece()) {
            this.setSeedingOnlyState(false, false);
        } else {
            this.checkSeedingOnlyState();
        }
        this.checkForceStart(manager.isForceStart() && new_state == 50);
    }

    protected void checkForceStart(boolean known_to_exist) {
        boolean exists;
        if (known_to_exist) {
            exists = true;
        } else {
            exists = false;
            if (this.force_start_non_seed_exists) {
                DownloadManager[] managers;
                DownloadManager[] downloadManagerArray = managers = this.managers_list_cow;
                int n = managers.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager manager = downloadManagerArray[n2];
                    if (manager.isForceStart() && manager.getState() == 50) {
                        exists = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        if (exists != this.force_start_non_seed_exists) {
            this.force_start_non_seed_exists = exists;
            Logger.log(new LogEvent(LOGID, "Force start download " + (this.force_start_non_seed_exists ? "exists" : "doesn't exist") + ", modifying download weighting"));
            PeerControlSchedulerFactory.overrideWeightedPriorities(this.force_start_non_seed_exists);
        }
    }

    protected void checkSeedingOnlyState() {
        this.check_seeding_only_state_dispatcher.dispatch();
    }

    protected void checkSeedingOnlyStateSupport() {
        boolean full_sync;
        boolean seeding = false;
        boolean seeding_set = false;
        boolean potentially_seeding = false;
        long curr_mut = this.all_trackers.getOptionsMutationCount();
        boolean bl = full_sync = curr_mut != this.all_trackers_options_mut;
        if (full_sync) {
            this.all_trackers_options_mut = curr_mut;
        }
        DownloadManager[] managers = this.managers_list_cow;
        boolean got_result = false;
        DownloadManager[] downloadManagerArray = managers;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            DownloadManager manager = downloadManagerArray[n2];
            int state = manager.getState();
            if (got_result) {
                if (state == 75 && manager.isDownloadComplete(false)) {
                    manager.checkLightSeeding(full_sync);
                }
            } else {
                PEPeerManager pm = manager.getPeerManager();
                if (pm == null) {
                    if (state == 75) {
                        if (manager.isDownloadComplete(false)) {
                            manager.checkLightSeeding(full_sync);
                            potentially_seeding = true;
                        } else {
                            seeding = false;
                            seeding_set = true;
                        }
                    }
                } else if (state == 50) {
                    if (!pm.hasDownloadablePiece()) {
                        if (!seeding_set) {
                            seeding = true;
                        }
                    } else {
                        seeding = false;
                        potentially_seeding = false;
                        got_result = true;
                    }
                } else if (state == 60 && !seeding_set) {
                    seeding = true;
                }
            }
            ++n2;
        }
        if (seeding) {
            potentially_seeding = true;
        }
        this.setSeedingOnlyState(seeding, potentially_seeding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSeedingOnlyState(boolean seeding, boolean potentially_seeding) {
        GlobalManagerImpl globalManagerImpl = this;
        synchronized (globalManagerImpl) {
            if (seeding != this.seeding_only_mode || potentially_seeding != this.potentially_seeding_only_mode) {
                this.seeding_only_mode = seeding;
                this.potentially_seeding_only_mode = potentially_seeding;
                this.listeners_and_event_listeners.dispatch(5, new boolean[]{this.seeding_only_mode, this.potentially_seeding_only_mode});
            }
        }
    }

    @Override
    public boolean isSeedingOnly() {
        return this.seeding_only_mode;
    }

    @Override
    public boolean isPotentiallySeedingOnly() {
        return this.potentially_seeding_only_mode;
    }

    public long getTotalSwarmsPeerRate(boolean downloading, boolean seeding) {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_swarm_stats_calc_time || now - this.last_swarm_stats_calc_time >= 1000L) {
            DownloadManager[] managers;
            long total = 0L;
            DownloadManager[] downloadManagerArray = managers = this.managers_list_cow;
            int n = managers.length;
            int n2 = 0;
            while (n2 < n) {
                boolean is_seeding;
                DownloadManager manager = downloadManagerArray[n2];
                boolean bl = is_seeding = manager.getState() == 60;
                if (downloading && !is_seeding || seeding && is_seeding) {
                    total += manager.getStats().getTotalAveragePerPeer();
                }
                ++n2;
            }
            this.last_swarm_stats = total;
            this.last_swarm_stats_calc_time = now;
        }
        return this.last_swarm_stats;
    }

    protected void computeNATStatus() {
        DownloadManager[] managers;
        int num_ok = 0;
        int num_probably_ok = 0;
        int num_bad = 0;
        int num_unknown = 0;
        String[] infos = new String[]{"", "", "", ""};
        int[] extra = new int[4];
        DownloadManager[] downloadManagerArray = managers = this.managers_list_cow;
        int n = managers.length;
        int n2 = 0;
        while (n2 < n) {
            block25: {
                int index;
                String info;
                DownloadManager manager;
                block22: {
                    int status;
                    block24: {
                        block23: {
                            block21: {
                                manager = downloadManagerArray[n2];
                                Object[] o_status = manager.getNATStatus();
                                status = (Integer)o_status[0];
                                info = (String)o_status[1];
                                if (status != 1) break block21;
                                index = 0;
                                ++num_ok;
                                break block22;
                            }
                            if (status != 2) break block23;
                            index = 1;
                            ++num_probably_ok;
                            break block22;
                        }
                        if (status != 3) break block24;
                        index = 2;
                        ++num_bad;
                        break block22;
                    }
                    if (status != 0) break block25;
                    index = 3;
                    ++num_unknown;
                }
                String str = infos[index];
                if (str.length() < 250) {
                    String name = manager.getDisplayName();
                    if (name.length() > 23) {
                        name = String.valueOf(name.substring(0, 20)) + "...";
                    }
                    infos[index] = str = String.valueOf(str) + (str.isEmpty() ? "" : "\n") + name + ": " + info;
                } else {
                    int n3 = index;
                    extra[n3] = extra[n3] + 1;
                }
            }
            ++n2;
        }
        int i = 0;
        while (i < infos.length) {
            int e = extra[i];
            if (e > 0) {
                int n4 = i;
                infos[n4] = String.valueOf(infos[n4]) + "\n(" + e + " more)";
            }
            ++i;
        }
        long now = SystemTime.getMonotonousTime();
        this.nat_info_prefix = null;
        if (num_ok > 0) {
            this.nat_status = 1;
            this.nat_status_last_good = now;
            this.nat_info = infos[0];
        } else if (this.nat_status_last_good != -1L && now - this.nat_status_last_good < 1800000L) {
            this.nat_status = 1;
            this.nat_info_prefix = "Has been good within the last hour: ";
        } else if (this.nat_status_last_good != -1L && SystemTime.getCurrentTime() - TCPNetworkManager.getSingleton().getLastIncomingNonLocalConnectionTime() < 1800000L) {
            this.nat_status = 1;
            this.nat_info_prefix = "Last incoming connection received less than an hour ago: ";
        } else if (num_probably_ok > 0 || this.nat_status_probably_ok) {
            this.nat_status = 2;
            this.nat_status_probably_ok = true;
            if (num_probably_ok > 0) {
                this.nat_info = infos[1];
            }
        } else if (num_bad > 0) {
            this.nat_status = 3;
            this.nat_info = infos[2];
        } else {
            this.nat_status = 0;
            this.nat_info = infos[3];
        }
    }

    @Override
    public Object[] getNATStatus() {
        String info = this.nat_info;
        String prefix = this.nat_info_prefix;
        if (prefix != null) {
            info = String.valueOf(prefix) + info;
        }
        return new Object[]{this.nat_status, info};
    }

    protected void seedPieceRecheck() {
        DownloadManager manager;
        DownloadManager[] managers = this.managers_list_cow;
        if (this.next_seed_piece_recheck_index >= managers.length) {
            this.next_seed_piece_recheck_index = 0;
        }
        int i = this.next_seed_piece_recheck_index;
        while (i < managers.length) {
            manager = managers[i];
            if (this.seedPieceRecheck(manager)) {
                this.next_seed_piece_recheck_index = i + 1;
                if (this.next_seed_piece_recheck_index >= managers.length) {
                    this.next_seed_piece_recheck_index = 0;
                }
                return;
            }
            ++i;
        }
        i = 0;
        while (i < this.next_seed_piece_recheck_index) {
            manager = managers[i];
            if (this.seedPieceRecheck(manager)) {
                this.next_seed_piece_recheck_index = i + 1;
                if (this.next_seed_piece_recheck_index >= managers.length) {
                    this.next_seed_piece_recheck_index = 0;
                }
                return;
            }
            ++i;
        }
    }

    protected boolean seedPieceRecheck(DownloadManager manager) {
        if (manager.getState() != 60) {
            return false;
        }
        return manager.seedPieceRecheck();
    }

    protected DownloadManagerInitialisationAdapter getDMAdapter(DownloadManagerInitialisationAdapter adapter) {
        List<DownloadManagerInitialisationAdapter> adapters = this.dm_adapters.getList();
        adapters = new ArrayList<DownloadManagerInitialisationAdapter>(adapters);
        if (adapter != null) {
            adapters.add(adapter);
        }
        ArrayList<DownloadManagerInitialisationAdapter> tag_assigners = new ArrayList<DownloadManagerInitialisationAdapter>();
        ArrayList<DownloadManagerInitialisationAdapter> tag_processors = new ArrayList<DownloadManagerInitialisationAdapter>();
        for (DownloadManagerInitialisationAdapter a : adapters) {
            int actions = a.getActions();
            if ((actions & 1) != 0) {
                tag_assigners.add(a);
            }
            if ((actions & 2) == 0) continue;
            tag_processors.add(a);
        }
        if (tag_assigners.size() > 0 && tag_processors.size() > 0) {
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.remove(a);
            }
            int pos = adapters.indexOf(tag_assigners.get(tag_assigners.size() - 1));
            for (DownloadManagerInitialisationAdapter a : tag_processors) {
                adapters.add(++pos, a);
            }
        }
        final List<DownloadManagerInitialisationAdapter> f_adapters = adapters;
        return new DownloadManagerInitialisationAdapter(){

            @Override
            public int getActions() {
                return 0;
            }

            @Override
            public void initialised(DownloadManager manager, boolean for_seeding) {
                int i = 0;
                while (i < f_adapters.size()) {
                    try {
                        ((DownloadManagerInitialisationAdapter)f_adapters.get(i)).initialised(manager, for_seeding);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    ++i;
                }
                if (Constants.isOSX) {
                    GlobalManagerImpl.this.fixLongFileName(manager);
                }
                if (COConfigurationManager.getBooleanParameter("Rename Incomplete Files")) {
                    DiskManagerFileInfo[] fileInfos;
                    String ext = COConfigurationManager.getStringParameter("Rename Incomplete Files Extension").trim();
                    boolean use_prefix = COConfigurationManager.getBooleanParameter("Use Incomplete File Prefix");
                    DownloadManagerState state = manager.getDownloadState();
                    String existing_ext = state.getAttribute("incompfilesuffix");
                    if (ext.length() > 0 && existing_ext == null && (fileInfos = manager.getDiskManagerFileInfo()).length <= DownloadManagerStateFactory.MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE) {
                        ext = FileUtil.convertOSSpecificChars(ext, false);
                        String prefix = "";
                        if (use_prefix) {
                            try {
                                prefix = String.valueOf(Base32.encode(manager.getTorrent().getHash()).substring(0, 12).toLowerCase(Locale.US)) + "_";
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        try {
                            state.suppressStateSave(true);
                            ArrayList<Integer> from_indexes = new ArrayList<Integer>();
                            ArrayList<File> from_links = new ArrayList<File>();
                            ArrayList<File> to_links = new ArrayList<File>();
                            int i2 = 0;
                            while (i2 < fileInfos.length) {
                                DiskManagerFileInfo fileInfo2 = fileInfos[i2];
                                File base_file = fileInfo2.getFile(false);
                                File existing_link = state.getFileLink(i2);
                                if (!(existing_link == null && base_file.exists() || existing_link != null && existing_link.exists())) {
                                    File new_link;
                                    if (existing_link == null) {
                                        new_link = FileUtil.newFile(base_file.getParentFile(), String.valueOf(prefix) + base_file.getName() + ext);
                                    } else {
                                        String link_name = existing_link.getName();
                                        if (!link_name.startsWith(prefix)) {
                                            link_name = String.valueOf(prefix) + link_name;
                                        }
                                        new_link = FileUtil.newFile(existing_link.getParentFile(), String.valueOf(link_name) + ext);
                                    }
                                    from_indexes.add(i2);
                                    from_links.add(base_file);
                                    to_links.add(new_link);
                                }
                                ++i2;
                            }
                            if (from_links.size() > 0) {
                                state.setFileLinks(from_indexes, from_links, to_links);
                            }
                        }
                        finally {
                            state.setAttribute("incompfilesuffix", ext);
                            if (use_prefix) {
                                state.setAttribute("dnd_pfx", prefix);
                            }
                            state.suppressStateSave(false);
                        }
                    }
                }
            }
        };
    }

    void fixLongFileName(DownloadManager manager) {
        DiskManagerFileInfo[] fileInfos = manager.getDiskManagerFileInfo();
        DownloadManagerState state = manager.getDownloadState();
        try {
            state.suppressStateSave(true);
            int i = 0;
            while (i < fileInfos.length) {
                DiskManagerFileInfo fileInfo2 = fileInfos[i];
                File base_file = fileInfo2.getFile(false);
                File existing_link = state.getFileLink(i);
                if (existing_link == null && !base_file.exists()) {
                    String name = base_file.getName();
                    String ext = FileUtil.getExtension(name);
                    int extLength = ext.length();
                    int origLength = (name = name.substring(0, name.length() - extLength)).length();
                    if (origLength > 50) {
                        File parentFile = base_file.getParentFile();
                        parentFile.mkdirs();
                        File newFile = null;
                        boolean first = true;
                        while (name.length() > 50) {
                            try {
                                boolean redo;
                                newFile = FileUtil.newFile(parentFile, String.valueOf(name) + ext);
                                newFile.getCanonicalPath();
                                if (first) break;
                                int fixNameID = 255;
                                block8: do {
                                    redo = false;
                                    int j = 0;
                                    while (j < i) {
                                        DiskManagerFileInfo convertedFileInfo = fileInfos[j];
                                        if (newFile.equals(convertedFileInfo.getFile(true))) {
                                            while (++fixNameID < 4095) {
                                                newFile = FileUtil.newFile(parentFile, String.valueOf(name = String.valueOf(name.substring(0, name.length() - 3)) + Integer.toHexString(fixNameID)) + ext);
                                                if (newFile.equals(convertedFileInfo.getFile(true))) continue;
                                            }
                                            redo = fixNameID <= 4095;
                                            continue block8;
                                        }
                                        ++j;
                                    }
                                } while (redo);
                                if (fixNameID > 4095) break;
                                state.setFileLink(i, base_file, newFile);
                                break;
                            }
                            catch (IOException e) {
                                first = false;
                                name = name.substring(0, name.length() - 1);
                            }
                            catch (Throwable t) {
                                Debug.out(t);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        finally {
            state.suppressStateSave(false);
        }
    }

    @Override
    public void addDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.add(adapter);
    }

    @Override
    public void removeDownloadManagerInitialisationAdapter(DownloadManagerInitialisationAdapter adapter) {
        this.dm_adapters.remove(adapter);
    }

    @Override
    public Object getDownloadHistoryManager() {
        return this.download_history_manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Global Manager");
        try {
            writer.indent();
            Object object = this.managers_lock;
            synchronized (object) {
                writer.println("  managers: " + this.managers_list_cow.length);
                DownloadManager[] downloadManagerArray = this.managers_list_cow;
                int n = this.managers_list_cow.length;
                int n2 = 0;
                while (n2 < n) {
                    DownloadManager manager = downloadManagerArray[n2];
                    try {
                        writer.indent();
                        manager.generateEvidence(writer, false);
                    }
                    finally {
                        writer.exdent();
                    }
                    ++n2;
                }
            }
        }
        finally {
            writer.exdent();
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"C:\\temp\\downloads.config", "C:\\temp\\downloads-9-3-05.config", "C:\\temp\\merged.config"};
        } else if (args.length != 3) {
            System.out.println("Usage: newer_config_file older_config_file save_config_file");
            return;
        }
        try {
            Map map1 = FileUtil.readResilientFile(FileUtil.newFile(args[0], new String[0]));
            Map map2 = FileUtil.readResilientFile(FileUtil.newFile(args[1], new String[0]));
            List downloads1 = (List)map1.get("downloads");
            List downloads2 = (List)map2.get("downloads");
            HashSet<HashWrapper> torrents = new HashSet<HashWrapper>();
            for (Map m : downloads1) {
                byte[] hash = (byte[])m.get("torrent_hash");
                System.out.println("1:" + ByteFormatter.nicePrint(hash));
                torrents.add(new HashWrapper(hash));
            }
            ArrayList<Map> to_add = new ArrayList<Map>();
            for (Map m : downloads2) {
                byte[] hash = (byte[])m.get("torrent_hash");
                HashWrapper wrapper = new HashWrapper(hash);
                if (torrents.contains(wrapper)) {
                    System.out.println("-:" + ByteFormatter.nicePrint(hash));
                    continue;
                }
                System.out.println("2:" + ByteFormatter.nicePrint(hash));
                to_add.add(m);
            }
            downloads1.addAll(to_add);
            System.out.println(String.valueOf(to_add.size()) + " copied from " + args[1] + " to " + args[2]);
            FileUtil.writeResilientFile(FileUtil.newFile(args[2], new String[0]), map1);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setMainlineDHTProvider(MainlineDHTProvider provider) {
        this.provider = provider;
    }

    @Override
    public MainlineDHTProvider getMainlineDHTProvider() {
        return this.provider;
    }

    @Override
    public void statsRequest(Map request2, Map reply) {
        Core core = CoreFactory.getSingleton();
        HashMap<String, Long> glob = new HashMap<String, Long>();
        reply.put("gm", glob);
        try {
            boolean bias_up;
            glob.put("u_rate", new Long(this.stats.getDataAndProtocolSendRate()));
            glob.put("d_rate", new Long(this.stats.getDataAndProtocolReceiveRate()));
            glob.put("d_lim", new Long(TransferSpeedValidator.getGlobalDownloadRateLimitBytesPerSecond()));
            boolean auto_up = TransferSpeedValidator.isAutoSpeedActive(this) && TransferSpeedValidator.isAutoUploadAvailable(core);
            glob.put("auto_up", new Long(auto_up ? COConfigurationManager.getLongParameter("Auto Upload Speed Version") : 0L));
            long up_lim = NetworkManager.getMaxUploadRateBPSNormal();
            boolean seeding_only = NetworkManager.isSeedingOnlyUploadRate();
            glob.put("so", new Long(seeding_only ? 1 : 0));
            if (seeding_only) {
                up_lim = NetworkManager.getMaxUploadRateBPSSeedingOnly();
            }
            glob.put("u_lim", new Long(up_lim));
            SpeedManager sm = core.getSpeedManager();
            if (sm != null) {
                glob.put("u_cap", new Long(sm.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()));
                glob.put("d_cap", new Long(sm.getEstimatedDownloadCapacityBytesPerSec().getBytesPerSec()));
            }
            List<DownloadManager> dms = this.getDownloadManagers();
            int comp2 = 0;
            int incomp = 0;
            long comp_up = 0L;
            long incomp_up = 0L;
            long incomp_down = 0L;
            for (DownloadManager dm : dms) {
                int state = dm.getState();
                if (state != 60 && state != 50) continue;
                DownloadManagerStats stats2 = dm.getStats();
                if (dm.isDownloadComplete(false)) {
                    ++comp2;
                    comp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                    continue;
                }
                ++incomp;
                incomp_up += stats2.getProtocolSendRate() + stats2.getDataSendRate();
                incomp_down += stats2.getProtocolReceiveRate() + stats2.getDataReceiveRate();
            }
            glob.put("dm_i", new Long(incomp));
            glob.put("dm_c", new Long(comp2));
            glob.put("dm_i_u", new Long(incomp_up));
            glob.put("dm_i_d", new Long(incomp_down));
            glob.put("dm_c_u", new Long(comp_up));
            glob.put("nat", new Long(this.nat_status));
            boolean request_limiting = COConfigurationManager.getBooleanParameter("Use Request Limiting");
            glob.put("req_lim", new Long(request_limiting ? 1 : 0));
            if (request_limiting) {
                glob.put("req_focus", new Long(COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities") ? 1 : 0));
            }
            glob.put("bias_up", new Long((bias_up = COConfigurationManager.getBooleanParameter("Bias Upload Enable")) ? 1 : 0));
            if (bias_up) {
                glob.put("bias_slack", new Long(COConfigurationManager.getLongParameter("Bias Upload Slack KBs")));
                glob.put("bias_ulim", new Long(COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") ? 1 : 0));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class Checker
    extends AEThread {
        int loopFactor;
        private static final int waitTime = 10000;
        private int saveResumeLoopCount;
        private static final int initSaveResumeLoopCount = 6;
        private static final int natCheckLoopCount = 3;
        private static final int seedPieceCheckCount = 3;
        private static final int oneMinuteThingCount = 6;
        private final AESemaphore run_sem;

        public Checker() {
            super("Global Status Checker");
            this.saveResumeLoopCount = 30;
            this.run_sem = new AESemaphore("GM:Checker:run");
            this.loopFactor = 0;
            this.setPriority(1);
        }

        private void determineSaveResumeDataInterval() {
            int saveResumeInterval = COConfigurationManager.getIntParameter("Save Resume Interval", 5);
            if (saveResumeInterval >= 1 && saveResumeInterval <= 90) {
                this.saveResumeLoopCount = saveResumeInterval * 60000 / 10000;
            }
        }

        @Override
        public void runSupport() {
            while (true) {
                block35: {
                    try {
                        int lc;
                        ++this.loopFactor;
                        this.determineSaveResumeDataInterval();
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            GlobalManagerImpl.this.saveDownloads(true, null);
                        } else if (GlobalManagerImpl.this.loadingComplete && this.loopFactor > 6 && GlobalManagerImpl.this.needsSavingCozStateChanged > 0L) {
                            int num_downloads = GlobalManagerImpl.this.managers_list_cow.length;
                            boolean do_save = false;
                            if (num_downloads < 10) {
                                do_save = true;
                            } else {
                                long now = SystemTime.getMonotonousTime();
                                long elapsed_secs = (now - GlobalManagerImpl.this.needsSavingCozStateChanged) / 1000L;
                                boolean bl = do_save = elapsed_secs > (long)num_downloads;
                            }
                            if (do_save) {
                                GlobalManagerImpl.this.saveDownloads(true, null);
                            }
                        }
                        if (this.loopFactor % 3 == 0) {
                            GlobalManagerImpl.this.computeNATStatus();
                            GlobalManagerImpl.this.checkSeedingOnlyState();
                            GlobalManagerImpl.this.checkForceStart(false);
                        }
                        if (this.loopFactor % 3 == 0) {
                            GlobalManagerImpl.this.seedPieceRecheck();
                        }
                        if (this.loopFactor % this.saveResumeLoopCount == 0) {
                            DownloadManager[] managers;
                            DownloadManager[] elapsed_secs = managers = GlobalManagerImpl.this.managers_list_cow;
                            int n = managers.length;
                            int now = 0;
                            while (now < n) {
                                DownloadManager manager = elapsed_secs[now];
                                manager.saveResumeData();
                                ++now;
                            }
                        }
                        if (no_space_dl_restart_check_period_millis > 0 && this.loopFactor % (lc = no_space_dl_restart_check_period_millis / 10000) == 0) {
                            DownloadManager[] managers2;
                            ArrayList<DownloadManager> eligible = new ArrayList<DownloadManager>();
                            DownloadManager[] downloadManagerArray = managers2 = GlobalManagerImpl.this.managers_list_cow;
                            int n = managers2.length;
                            int elapsed_secs = 0;
                            while (elapsed_secs < n) {
                                DownloadManager manager = downloadManagerArray[elapsed_secs];
                                if (manager.getState() == 100 && !manager.isDownloadComplete(false) && !manager.isPaused() && manager.getErrorType() == 2) {
                                    eligible.add(manager);
                                }
                                ++elapsed_secs;
                            }
                            if (!eligible.isEmpty()) {
                                boolean force;
                                if (eligible.size() > 1) {
                                    Collections.sort(eligible, new Comparator<DownloadManager>(){

                                        @Override
                                        public int compare(DownloadManager o1, DownloadManager o2) {
                                            return o1.getPosition() - o2.getPosition();
                                        }
                                    });
                                }
                                DownloadManager manager = (DownloadManager)eligible.get(0);
                                Logger.log(new LogEvent(LOGID, "Restarting download '" + manager.getDisplayName() + "' to check if disk space now available"));
                                boolean bl = force = (manager.getErrorFlags() & 1) != 0;
                                if (force) {
                                    manager.setForceStart(true);
                                } else {
                                    manager.setStateQueued();
                                }
                            }
                        }
                        if (no_space_dl_pause_min_bytes > 0L) {
                            DownloadManager[] managers;
                            DownloadManager[] force = managers = GlobalManagerImpl.this.managers_list_cow;
                            int manager = managers.length;
                            int managers2 = 0;
                            while (managers2 < manager) {
                                File save_loc;
                                long avail;
                                DownloadManager manager2 = force[managers2];
                                if (manager2.getState() == 50 && (avail = FileUtil.getUsableSpace(save_loc = manager2.getSaveLocation())) >= 0L && avail < no_space_dl_pause_min_bytes) {
                                    manager2.pause(true);
                                    manager2.setStopReason("Insufficient space on '" + save_loc.getAbsolutePath() + "'");
                                }
                                ++managers2;
                            }
                        }
                        if (missing_file_dl_restart_check_period_millis > 0) {
                            DownloadManager[] managers;
                            final long now = SystemTime.getMonotonousTime();
                            ArrayList<DownloadManager> eligible = new ArrayList<DownloadManager>();
                            DownloadManager[] downloadManagerArray = managers = GlobalManagerImpl.this.managers_list_cow;
                            int n = managers.length;
                            int save_loc = 0;
                            while (save_loc < n) {
                                Long t;
                                DownloadManager manager = downloadManagerArray[save_loc];
                                if (!(manager.getState() != 100 || manager.isPaused() || manager.getErrorType() != 4 || (t = (Long)manager.getUserData(missing_file_dl_restart_key)) != null && now - t < (long)missing_file_dl_restart_check_period_millis)) {
                                    eligible.add(manager);
                                }
                                ++save_loc;
                            }
                            if (!eligible.isEmpty()) {
                                boolean force;
                                if (eligible.size() > 1) {
                                    Collections.sort(eligible, new Comparator<DownloadManager>(){

                                        @Override
                                        public int compare(DownloadManager o1, DownloadManager o2) {
                                            long e1;
                                            Long t1 = (Long)o1.getUserData(missing_file_dl_restart_key);
                                            Long t2 = (Long)o2.getUserData(missing_file_dl_restart_key);
                                            long e2 = t2 == null ? 0L : now - t2;
                                            long diff = e2 - (e1 = t1 == null ? 0L : now - t1);
                                            if (diff < 0L) {
                                                return -1;
                                            }
                                            if (diff > 0L) {
                                                return 1;
                                            }
                                            return o1.getPosition() - o2.getPosition();
                                        }
                                    });
                                }
                                DownloadManager manager = (DownloadManager)eligible.get(0);
                                manager.setUserData(missing_file_dl_restart_key, now);
                                Logger.log(new LogEvent(LOGID, "Restarting download '" + manager.getDisplayName() + "' to check if missing file(s) now available"));
                                boolean bl = force = (manager.getErrorFlags() & 1) != 0;
                                if (force) {
                                    manager.setForceStart(true);
                                } else {
                                    manager.setStateQueued();
                                }
                            }
                        }
                        if (this.loopFactor % 6 != 0) break block35;
                        try {
                            if (!HttpURLConnection.getFollowRedirects()) {
                                Debug.outNoStack("Something has set global 'follow redirects' to false!!!!");
                                HttpURLConnection.setFollowRedirects(true);
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                try {
                    this.run_sem.reserve(10000L);
                    if (!this.run_sem.isReleasedForever()) continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                    continue;
                }
                break;
            }
        }

        public void stopIt() {
            this.run_sem.releaseForever();
        }
    }

    private class DownloadStateTagger
    extends TagTypeWithState
    implements DownloadManagerListener {
        private final int[] color_default;
        private final Object main_tag_key;
        private final Object comp_tag_key;
        private final TagDownloadWithState tag_initialising;
        private final TagDownloadWithState tag_downloading;
        private final TagDownloadWithState tag_seeding;
        private final TagDownloadWithState tag_queued_downloading;
        private final TagDownloadWithState tag_queued_seeding;
        private final TagDownloadWithState tag_stopped;
        private final TagDownloadWithState tag_error;
        private final TagDownloadWithState tag_active;
        private final TagDownloadWithState tag_inactive;
        private final TagDownloadWithState tag_complete;
        private final TagDownloadWithState tag_incomplete;
        private final TagDownloadWithState tag_moving;
        private final TagDownloadWithState tag_checking;
        private final TagDownloadWithState tag_deleting;
        private final TagDownloadWithState tag_paused;
        private final TagDownloadWithState[] derived_tags;
        int user_mode;

        DownloadStateTagger(Core core) {
            super(2, 255, "tag.type.ds");
            this.color_default = new int[]{41, 140, 165};
            this.main_tag_key = new Object();
            this.comp_tag_key = new Object();
            this.user_mode = -1;
            COConfigurationManager.addAndFireParameterListener("User Mode", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    int old_mode = DownloadStateTagger.this.user_mode;
                    DownloadStateTagger.this.user_mode = COConfigurationManager.getIntParameter("User Mode");
                    if (old_mode != -1) {
                        DownloadStateTagger.this.fireChanged();
                    }
                }
            });
            this.addTagType();
            this.tag_initialising = new MyTag(0, "tag.type.ds.init", false, false, false, false, 0);
            this.tag_downloading = new MyTag(1, "tag.type.ds.down", true, true, true, true, 3);
            this.tag_seeding = new MyTag(2, "tag.type.ds.seed", true, true, false, true, 3);
            this.tag_queued_downloading = new MyTag(3, "tag.type.ds.qford", false, false, false, false, 3);
            this.tag_queued_seeding = new MyTag(4, "tag.type.ds.qfors", false, false, false, false, 3);
            this.tag_stopped = new MyTag(5, "tag.type.ds.stop", false, false, false, false, 8);
            this.tag_error = new MyTag(6, "tag.type.ds.err", false, false, false, false, 0);
            this.tag_active = new MyTag(7, "tag.type.ds.act", true, false, false, false, 3);
            this.tag_paused = new MyTag(8, "tag.type.ds.pau", false, false, false, false, 4);
            this.tag_inactive = new MyTag(9, "tag.type.ds.inact", false, false, false, false, 139);
            this.tag_complete = new MyTag(10, "tag.type.ds.comp", true, true, false, true, 139);
            this.tag_incomplete = new MyTag(11, "tag.type.ds.incomp", true, true, true, true, 139);
            this.tag_moving = new MyTag(12, "tag.type.ds.mov", false, false, false, false, 3);
            this.tag_checking = new MyTag(13, "tag.type.ds.chk", false, false, false, false, 3);
            this.tag_deleting = new MyTag(14, "tag.type.ds.del", false, false, false, false, 0);
            this.derived_tags = new TagDownloadWithState[]{this.tag_active, this.tag_inactive, this.tag_complete, this.tag_incomplete, this.tag_moving, this.tag_checking, this.tag_deleting, this.tag_paused};
            if (this.tag_active.isColorDefault()) {
                this.tag_active.setColor(new int[]{96, 160, 96});
            }
            if (this.tag_error.isColorDefault()) {
                this.tag_error.setColor(new int[]{132, 16, 58});
            }
            core.addOperationListener(new CoreOperationListener(){

                @Override
                public void operationAdded(CoreOperation operation) {
                    this.process(operation, true);
                }

                @Override
                public void operationRemoved(CoreOperation operation) {
                    this.process(operation, false);
                }

                private void process(CoreOperation operation, boolean added) {
                    int type = operation.getOperationType();
                    if (type == 6 || type == 2) {
                        CoreOperationTask task2 = operation.getTask();
                        DownloadManager dm = task2.getDownload();
                        if (dm == null) {
                            return;
                        }
                        if (type == 6) {
                            if (added) {
                                DownloadStateTagger.this.tag_checking.addTaggable(dm);
                            } else {
                                DownloadStateTagger.this.tag_checking.removeTaggable(dm);
                            }
                        } else if (added) {
                            DownloadStateTagger.this.tag_moving.addTaggable(dm);
                        } else {
                            DownloadStateTagger.this.tag_moving.removeTaggable(dm);
                        }
                    }
                }

                @Override
                public boolean operationExecuteRequest(CoreOperation operation) {
                    return false;
                }
            });
        }

        private void initialise() {
            GlobalManagerImpl.this.addListener(new GlobalManagerAdapter(){

                @Override
                public void downloadManagerAdded(DownloadManager dm) {
                    dm.addListener(DownloadStateTagger.this, true);
                }

                @Override
                public void downloadManagerRemoved(DownloadManager dm) {
                    dm.removeListener(DownloadStateTagger.this);
                    DownloadStateTagger.this.remove(dm);
                }
            });
            SimpleTimer.addPeriodicEvent("gm:ds", 10000L, new TimerEventPerformer(){

                @Override
                public void perform(TimerEvent event2) {
                    DownloadStateTagger.this.updateActive();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(DownloadManager manager, int state) {
            Tag new_tag;
            if (manager.isDestroyed()) {
                this.remove(manager);
                return;
            }
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            boolean complete = manager.isDownloadComplete(false);
            switch (state) {
                case 0: 
                case 5: 
                case 10: 
                case 20: 
                case 30: 
                case 40: {
                    if (old_tag == null) {
                        new_tag = this.tag_initialising;
                        break;
                    }
                    new_tag = old_tag;
                    break;
                }
                case 55: {
                    new_tag = old_tag;
                    break;
                }
                case 50: {
                    new_tag = this.tag_downloading;
                    break;
                }
                case 60: {
                    new_tag = this.tag_seeding;
                    break;
                }
                case 65: 
                case 70: 
                case 71: {
                    new_tag = this.tag_stopped;
                    break;
                }
                case 75: {
                    if (complete) {
                        new_tag = this.tag_queued_seeding;
                        break;
                    }
                    new_tag = this.tag_queued_downloading;
                    break;
                }
                default: {
                    new_tag = this.tag_error;
                }
            }
            if (old_tag != new_tag) {
                if (old_tag != null) {
                    old_tag.removeTaggable(manager);
                }
                new_tag.addTaggable(manager);
                manager.setUserData(this.main_tag_key, new_tag);
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    boolean was_inactive = this.tag_inactive.hasTaggable(manager);
                    if (new_tag != this.tag_seeding && new_tag != this.tag_downloading) {
                        this.tag_active.removeTaggable(manager);
                        if (!was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    } else {
                        boolean was_active = this.tag_active.hasTaggable(manager);
                        if (!was_active && !was_inactive) {
                            this.tag_inactive.addTaggable(manager);
                        }
                    }
                }
                if (new_tag == this.tag_stopped && manager.isPaused()) {
                    this.tag_paused.addTaggable(manager);
                } else if (old_tag == this.tag_stopped) {
                    this.tag_paused.removeTaggable(manager);
                }
            } else if (state == 70) {
                boolean paused = manager.isPaused();
                if (paused && !this.tag_paused.hasTaggable(manager)) {
                    this.tag_paused.addTaggable(manager);
                } else if (!paused && this.tag_paused.hasTaggable(manager)) {
                    this.tag_paused.removeTaggable(manager);
                }
            }
            Boolean was_complete = (Boolean)manager.getUserData(this.comp_tag_key);
            if (was_complete == null || was_complete != complete) {
                DownloadStateTagger downloadStateTagger = this;
                synchronized (downloadStateTagger) {
                    if (complete) {
                        if (!this.tag_complete.hasTaggable(manager)) {
                            this.tag_complete.addTaggable(manager);
                            this.tag_incomplete.removeTaggable(manager);
                        }
                    } else if (!this.tag_incomplete.hasTaggable(manager)) {
                        this.tag_incomplete.addTaggable(manager);
                        this.tag_complete.removeTaggable(manager);
                    }
                    manager.setUserData(this.comp_tag_key, complete);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateActive() {
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                IdentityHashSet<DownloadManager> active = new IdentityHashSet<DownloadManager>(this.tag_active.getTaggedDownloads());
                TagDownloadWithState[] tagDownloadWithStateArray = new TagDownloadWithState[]{this.tag_downloading, this.tag_seeding};
                int n = tagDownloadWithStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TagDownloadWithState tag = tagDownloadWithStateArray[n2];
                    for (DownloadManager dm : tag.getTaggedDownloads()) {
                        boolean is_active;
                        DownloadManagerStats stats2 = dm.getStats();
                        long total_data = stats2.getTotalDataBytesReceived() + stats2.getTotalDataBytesSent();
                        Long old = (Long)dm.getUserData(ACTIVE_KEY);
                        dm.setUserData(ACTIVE_KEY, total_data);
                        boolean bl = is_active = (stats2.getDataReceiveRate() + stats2.getDataSendRate() > 0L || old != null && old != total_data) && !dm.isDestroyed();
                        if (!is_active) continue;
                        if (!active.remove(dm)) {
                            this.tag_active.addTaggable(dm);
                            this.tag_inactive.removeTaggable(dm);
                        }
                        dm.getDownloadState().setLongAttribute("last.act.tag", SystemTime.getCurrentTime());
                    }
                    ++n2;
                }
                for (DownloadManager dm : active) {
                    this.tag_active.removeTaggable(dm);
                    if (dm.isDestroyed()) continue;
                    this.tag_inactive.addTaggable(dm);
                }
            }
        }

        void removeInitiated(DownloadManager manager) {
            this.tag_deleting.addTaggable(manager);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(DownloadManager manager) {
            Tag old_tag = (Tag)manager.getUserData(this.main_tag_key);
            if (old_tag != null) {
                old_tag.removeTaggable(manager);
            }
            DownloadStateTagger downloadStateTagger = this;
            synchronized (downloadStateTagger) {
                TagDownloadWithState[] tagDownloadWithStateArray = this.derived_tags;
                int n = this.derived_tags.length;
                int n2 = 0;
                while (n2 < n) {
                    TagDownloadWithState tag = tagDownloadWithStateArray[n2];
                    if (tag.hasTaggable(manager)) {
                        tag.removeTaggable(manager);
                    }
                    ++n2;
                }
            }
        }

        @Override
        public void downloadComplete(DownloadManager manager) {
        }

        @Override
        public void completionChanged(DownloadManager manager, boolean bCompleted) {
            this.stateChanged(manager, manager.getState());
        }

        @Override
        public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
        }

        @Override
        public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
        }

        @Override
        public int[] getColorDefault() {
            return this.color_default;
        }

        private class MyTag
        extends TagDownloadWithState {
            MyTag(int tag_id, String name, boolean do_rates, boolean do_up, boolean do_down, boolean do_bytes, int run_states) {
                super((TagTypeBase)DownloadStateTagger.this, tag_id, name, do_rates, do_up, do_down, do_bytes, run_states);
                this.setGroup(MessageText.getString("tag.type.ds"));
                this.addTag();
            }

            @Override
            protected boolean getVisibleDefault() {
                int id = this.getTagID();
                if (id >= 7 && id <= 9) {
                    return DownloadStateTagger.this.user_mode > 0;
                }
                return id == 7;
            }

            @Override
            protected boolean getCanBePublicDefault() {
                return false;
            }

            @Override
            public void removeTag() {
                throw new RuntimeException("Not Supported");
            }
        }
    }
}

