/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.history.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreComponent;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerFactory;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.download.DownloadManagerStateAttributeListener;
import com.biglybt.core.download.DownloadManagerStateFactory;
import com.biglybt.core.download.impl.DownloadManagerAdapter;
import com.biglybt.core.global.GlobalManager;
import com.biglybt.core.global.GlobalManagerAdapter;
import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.history.DownloadHistoryEvent;
import com.biglybt.core.history.DownloadHistoryListener;
import com.biglybt.core.history.DownloadHistoryManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.core.util.ListenerManager;
import com.biglybt.core.util.ListenerManagerDispatcher;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.net.magneturi.MagnetURIHandler;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.utils.search.SearchException;
import com.biglybt.pif.utils.search.SearchInstance;
import com.biglybt.pif.utils.search.SearchObserver;
import com.biglybt.pif.utils.search.SearchProvider;
import com.biglybt.pif.utils.search.SearchResult;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.utils.SearchMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadHistoryManagerImpl
implements DownloadHistoryManager {
    private static final String CONFIG_ENABLED = "Download History Enabled";
    private static final String CONFIG_ACTIVE_FILE = "dlhistorya.config";
    private static final String CONFIG_DEAD_FILE = "dlhistoryd.config";
    private static final String CONFIG_ACTIVE_SIZE = "download.history.active.size";
    private static final String CONFIG_DEAD_SIZE = "download.history.dead.size";
    private static final int UPDATE_TYPE_ACTIVE = 1;
    private static final int UPDATE_TYPE_DEAD = 16;
    private static final int UPDATE_TYPE_BOTH = 17;
    private static final Object TAG_CACHE_KEY = new Object();
    private final Core core;
    private static final TagManager tag_manager = TagManagerFactory.getTagManager();
    private final ListenerManager<DownloadHistoryListener> listeners = ListenerManager.createAsyncManager("DHM", new ListenerManagerDispatcher<DownloadHistoryListener>(){

        @Override
        public void dispatch(DownloadHistoryListener listener, int type, Object value) {
            listener.downloadHistoryEventOccurred((DownloadHistoryEvent)value);
        }
    });
    final Object lock = new Object();
    private AtomicInteger mutation_count = new AtomicInteger();
    private WeakReference<Map<Long, DownloadHistoryImpl>> history_active = new WeakReference<Object>(null);
    private WeakReference<Map<Long, DownloadHistoryImpl>> history_dead = new WeakReference<Object>(null);
    volatile int active_history_size = COConfigurationManager.getIntParameter("download.history.active.size", 0);
    volatile int dead_history_size = COConfigurationManager.getIntParameter("download.history.dead.size", 0);
    private Map<Long, DownloadHistoryImpl> active_dirty;
    private Map<Long, DownloadHistoryImpl> dead_dirty;
    TimerEvent write_pending_event;
    private long active_load_time;
    private long dead_load_time;
    private boolean history_escaped = false;
    private final Map<Long, Long> redownload_cache = new HashMap<Long, Long>();
    private volatile ByteArrayHashMap<long[]> dates_cache;
    private volatile int dates_cache_mutation_count;
    private volatile long dates_cache_last_access;
    boolean enabled;
    private static String[] NO_TAGS = new String[0];

    public DownloadHistoryManagerImpl() {
        this.core = CoreFactory.getSingleton();
        COConfigurationManager.addAndFireParameterListener(CONFIG_ENABLED, new ParameterListener(){
            private boolean first_time = true;

            @Override
            public void parameterChanged(String name) {
                DownloadHistoryManagerImpl.this.setEnabledSupport(COConfigurationManager.getBooleanParameter(name), this.first_time);
                this.first_time = false;
            }
        });
        this.core.addLifecycleListener(new CoreLifecycleAdapter(){

            @Override
            public void componentCreated(Core core, CoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager global_manager = (GlobalManager)component;
                    global_manager.addListener(new GlobalManagerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void downloadManagerAdded(DownloadManager dm) {
                            Object object = (this).DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                DownloadHistoryImpl new_dh;
                                long uid;
                                if (!(this).DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                Map<Long, DownloadHistoryImpl> active_history = DownloadHistoryManagerImpl.this.getActiveHistory();
                                DownloadHistoryImpl old_dh = active_history.put(uid = (new_dh = new DownloadHistoryImpl(active_history, dm)).getUID(), new_dh);
                                if (old_dh != null) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(old_dh, 2, 1);
                                }
                                if ((old_dh = DownloadHistoryManagerImpl.this.getDeadHistory().remove(uid)) != null) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(old_dh, 2, 16);
                                }
                                DownloadHistoryManagerImpl.this.historyUpdated(new_dh, 1, 1);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void downloadManagerRemoved(DownloadManager dm) {
                            Object object = (this).DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!(this).DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = DownloadHistoryManagerImpl.this.getActiveHistory().remove(uid);
                                if (dh != null) {
                                    Map<Long, DownloadHistoryImpl> dead_history = DownloadHistoryManagerImpl.this.getDeadHistory();
                                    dead_history.put(uid, dh);
                                    dh.setHistoryReference(dead_history);
                                    List<Tag> tags = (List<Tag>)dm.getUserData(TAG_CACHE_KEY);
                                    tags = TagUtils.sortTags((Collection<Tag>)tags);
                                    dh.setRemoved(tags);
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 17);
                                }
                            }
                        }
                    }, false);
                    global_manager.addDownloadWillBeRemovedListener((dm, b1, b2) -> {
                        try {
                            List<Tag> tags = tag_manager.getTagsForTaggable(3, (Taggable)dm);
                            dm.setUserData(TAG_CACHE_KEY, tags);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    });
                    DownloadManagerFactory.addGlobalDownloadListener(new DownloadManagerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void completionChanged(DownloadManager dm, boolean comp2) {
                            Object object = (this).DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!(this).DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = DownloadHistoryManagerImpl.this.getActiveHistory().get(uid);
                                if (dh != null && dh.updateCompleteTime(dm.getDownloadState())) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 1);
                                }
                            }
                        }
                    });
                    DownloadManagerStateFactory.addGlobalListener(new DownloadManagerStateAttributeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void attributeEventOccurred(DownloadManager dm, String attribute, int event_type) {
                            Object object = (this).DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!(this).DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = DownloadHistoryManagerImpl.this.getActiveHistory().get(uid);
                                if (dh != null && dh.updateSaveLocation(dm)) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 1);
                                }
                            }
                        }
                    }, "canosavedir", 1);
                    DownloadManagerStateFactory.addGlobalListener(new DownloadManagerStateAttributeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void attributeEventOccurred(DownloadManager dm, String attribute, int event_type) {
                            Object object = (this).DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!(this).DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = DownloadHistoryManagerImpl.this.getActiveHistory().get(uid);
                                if (dh != null && dh.updateName(dm)) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 1);
                                }
                            }
                        }
                    }, "displayname", 1);
                    if (DownloadHistoryManagerImpl.this.enabled && !FileUtil.resilientConfigFileExists(DownloadHistoryManagerImpl.CONFIG_ACTIVE_FILE)) {
                        DownloadHistoryManagerImpl.this.resetHistory();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopping(Core core) {
                Object object = DownloadHistoryManagerImpl.this.lock;
                synchronized (object) {
                    DownloadHistoryManagerImpl.this.writeHistory();
                    COConfigurationManager.setParameter(DownloadHistoryManagerImpl.CONFIG_ACTIVE_SIZE, DownloadHistoryManagerImpl.this.active_history_size);
                    COConfigurationManager.setParameter(DownloadHistoryManagerImpl.CONFIG_DEAD_SIZE, DownloadHistoryManagerImpl.this.dead_history_size);
                }
            }
        });
        if (this.enabled) {
            try {
                PluginInterface default_pi = PluginInitializer.getDefaultInterface();
                default_pi.getUtilities().registerSearchProvider(new SearchProvider(){
                    private Map<Integer, Object> properties = new HashMap<Integer, Object>();
                    {
                        this.properties.put(1, MessageText.getString("downloadhistoryview.view.heading"));
                        try {
                            URL url = MagnetURIHandler.getSingleton().registerResource(new MagnetURIHandler.ResourceProvider(){

                                @Override
                                public String getUID() {
                                    return String.valueOf(DownloadHistoryManager.class.getName()) + ".1";
                                }

                                @Override
                                public String getFileType() {
                                    return "png";
                                }

                                @Override
                                public byte[] getData() {
                                    try {
                                        InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/ui/images/sb/ic_logview.png");
                                        if (is != null) {
                                            return FileUtil.readInputStreamAsByteArray(is);
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                    return null;
                                }
                            });
                            this.properties.put(2, url.toExternalForm());
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }

                    @Override
                    public SearchInstance search(Map<String, Object> search_parameters, SearchObserver observer) throws SearchException {
                        try {
                            return DownloadHistoryManagerImpl.this.searchHistory(search_parameters, observer);
                        }
                        catch (Throwable e) {
                            throw new SearchException("Search failed", e);
                        }
                    }

                    @Override
                    public Object getProperty(int property) {
                        return this.properties.get(property);
                    }

                    @Override
                    public void setProperty(int property, Object value) {
                        this.properties.put(property, value);
                    }
                });
            }
            catch (Throwable e) {
                Debug.out("Failed to register search provider");
            }
        }
        SimpleTimer.addPeriodicEvent("DHM:timer", 60000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                Object object = DownloadHistoryManagerImpl.this.lock;
                synchronized (object) {
                    DownloadHistoryManagerImpl.this.checkDiscard();
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_ENABLED, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEnabledSupport(boolean b, boolean startup) {
        Object object = this.lock;
        synchronized (object) {
            if (this.enabled == b) {
                return;
            }
            this.enabled = b;
            if (!startup) {
                if (this.enabled) {
                    this.resetHistory();
                } else {
                    this.clearHistory();
                }
            }
        }
    }

    boolean isMonitored(DownloadManager dm) {
        if (dm.isPersistent()) {
            long flags = dm.getDownloadState().getFlags();
            return (flags & 0x210L) == 0L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFromExisting(GlobalManager global_manager) {
        if (global_manager == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List<DownloadManager> dms = global_manager.getDownloadManagers();
            Map<Long, DownloadHistoryImpl> history = this.getActiveHistory();
            if (history.size() > 0) {
                ArrayList<DownloadHistoryImpl> existing = new ArrayList<DownloadHistoryImpl>(history.values());
                history.clear();
                this.historyUpdated(new ArrayList<DownloadHistory>(existing), 2, 1);
            }
            for (DownloadManager dm : dms) {
                if (!this.isMonitored(dm)) continue;
                DownloadHistoryImpl new_dh = new DownloadHistoryImpl(history, dm);
                history.put(new_dh.getUID(), new_dh);
            }
            this.historyUpdated(new ArrayList<DownloadHistory>(history.values()), 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DownloadHistory> getHistory() {
        Object object = this.lock;
        synchronized (object) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            ArrayList<DownloadHistory> result = new ArrayList<DownloadHistory>(active.size() + dead.size());
            result.addAll(active.values());
            result.addAll(dead.values());
            return result;
        }
    }

    @Override
    public int getHistoryCount() {
        return this.active_history_size + this.dead_history_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistory(List<DownloadHistory> to_remove) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadHistory> removed = new ArrayList<DownloadHistory>(to_remove.size());
            int update_type = 0;
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            for (DownloadHistory h : to_remove) {
                long uid = h.getUID();
                DownloadHistoryImpl r = active.remove(uid);
                if (r != null) {
                    removed.add(r);
                    update_type |= 1;
                    continue;
                }
                r = dead.remove(uid);
                if (r == null) continue;
                removed.add(r);
                update_type |= 0x10;
            }
            if (removed.size() > 0) {
                this.historyUpdated(removed, 2, update_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistory() {
        Object object = this.lock;
        synchronized (object) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            int update_type = 0;
            List<DownloadHistory> entries = this.getHistory();
            if (active.size() > 0) {
                active.clear();
                update_type |= 1;
            }
            if (dead.size() > 0) {
                dead.clear();
                update_type |= 0x10;
            }
            if (update_type != 0) {
                this.historyUpdated(entries, 2, update_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHistory() {
        Object object = this.lock;
        synchronized (object) {
            this.clearHistory();
            this.syncFromExisting(this.core.getGlobalManager());
        }
    }

    @Override
    public long[] getDates(byte[] hash, boolean with_redownload) {
        this.dates_cache_last_access = SystemTime.getMonotonousTime();
        ByteArrayHashMap<long[]> cache = this.getDatesCache();
        long[] entry = cache.get(hash);
        if (entry != null) {
            long uid = entry[0];
            Long rdl = with_redownload ? this.redownload_cache.remove(uid) : this.redownload_cache.get(uid);
            long[] result = new long[]{entry[1], entry[2], entry[3], rdl == null ? 0L : rdl};
            return result;
        }
        return null;
    }

    private ByteArrayHashMap<long[]> getDatesCache() {
        ByteArrayHashMap<Object> cache = this.dates_cache;
        int mut = this.mutation_count.get();
        if (cache != null && mut == this.dates_cache_mutation_count) {
            return cache;
        }
        cache = new ByteArrayHashMap();
        List<DownloadHistory> history = this.getHistory();
        for (DownloadHistory dh : history) {
            long[] entry = new long[]{dh.getUID(), dh.getAddTime(), dh.getCompleteTime(), dh.getRemoveTime()};
            byte[] hash = dh.getTorrentHash();
            if (hash != null) {
                cache.put(hash, entry);
            }
            if ((hash = dh.getTorrentV2Hash()) == null) continue;
            cache.put(hash, entry);
        }
        this.dates_cache = cache;
        this.dates_cache_mutation_count = mut;
        this.dates_cache_last_access = SystemTime.getMonotonousTime();
        return cache;
    }

    void setRedownloading(DownloadHistory dh) {
        this.redownload_cache.put(dh.getUID(), SystemTime.getCurrentTime());
    }

    static long getUID(DownloadManager dm) {
        long lhs;
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            lhs = 0L;
        } else {
            try {
                byte[] hash = torrent.getHash();
                lhs = hash[0] << 24 & 0xFF000000 | hash[1] << 16 & 0xFF0000 | hash[2] << 8 & 0xFF00 | hash[3] & 0xFF;
            }
            catch (Throwable e) {
                lhs = 0L;
            }
        }
        long date_added = dm.getDownloadState().getLongAttribute("stats.download.added.time");
        long rhs = date_added / 1000L;
        return lhs << 32 | rhs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DownloadHistoryListener listener, boolean fire_for_existing) {
        Object object = this.lock;
        synchronized (object) {
            this.history_escaped = true;
            this.listeners.addListener(listener);
            if (fire_for_existing) {
                List<DownloadHistory> history = this.getHistory();
                this.listeners.dispatch(listener, 0, new DownloadHistoryEventImpl(1, history));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloadHistoryListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.removeListener(listener);
            if (this.listeners.size() == 0L) {
                this.history_escaped = false;
            }
        }
    }

    Map<Long, DownloadHistoryImpl> getActiveHistory() {
        Map<Long, DownloadHistoryImpl> ref = (Map<Long, DownloadHistoryImpl>)this.history_active.get();
        if (ref == null) {
            ref = this.loadHistory(CONFIG_ACTIVE_FILE);
            this.active_load_time = SystemTime.getMonotonousTime();
            this.history_active = new WeakReference<Map<Long, DownloadHistoryImpl>>(ref);
            this.active_history_size = ref.size();
        }
        return ref;
    }

    Map<Long, DownloadHistoryImpl> getDeadHistory() {
        Map<Long, DownloadHistoryImpl> ref = (Map<Long, DownloadHistoryImpl>)this.history_dead.get();
        if (ref == null) {
            ref = this.loadHistory(CONFIG_DEAD_FILE);
            this.dead_load_time = SystemTime.getMonotonousTime();
            this.history_dead = new WeakReference<Map<Long, DownloadHistoryImpl>>(ref);
            this.dead_history_size = ref.size();
        }
        return ref;
    }

    void historyUpdated(DownloadHistory dh, int action, int type) {
        ArrayList<DownloadHistory> list = new ArrayList<DownloadHistory>(1);
        list.add(dh);
        this.historyUpdated(list, action, type);
    }

    private void historyUpdated(Collection<DownloadHistory> list, int action, int type) {
        this.mutation_count.incrementAndGet();
        if ((type & 1) != 0) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            this.active_history_size = active.size();
            this.active_dirty = active;
        }
        if ((type & 0x10) != 0) {
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            this.dead_history_size = dead.size();
            this.dead_dirty = dead;
        }
        if (this.write_pending_event == null) {
            this.write_pending_event = SimpleTimer.addEvent("DHL:write", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    Object object = DownloadHistoryManagerImpl.this.lock;
                    synchronized (object) {
                        DownloadHistoryManagerImpl.this.write_pending_event = null;
                        DownloadHistoryManagerImpl.this.writeHistory();
                    }
                }
            });
        }
        this.listeners.dispatch(0, new DownloadHistoryEventImpl(action, new ArrayList<DownloadHistory>(list)));
    }

    void checkDiscard() {
        long now = SystemTime.getMonotonousTime();
        if (now - this.dates_cache_last_access > 60000L) {
            this.dates_cache = null;
        }
        if (this.history_escaped) {
            return;
        }
        if (now - this.active_load_time > 30000L && this.active_dirty == null && this.history_active.get() != null) {
            this.history_active.clear();
        }
        if (now - this.dead_load_time > 30000L && this.dead_dirty == null && this.history_dead.get() != null) {
            this.history_dead.clear();
        }
    }

    void writeHistory() {
        if (this.active_dirty != null) {
            this.saveHistory(CONFIG_ACTIVE_FILE, this.active_dirty);
            this.active_dirty = null;
        }
        if (this.dead_dirty != null) {
            this.saveHistory(CONFIG_DEAD_FILE, this.dead_dirty);
            this.dead_dirty = null;
        }
    }

    private Map<Long, DownloadHistoryImpl> loadHistory(String file) {
        HashMap<Long, DownloadHistoryImpl> result = new HashMap<Long, DownloadHistoryImpl>();
        try {
            if (FileUtil.resilientConfigFileExists(file)) {
                Map map = FileUtil.readResilientConfigFile(file);
                List list = (List)map.get("records");
                for (Map m : list) {
                    try {
                        DownloadHistoryImpl record = new DownloadHistoryImpl(result, m);
                        result.put(record.getUID(), record);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return result;
    }

    private void saveHistory(String file, Map<Long, DownloadHistoryImpl> records) {
        try {
            HashMap map = new HashMap();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(records.size());
            map.put("records", list);
            for (DownloadHistoryImpl record : records.values()) {
                try {
                    Map<String, Object> m = record.exportToMap();
                    list.add(m);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            FileUtil.writeResilientConfigFile(file, map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    public SearchInstance searchHistory(Map<String, Object> search_parameters, final SearchObserver observer) throws SearchException {
        final String term = (String)search_parameters.get("s");
        final SearchInstance si = new SearchInstance(){

            @Override
            public void cancel() {
                Debug.out("Cancelled");
            }
        };
        if (term == null) {
            try {
                observer.complete();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            new AEThread2("DownloadHistory:search", true){

                @Override
                public void run() {
                    try {
                        try {
                            List<DownloadHistory> history = DownloadHistoryManagerImpl.this.getHistory();
                            SearchMatcher matcher = new SearchMatcher(term);
                            ByteArrayHashMap<String> hashes = new ByteArrayHashMap<String>();
                            for (DownloadHistory entry : history) {
                                if (!matcher.matches(entry.getName())) continue;
                                byte[] hash = entry.getTorrentHash();
                                if (hash != null) {
                                    if (hashes.containsKey(hash)) continue;
                                    hashes.put(hash, "");
                                }
                                final Map<Integer, Object> result_properties = entry.toPropertyMap();
                                SearchResult search_result = new SearchResult(){

                                    @Override
                                    public Object getProperty(int property_name) {
                                        return result_properties.get(property_name);
                                    }
                                };
                                try {
                                    observer.resultReceived(si, search_result);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            observer.complete();
                        }
                    }
                    finally {
                        observer.complete();
                    }
                }
            }.start();
        }
        return si;
    }

    static /* synthetic */ String[] access$0() {
        return NO_TAGS;
    }

    private static class DownloadHistoryEventImpl
    implements DownloadHistoryEvent {
        private final int type;
        private final List<DownloadHistory> history;

        DownloadHistoryEventImpl(int _type, List<DownloadHistory> _history) {
            this.type = _type;
            this.history = _history;
        }

        @Override
        public int getEventType() {
            return this.type;
        }

        @Override
        public List<DownloadHistory> getHistory() {
            return this.history;
        }
    }

    private class DownloadHistoryImpl
    implements DownloadHistory {
        private final long uid;
        private final byte[] hash;
        private final byte[] hash_v2;
        private final long size;
        private final long add_time;
        private String name;
        private String save_location;
        private String[] tags = DownloadHistoryManagerImpl.access$0();
        private long complete_time = 0L;
        private long remove_time = 0L;
        private Map<Long, DownloadHistoryImpl> history_ref;

        DownloadHistoryImpl(Map<Long, DownloadHistoryImpl> _history_ref, DownloadManager dm) {
            this.history_ref = _history_ref;
            this.uid = DownloadHistoryManagerImpl.getUID(dm);
            byte[] h1 = null;
            byte[] h2 = null;
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                try {
                    h1 = torrent.getFullHash(1);
                    if (h1 == null) {
                        h1 = torrent.getHash();
                    }
                    h2 = torrent.getFullHash(3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.hash = h1;
            this.hash_v2 = h2;
            this.name = dm.getDisplayName();
            this.size = dm.getSize();
            this.save_location = dm.getSaveLocation().getAbsolutePath();
            DownloadManagerState dms = dm.getDownloadState();
            this.add_time = dms.getLongParameter("stats.download.added.time");
            this.updateCompleteTime(dms);
        }

        DownloadHistoryImpl(Map<Long, DownloadHistoryImpl> _history_ref, Map<String, Object> map) throws IOException {
            this.history_ref = _history_ref;
            try {
                List l_tags;
                this.uid = (Long)map.get("u");
                this.hash = (byte[])map.get("h");
                this.hash_v2 = (byte[])map.get("v");
                this.name = new String((byte[])map.get("n"), Constants.UTF_8);
                this.save_location = new String((byte[])map.get("s"), Constants.UTF_8);
                Long l_size = (Long)map.get("z");
                this.size = l_size == null ? 0L : l_size;
                this.add_time = (Long)map.get("a");
                this.complete_time = (Long)map.get("c");
                if (this.complete_time < 0L) {
                    this.complete_time = 0L;
                }
                this.remove_time = (Long)map.get("r");
                if (this.remove_time < 0L) {
                    this.remove_time = 0L;
                }
                if ((l_tags = (List)map.get("t")) != null) {
                    this.tags = new String[l_tags.size()];
                    int i = 0;
                    while (i < l_tags.size()) {
                        this.tags[i] = new String((byte[])l_tags.get(i), Constants.UTF_8);
                        ++i;
                    }
                }
            }
            catch (Throwable e) {
                throw new IOException("History decode failed: " + Debug.getNestedExceptionMessage(e));
            }
        }

        void setHistoryReference(Map<Long, DownloadHistoryImpl> ref) {
            this.history_ref = ref;
        }

        Map<String, Object> exportToMap() throws IOException {
            LightHashMap<String, Object> map = new LightHashMap<String, Object>();
            map.put("u", this.uid);
            map.put("h", this.hash);
            if (this.hash_v2 != null) {
                map.put("v", this.hash_v2);
            }
            map.put("n", this.name.getBytes(Constants.UTF_8));
            map.put("z", this.size);
            map.put("s", this.save_location.getBytes(Constants.UTF_8));
            map.put("a", this.add_time);
            map.put("c", this.complete_time);
            map.put("r", this.remove_time);
            if (this.tags != null && this.tags.length > 0) {
                ArrayList<byte[]> l_tags = new ArrayList<byte[]>();
                String[] stringArray = this.tags;
                int n = this.tags.length;
                int n2 = 0;
                while (n2 < n) {
                    String tag = stringArray[n2];
                    l_tags.add(tag.getBytes(Constants.UTF_8));
                    ++n2;
                }
                map.put("t", l_tags);
            }
            return map;
        }

        @Override
        public Map<Integer, Object> toPropertyMap() {
            HashMap<Integer, Object> result = new HashMap<Integer, Object>();
            result.put(1, this.name);
            result.put(3, this.size);
            result.put(21, this.hash);
            result.put(2, new Date(this.add_time));
            if (this.hash != null) {
                String magnet = UrlUtils.getMagnetURI(this.hash, this.getTorrentV2Hash(), this.getName(), null);
                if (this.tags != null && this.tags.length > 0) {
                    result.put(25, this.tags);
                    String[] stringArray = this.tags;
                    int n = this.tags.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String tag = stringArray[n2];
                        magnet = String.valueOf(magnet) + "&tag=" + UrlUtils.encode(tag);
                        ++n2;
                    }
                }
                result.put(23, magnet);
            }
            return result;
        }

        boolean updateCompleteTime(DownloadManagerState dms) {
            long old_time = this.complete_time;
            long comp2 = dms.getLongAttribute("complt");
            if (comp2 == 0L) {
                comp2 = dms.getLongParameter("stats.download.completed.time");
            }
            if (comp2 < 0L) {
                comp2 = 0L;
            }
            if (comp2 != old_time) {
                this.complete_time = comp2;
                return true;
            }
            return false;
        }

        boolean updateSaveLocation(DownloadManager dm) {
            String old_location = this.save_location;
            String loc = dm.getSaveLocation().getAbsolutePath();
            if (!loc.equals(old_location)) {
                this.save_location = loc;
                return true;
            }
            return false;
        }

        boolean updateName(DownloadManager dm) {
            String name2 = dm.getDisplayName();
            if (!this.name.equals(name2)) {
                this.name = name2;
                return true;
            }
            return false;
        }

        @Override
        public long getUID() {
            return this.uid;
        }

        @Override
        public byte[] getTorrentHash() {
            return this.hash;
        }

        @Override
        public byte[] getTorrentV2Hash() {
            return this.hash_v2;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public String getSaveLocation() {
            return this.save_location;
        }

        @Override
        public long getAddTime() {
            return this.add_time;
        }

        @Override
        public long getCompleteTime() {
            return this.complete_time;
        }

        @Override
        public String[] getTags() {
            return this.tags;
        }

        void setRemoved(List<Tag> removal_tags) {
            this.remove_time = SystemTime.getCurrentTime();
            if (removal_tags != null && !removal_tags.isEmpty()) {
                this.tags = new String[removal_tags.size()];
                int i = 0;
                while (i < removal_tags.size()) {
                    this.tags[i] = removal_tags.get(i).getTagName(true);
                    ++i;
                }
            }
        }

        @Override
        public long getRemoveTime() {
            return this.remove_time;
        }

        @Override
        public void setRedownloading() {
            DownloadHistoryManagerImpl.this.setRedownloading(this);
        }
    }
}

