/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.instancemanager.impl;

import com.biglybt.core.instancemanager.ClientInstance;
import com.biglybt.core.instancemanager.ClientInstanceManagerListener;
import com.biglybt.core.instancemanager.ClientInstanceTracked;
import com.biglybt.core.instancemanager.impl.ClientInstanceManagerImpl;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.Logger;
import java.net.InetAddress;

public class ClientPortClashHandler
implements ClientInstanceManagerListener {
    private final ClientInstance my_instance;
    private int last_warned_tcp;
    private int last_warned_udp;
    private int last_warned_udp2;

    protected ClientPortClashHandler(ClientInstanceManagerImpl inst_man) {
        this.my_instance = inst_man.getMyInstance();
        inst_man.addListener(this);
    }

    protected void check(ClientInstance instance) {
        if (instance == this.my_instance) {
            return;
        }
        InetAddress my_ext = this.my_instance.getExternalAddress();
        InetAddress other_ext = instance.getExternalAddress();
        if (my_ext.isLoopbackAddress() || other_ext.isLoopbackAddress() || my_ext.equals(other_ext)) {
            String warning = null;
            int my_tcp = this.my_instance.getTCPListenPort();
            if (my_tcp != 0 && my_tcp != this.last_warned_tcp && my_tcp == instance.getTCPListenPort()) {
                warning = "TCP " + my_tcp;
                this.last_warned_tcp = my_tcp;
            }
            int my_udp = this.my_instance.getUDPListenPort();
            int my_udp2 = this.my_instance.getUDPNonDataListenPort();
            int other_udp = instance.getUDPListenPort();
            int other_udp2 = instance.getUDPNonDataListenPort();
            if (my_udp != 0 && my_udp != this.last_warned_udp && (my_udp == other_udp || my_udp == other_udp2)) {
                warning = String.valueOf(warning == null ? "" : String.valueOf(warning) + ", ") + "UDP " + my_udp;
                this.last_warned_udp = my_udp;
            }
            if (my_udp != my_udp2 && my_udp2 != 0 && my_udp2 != this.last_warned_udp2 && (my_udp2 == other_udp || my_udp2 == other_udp2)) {
                warning = String.valueOf(warning == null ? "" : String.valueOf(warning) + ", ") + "UDP " + my_udp2;
                this.last_warned_udp2 = my_udp2;
            }
            if (warning != null) {
                Logger.logTextResource(new LogAlert(true, 1, "azinstancehandler.alert.portclash"), new String[]{warning, String.valueOf(10000), String.valueOf(65535)});
            }
        }
    }

    @Override
    public void instanceFound(ClientInstance instance) {
        this.check(instance);
    }

    @Override
    public void instanceChanged(ClientInstance instance) {
        this.check(instance);
    }

    @Override
    public void instanceLost(ClientInstance instance) {
    }

    @Override
    public void instanceTracked(ClientInstanceTracked instance) {
    }
}

