/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.internat;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.LocaleUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.internat.LocaleUtilDecoderCandidate;
import com.biglybt.core.internat.LocaleUtilEncodingException;
import com.biglybt.core.internat.LocaleUtilListener;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.TorrentUtils;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class LocaleTorrentUtil {
    private static final List<LocaleUtilListener> listeners = new ArrayList<LocaleUtilListener>();

    public static LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent torrent) {
        LocaleUtilDecoder[] all_decoders;
        String canonical_name;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding == null) {
            return null;
        }
        if ("utf8 keys".equals(encoding)) {
            encoding = "utf8";
        }
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        try {
            LocaleUtilDecoder fallback_decoder = localeUtil.getFallBackDecoder();
            canonical_name = encoding.equals(fallback_decoder.getName()) ? encoding : Charset.forName(encoding).name();
        }
        catch (Throwable e) {
            canonical_name = encoding;
        }
        LocaleUtilDecoder[] localeUtilDecoderArray = all_decoders = localeUtil.getDecoders();
        int n = all_decoders.length;
        int n2 = 0;
        while (n2 < n) {
            LocaleUtilDecoder decoder = localeUtilDecoderArray[n2];
            if (decoder.getName().equals(canonical_name)) {
                return decoder;
            }
            ++n2;
        }
        return null;
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent) throws TOTorrentException {
        return LocaleTorrentUtil.getTorrentEncoding(torrent, true, false);
    }

    public static boolean canChangeTorrentEncoding(TOTorrent torrent) {
        String encoding = torrent.getAdditionalStringProperty("encoding");
        return !"utf8 keys".equals(encoding);
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent, boolean saveToFileAllowed, boolean forcePrompt) throws TOTorrentException {
        LocaleUtilDecoder decoder;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if ("utf8 keys".equals(encoding)) {
            forcePrompt = false;
        }
        if (!forcePrompt && (decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent)) != null) {
            return decoder;
        }
        boolean bSaveToFile = saveToFileAllowed;
        try {
            bSaveToFile &= TorrentUtils.getTorrentFileName(torrent) != null;
        }
        catch (Throwable e) {
            bSaveToFile = false;
        }
        List<LocaleUtilDecoderCandidate> candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        LocaleUtilDecoder selected_decoder = null;
        int min_length = Integer.MAX_VALUE;
        int utf8_length = Integer.MAX_VALUE;
        LocaleUtilDecoder utf8_decoder = null;
        for (LocaleUtilDecoderCandidate candidate : candidates) {
            LocaleUtilDecoder decoder2;
            String name;
            String val = candidate.getValue();
            if (val == null) continue;
            int len = val.length();
            if (len < min_length) {
                min_length = len;
            }
            if (!(name = (decoder2 = candidate.getDecoder()).getName().toUpperCase(Locale.US)).equals("UTF-8") && !name.equals("UTF8")) continue;
            utf8_length = len;
            utf8_decoder = decoder2;
        }
        if (utf8_decoder != null && utf8_length == min_length) {
            selected_decoder = utf8_decoder;
        } else {
            String default_name = COConfigurationManager.getStringParameter("File.Decoder.Default", "");
            if (default_name.length() > 0) {
                for (LocaleUtilDecoderCandidate localeUtilDecoderCandidate : candidates) {
                    LocaleUtilDecoder decoder3 = localeUtilDecoderCandidate.getDecoder();
                    if (localeUtilDecoderCandidate.getValue() == null || !decoder3.getName().equals(default_name)) continue;
                    selected_decoder = decoder3;
                    break;
                }
            }
        }
        if (selected_decoder == null || forcePrompt) {
            LocaleUtilDecoder decoder4;
            for (LocaleUtilListener listener : listeners) {
                try {
                    LocaleUtilDecoderCandidate candidate = listener.selectDecoder(localeUtil, torrent, candidates, forcePrompt);
                    if (candidate == null) continue;
                    selected_decoder = candidate.getDecoder();
                    break;
                }
                catch (Throwable candidate) {
                    // empty catch block
                }
            }
            if (forcePrompt && selected_decoder == null && (decoder4 = LocaleTorrentUtil.getTorrentEncodingIfAvailable(torrent)) != null) {
                return decoder4;
            }
        }
        if (selected_decoder == null) {
            bSaveToFile = false;
            boolean system_decoder_is_valid = false;
            LocaleUtilDecoder localeUtilDecoder = localeUtil.getSystemDecoder();
            for (LocaleUtilDecoderCandidate candidate : candidates) {
                if (candidate.getDecoder() != localeUtilDecoder) continue;
                system_decoder_is_valid = true;
                break;
            }
            selected_decoder = system_decoder_is_valid ? localeUtil.getSystemDecoder() : localeUtil.getFallBackDecoder();
        }
        torrent.setAdditionalStringProperty("encoding", selected_decoder.getName());
        if (bSaveToFile) {
            TorrentUtils.writeToFile(torrent);
        }
        return selected_decoder;
    }

    protected static List<LocaleUtilDecoderCandidate> getTorrentCandidates(TOTorrent torrent) {
        byte[] created;
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        byte[] torrentName = torrent.getName();
        List<LocaleUtilDecoderCandidate> candidateList = localeUtil.getCandidates(torrentName);
        long lMinCandidates = candidateList.size();
        byte[] minCandidatesArray = torrentName;
        TOTorrentFile[] files = torrent.getFiles();
        ByteArrayHashMap<String> tested = new ByteArrayHashMap<String>();
        TOTorrentFile[] tOTorrentFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TOTorrentFile file = tOTorrentFileArray[n2];
            byte[][] comps = file.getPathComponents();
            int last_comp = comps.length - 1;
            int i = 0;
            while (i <= last_comp) {
                block14: {
                    List<LocaleUtilDecoderCandidate> candidateDecoders;
                    byte[] comp2;
                    block13: {
                        comp2 = comps[i];
                        if (i == last_comp) break block13;
                        if (tested.containsKey(comp2)) break block14;
                        tested.put(comp2, "");
                    }
                    if ((long)(candidateDecoders = localeUtil.getCandidates(comp2)).size() < lMinCandidates) {
                        lMinCandidates = candidateDecoders.size();
                        minCandidatesArray = comp2;
                    }
                    LocaleTorrentUtil.retainAll(candidateList, candidateDecoders);
                }
                ++i;
            }
            ++n2;
        }
        byte[] comment = torrent.getComment();
        if (comment != null) {
            List<LocaleUtilDecoderCandidate> candidateDecoders = localeUtil.getCandidates(comment);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = comment;
            }
            LocaleTorrentUtil.retainAll(candidateList, candidateDecoders);
        }
        if ((created = torrent.getCreatedBy()) != null) {
            List<LocaleUtilDecoderCandidate> candidateDecoders = localeUtil.getCandidates(created);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = created;
            }
            LocaleTorrentUtil.retainAll(candidateList, candidateDecoders);
        }
        if (candidateList.isEmpty()) {
            candidateList = localeUtil.getCandidates(minCandidatesArray);
        }
        int i = 0;
        while (i < candidateList.size()) {
            LocaleUtilDecoderCandidate candidate = candidateList.get(i);
            if (candidate.getDecoder().getName().equals("UTF-8")) {
                if (i <= 0) break;
                candidateList.remove(i);
                candidateList.add(0, candidate);
                break;
            }
            ++i;
        }
        return candidateList;
    }

    private static void retainAll(List<LocaleUtilDecoderCandidate> listToModify, List<LocaleUtilDecoderCandidate> list) {
        Iterator<LocaleUtilDecoderCandidate> it = listToModify.iterator();
        boolean caused_removal = false;
        while (it.hasNext()) {
            LocaleUtilDecoderCandidate candidate = it.next();
            if (candidate == null) continue;
            boolean found = false;
            for (LocaleUtilDecoderCandidate candidate2 : list) {
                if (candidate.getIndex() != candidate2.getIndex()) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
            caused_removal = true;
        }
        if (caused_removal) {
            for (LocaleUtilDecoderCandidate rem : listToModify) {
                if (rem == null) continue;
                for (LocaleUtilDecoderCandidate candidate2 : list) {
                    if (rem.getIndex() != candidate2.getIndex()) continue;
                    rem.setDetails(rem.getDecoder(), String.valueOf(rem.getValue()) + "; " + candidate2.getValue());
                }
            }
        }
    }

    public static void setTorrentEncoding(TOTorrent torrent, String encoding) throws LocaleUtilEncodingException {
        try {
            String canonical_requested_name;
            LocaleUtil localeUtil = LocaleUtil.getSingleton();
            List<LocaleUtilDecoderCandidate> candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
            if (encoding.equalsIgnoreCase("system")) {
                canonical_requested_name = localeUtil.getSystemEncoding().name();
            } else if (encoding.equalsIgnoreCase("Fallback")) {
                canonical_requested_name = "Fallback";
            } else {
                CharsetDecoder requested_decoder = Charset.forName(encoding).newDecoder();
                canonical_requested_name = requested_decoder.charset().name();
            }
            boolean ok = false;
            for (LocaleUtilDecoderCandidate candidate : candidates) {
                if (!candidate.getDecoder().getName().equals(canonical_requested_name)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                String[] charsets = new String[candidates.size()];
                String[] names = new String[candidates.size()];
                int i = 0;
                while (i < candidates.size()) {
                    LocaleUtilDecoder decoder = candidates.get(i).getDecoder();
                    charsets[i] = decoder.getName();
                    names[i] = decoder.decodeString(torrent.getName());
                    ++i;
                }
                throw new LocaleUtilEncodingException(charsets, names);
            }
            torrent.setAdditionalStringProperty("encoding", canonical_requested_name);
        }
        catch (Throwable e) {
            if (e instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)e;
            }
            throw new LocaleUtilEncodingException(e);
        }
    }

    public static void setDefaultTorrentEncoding(TOTorrent torrent) throws LocaleUtilEncodingException {
        LocaleTorrentUtil.setTorrentEncoding(torrent, Constants.DEFAULT_ENCODING_CHARSET.name());
    }

    public static String getCurrentTorrentEncoding(TOTorrent torrent) {
        return torrent.getAdditionalStringProperty("encoding");
    }

    public static void addListener(LocaleUtilListener l) {
        listeners.add(l);
    }

    public static void removeListener(LocaleUtilListener l) {
        listeners.remove(l);
    }
}

