/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipchecker.extipchecker.impl;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.internat.StringSupplier;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerService;
import com.biglybt.core.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.clientid.ClientIDException;
import com.biglybt.pifimpl.local.clientid.ClientIDManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;

public abstract class ExternalIPCheckerServiceImpl
implements ExternalIPCheckerService,
Cloneable {
    private static final int MAX_PAGE_SIZE = 4096;
    private final String name;
    private final StringSupplier description;
    private final String url;
    boolean completed;
    private final Vector listeners = new Vector();
    private final AEMonitor this_mon = new AEMonitor("ExtIPCheckServ");
    final AESemaphore timeout_sem = new AESemaphore("ExtIPCheckServ");

    protected ExternalIPCheckerServiceImpl(String serviceName, String serviceUrl, StringSupplier serviceDescription) {
        this.name = serviceName;
        this.description = serviceDescription;
        this.url = serviceUrl;
    }

    @Override
    public void initiateCheck(long timeout) {
        this._clone().initiateCheckSupport(timeout);
    }

    protected ExternalIPCheckerServiceImpl _clone() {
        try {
            return (ExternalIPCheckerServiceImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void initiateCheckSupport(final long timeout) {
        AEThread t = new AEThread("IPChecker"){

            @Override
            public void runSupport() {
                try {
                    ExternalIPCheckerServiceImpl.this.initiateCheckSupport();
                }
                finally {
                    ExternalIPCheckerServiceImpl.this.setComplete();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        if (timeout > 0L) {
            AEThread t2 = new AEThread("IPChecker2"){

                @Override
                public void runSupport() {
                    try {
                        if (!ExternalIPCheckerServiceImpl.this.timeout_sem.reserve(timeout) && !ExternalIPCheckerServiceImpl.this.completed) {
                            ExternalIPCheckerServiceImpl.this.informFailure("IPChecker.external.timeout");
                            ExternalIPCheckerServiceImpl.this.setComplete();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            };
            t2.setDaemon(true);
            t2.start();
        }
    }

    protected abstract void initiateCheckSupport();

    protected void setComplete() {
        this.completed = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String loadPage(URL url) {
        try {
            byte[] buffer;
            int len;
            String page;
            HttpURLConnection connection = null;
            InputStream is = null;
            Properties http_properties = new Properties();
            http_properties.put("URL", url);
            try {
                ClientIDManagerImpl.getSingleton().generateHTTPProperties(null, http_properties);
            }
            catch (ClientIDException e) {
                throw new IOException(e.getMessage());
            }
            url = (URL)http_properties.get("URL");
            connection = (HttpURLConnection)url.openConnection();
            int response = connection.getResponseCode();
            if (response == 202 || response == 200) {
                is = connection.getInputStream();
                page = "";
            } else {
                this.informFailure("IPChecker.external.httpinvalidresponse", String.valueOf(response));
                return null;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            while ((len = is.read(buffer = new byte[2048])) >= 0) {
                page = String.valueOf(page) + new String(buffer, 0, len);
                if (page.length() < 4096) continue;
            }
            String string = page;
            return string;
        }
        catch (Throwable e) {
            this.informFailure("IPChecker.external.httploadfail", e.toString());
            return null;
        }
    }

    protected String extractIPAddress(String str) {
        int pos = 0;
        while (pos < str.length()) {
            int p1 = str.indexOf(46, pos);
            if (p1 == -1) {
                this.informFailure("IPChecker.external.ipnotfound");
                return null;
            }
            if (p1 > 0 && Character.isDigit(str.charAt(p1 - 1))) {
                int p2 = p1 - 1;
                while (p2 >= 0 && Character.isDigit(str.charAt(p2))) {
                    --p2;
                }
                int p3 = ++p2 + 1;
                int dots = 0;
                while (p3 < str.length()) {
                    char c = str.charAt(p3);
                    if (c == '.') {
                        ++dots;
                    } else if (!Character.isDigit(c)) break;
                    ++p3;
                }
                if (dots == 3) {
                    return str.substring(p2, p3);
                }
            }
            pos = p1 + 1;
        }
        this.informFailure("IPChecker.external.ipnotfound");
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description.get();
    }

    @Override
    public String getURL() {
        return this.url;
    }

    protected void informSuccess(String ip) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                int i = 0;
                while (i < this.listeners.size()) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkComplete(this, ip);
                    ++i;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void informFailure(String msg_key) {
        try {
            this.this_mon.enter();
            this.informFailure(msg_key, null);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void informFailure(String msg_key, String extra) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                String message = MessageText.getString(msg_key);
                if (extra != null) {
                    message = String.valueOf(message) + ": " + extra;
                }
                int i = 0;
                while (i < this.listeners.size()) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkFailed(this, message);
                    ++i;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void reportProgress(String msg_key) {
        try {
            this.this_mon.enter();
            this.reportProgress(msg_key, null);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void reportProgress(String msg_key, Object extra) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                String message = MessageText.getString(msg_key);
                if (extra != null) {
                    message = String.valueOf(message) + ": " + extra;
                }
                int i = 0;
                while (i < this.listeners.size()) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).reportProgress(this, message);
                    ++i;
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void addListener(ExternalIPCheckerServiceListener l) {
        try {
            this.this_mon.enter();
            this.listeners.addElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void removeListener(ExternalIPCheckerServiceListener l) {
        try {
            this.this_mon.enter();
            this.listeners.removeElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected static URL url(String urlSpec) {
        try {
            return new URL(urlSpec);
        }
        catch (MalformedURLException e) {
            Debug.out(e);
            throw new RuntimeException(e);
        }
    }
}

