/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.ipfilter.impl;

import com.biglybt.core.ipfilter.impl.IpRangeV4Impl;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.tracker.protocol.PRHelpers;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IdentityHashSet;
import com.biglybt.core.util.SystemTime;
import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class IPAddressRangeManagerV4 {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected final Set<IpRangeV4Impl> entries = new IdentityHashSet<IpRangeV4Impl>();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time = -1L;
    protected IpRangeV4Impl[] mergedRanges = new IpRangeV4Impl[0];
    protected final AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    protected IPAddressRangeManagerV4() {
    }

    protected void addRange(IpRangeV4Impl range) {
        try {
            this.this_mon.enter();
            this.entries.add(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected void removeRange(IpRangeV4Impl range) {
        try {
            this.this_mon.enter();
            this.entries.remove(range);
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public IpRangeV4Impl isInRange(Inet4Address ip) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            IpRangeV4Impl res;
            this.this_mon.enter();
            long address_long = PRHelpers.addressToInt(ip);
            if (address_long < 0L) {
                address_long += 0x100000000L;
            }
            IpRangeV4Impl ipRangeV4Impl = res = this.isInRange(address_long);
            return ipRangeV4Impl;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private IpRangeV4Impl isInRange(long address_long) {
        try {
            IpRangeV4Impl e;
            this.this_mon.enter();
            this.checkRebuild();
            if (this.mergedRanges.length == 0) {
                return null;
            }
            int bottom = 0;
            int top = this.mergedRanges.length - 1;
            int current = -1;
            while (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                current = (bottom + top) / 2;
                e = this.mergedRanges[current];
                long this_start = e.getStartIpLong();
                long this_end = e.getMergedEndLong();
                if (address_long == this_start) break;
                if (address_long > this_start) {
                    if (address_long <= this_end) break;
                    bottom = current + 1;
                    continue;
                }
                if (address_long == this_end || address_long >= this_start) break;
                top = current - 1;
            }
            if (top >= 0 && bottom < this.mergedRanges.length && bottom <= top) {
                e = this.mergedRanges[current];
                if (address_long <= e.getEndIpLong()) {
                    IpRangeV4Impl ipRangeV4Impl = e;
                    return ipRangeV4Impl;
                }
                IpRangeV4Impl[] merged = e.getMergedEntries();
                if (merged == null) {
                    Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                    return null;
                }
                int i = 0;
                while (i < merged.length) {
                    IpRangeV4Impl me = merged[i];
                    if (me.getStartIpLong() <= address_long && me.getEndIpLong() >= address_long) {
                        IpRangeV4Impl ipRangeV4Impl = me;
                        return ipRangeV4Impl;
                    }
                    ++i;
                }
                Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
            }
            return null;
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void checkRebuild() {
        try {
            this.this_mon.enter();
            if (this.rebuild_required) {
                long now = SystemTime.getMonotonousTime();
                if (this.last_rebuild_time == -1L || (now - this.last_rebuild_time) / 1000L > (long)(this.entries.size() / 2000)) {
                    this.last_rebuild_time = now;
                    this.rebuild_required = false;
                    this.rebuild();
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void rebuild() {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts"));
        }
        IpRangeV4Impl[] ents = new IpRangeV4Impl[this.entries.size()];
        this.entries.toArray(ents);
        int i = 0;
        while (i < ents.length) {
            ents[i].resetMergeInfo();
            ++i;
        }
        Arrays.sort(ents, new Comparator<IpRangeV4Impl>(){

            @Override
            public int compare(IpRangeV4Impl e1, IpRangeV4Impl e2) {
                long diff = e1.getStartIpLong() - e2.getStartIpLong();
                if (diff == 0L) {
                    diff = e2.getEndIpLong() - e1.getEndIpLong();
                }
                return IPAddressRangeManagerV4.this.signum(diff);
            }
        });
        ArrayList<IpRangeV4Impl> me = new ArrayList<IpRangeV4Impl>(ents.length);
        int i2 = 0;
        while (i2 < ents.length) {
            IpRangeV4Impl entry = ents[i2];
            if (!entry.getMerged()) {
                me.add(entry);
                int pos = i2 + 1;
                while (pos < ents.length) {
                    IpRangeV4Impl e2;
                    long end_pos = entry.getMergedEndLong();
                    if ((e2 = ents[pos++]).getMerged()) continue;
                    if (end_pos < e2.getStartIpLong()) break;
                    e2.setMerged();
                    if (e2.getEndIpLong() <= end_pos) continue;
                    entry.setMergedEnd(e2.getEndIpLong());
                    entry.addMergedEntry(e2);
                }
            }
            ++i2;
        }
        this.mergedRanges = new IpRangeV4Impl[me.size()];
        me.toArray(this.mergedRanges);
        this.total_span = 0L;
        i2 = 0;
        while (i2 < this.mergedRanges.length) {
            IpRangeV4Impl e = this.mergedRanges[i2];
            long span = e.getMergedEndLong() - e.getStartIpLong() + 1L;
            this.total_span += span;
            ++i2;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends"));
        }
    }

    private int signum(long diff) {
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public static void main(String[] args) {
        IPAddressRangeManagerV4 manager = new IPAddressRangeManagerV4();
        Random r = new Random();
        int i = 0;
        while (i < 1000000) {
            int ip1 = r.nextInt(0xFFFFFFF);
            int ip2 = ip1 + r.nextInt(255);
            String start = PRHelpers.intToAddress(ip1);
            String end = PRHelpers.intToAddress(ip2);
            manager.addRange(new IpRangeV4Impl("test_" + i, start, end, true));
            ++i;
        }
        int num = 0;
        int hits = 0;
        while (true) {
            if (num % 1000 == 0) {
                System.out.println(String.valueOf(num) + "/" + hits);
            }
            ++num;
            int ip = r.nextInt();
            IpRangeV4Impl res = manager.isInRange(ip);
            if (res == null) continue;
            ++hits;
        }
    }

    protected List getEntries() {
        try {
            this.this_mon.enter();
            ArrayList<IpRangeV4Impl> arrayList = new ArrayList<IpRangeV4Impl>(this.entries);
            return arrayList;
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected int getEntryCount() {
        return this.entries.size();
    }

    protected void clearAllEntries() {
        try {
            this.this_mon.enter();
            this.entries.clear();
            this.rebuild_required = true;
        }
        finally {
            this.this_mon.exit();
        }
    }
}

