/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.logging.impl;

import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.ILogAlertListener;
import com.biglybt.core.logging.ILogEventListener;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.logging.impl.FileLogging;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsLogger;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class LoggerImpl {
    private static final int MAXHISTORY = 256;
    static final boolean bLogToStdOut = System.getProperty(SystemProperties.SYSPROP_LOG_STDOUT) != null;
    boolean bEventLoggingEnabled = false;
    private PrintStream psOldOut = null;
    private PrintStream psOldErr = null;
    private PrintStream psOut;
    private PrintStream psErr;
    private final List logListeners = new ArrayList();
    private AEDiagnosticsLogger alertLogger;
    private final List alertListeners = new ArrayList();
    private final List alertHistory = new ArrayList();
    private boolean logToStdErrAllowed = true;

    public LoggerImpl() {
        this.doRedirects();
    }

    public void init() {
        boolean overrideLog;
        this.bEventLoggingEnabled = true;
        final ConfigurationManager config = ConfigurationManager.getInstance();
        boolean bl = overrideLog = System.getProperty(SystemProperties.SYSPROP_OVERRIDELOG) != null;
        if (overrideLog) {
            this.bEventLoggingEnabled = true;
        } else {
            this.bEventLoggingEnabled = config.getBooleanParameter("Logger.Enabled");
            config.addParameterListener("Logger.Enabled", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    LoggerImpl.this.bEventLoggingEnabled = config.getBooleanParameter("Logger.Enabled");
                }
            });
        }
    }

    public void doRedirects() {
        try {
            if (System.out != this.psOut) {
                if (this.psOldOut == null) {
                    this.psOldOut = System.out;
                }
                this.psOut = new PrintStream((OutputStream)new RedirectorStream(this.psOldOut, LogIDs.STDOUT, 0), true, "utf-8");
                System.setOut(this.psOut);
            }
            if (System.err != this.psErr) {
                if (this.psOldErr == null) {
                    this.psOldErr = System.err;
                }
                this.psErr = new RedirectorPrintStream(this.psOldErr, LogIDs.STDERR, 3);
                System.setErr(this.psErr);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isEnabled() {
        return this.bEventLoggingEnabled;
    }

    public void setClosing() {
        FileLogging.setClosing();
    }

    public void log(LogEvent event2) {
        if ((bLogToStdOut || event2.logID == LogIDs.STDOUT) && this.psOldOut != null) {
            this.psOldOut.println(event2.text);
        }
        if (event2.entryType == 3) {
            if (AEDiagnostics.isStartupComplete()) {
                try {
                    Debug.outDiagLoggerOnly("[" + event2.logID + "] " + event2.text);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.logToStdErrAllowed && this.psOldErr != null) {
                if (event2.logID == LogIDs.STDERR) {
                    this.psOldErr.println(event2.text);
                } else {
                    this.psOldErr.println("[" + event2.logID + "] " + event2.text);
                }
            }
        }
        if (this.bEventLoggingEnabled) {
            int i = 0;
            while (i < this.logListeners.size()) {
                block14: {
                    try {
                        Object listener = this.logListeners.get(i);
                        if (listener instanceof ILogEventListener) {
                            ((ILogEventListener)listener).log(event2);
                        }
                    }
                    catch (Throwable e) {
                        if (!this.logToStdErrAllowed || this.psOldErr == null) break block14;
                        this.psOldErr.println("Error while logging: " + e.getMessage());
                        e.printStackTrace(this.psOldErr);
                    }
                }
                ++i;
            }
        }
        if (event2.err != null && event2.entryType == 3) {
            Debug.printStackTrace(event2.err);
        }
    }

    public void logTextResource(LogEvent event2) {
        event2.text = MessageText.getString(event2.text);
        this.log(event2);
    }

    public void logTextResource(LogEvent event2, String[] params) {
        event2.text = MessageText.getString(event2.text, params);
        this.log(event2);
    }

    public void addListener(ILogEventListener aListener) {
        this.logListeners.add(aListener);
    }

    public void removeListener(ILogEventListener aListener) {
        this.logListeners.remove(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogAlert alert) {
        String logText = "Alert:" + alert.entryType + ":" + alert.text;
        LogEvent alertEvent = new LogEvent(LogIDs.ALERT, alert.entryType, logText);
        alertEvent.err = alert.err;
        Logger.log(alertEvent);
        LoggerImpl loggerImpl = this;
        synchronized (loggerImpl) {
            if (this.alertLogger == null) {
                this.alertLogger = AEDiagnostics.getLogger("alerts");
            }
        }
        Throwable error = alert.getError();
        if (error != null) {
            logText = String.valueOf(logText) + " (" + Debug.getNestedExceptionMessageAndStack(error) + ")";
        }
        this.alertLogger.log(logText);
        List list = this.alertHistory;
        synchronized (list) {
            this.alertHistory.add(alert);
            if (this.alertHistory.size() > 256) {
                this.alertHistory.remove(0);
            }
        }
        int i = 0;
        while (i < this.alertListeners.size()) {
            block13: {
                try {
                    Object listener = this.alertListeners.get(i);
                    if (listener instanceof ILogAlertListener) {
                        ((ILogAlertListener)listener).alertRaised(alert);
                    }
                }
                catch (Throwable f) {
                    if (this.psOldErr == null) break block13;
                    this.psOldErr.println("Error while alerting: " + f.getMessage());
                    f.printStackTrace(this.psOldErr);
                }
            }
            ++i;
        }
    }

    public void logTextResource(LogAlert alert) {
        alert.text = MessageText.getString(alert.text);
        this.log(alert);
    }

    public void logTextResource(LogAlert alert, String[] params) {
        alert.text = MessageText.getString(alert.text, params);
        this.log(alert);
    }

    public void addListener(ILogAlertListener l) {
        this.alertListeners.add(l);
        int i = 0;
        while (i < this.alertHistory.size()) {
            LogAlert alert = (LogAlert)this.alertHistory.get(i);
            l.alertRaised(alert);
            ++i;
        }
    }

    public void removeListener(ILogAlertListener l) {
        this.alertListeners.remove(l);
    }

    public PrintStream getOldStdErr() {
        return this.psOldErr;
    }

    public void allowLoggingToStdErr(boolean allowed) {
        this.logToStdErrAllowed = allowed;
    }

    private class RedirectorPrintStream
    extends PrintStream {
        public RedirectorPrintStream(PrintStream ps, LogIDs logID, int logType) throws UnsupportedEncodingException {
            super((OutputStream)new RedirectorStream(ps, logID, logType), true, "utf-8");
        }
    }

    private class RedirectorStream
    extends ByteArrayOutputStream {
        private final PrintStream ps;
        private final LogIDs logID;
        private final int logType;
        private boolean flushing;

        protected RedirectorStream(PrintStream _ps, LogIDs _logID, int _logType) {
            super(80);
            this.flushing = false;
            this.ps = _ps;
            this.logType = _logType;
            this.logID = _logID;
        }

        @Override
        public synchronized void reset() {
            if (this.count > 0) {
                if (this.buf[this.count - 1] != 10) {
                    this.write(10);
                }
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            super.reset();
        }

        @Override
        public void close() throws IOException {
            this.flush();
            super.close();
        }

        @Override
        public synchronized void flush() throws IOException {
            if (this.flushing) {
                return;
            }
            try {
                this.flushing = true;
                super.flush();
                if (this.count == 0) {
                    return;
                }
                if (this.buf[this.count - 1] != 10 && this.count < 2048) {
                    return;
                }
                String s = this.toString("utf-8");
                if (s.endsWith("\r\n")) {
                    s = s.substring(0, s.length() - 2);
                } else if (s.endsWith("\n")) {
                    s = s.substring(0, s.length() - 1);
                }
                LoggerImpl.this.log(new LogEvent(this.logID, this.logType, s));
                super.reset();
            }
            finally {
                this.flushing = false;
            }
        }
    }
}

