/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.lws;

import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerCheckRequest;
import com.biglybt.core.disk.DiskManagerCheckRequestListener;
import com.biglybt.core.disk.DiskManagerFileInfo;
import com.biglybt.core.disk.DiskManagerFileInfoSet;
import com.biglybt.core.disk.DiskManagerListener;
import com.biglybt.core.disk.DiskManagerPiece;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.disk.DiskManagerReadRequestListener;
import com.biglybt.core.disk.DiskManagerWriteRequest;
import com.biglybt.core.disk.DiskManagerWriteRequestListener;
import com.biglybt.core.disk.impl.DiskManagerFileInfoImpl;
import com.biglybt.core.disk.impl.DiskManagerHelper;
import com.biglybt.core.disk.impl.DiskManagerImpl;
import com.biglybt.core.disk.impl.DiskManagerPieceImpl;
import com.biglybt.core.disk.impl.DiskManagerRecheckScheduler;
import com.biglybt.core.disk.impl.DiskManagerUtil;
import com.biglybt.core.disk.impl.access.DMAccessFactory;
import com.biglybt.core.disk.impl.access.DMChecker;
import com.biglybt.core.disk.impl.access.DMReader;
import com.biglybt.core.disk.impl.piecemapper.DMPieceList;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMap;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapper;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFactory;
import com.biglybt.core.disk.impl.piecemapper.DMPieceMapperFile;
import com.biglybt.core.diskmanager.access.DiskAccessController;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.download.DownloadManagerState;
import com.biglybt.core.internat.LocaleTorrentUtil;
import com.biglybt.core.internat.LocaleUtilDecoder;
import com.biglybt.core.lws.LWSDiskManagerState;
import com.biglybt.core.lws.LightWeightSeed;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.IndentWriter;
import java.io.File;

public class LWSDiskManager
implements DiskManagerHelper {
    private static final sePiece piece = new sePiece();
    private final LightWeightSeed lws;
    private final DiskAccessController disk_access_controller;
    private final File save_file;
    private DMReader reader;
    private DMChecker checker_use_accessor;
    private DMPieceMapper piece_mapper;
    private DMPieceMap piece_map_use_accessor;
    private final sePiece[] pieces;
    private final BitFlags availability;
    private DiskManagerFileInfoImpl[] files;
    private String internal_name;
    private final DownloadManagerState download_state;
    private boolean started;
    private int state = 1;
    private String error_message = "";
    private int error_type = 0;

    protected LWSDiskManager(LightWeightSeed _lws, File _save_file) {
        this.lws = _lws;
        this.save_file = _save_file;
        this.disk_access_controller = DiskManagerImpl.getDefaultDiskAccessController();
        this.download_state = new LWSDiskManagerState();
        TOTorrent torrent = this.lws.getTOTorrent(false);
        this.pieces = new sePiece[torrent.getNumberOfPieces()];
        int i = 0;
        while (i < this.pieces.length) {
            this.pieces[i] = piece;
            ++i;
        }
        this.availability = new BitFlags(this.pieces.length);
        this.availability.setAll();
    }

    public String getName() {
        return this.lws.getName();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public DownloadManager getDownload() {
        return null;
    }

    @Override
    public int getCacheMode() {
        return 1;
    }

    @Override
    public long[] getReadStats() {
        if (this.reader == null) {
            return new long[2];
        }
        return this.reader.getStats();
    }

    @Override
    public long[] getWriteStats() {
        return new long[4];
    }

    @Override
    public void start() {
        try {
            TOTorrent torrent = this.lws.getTOTorrent(false);
            this.internal_name = ByteFormatter.nicePrint(torrent.getHash(), true);
            LocaleUtilDecoder locale_decoder = LocaleTorrentUtil.getTorrentEncoding(torrent);
            this.piece_mapper = DMPieceMapperFactory.create(torrent);
            this.piece_mapper.construct(locale_decoder, this.save_file.getName());
            this.files = this.getFileInfo(this.piece_mapper.getFiles(), this.save_file);
            this.reader = DMAccessFactory.createReader(this);
            this.reader.start();
            if (this.state != 10) {
                this.started = true;
                this.state = 4;
            }
        }
        catch (Throwable e) {
            this.setFailed(1, "Start failed", e, false);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DiskManagerFileInfoImpl[] getFileInfo(DMPieceMapperFile[] pm_files, File save_location) {
        ok = false;
        local_files = new DiskManagerFileInfoImpl[pm_files.length];
        try {
            torrent = this.lws.getTOTorrent(false);
            if (torrent.isSimpleTorrent()) {
                save_location = save_location.getParentFile();
            }
            i = 0;
            while (true) {
                if (i >= pm_files.length) {
                    ok = true;
                    var14_13 = local_files;
                    return var14_13;
                }
                pm_info = pm_files[i];
                target_length = pm_info.getLength();
                local_files[i] = file_info = new DiskManagerFileInfoImpl(this, save_location, pm_info.getRelativeDataPath(), i, pm_info.getTorrentFile(), 1);
                cache_file = file_info.getCacheFile();
                data_file = file_info.getFile(true);
                if (!cache_file.exists()) {
                    throw new Exception("File '" + data_file + "' doesn't exist");
                }
                if (cache_file.getLength() != target_length) {
                    throw new Exception("File '" + data_file + "' doesn't exist");
                }
                pm_info.setFileInfo(file_info);
                ++i;
            }
        }
        catch (Throwable e) {
            this.setFailed(5, "getFiles failed", e, false);
        }
        finally {
            if (ok != false) return var14_13;
            i = 0;
            ** while (i < local_files.length)
        }
lbl-1000:
        // 1 sources

        {
            if (local_files[i] != null) {
                local_files[i].close();
            }
            ++i;
            continue;
        }
lbl35:
        // 1 sources

        return var14_13;
    }

    @Override
    public void setPieceDone(DiskManagerPieceImpl dmPiece, boolean done) {
    }

    @Override
    public boolean stop(boolean closing) {
        this.started = false;
        if (this.reader != null) {
            this.reader.stop();
            this.reader = null;
        }
        if (this.files != null) {
            int i = 0;
            while (i < this.files.length) {
                try {
                    this.files[i].getCacheFile().close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean isStopped() {
        return !this.started;
    }

    @Override
    public boolean filesExist() {
        throw new RuntimeException("filesExist not implemented");
    }

    @Override
    public void rateLimitChanged() {
    }

    @Override
    public DiskManagerWriteRequest createWriteRequest(int pieceNumber, int offset, DirectByteBuffer data, Object user_data) {
        throw new RuntimeException("createWriteRequest not implemented");
    }

    @Override
    public void enqueueWriteRequest(DiskManagerWriteRequest request2, DiskManagerWriteRequestListener listener) {
        throw new RuntimeException("enqueueWriteRequest not implemented");
    }

    @Override
    public boolean hasOutstandingWriteRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingWriteRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingReadRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingReadRequestForPiece not implemented");
    }

    @Override
    public boolean hasOutstandingCheckRequestForPiece(int piece_number) {
        throw new RuntimeException("hasOutstandingCheckRequestForPiece not implemented");
    }

    @Override
    public DirectByteBuffer readBlock(int pieceNumber, int offset, int length) {
        return this.reader.readBlock(pieceNumber, offset, length);
    }

    @Override
    public DiskManagerReadRequest createReadRequest(int pieceNumber, int offset, int length) {
        return this.reader.createReadRequest(pieceNumber, offset, length);
    }

    @Override
    public void enqueueReadRequest(DiskManagerReadRequest request2, DiskManagerReadRequestListener listener) {
        this.reader.readBlock(request2, listener);
    }

    @Override
    public DiskManagerCheckRequest createCheckRequest(int pieceNumber, Object user_data) {
        DMChecker checker = this.getChecker();
        return checker.createCheckRequest(pieceNumber, user_data);
    }

    @Override
    public void enqueueCheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        DMChecker checker = this.getChecker();
        checker.enqueueCheckRequest(request2, listener);
    }

    @Override
    public void enqueueCompleteRecheckRequest(DiskManagerCheckRequest request2, DiskManagerCheckRequestListener listener) {
        throw new RuntimeException("enqueueCompleteRecheckRequest not implemented");
    }

    @Override
    public void setPieceCheckingEnabled(boolean enabled) {
    }

    @Override
    public void saveResumeData(boolean interim_save) {
    }

    @Override
    public DiskManagerPiece[] getPieces() {
        return this.pieces;
    }

    @Override
    public BitFlags getAvailability() {
        return this.availability;
    }

    @Override
    public DiskManagerPiece getPiece(int index) {
        return this.pieces[index];
    }

    @Override
    public boolean isInteresting(int piece_num) {
        return false;
    }

    @Override
    public boolean isDone(int piece_num) {
        return false;
    }

    @Override
    public int getNbPieces() {
        return this.pieces.length;
    }

    @Override
    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    @Override
    public DiskManagerFileInfoSet getFileSet() {
        throw new RuntimeException("getFileSet not implemented");
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public long getTotalLength() {
        return this.piece_mapper.getTotalLength();
    }

    @Override
    public int getPieceLength() {
        return this.piece_mapper.getPieceLength();
    }

    @Override
    public int getPieceLength(int piece_number) {
        if (piece_number == this.pieces.length - 1) {
            return this.piece_mapper.getLastPieceLength();
        }
        return this.piece_mapper.getPieceLength();
    }

    public int getLastPieceLength() {
        return this.piece_mapper.getLastPieceLength();
    }

    @Override
    public long getRemaining() {
        return 0L;
    }

    @Override
    public long getRemainingExcludingDND() {
        return 0L;
    }

    @Override
    public int getPercentDone() {
        return 100;
    }

    @Override
    public int getPercentAllocated() {
        return 100;
    }

    @Override
    public int getPercentDoneExcludingDND() {
        return 1000;
    }

    @Override
    public long getSizeExcludingDND() {
        return this.getTotalLength();
    }

    @Override
    public String getErrorMessage() {
        return this.error_message;
    }

    @Override
    public int getErrorType() {
        return this.error_type;
    }

    @Override
    public DiskManager.DownloadEndedProgress downloadEnded(boolean start_of_day) {
        return new DiskManager.DownloadEndedProgress(){

            @Override
            public boolean isComplete() {
                return true;
            }
        };
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) {
        throw new RuntimeException("moveDataFiles not implemented");
    }

    @Override
    public int getCompleteRecheckStatus() {
        return -1;
    }

    @Override
    public boolean getRecheckCancelled() {
        return false;
    }

    @Override
    public long[] getMoveProgress() {
        return null;
    }

    @Override
    public String getMoveSubTask() {
        return null;
    }

    @Override
    public void setMoveState(int state) {
    }

    @Override
    public boolean checkBlockConsistencyForWrite(String originator, int pieceNumber, int offset, DirectByteBuffer data) {
        long pos = (long)pieceNumber * (long)this.piece_mapper.getPieceLength() + (long)offset + (long)data.remaining((byte)1);
        return pos <= this.piece_mapper.getTotalLength();
    }

    @Override
    public boolean checkBlockConsistencyForRead(String originator, boolean peer_request, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForRead(this, originator, peer_request, pieceNumber, offset, length);
    }

    @Override
    public boolean checkBlockConsistencyForHint(String originator, int pieceNumber, int offset, int length) {
        return DiskManagerUtil.checkBlockConsistencyForHint(this, originator, pieceNumber, offset, length);
    }

    @Override
    public void addListener(DiskManagerListener l) {
    }

    @Override
    public void removeListener(DiskManagerListener l) {
    }

    @Override
    public boolean hasListener(DiskManagerListener l) {
        return false;
    }

    @Override
    public void saveState(boolean interim) {
    }

    @Override
    public DiskAccessController getDiskAccessController() {
        return this.disk_access_controller;
    }

    @Override
    public DMPieceMap getPieceMap() {
        DMPieceMap map = this.piece_map_use_accessor;
        if (map == null) {
            this.piece_map_use_accessor = map = this.piece_mapper.getPieceMap();
        }
        return map;
    }

    @Override
    public DMPieceList getPieceList(int piece_number) {
        DMPieceMap map = this.getPieceMap();
        return map.getPieceList(piece_number);
    }

    protected DMChecker getChecker() {
        DMChecker checker = this.checker_use_accessor;
        if (checker == null) {
            checker = this.checker_use_accessor = DMAccessFactory.createChecker(this);
        }
        return checker;
    }

    @Override
    public byte[] getPieceHash(int piece_number) throws TOTorrentException {
        return this.lws.getTorrent().getPieces()[piece_number];
    }

    @Override
    public DiskManagerRecheckScheduler getRecheckScheduler() {
        throw new RuntimeException("getPieceHash not implemented");
    }

    @Override
    public void downloadRemoved() {
    }

    @Override
    public void setFailed(int type, String reason, Throwable cause, boolean can_continue) {
        this.started = false;
        this.state = 10;
        this.error_message = reason;
        this.error_type = type;
    }

    @Override
    public void setFailedAndRecheck(DiskManagerFileInfo file, String reason) {
        this.started = false;
        this.state = 10;
        this.error_message = reason;
        this.error_type = 1;
    }

    @Override
    public boolean isUploadOnly() {
        return false;
    }

    @Override
    public TOTorrent getTorrent() {
        return this.lws.getTOTorrent(false);
    }

    @Override
    public String[] getStorageTypes() {
        throw new RuntimeException("getStorageTypes not implemented");
    }

    @Override
    public String getStorageType(int fileIndex) {
        throw new RuntimeException("getStorageType not implemented");
    }

    @Override
    public void skippedFileSetChanged(DiskManagerFileInfo file) {
    }

    @Override
    public void priorityChanged(DiskManagerFileInfo file) {
    }

    @Override
    public void storageTypeChanged(DiskManagerFileInfo file) {
    }

    @Override
    public File getSaveLocation() {
        return this.save_file;
    }

    @Override
    public String getInternalName() {
        return this.internal_name;
    }

    @Override
    public DownloadManagerState getDownloadState() {
        return this.download_state;
    }

    @Override
    public long getPriorityChangeMarker() {
        return 0L;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
    }

    protected static class sePiece
    implements DiskManagerPiece {
        protected sePiece() {
        }

        public void clearChecking() {
            throw new RuntimeException("clearChecking not implemented");
        }

        @Override
        public boolean isNeedsCheck() {
            throw new RuntimeException("isNeedsCheck not implemented");
        }

        @Override
        public boolean spansFiles() {
            throw new RuntimeException("spansfiles not implemented");
        }

        @Override
        public DMPieceList getPieceList() {
            throw new RuntimeException("getPieceList not implemented");
        }

        @Override
        public int getLength() {
            throw new RuntimeException("getLength not implemented");
        }

        @Override
        public int getNbBlocks() {
            throw new RuntimeException("getNbBlocks not implemented");
        }

        @Override
        public int getPieceNumber() {
            throw new RuntimeException("getPieceNumber not implemented");
        }

        @Override
        public int getBlockSize(int b) {
            throw new RuntimeException("getBlockSize not implemented");
        }

        @Override
        public boolean isWritten() {
            throw new RuntimeException("isWritten not implemented");
        }

        @Override
        public int getNbWritten() {
            throw new RuntimeException("getNbWritten not implemented");
        }

        @Override
        public boolean[] getWritten() {
            throw new RuntimeException("getWritten not implemented");
        }

        @Override
        public void reDownloadBlock(int blockNumber) {
            throw new RuntimeException("reDownloadBlock not implemented");
        }

        @Override
        public void reset() {
            throw new RuntimeException("reset not implemented");
        }

        @Override
        public boolean isDownloadable() {
            return false;
        }

        @Override
        public void setDownloadable() {
            throw new RuntimeException("setRequestable not implemented");
        }

        @Override
        public DiskManager getManager() {
            throw new RuntimeException("getManager not implemented");
        }

        @Override
        public boolean calcNeeded() {
            throw new RuntimeException("calcNeeded not implemented");
        }

        @Override
        public void clearNeeded() {
            throw new RuntimeException("clearNeeded not implemented");
        }

        @Override
        public boolean isNeeded() {
            throw new RuntimeException("isNeeded not implemented");
        }

        @Override
        public void setNeeded() {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setNeeded(boolean b) {
            throw new RuntimeException("setNeeded not implemented");
        }

        @Override
        public void setWritten(int b) {
            throw new RuntimeException("setWritten not implemented");
        }

        @Override
        public void clearWritten(int b) {
            throw new RuntimeException("setWritten not implemented");
        }

        @Override
        public boolean isWritten(int blockNumber) {
            throw new RuntimeException("isWritten not implemented");
        }

        public boolean calcChecking() {
            throw new RuntimeException("calcChecking not implemented");
        }

        @Override
        public boolean isChecking() {
            return false;
        }

        @Override
        public void setChecking() {
            throw new RuntimeException("setChecking not implemented");
        }

        public void setChecking(boolean b) {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public boolean calcDone() {
            throw new RuntimeException("calcDone not implemented");
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public boolean isInteresting() {
            return false;
        }

        @Override
        public boolean isSkipped() {
            return false;
        }

        @Override
        public String getString() {
            return "";
        }

        @Override
        public short getReadCount() {
            return 0;
        }

        @Override
        public void setReadCount(short c) {
        }

        @Override
        public boolean isMergeRead() {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public boolean isMergeWrite() {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public void setMergeRead() {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public void setMergeWrite() {
            throw new RuntimeException("setChecking not implemented");
        }

        @Override
        public int getRemaining() {
            return 0;
        }

        @Override
        public void setDone(boolean b) {
            if (!b) {
                Debug.out("Piece failed recheck");
            }
        }
    }
}

