/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.lws;

import com.biglybt.core.logging.LogRelation;
import com.biglybt.core.lws.LightWeightSeed;
import com.biglybt.core.tracker.client.TRTrackerAnnouncer;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.disk.DiskManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadActivationEvent;
import com.biglybt.pif.download.DownloadActivationListener;
import com.biglybt.pif.download.DownloadAnnounceResult;
import com.biglybt.pif.download.DownloadAttributeListener;
import com.biglybt.pif.download.DownloadCompletionListener;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.download.DownloadListener;
import com.biglybt.pif.download.DownloadPeerListener;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pif.download.DownloadScrapeResult;
import com.biglybt.pif.download.DownloadStats;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.download.DownloadTrackerListener;
import com.biglybt.pif.download.DownloadWillBeRemovedListener;
import com.biglybt.pif.download.savelocation.SaveLocationChange;
import com.biglybt.pif.network.RateLimiter;
import com.biglybt.pif.peers.PeerManager;
import com.biglybt.pif.tag.Tag;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.torrent.TorrentManager;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.pifimpl.local.ddb.DDBaseImpl;
import com.biglybt.pifimpl.local.download.DownloadAnnounceResultImpl;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LWSDownload
extends LogRelation
implements Download {
    private final LightWeightSeed lws;
    private final TRTrackerAnnouncer announcer;
    final DownloadAnnounceResultImpl announce_result;
    private final Map user_data = new HashMap();
    private final Map torrent_attributes = new HashMap();
    private final DownloadScrapeResult scrape_result = new DownloadScrapeResult(){

        @Override
        public Download getDownload() {
            return LWSDownload.this;
        }

        @Override
        public int getResponseType() {
            return LWSDownload.this.announce_result.getResponseType() == 1 ? 1 : 2;
        }

        @Override
        public int getSeedCount() {
            return LWSDownload.this.announce_result.getSeedCount();
        }

        @Override
        public int getNonSeedCount() {
            int seeds = this.getSeedCount();
            int reported = LWSDownload.this.announce_result.getReportedPeerCount();
            int min_peers = reported - seeds;
            int peers = LWSDownload.this.announce_result.getNonSeedCount();
            if (peers < min_peers) {
                peers = min_peers;
            }
            return peers;
        }

        @Override
        public long getScrapeStartTime() {
            return 0L;
        }

        @Override
        public void setNextScrapeStartTime(long nextScrapeStartTime) {
        }

        @Override
        public long getNextScrapeStartTime() {
            return 0L;
        }

        @Override
        public String getStatus() {
            if (this.getResponseType() == 1) {
                return "OK";
            }
            return LWSDownload.this.announce_result.getError();
        }

        @Override
        public URL getURL() {
            return LWSDownload.this.announce_result.getURL();
        }
    };

    protected LWSDownload(LightWeightSeed _lws, TRTrackerAnnouncer _announcer) {
        this.lws = _lws;
        this.announcer = _announcer;
        this.announce_result = new DownloadAnnounceResultImpl(this, this.announcer.getLastResponse());
    }

    public LightWeightSeed getLWS() {
        return this.lws;
    }

    @Override
    public int getState() {
        return 5;
    }

    @Override
    public int getSubState() {
        return 5;
    }

    @Override
    public String getErrorStateDetails() {
        return "";
    }

    @Override
    public void setFlag(long flag, boolean value) {
        this.notSupported();
    }

    @Override
    public boolean getFlag(long flag) {
        return flag == 1024L;
    }

    @Override
    public long getFlags() {
        return 1024L;
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        return null;
    }

    @Override
    public Torrent getTorrent() {
        return this.lws.getTorrent();
    }

    @Override
    public void initialize() throws DownloadException {
    }

    @Override
    public void start() throws DownloadException {
    }

    @Override
    public void startDownload(boolean force) {
    }

    @Override
    public void stopDownload() {
    }

    @Override
    public void stop() throws DownloadException {
    }

    @Override
    public void setStopReason(String reason) {
        this.setUserData(UD_KEY_STOP_REASON, reason);
    }

    @Override
    public String getStopReason() {
        return (String)this.getUserData(UD_KEY_STOP_REASON);
    }

    @Override
    public void stopAndQueue() throws DownloadException {
    }

    @Override
    public void restart() throws DownloadException {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recheckData() throws DownloadException {
    }

    @Override
    public boolean isStartStopLocked() {
        return false;
    }

    @Override
    public boolean isForceStart() {
        return true;
    }

    @Override
    public void setForceStart(boolean forceStart) {
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public String getName() {
        return this.lws.getName();
    }

    @Override
    public String getTorrentFileName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(TorrentAttribute attribute) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            return (String)this.torrent_attributes.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(TorrentAttribute attribute, String value) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            this.torrent_attributes.put(attribute, value);
        }
    }

    @Override
    public String[] getListAttribute(TorrentAttribute attribute) {
        TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
        if (attribute == tm.getAttribute("Networks")) {
            return new String[]{this.lws.getNetwork()};
        }
        if (attribute == tm.getAttribute("PeerSources")) {
            return new String[]{"DHT"};
        }
        return null;
    }

    @Override
    public void setListAttribute(TorrentAttribute attribute, String[] value) {
        this.notSupported();
    }

    @Override
    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        this.notSupported();
    }

    @Override
    public Map getMapAttribute(TorrentAttribute attribute) {
        return null;
    }

    @Override
    public void setIntAttribute(TorrentAttribute name, int value) {
        this.notSupported();
    }

    @Override
    public int getIntAttribute(TorrentAttribute name) {
        return 0;
    }

    @Override
    public void setLongAttribute(TorrentAttribute name, long value) {
        this.notSupported();
    }

    @Override
    public long getLongAttribute(TorrentAttribute name) {
        return 0L;
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute name, boolean value) {
        this.notSupported();
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute name) {
        return false;
    }

    @Override
    public boolean hasAttribute(TorrentAttribute name) {
        return false;
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    @Override
    public String getCategoryName() {
        return null;
    }

    @Override
    public void setCategory(String sName) {
        this.notSupported();
    }

    @Override
    public List<Tag> getTags() {
        return Collections.emptyList();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void stopAndRemove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    public void setPosition(int newPosition) {
        this.notSupported();
    }

    @Override
    public void moveUp() {
        this.notSupported();
    }

    @Override
    public void moveDown() {
        this.notSupported();
    }

    @Override
    public void moveTo(int position) {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.announcer.setAnnounceResult(result);
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult result) {
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.scrape_result;
    }

    @Override
    public DownloadScrapeResult getAggregatedScrapeResult(boolean cache) {
        return this.getLastScrapeResult();
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        return null;
    }

    @Override
    public DownloadStats getStats() {
        return null;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int kb) {
        this.notSupported();
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        return 0;
    }

    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isComplete(boolean bIncludeDND) {
        return true;
    }

    @Override
    public boolean isChecking() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public String getSavePath() {
        return "";
    }

    @Override
    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    @Override
    public boolean canMoveDataFiles() {
        return false;
    }

    @Override
    public void moveTorrentFile(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void renameDownload(String name) throws DownloadException {
        this.notSupported();
    }

    @Override
    public PeerManager getPeerManager() {
        return null;
    }

    @Override
    public DiskManager getDiskManager() {
        return null;
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return null;
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int i) {
        return null;
    }

    @Override
    public int getDiskManagerFileCount() {
        return 0;
    }

    @Override
    public void requestTrackerAnnounce() {
    }

    @Override
    public void requestTrackerAnnounce(boolean immediate) {
    }

    @Override
    public void requestTrackerScrape(boolean immediate) {
    }

    @Override
    public void addListener(DownloadListener l) {
    }

    @Override
    public void removeListener(DownloadListener l) {
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l) {
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener l) {
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public void addActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void removeActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void addPeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public void removePeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public Download.SeedingRank getSeedingRank() {
        return null;
    }

    @Override
    public void setSeedingRank(Download.SeedingRank rank) {
        this.notSupported();
    }

    @Override
    public byte[] getDownloadPeerId() {
        return null;
    }

    @Override
    public boolean isMessagingEnabled() {
        return true;
    }

    @Override
    public void setMessagingEnabled(boolean enabled) {
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        Map map = this.user_data;
        synchronized (map) {
            this.user_data.put(key, data);
        }
    }

    @Override
    public void changeLocation(SaveLocationChange slc) throws DownloadException {
        this.notSupported();
    }

    @Override
    public boolean isStub() {
        return false;
    }

    @Override
    public boolean canStubbify() {
        return false;
    }

    @Override
    public DownloadStub stubbify() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public Download destubbify() throws DownloadException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases() {
        return DDBaseImpl.getDDBs(this);
    }

    @Override
    public byte[] getTorrentHash() {
        return this.lws.getTorrent().getHash();
    }

    @Override
    public long getTorrentSize() {
        return this.lws.getTorrent().getSize();
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        this.notSupported();
        return null;
    }

    protected void notSupported() {
        Debug.out("Not Supported");
    }

    @Override
    public DiskManagerFileInfo getPrimaryFile() {
        return null;
    }

    @Override
    public String getRelationText() {
        return "Internal: '" + new String(this.getName()) + "'";
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.lws};
    }
}

