/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager;

import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.NetworkManager;

public abstract class NetworkConnectionHelper
implements NetworkConnectionBase {
    int upload_limit;
    private final LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_con_up: " + NetworkConnectionHelper.this.getString();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.upload_limit;
        }

        @Override
        public boolean isDisabled() {
            return NetworkConnectionHelper.this.upload_limit == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    int download_limit;
    private final LimitedRateGroup download_limiter = new LimitedRateGroup(){

        @Override
        public String getName() {
            return "per_con_down: " + NetworkConnectionHelper.this.getString();
        }

        @Override
        public int getRateLimitBytesPerSecond() {
            return NetworkConnectionHelper.this.download_limit;
        }

        @Override
        public boolean isDisabled() {
            return NetworkConnectionHelper.this.download_limit == -1;
        }

        @Override
        public void updateBytesUsed(int used) {
        }
    };
    private volatile LimitedRateGroup[] upload_limiters = new LimitedRateGroup[]{this.upload_limiter};
    private volatile LimitedRateGroup[] download_limiters = new LimitedRateGroup[]{this.download_limiter};

    @Override
    public int getUploadLimit() {
        return this.upload_limit;
    }

    @Override
    public int getDownloadLimit() {
        return this.download_limit;
    }

    @Override
    public void setUploadLimit(int limit) {
        this.upload_limit = limit;
    }

    @Override
    public void setDownloadLimit(int limit) {
        this.download_limit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (upload) {
                int i = 0;
                while (i < this.upload_limiters.length) {
                    if (this.upload_limiters[i] == limiter) {
                        return;
                    }
                    ++i;
                }
                LimitedRateGroup[] new_upload_limiters = new LimitedRateGroup[this.upload_limiters.length + 1];
                System.arraycopy(this.upload_limiters, 0, new_upload_limiters, 0, this.upload_limiters.length);
                new_upload_limiters[this.upload_limiters.length] = limiter;
                this.upload_limiters = new_upload_limiters;
            } else {
                int i = 0;
                while (i < this.download_limiters.length) {
                    if (this.download_limiters[i] == limiter) {
                        return;
                    }
                    ++i;
                }
                LimitedRateGroup[] new_download_limiters = new LimitedRateGroup[this.download_limiters.length + 1];
                System.arraycopy(this.download_limiters, 0, new_download_limiters, 0, this.download_limiters.length);
                new_download_limiters[this.download_limiters.length] = limiter;
                this.download_limiters = new_download_limiters;
            }
        }
        NetworkManager.getSingleton().addRateLimiter(this, limiter, upload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        NetworkConnectionHelper networkConnectionHelper = this;
        synchronized (networkConnectionHelper) {
            if (upload) {
                if (this.upload_limiters.length == 0) {
                    return;
                }
                int pos = 0;
                LimitedRateGroup[] new_upload_limiters = new LimitedRateGroup[this.upload_limiters.length - 1];
                int i = 0;
                while (i < this.upload_limiters.length) {
                    if (this.upload_limiters[i] != limiter) {
                        if (pos == new_upload_limiters.length) {
                            return;
                        }
                        new_upload_limiters[pos++] = this.upload_limiters[i];
                    }
                    ++i;
                }
                this.upload_limiters = new_upload_limiters;
            } else {
                if (this.download_limiters.length == 0) {
                    return;
                }
                int pos = 0;
                LimitedRateGroup[] new_download_limiters = new LimitedRateGroup[this.download_limiters.length - 1];
                int i = 0;
                while (i < this.download_limiters.length) {
                    if (this.download_limiters[i] != limiter) {
                        if (pos == new_download_limiters.length) {
                            return;
                        }
                        new_download_limiters[pos++] = this.download_limiters[i];
                    }
                    ++i;
                }
                this.download_limiters = new_download_limiters;
            }
        }
        NetworkManager.getSingleton().removeRateLimiter(this, limiter, upload);
    }

    @Override
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        if (upload) {
            return this.upload_limiters;
        }
        return this.download_limiters;
    }
}

