/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager;

import com.biglybt.core.networkmanager.impl.tcp.VirtualChannelSelectorImpl;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;

public class VirtualChannelSelector {
    public static final int OP_ACCEPT = 16;
    public static final int OP_CONNECT = 8;
    public static final int OP_READ = 1;
    public static final int OP_WRITE = 4;
    private final String name;
    private final VirtualChannelSelectorImpl selector_impl;
    private volatile boolean destroyed;
    private final int op;
    private boolean randomise_keys;

    public VirtualChannelSelector(String name, int interest_op, boolean pause_after_select) {
        this.name = name;
        this.op = interest_op;
        this.selector_impl = new VirtualChannelSelectorImpl(this, this.op, pause_after_select, this.randomise_keys);
    }

    public String getName() {
        return this.name;
    }

    public void register(SocketChannel channel2, VirtualSelectorListener listener, Object attachment) {
        this.registerSupport(channel2, listener, attachment);
    }

    public void register(ServerSocketChannel channel2, VirtualAcceptSelectorListener listener, Object attachment) {
        this.registerSupport(channel2, listener, attachment);
    }

    protected void registerSupport(AbstractSelectableChannel channel2, VirtualAbstractSelectorListener listener, Object attachment) {
        this.selector_impl.register(channel2, listener, attachment);
    }

    public boolean isPaused(AbstractSelectableChannel channel2) {
        return this.selector_impl.isPaused(channel2);
    }

    public void pauseSelects(AbstractSelectableChannel channel2) {
        this.selector_impl.pauseSelects(channel2);
    }

    public void resumeSelects(AbstractSelectableChannel channel2) {
        this.selector_impl.resumeSelects(channel2);
    }

    public boolean isRegistered(AbstractSelectableChannel channel2) {
        return this.selector_impl.isRegistered(channel2);
    }

    public void cancel(AbstractSelectableChannel channel2) {
        this.selector_impl.cancel(channel2);
    }

    public void setRandomiseKeys(boolean _rk) {
        this.randomise_keys = _rk;
        this.selector_impl.setRandomiseKeys(this.randomise_keys);
    }

    public int select(long timeout) {
        return this.selector_impl.select(timeout);
    }

    public void destroy() {
        this.destroyed = true;
        this.selector_impl.destroy();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public boolean selectSuccess(VirtualAbstractSelectorListener listener, AbstractSelectableChannel sc, Object attachment) {
        if (this.op == 16) {
            return ((VirtualAcceptSelectorListener)listener).selectSuccess(this, (ServerSocketChannel)sc, attachment);
        }
        return ((VirtualSelectorListener)listener).selectSuccess(this, (SocketChannel)sc, attachment);
    }

    public void selectFailure(VirtualAbstractSelectorListener listener, AbstractSelectableChannel sc, Object attachment, Throwable msg) {
        if (this.op == 16) {
            ((VirtualAcceptSelectorListener)listener).selectFailure(this, (ServerSocketChannel)sc, attachment, msg);
        } else {
            ((VirtualSelectorListener)listener).selectFailure(this, (SocketChannel)sc, attachment, msg);
        }
    }

    public static interface VirtualAbstractSelectorListener {
    }

    public static interface VirtualAcceptSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, ServerSocketChannel var2, Object var3, Throwable var4);
    }

    public static interface VirtualSelectorListener
    extends VirtualAbstractSelectorListener {
        public boolean selectSuccess(VirtualChannelSelector var1, SocketChannel var2, Object var3);

        public void selectFailure(VirtualChannelSelector var1, SocketChannel var2, Object var3, Throwable var4);
    }
}

