/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.admin.impl;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.instancemanager.ClientInstance;
import com.biglybt.core.instancemanager.ClientInstanceManager;
import com.biglybt.core.instancemanager.ClientInstanceManagerListener;
import com.biglybt.core.instancemanager.ClientInstanceTracked;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.NetworkConnectionBase;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.TransportBase;
import com.biglybt.core.networkmanager.TransportStartpoint;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.admin.NetworkAdminASN;
import com.biglybt.core.networkmanager.admin.NetworkAdminASNListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminException;
import com.biglybt.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.biglybt.core.networkmanager.admin.NetworkAdminNATDevice;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.biglybt.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.biglybt.core.networkmanager.admin.NetworkAdminNode;
import com.biglybt.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminProtocol;
import com.biglybt.core.networkmanager.admin.NetworkAdminRouteListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.biglybt.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.biglybt.core.networkmanager.admin.NetworkAdminSpeedTestScheduler;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminASNImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminASNLookupImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminDistributedNATTester;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminHTTPProxyImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminNATDeviceImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminProtocolImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminSocksProxyImpl;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminSpeedTestSchedulerImpl;
import com.biglybt.core.networkmanager.impl.http.HTTPNetworkManager;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.networkmanager.impl.udp.UDPNetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerListenerAdapter;
import com.biglybt.core.proxy.AEProxySelectorFactory;
import com.biglybt.core.proxy.socks.AESocksProxy;
import com.biglybt.core.proxy.socks.AESocksProxyFactory;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.DNSUtils;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FeatureAvailability;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.NetUtils;
import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.core.util.TimerEventPeriodic;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.platform.PlatformManagerException;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pif.utils.Utilities;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.platform.PlatformManagerPingCallback;
import com.biglybt.plugin.upnp.UPnPPlugin;
import com.biglybt.plugin.upnp.UPnPPluginService;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;

public class NetworkAdminImpl
extends NetworkAdmin
implements AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final boolean FULL_INTF_PROBE = false;
    private static InetAddress anyLocalAddress;
    private static InetAddress anyLocalAddressIPv4;
    private static InetAddress anyLocalAddressIPv6;
    private static InetAddress localhostV4;
    private static InetAddress localhostV6;
    private static final int INTERFACE_CHECK_MILLIS = 15000;
    private static final int ROUTE_CHECK_MILLIS = 60000;
    private static final int ROUTE_CHECK_TICKS = 4;
    private Set<NetworkInterface> old_network_interfaces;
    private final Map<String, AddressHistoryRecord> address_history = new HashMap<String, AddressHistoryRecord>();
    private long address_history_update_time;
    private InetAddress[] currentBindIPs = new InetAddress[1];
    private boolean forceBind = false;
    private boolean supportsIPv6withNIO = true;
    private boolean supportsIPv6 = true;
    private boolean supportsIPv4 = true;
    private boolean ignoreIPv4;
    private boolean ignoreIPv6;
    private boolean IPv6_enabled;
    private boolean preferIPv6;
    private InetAddress[] additionalServiceBindIPs;
    private volatile boolean testedIPv6Routing;
    private int roundRobinCounterV4 = 0;
    private int roundRobinCounterV6 = 0;
    private boolean logged_bind_force_issue;
    private final CopyOnWriteList<NetworkAdminPropertyChangeListener> listeners = new CopyOnWriteList();
    final NetworkAdminRouteListener trace_route_listener = new NetworkAdminRouteListener(){
        private int node_count = 0;

        @Override
        public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
            ++this.node_count;
            return true;
        }

        @Override
        public boolean timeout(int distance) {
            return distance != 3 || this.node_count != 0;
        }
    };
    private static final int ASN_MIN_CHECK = 1800000;
    private long last_asn_lookup_time;
    private final List asn_ips_checked = new ArrayList(0);
    private final List as_history = new ArrayList();
    private final AsyncDispatcher async_asn_dispacher = new AsyncDispatcher();
    private static final int MAX_ASYNC_ASN_LOOKUPS = 1024;
    final Map<InetAddress, NetworkAdminASN> async_asn_history = new LinkedHashMap<InetAddress, NetworkAdminASN>(256, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetAddress, NetworkAdminASN> eldest) {
            return this.size() > 256;
        }
    };
    private final InetAddress[] gdpa_lock = new InetAddress[1];
    private AESemaphore gdpa_sem;
    private long gdpa_last_fail;
    private long gdpa_last_lookup;
    private final AESemaphore gdpa_initial_sem = new AESemaphore("gdpa:init");
    private InetAddress gdpa6 = null;
    private int gdpa6_count;
    private InetAddress gdpa6_last_good = null;
    private long gdpa6_last_check;
    private boolean gdpa6_checking;
    private volatile long rpa_last_refresh = -1L;
    private final Object rpa_lock = new Object();
    private Map<InetAddress, String> rpa = new LinkedHashMap<InetAddress, String>(64, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<InetAddress, String> eldest) {
            return this.size() > 64;
        }
    };
    private final boolean initialised;
    private static final String DM_PAUSE_PENDING_KEY = "NetworkAdminImpl::pausePending";
    private List<NetworkInterface> last_getni_result;
    private final Object getni_lock;
    public static final int BS_INACTIVE = 0;
    public static final int BS_OK = 1;
    public static final int BS_WARNING = 2;
    public static final int BS_ERROR = 3;
    long bs_last_calc;
    private Object[] bs_last_value;

    static {
        try {
            anyLocalAddressIPv4 = InetAddress.getByAddress(new byte[4]);
            anyLocalAddressIPv6 = InetAddress.getByAddress(new byte[16]);
            anyLocalAddress = new InetSocketAddress(0).getAddress();
            byte[] byArray = new byte[4];
            byArray[0] = 127;
            byArray[3] = 1;
            localhostV4 = InetAddress.getByAddress(byArray);
            byte[] byArray2 = new byte[16];
            byArray2[15] = 1;
            localhostV6 = InetAddress.getByAddress(byArray2);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
    }

    public NetworkAdminImpl() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV6 Enable Support", "IPV6 Prefer Addresses"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.setIPv6Enabled(COConfigurationManager.getBooleanParameter("IPV6 Enable Support"));
                NetworkAdminImpl.this.preferIPv6 = COConfigurationManager.getBooleanParameter("IPV6 Prefer Addresses");
            }
        });
        COConfigurationManager.addResetToDefaultsListener(new COConfigurationManager.ResetToDefaultsListener(){

            @Override
            public void reset() {
                NetworkAdminImpl.this.clearMaybeVPNs();
            }
        });
        this.loadRecentPublicIPs();
        this.getni_lock = new Object();
        this.bs_last_calc = 0L;
        this.bs_last_value = null;
        COConfigurationManager.addParameterListener(new String[]{"Bind IP", "Enforce Bind IP"}, new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.checkDefaultBindAddress(false);
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"IPV4 Ignore Network Addresses", "IPV6 Ignore Network Addresses"}, n -> {
            this.ignoreIPv4 = COConfigurationManager.getBooleanParameter("IPV4 Ignore Network Addresses");
            this.ignoreIPv6 = COConfigurationManager.getBooleanParameter("IPV6 Ignore Network Addresses");
            if (n != null) {
                this.checkNetworkInterfaces(false, true);
                this.checkDefaultBindAddress(false);
            }
        });
        SimpleTimer.addPeriodicEvent("NetworkAdmin:checker", 15000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event2) {
                ++this.tick_count;
                boolean changed = NetworkAdminImpl.this.checkNetworkInterfaces(false, false);
                if (changed || this.tick_count % 4 == 0) {
                    NetworkAdminImpl.this.checkConnectionRoutes();
                }
            }
        });
        this.checkNetworkInterfaces(true, true);
        this.checkDefaultBindAddress(true);
        COConfigurationManager.addAndFireParameterListener("Additional Service Bind IPs", n -> this.setupAdditionalServiceBindIPs(COConfigurationManager.getStringParameter(n)));
        AEDiagnostics.addWeakEvidenceGenerator(this);
        if (System.getProperty("skip.dns.spi.test", "0").equals("0")) {
            this.checkDNSSPI();
        }
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                NetworkAdminImpl.this.setup(core);
            }
        });
        this.initialised = true;
    }

    private void setup(final Core core) {
        try {
            Class.forName("com.biglybt.ui.swt.core.nwmadmin.NetworkAdminSWTImpl").getConstructor(Core.class, NetworkAdminImpl.class).newInstance(core, this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Enforce Bind IP", "Enforce Bind IP Pause"}, new ParameterListener(){
            private Object lock = new Object();
            private TimerEventPeriodic timer;
            private boolean paused;
            TimerEventPerformer listener = event_unused -> {
                boolean enforce = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
                boolean enforce_pause = COConfigurationManager.getBooleanParameter("Enforce Bind IP Pause");
                boolean bad = enforce && enforce_pause && NetworkAdminImpl.this.hasMissingForcedBind();
                Object object = this.lock;
                synchronized (object) {
                    if (bad || this.paused) {
                        this.paused = bad;
                        List<DownloadManager> dms = core2.getGlobalManager().getDownloadManagers();
                        for (DownloadManager dm : dms) {
                            if (this.paused) {
                                DiskManager disk_manager;
                                int state;
                                if (dm.isPaused() || (state = dm.getState()) == 100 || state == 70 || state == 65) continue;
                                boolean can_pause = true;
                                if (dm.getMoveProgress() != null || FileUtil.hasTask(dm)) {
                                    can_pause = false;
                                } else if (state == 30) {
                                    can_pause = false;
                                } else if (state == 60 && (disk_manager = dm.getDiskManager()) != null && disk_manager.getCompleteRecheckStatus() != -1) {
                                    can_pause = false;
                                }
                                if (can_pause) {
                                    if (!dm.pause(true)) continue;
                                    dm.setStopReason("{label.binding.missing}");
                                    continue;
                                }
                                PEPeerManager pm = dm.getPeerManager();
                                if (pm == null) continue;
                                NetworkAdminImpl.this.addKickAllPeerListener(pm);
                                continue;
                            }
                            if (dm.isPaused()) {
                                String reason = dm.getStopReason();
                                if (reason == null || !reason.equals("{label.binding.missing}")) continue;
                                dm.resume();
                                continue;
                            }
                            PEPeerManager pm = dm.getPeerManager();
                            if (pm == null) continue;
                            NetworkAdminImpl.this.removeKickAllPeerListener(pm);
                        }
                    }
                }
            };

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                boolean enforce = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
                boolean enforce_pause = COConfigurationManager.getBooleanParameter("Enforce Bind IP Pause");
                Object object = this.lock;
                synchronized (object) {
                    if (enforce && enforce_pause) {
                        if (this.timer == null) {
                            this.timer = SimpleTimer.addPeriodicEvent("bind checker", 10000L, this.listener);
                        }
                    } else if (this.timer != null) {
                        this.timer.cancel();
                        this.timer = null;
                        this.listener.perform(null);
                    }
                }
            }
        });
        new NetworkAdminDistributedNATTester(this, core);
    }

    private void addKickAllPeerListener(PEPeerManager pm) {
        if (pm.getData(DM_PAUSE_PENDING_KEY) != null) {
            return;
        }
        PEPeerManagerListenerAdapter listener = new PEPeerManagerListenerAdapter(){

            @Override
            public void peerAdded(PEPeerManager manager, PEPeer peer) {
                manager.removePeer(peer, "Pause pending", 2);
            }
        };
        pm.setData(DM_PAUSE_PENDING_KEY, new Object[]{pm, listener});
        pm.addListener(listener);
        pm.removeAllPeers("Pause pending", 2);
    }

    private void removeKickAllPeerListener(PEPeerManager pm) {
        Object[] data = (Object[])pm.getData(DM_PAUSE_PENDING_KEY);
        if (data != null) {
            if (data[0] == pm) {
                pm.removeListener((PEPeerManagerListener)data[1]);
            }
            pm.setData(DM_PAUSE_PENDING_KEY, null);
        }
    }

    private void checkDNSSPI() {
        String error_str = null;
        try {
            InetAddress ia = InetAddress.getByName("http://dns.test.client.biglybittorrent.com/");
            if (!ia.isLoopbackAddress()) {
                error_str = "Loopback address expected, got " + ia;
            }
        }
        catch (UnknownHostException e) {
            error_str = "DNS SPI not loaded";
        }
        catch (Throwable e) {
            error_str = "Test lookup failed: " + Debug.getNestedExceptionMessage(e);
        }
        if (error_str != null) {
            Logger.log(new LogAlert(true, 1, MessageText.getString("network.admin.dns.spi.fail", new String[]{error_str})));
        }
    }

    protected void setIPv6Enabled(boolean enabled) {
        this.IPv6_enabled = enabled;
        this.supportsIPv6withNIO = enabled;
        this.supportsIPv6 = enabled;
        if (this.initialised) {
            this.checkNetworkInterfaces(false, true);
            this.checkDefaultBindAddress(false);
        }
    }

    @Override
    public boolean isIPV6Enabled() {
        return this.IPv6_enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkNetworkInterfaces(boolean first_time, boolean force) {
        boolean changed;
        block34: {
            changed = false;
            try {
                List<NetworkInterface> x = NetUtils.getNetworkInterfaces();
                boolean fire_stuff = false;
                Object object = this.getni_lock;
                synchronized (object) {
                    if (this.last_getni_result != x) {
                        this.last_getni_result = x;
                        if (x.size() != 0 || this.old_network_interfaces != null) {
                            HashSet<NetworkInterface> new_network_interfaces;
                            if (x.size() == 0) {
                                this.old_network_interfaces = null;
                                changed = true;
                            } else if (this.old_network_interfaces == null) {
                                new_network_interfaces = new HashSet<NetworkInterface>();
                                new_network_interfaces.addAll(x);
                                this.old_network_interfaces = new_network_interfaces;
                                changed = true;
                            } else {
                                new_network_interfaces = new HashSet();
                                for (NetworkInterface ni : x) {
                                    if (!this.old_network_interfaces.contains(ni)) {
                                        changed = true;
                                    }
                                    new_network_interfaces.add(ni);
                                }
                                if (this.old_network_interfaces.size() != new_network_interfaces.size()) {
                                    changed = true;
                                }
                                this.old_network_interfaces = new_network_interfaces;
                            }
                        }
                        if (changed || force) {
                            if (changed) {
                                this.testedIPv6Routing = false;
                            }
                            fire_stuff = true;
                            boolean newV6 = false;
                            boolean newV4 = false;
                            Set<NetworkInterface> interfaces = this.old_network_interfaces;
                            long now = SystemTime.getMonotonousTime();
                            ArrayList<AddressHistoryRecord> a_history = new ArrayList<AddressHistoryRecord>();
                            if (interfaces != null) {
                                for (NetworkInterface ni : interfaces) {
                                    Enumeration<InetAddress> addresses = ni.getInetAddresses();
                                    while (addresses.hasMoreElements()) {
                                        InetAddress ia = (InetAddress)addresses.nextElement();
                                        a_history.add(new AddressHistoryRecord(ni, ia, now));
                                        if (ia.isLoopbackAddress()) continue;
                                        if (ia instanceof Inet6Address && !ia.isLinkLocalAddress()) {
                                            if (!this.IPv6_enabled) continue;
                                            newV6 = true;
                                            continue;
                                        }
                                        if (!(ia instanceof Inet4Address)) continue;
                                        newV4 = true;
                                    }
                                }
                            }
                            Map<String, AddressHistoryRecord> it = this.address_history;
                            synchronized (it) {
                                this.address_history_update_time = now;
                                for (AddressHistoryRecord entry : a_history) {
                                    String name = entry.getAddress().getHostAddress();
                                    AddressHistoryRecord existing = this.address_history.get(name);
                                    if (existing == null) {
                                        this.address_history.put(name, entry);
                                        continue;
                                    }
                                    existing.setLastSeen(now);
                                }
                                Iterator<AddressHistoryRecord> it2 = this.address_history.values().iterator();
                                while (it2.hasNext()) {
                                    AddressHistoryRecord entry = it2.next();
                                    long age = now - entry.getLastSeen();
                                    if (age <= 600000L) continue;
                                    it2.remove();
                                }
                            }
                            this.supportsIPv4 = newV4;
                            this.supportsIPv6 = newV6;
                            Logger.log(new LogEvent(LOGID, "NetworkAdmin: ipv4 supported: " + this.supportsIPv4 + "; ipv6: " + this.supportsIPv6 + "; probing v6+nio functionality"));
                            if (newV6) {
                                try {
                                    ServerSocketChannel channel2 = ServerSocketChannel.open();
                                    try {
                                        channel2.configureBlocking(false);
                                        channel2.socket().bind(new InetSocketAddress(anyLocalAddressIPv6, 0));
                                        Logger.log(new LogEvent(LOGID, "NetworkAdmin: testing nio + ipv6 bind successful"));
                                        this.supportsIPv6withNIO = true;
                                    }
                                    catch (Throwable e) {
                                        Logger.log(new LogEvent(LOGID, 1, "nio + ipv6 test failed", e));
                                        this.supportsIPv6withNIO = false;
                                    }
                                    channel2.close();
                                }
                                catch (Throwable throwable) {}
                            } else {
                                this.supportsIPv6withNIO = false;
                            }
                            if (!first_time) {
                                Logger.log(new LogEvent(LOGID, "NetworkAdmin: network interfaces have changed"));
                            }
                        }
                    }
                }
                if (fire_stuff) {
                    this.interfacesChanged(first_time);
                }
            }
            catch (Throwable e) {
                if (!Constants.IS_CVS_VERSION) break block34;
                Debug.out(e);
            }
        }
        return changed;
    }

    @Override
    public InetAddress getMultiHomedOutgoingRoundRobinBindAddress(InetAddress target) {
        InetAddress[] addresses = this.currentBindIPs;
        boolean v6 = target instanceof Inet6Address;
        int previous = (v6 ? this.roundRobinCounterV6 : this.roundRobinCounterV4) % addresses.length;
        InetAddress toReturn = null;
        int i = previous;
        do {
            ++i;
            if (target == null || v6 && addresses[i %= addresses.length] instanceof Inet6Address || !v6 && addresses[i] instanceof Inet4Address) {
                toReturn = addresses[i];
                break;
            }
            if (v6 || !addresses[i].isAnyLocalAddress()) continue;
            toReturn = anyLocalAddressIPv4;
            break;
        } while (i != previous);
        if (v6) {
            this.roundRobinCounterV6 = i;
        } else {
            this.roundRobinCounterV4 = i;
        }
        return toReturn != null ? toReturn : (v6 ? localhostV6 : localhostV4);
    }

    private void setupAdditionalServiceBindIPs(String str) {
        Object[] latest;
        List<InetAddress> addrs = NetworkAdminImpl.parseAddresses(str);
        Object[] objectArray = latest = addrs.isEmpty() ? null : addrs.toArray(new InetAddress[addrs.size()]);
        if (!Arrays.equals(latest, this.additionalServiceBindIPs)) {
            this.additionalServiceBindIPs = latest;
            this.firePropertyChange("Additional Service Address");
        }
    }

    @Override
    public InetAddress[] getMultiHomedServiceBindAddresses(boolean nio) {
        InetAddress[] bindIPs = this.currentBindIPs;
        int i = 0;
        while (i < bindIPs.length) {
            if (bindIPs[i].isAnyLocalAddress()) {
                return new InetAddress[]{nio && !this.supportsIPv6withNIO && bindIPs[i] instanceof Inet6Address ? anyLocalAddressIPv4 : bindIPs[i]};
            }
            ++i;
        }
        InetAddress[] extra = this.additionalServiceBindIPs;
        if (extra != null) {
            InetAddress[] result = new InetAddress[bindIPs.length + extra.length];
            System.arraycopy(bindIPs, 0, result, 0, bindIPs.length);
            System.arraycopy(extra, 0, result, bindIPs.length, extra.length);
            return result;
        }
        return bindIPs;
    }

    @Override
    public InetAddress getSingleHomedServiceBindAddress(final int proto) {
        InetAddress[] addrs = this.currentBindIPs;
        if (proto == 0) {
            return addrs[0];
        }
        InetAddress[] inetAddressArray = addrs;
        int n = addrs.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress addr = inetAddressArray[n2];
            if (proto == 1 && addr instanceof Inet4Address || addr.isAnyLocalAddress() || proto == 2 && addr instanceof Inet6Address) {
                if (addr.isAnyLocalAddress()) {
                    if (proto == 1) {
                        return anyLocalAddressIPv4;
                    }
                    return anyLocalAddressIPv6;
                }
                return addr;
            }
            ++n2;
        }
        throw new UnsupportedAddressTypeException(){

            @Override
            public String getMessage() {
                return "No bind address for " + (proto == 1 ? "IPv4" : "IPv6");
            }
        };
    }

    @Override
    public InetAddress[] getSingleHomedServiceBinding(final String host) throws UnknownHostException, UnsupportedAddressTypeException {
        InetAddress target_bind;
        InetAddress target_ia;
        List<InetAddress> addresses;
        try {
            addresses = DNSUtils.getSingleton().getAllByName(host);
        }
        catch (Throwable e) {
            addresses = Arrays.asList(InetAddress.getAllByName(host));
        }
        ArrayList<Inet4Address> ip4 = new ArrayList<Inet4Address>();
        ArrayList<Inet6Address> ip6 = new ArrayList<Inet6Address>();
        for (InetAddress ia : addresses) {
            if (ia instanceof Inet4Address) {
                ip4.add((Inet4Address)ia);
                continue;
            }
            ip6.add((Inet6Address)ia);
        }
        if (ip6.isEmpty()) {
            target_ia = (InetAddress)ip4.get(0);
            target_bind = this.getSingleHomedServiceBindAddress(1);
        } else if (ip4.isEmpty()) {
            target_ia = (InetAddress)ip6.get(0);
            target_bind = this.getSingleHomedServiceBindAddress(2);
        } else {
            InetAddress bind_v4 = null;
            InetAddress bind_v6 = null;
            try {
                bind_v4 = this.getSingleHomedServiceBindAddress(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                bind_v6 = this.getSingleHomedServiceBindAddress(2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (bind_v4 == null && bind_v6 == null) {
                throw new UnsupportedAddressTypeException(){

                    @Override
                    public String getMessage() {
                        return "No compatible bind address for '" + host + "'";
                    }
                };
            }
            if (bind_v4 != null && bind_v6 != null) {
                if (this.preferIPv6) {
                    bind_v4 = null;
                } else if (addresses.get(0) instanceof Inet4Address) {
                    bind_v6 = null;
                } else {
                    bind_v4 = null;
                }
            }
            if (bind_v6 == null) {
                target_ia = (InetAddress)ip4.get(0);
                target_bind = bind_v4;
            } else {
                target_ia = (InetAddress)ip6.get(0);
                target_bind = bind_v6;
            }
        }
        return new InetAddress[]{target_ia, target_bind};
    }

    @Override
    public List<InetAddress[]> getSingleHomedServiceBindings(final String host) throws UnknownHostException, UnsupportedAddressTypeException {
        List<InetAddress> addresses;
        try {
            addresses = DNSUtils.getSingleton().getAllByName(host);
        }
        catch (Throwable e) {
            addresses = Arrays.asList(InetAddress.getAllByName(host));
        }
        InetAddress bind_v4 = null;
        InetAddress bind_v6 = null;
        boolean has_b4 = false;
        boolean has_b6 = false;
        try {
            bind_v4 = this.getSingleHomedServiceBindAddress(1);
            has_b4 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            bind_v6 = this.getSingleHomedServiceBindAddress(2);
            has_b6 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ArrayList<InetAddress[]> bindings = new ArrayList<InetAddress[]>(addresses.size());
        for (InetAddress ia : addresses) {
            if (ia instanceof Inet4Address) {
                if (!has_b4) continue;
                bindings.add(new InetAddress[]{ia, bind_v4});
                continue;
            }
            if (!has_b6) continue;
            bindings.add(new InetAddress[]{ia, bind_v6});
        }
        if (bindings.isEmpty()) {
            throw new UnsupportedAddressTypeException(){

                @Override
                public String getMessage() {
                    return "No compatible bind address for '" + host + "'";
                }
            };
        }
        if (this.preferIPv6) {
            Collections.sort(bindings, (b1, b2) -> Boolean.compare(b1[0] instanceof Inet4Address, b2[0] instanceof Inet4Address));
        }
        return bindings;
    }

    @Override
    public InetAddress[] getAllBindAddresses(boolean include_wildcard) {
        InetAddress[] bind_ips;
        if (include_wildcard) {
            return this.currentBindIPs;
        }
        ArrayList<InetAddress> res = new ArrayList<InetAddress>();
        InetAddress[] inetAddressArray = bind_ips = this.currentBindIPs;
        int n = bind_ips.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress ip = inetAddressArray[n2];
            if (!ip.isAnyLocalAddress()) {
                res.add(ip);
            }
            ++n2;
        }
        return res.toArray(new InetAddress[res.size()]);
    }

    @Override
    public InetAddress[] resolveBindAddresses(String bind_to) {
        return this.calcBindAddresses(bind_to, false);
    }

    private static List<InetAddress> parseAddresses(String str) {
        if (str == null) {
            str = "";
        }
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        Pattern addressSplitter = Pattern.compile(";");
        Pattern interfaceSplitter = Pattern.compile("[\\]\\[]");
        String[] tokens = addressSplitter.split(str);
        int i = 0;
        while (i < tokens.length) {
            block19: {
                String currentAddress;
                block20: {
                    InetAddress parsedAddress;
                    block18: {
                        currentAddress = tokens[i];
                        if ((currentAddress = currentAddress.trim()).length() == 0) break block19;
                        parsedAddress = null;
                        try {
                            if (AddressUtils.isPotentialLiteralOrHostAddress(currentAddress)) {
                                parsedAddress = InetAddress.getByName(currentAddress);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (parsedAddress == null) break block20;
                        try {
                            if (!(parsedAddress.isAnyLocalAddress() && addrs.size() <= 0 || NetUtils.getByInetAddress(parsedAddress) != null)) {
                            }
                            break block18;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        break block19;
                    }
                    addrs.add(parsedAddress);
                    break block19;
                }
                String[] ifaces = interfaceSplitter.split(currentAddress);
                NetworkInterface netInterface = null;
                try {
                    netInterface = NetUtils.getByName(ifaces[0]);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                if (netInterface != null) {
                    Enumeration<InetAddress> interfaceAddresses = netInterface.getInetAddresses();
                    if (ifaces.length != 2) {
                        while (interfaceAddresses.hasMoreElements()) {
                            addrs.add(interfaceAddresses.nextElement());
                        }
                    } else {
                        int selectedAddress = 0;
                        try {
                            selectedAddress = Integer.parseInt(ifaces[1]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        int j = 0;
                        while (interfaceAddresses.hasMoreElements()) {
                            if (j == selectedAddress) {
                                addrs.add(interfaceAddresses.nextElement());
                                break;
                            }
                            ++j;
                            interfaceAddresses.nextElement();
                        }
                    }
                }
            }
            ++i;
        }
        return addrs;
    }

    private InetAddress[] calcBindAddresses(String addressString, boolean enforceBind) {
        List<InetAddress> addrs = NetworkAdminImpl.parseAddresses(addressString);
        if (!this.IPv6_enabled) {
            Iterator<InetAddress> it = addrs.iterator();
            while (it.hasNext()) {
                if (!(it.next() instanceof Inet6Address)) continue;
                it.remove();
            }
        }
        if (addrs.size() < 1) {
            return new InetAddress[]{enforceBind ? localhostV4 : (this.hasIPV6Potential() ? anyLocalAddressIPv6 : anyLocalAddressIPv4)};
        }
        return addrs.toArray(new InetAddress[addrs.size()]);
    }

    private String checkBindAddresses(boolean log_alerts) {
        Pattern addressSplitter = Pattern.compile(";");
        Pattern interfaceSplitter = Pattern.compile("[\\]\\[]");
        String bind_ips = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        if (enforceBind && bind_ips.length() == 0 && log_alerts) {
            Logger.log(new LogAlert(true, 1, MessageText.getString("network.admin.bind.enforce.fail")));
        }
        String[] tokens = addressSplitter.split(bind_ips);
        String failed_entries = "";
        int i = 0;
        while (i < tokens.length) {
            String currentAddress = tokens[i];
            if ((currentAddress = currentAddress.trim()).length() != 0) {
                boolean ok = false;
                InetAddress parsedAddress = null;
                try {
                    if (AddressUtils.isPotentialLiteralOrHostAddress(currentAddress)) {
                        parsedAddress = InetAddress.getByName(currentAddress);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (parsedAddress != null) {
                    try {
                        if (parsedAddress.isAnyLocalAddress() || NetUtils.getByInetAddress(parsedAddress) != null) {
                            ok = true;
                        }
                    }
                    catch (Throwable throwable) {}
                } else {
                    String[] ifaces = interfaceSplitter.split(currentAddress);
                    NetworkInterface netInterface = null;
                    try {
                        netInterface = NetUtils.getByName(ifaces[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (netInterface != null) {
                        Enumeration<InetAddress> interfaceAddresses = netInterface.getInetAddresses();
                        if (ifaces.length != 2) {
                            ok = interfaceAddresses.hasMoreElements();
                        } else {
                            try {
                                int selectedAddress = Integer.parseInt(ifaces[1]);
                                int j = 0;
                                while (interfaceAddresses.hasMoreElements()) {
                                    if (j == selectedAddress) {
                                        ok = true;
                                        break;
                                    }
                                    ++j;
                                    interfaceAddresses.nextElement();
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (!ok) {
                    failed_entries = String.valueOf(failed_entries) + (failed_entries.length() == 0 ? "" : ", ") + currentAddress;
                }
            }
            ++i;
        }
        if (failed_entries.length() > 0) {
            if (log_alerts) {
                Logger.log(new LogAlert(true, 1, "Bind IPs not resolved: " + failed_entries + "\n\nSee Tools->Options->Connection->Advanced Network Settings"));
            }
            return failed_entries;
        }
        return null;
    }

    protected void checkDefaultBindAddress(boolean first_time) {
        boolean changed = false;
        String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        if (enforceBind) {
            if (bind_ip.length() == 0) {
                if (!this.logged_bind_force_issue) {
                    this.logged_bind_force_issue = true;
                    Debug.out("'Enforce IP Bindings' is selected but no bindings have been specified - ignoring force request!");
                }
                enforceBind = false;
            } else {
                this.logged_bind_force_issue = false;
            }
        }
        this.forceBind = enforceBind;
        Object[] addrs = this.calcBindAddresses(bind_ip, enforceBind);
        boolean bl = changed = !Arrays.equals(this.currentBindIPs, addrs);
        if (changed) {
            this.currentBindIPs = addrs;
            if (!first_time) {
                String logmsg = "NetworkAdmin: default bind ip has changed to '";
                int i = 0;
                while (i < addrs.length) {
                    logmsg = String.valueOf(logmsg) + (addrs[i] == null ? "none" : ((InetAddress)addrs[i]).getHostAddress()) + (i < addrs.length ? ";" : "");
                    ++i;
                }
                logmsg = String.valueOf(logmsg) + "'";
                Logger.log(new LogEvent(LOGID, logmsg));
                if (bind_ip.length() == 0) {
                    this.clearMaybeVPNs();
                }
            }
            this.firePropertyChange("Default Bind IP");
        }
    }

    @Override
    public String getNetworkInterfacesAsString(boolean only_with_addresses) {
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return "";
        }
        Iterator<NetworkInterface> it = interfaces.iterator();
        StringBuilder sb = new StringBuilder(1024);
        while (it.hasNext()) {
            NetworkInterface ni = it.next();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            if (only_with_addresses && !addresses.hasMoreElements()) continue;
            sb.append(ni.getName());
            sb.append("\t\t(");
            sb.append(ni.getDisplayName());
            sb.append(")\n");
            int i = 0;
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                sb.append("\t");
                sb.append(ni.getName());
                sb.append("[");
                sb.append(i++);
                sb.append("]\t");
                sb.append(address.getHostAddress());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public boolean hasIPV4Potential() {
        return this.supportsIPv4;
    }

    @Override
    public boolean hasIPV6Potential(boolean nio) {
        return nio ? this.supportsIPv6withNIO : this.supportsIPv6;
    }

    @Override
    public InetAddress getLoopbackAddress() {
        if (this.supportsIPv4 && this.supportsIPv6) {
            if (this.preferIPv6) {
                return Inet6Address.getLoopbackAddress();
            }
            InetAddress a = this.getSingleHomedServiceBindAddress();
            if (a.isAnyLocalAddress()) {
                return Inet4Address.getLoopbackAddress();
            }
            if (a instanceof Inet4Address) {
                return Inet4Address.getLoopbackAddress();
            }
            return Inet6Address.getLoopbackAddress();
        }
        if (this.supportsIPv6) {
            return Inet6Address.getLoopbackAddress();
        }
        return Inet4Address.getLoopbackAddress();
    }

    @Override
    public InetAddress[] getBindableAddresses() {
        return this.getBindableAddresses(false, false);
    }

    private InetAddress[] getBindableAddresses(boolean ignore_loopback, boolean ignore_link_local) {
        NetworkAdminNetworkInterface[] interfaces;
        ArrayList<InetAddress> bindable = new ArrayList<InetAddress>();
        NetworkAdminNetworkInterface[] networkAdminNetworkInterfaceArray = interfaces = NetworkAdmin.getSingleton().getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkAdminNetworkInterfaceAddress[] addresses;
            NetworkAdminNetworkInterface intf = networkAdminNetworkInterfaceArray[n2];
            NetworkAdminNetworkInterfaceAddress[] networkAdminNetworkInterfaceAddressArray = addresses = intf.getAddresses();
            int n3 = addresses.length;
            int n4 = 0;
            while (n4 < n3) {
                NetworkAdminNetworkInterfaceAddress address = networkAdminNetworkInterfaceAddressArray[n4];
                InetAddress a = address.getAddress();
                if (!(ignore_loopback && a.isLoopbackAddress() || ignore_link_local && a.isLinkLocalAddress() || !this.canBind(a))) {
                    bindable.add(a);
                }
                ++n4;
            }
            ++n2;
        }
        return bindable.toArray(new InetAddress[bindable.size()]);
    }

    protected boolean canBind(InetAddress bind_ip) {
        ServerSocketChannel ssc = null;
        try {
            ssc = ServerSocketChannel.open();
            ssc.socket().bind(new InetSocketAddress(bind_ip, 0), 16);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
        finally {
            if (ssc != null) {
                try {
                    ssc.close();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    @Override
    public int getBindablePort(int prefer_port) throws IOException {
        int tries = 1024;
        Random random = new Random();
        int i = 1;
        while (i <= 1024) {
            int port = i == 1 && prefer_port != 0 ? prefer_port : (i == 1024 ? 0 : random.nextInt(20000) + 40000);
            ServerSocketChannel ssc = null;
            try {
                ssc = ServerSocketChannel.open();
                ssc.socket().setReuseAddress(true);
                this.bind(ssc, null, port);
                port = ssc.socket().getLocalPort();
                ssc.close();
                return port;
            }
            catch (Throwable e) {
                if (ssc != null) {
                    try {
                        ssc.close();
                    }
                    catch (Throwable f) {
                        Debug.printStackTrace(e);
                    }
                    ssc = null;
                }
                ++i;
            }
        }
        throw new IOException("No bindable ports found");
    }

    protected void bind(ServerSocketChannel ssc, InetAddress address, int port) throws IOException {
        if (address == null) {
            ssc.socket().bind(new InetSocketAddress(port), 1024);
        } else {
            ssc.socket().bind(new InetSocketAddress(address, port), 1024);
        }
    }

    @Override
    public InetAddress guessRoutableBindAddress() {
        try {
            ArrayList<InetAddress> local_addresses = new ArrayList<InetAddress>();
            ArrayList<InetAddress> non_local_addresses = new ArrayList<InetAddress>();
            try {
                NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
                ArrayList<InetAddress> possible = new ArrayList<InetAddress>();
                int i = 0;
                while (i < interfaces.length) {
                    NetworkAdminNetworkInterface intf = interfaces[i];
                    NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
                    int j = 0;
                    while (j < addresses.length) {
                        NetworkAdminNetworkInterfaceAddress address = addresses[j];
                        InetAddress ia = address.getAddress();
                        if (!ia.isLoopbackAddress()) {
                            if (ia.isLinkLocalAddress() || ia.isSiteLocalAddress()) {
                                local_addresses.add(ia);
                            } else {
                                non_local_addresses.add(ia);
                            }
                            if (this.hasIPV4Potential() && ia instanceof Inet4Address || this.hasIPV6Potential() && ia instanceof Inet6Address) {
                                possible.add(ia);
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
                if (possible.size() == 1) {
                    return (InetAddress)possible.get(0);
                }
            }
            catch (Throwable interfaces) {
                // empty catch block
            }
            try {
                NetworkAdminSocksProxy[] socks = this.getSocksProxies();
                if (socks.length > 0) {
                    return this.mapAddressToBindIP(InetAddress.getByName(socks[0].getHost()));
                }
            }
            catch (Throwable socks) {
                // empty catch block
            }
            try {
                NetworkAdminNATDevice[] nat = this.getNATDevices(CoreFactory.getSingleton());
                if (nat.length > 0) {
                    return this.mapAddressToBindIP(nat[0].getAddress());
                }
            }
            catch (Throwable nat) {
                // empty catch block
            }
            try {
                final AESemaphore sem = new AESemaphore("NA:conTest");
                final InetAddress[] can_connect = new InetAddress[1];
                int timeout = 10000;
                int i = 0;
                while (i < local_addresses.size()) {
                    final InetAddress address = (InetAddress)local_addresses.get(i);
                    new AEThread2("NA:conTest", true){

                        @Override
                        public void run() {
                            if (NetworkAdminImpl.this.canConnectWithBind(address, 10000)) {
                                can_connect[0] = address;
                                sem.release();
                            }
                        }
                    }.start();
                    ++i;
                }
                if (sem.reserve(10000L)) {
                    return can_connect[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (non_local_addresses.size() > 0) {
                return this.guessAddress(non_local_addresses);
            }
            if (local_addresses.size() > 0) {
                return this.guessAddress(local_addresses);
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InetAddress getAlternativeProtocolBindAddress(InetAddress address) {
        Set<NetworkInterface> nis = this.old_network_interfaces;
        if (nis == null) {
            return null;
        }
        for (NetworkInterface iface : nis) {
            try {
                for (InterfaceAddress ia : iface.getInterfaceAddresses()) {
                    InterfaceAddress x;
                    InetAddress xa;
                    if (!ia.getAddress().equals(address)) continue;
                    boolean want_v4 = address instanceof Inet6Address;
                    Iterator<InterfaceAddress> iterator = iface.getInterfaceAddresses().iterator();
                    do {
                        if (iterator.hasNext()) continue;
                        return null;
                    } while (want_v4 != (xa = (x = iterator.next()).getAddress()) instanceof Inet4Address);
                    return xa;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected boolean canConnectWithBind(InetAddress bind_address, int timeout) {
        List<String> domains = NetUtils.getTestDomains();
        for (String domain : domains) {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.bind(new InetSocketAddress(bind_address, 0));
                socket.setSoTimeout(timeout);
                InetAddress[] addresses = AddressUtils.getAllByName(domain);
                InetAddress target = null;
                boolean is6 = bind_address instanceof Inet6Address;
                InetAddress[] inetAddressArray = addresses;
                int n = addresses.length;
                int n2 = 0;
                while (n2 < n) {
                    InetAddress ia = inetAddressArray[n2];
                    if (ia instanceof Inet4Address) {
                        if (!is6) {
                            target = ia;
                            break;
                        }
                    } else if (is6) {
                        target = ia;
                        break;
                    }
                    ++n2;
                }
                InetSocketAddress isa = target == null ? new InetSocketAddress(domain, 80) : new InetSocketAddress(target, 80);
                socket.connect(isa, timeout);
                return true;
            }
            catch (Throwable throwable) {
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return false;
    }

    protected InetAddress mapAddressToBindIP(InetAddress address) {
        boolean[] address_bits = this.bytesToBits(address.getAddress());
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        InetAddress best_bind_address = null;
        int best_prefix = 0;
        int i = 0;
        while (i < interfaces.length) {
            NetworkAdminNetworkInterface intf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = intf.getAddresses();
            int j = 0;
            while (j < addresses.length) {
                NetworkAdminNetworkInterfaceAddress bind_address = addresses[j];
                InetAddress ba = bind_address.getAddress();
                byte[] bind_bytes = ba.getAddress();
                if (address_bits.length == bind_bytes.length) {
                    boolean[] bind_bits = this.bytesToBits(bind_bytes);
                    int k = 0;
                    while (k < bind_bits.length) {
                        if (address_bits[k] != bind_bits[k]) break;
                        if (k > best_prefix) {
                            best_prefix = k;
                            best_bind_address = ba;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return best_bind_address;
    }

    protected boolean[] bytesToBits(byte[] bytes) {
        boolean[] res = new boolean[bytes.length * 8];
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i];
            int j = 0;
            while (j < 8) {
                res[i * 8 + j] = (b & (byte)(1 << 7 - j)) != 0;
                ++j;
            }
            ++i;
        }
        return res;
    }

    protected InetAddress guessAddress(List addresses) {
        InetAddress address;
        int i = 0;
        while (i < addresses.size()) {
            address = (InetAddress)addresses.get(i);
            String str = address.getHostAddress();
            if (str.startsWith("192.168.0.") || str.startsWith("192.168.1.")) {
                return address;
            }
            ++i;
        }
        i = 0;
        while (i < addresses.size()) {
            address = (InetAddress)addresses.get(i);
            if (address instanceof Inet4Address) {
                return address;
            }
            ++i;
        }
        i = 0;
        while (i < addresses.size()) {
            address = (InetAddress)addresses.get(i);
            if (address instanceof Inet6Address) {
                return address;
            }
            ++i;
        }
        if (addresses.size() > 0) {
            return (InetAddress)addresses.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void interfacesChanged(boolean first_time) {
        InetAddress[] inetAddressArray = this.gdpa_lock;
        synchronized (this.gdpa_lock) {
            this.gdpa6 = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.firePropertyChange("Network Interfaces");
            this.checkDefaultBindAddress(first_time);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecentPublicAddresses(InetAddress address) {
        try {
            Object object = this.rpa_lock;
            synchronized (object) {
                if (!this.rpa.containsKey(address)) {
                    this.rpa.put(address, "");
                    String key = "netadmin.rpa.ipv" + (address instanceof Inet4Address ? "4" : "6");
                    ArrayList<Object> ips = COConfigurationManager.getListParameter(key, new ArrayList());
                    byte[] a = address.getAddress();
                    for (byte[] byArray : ips) {
                        if (!Arrays.equals(byArray, a)) continue;
                        return;
                    }
                    if ((ips = new ArrayList<Object>(ips.size() + 1)).size() >= 16) {
                        ips.addAll(ips.subList(1, 16));
                    } else {
                        ips.addAll(ips);
                    }
                    ips.add(a);
                    COConfigurationManager.setParameter(key, ips);
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRecentPublicIPs() {
        try {
            Object object = this.rpa_lock;
            synchronized (object) {
                String[] stringArray = new String[]{"4", "6"};
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String suffix = stringArray[n2];
                    List ips = COConfigurationManager.getListParameter("netadmin.rpa.ipv" + suffix, new ArrayList());
                    for (byte[] ip : ips) {
                        this.rpa.put(InetAddress.getByAddress(ip), "");
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecentPublicIPAddress(InetAddress address) {
        long now = SystemTime.getMonotonousTime();
        if (this.rpa_last_refresh == -1L || now - this.rpa_last_refresh > 60000L) {
            this.getDefaultPublicAddress(true);
            this.getDefaultPublicAddressV6();
            this.rpa_last_refresh = now;
        }
        Object object = this.rpa_lock;
        synchronized (object) {
            boolean result = this.rpa.containsKey(address);
            return result;
        }
    }

    @Override
    public InetAddress getDefaultPublicAddress() {
        return this.getDefaultPublicAddress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InetAddress getDefaultPublicAddress(boolean peek) {
        InetAddress[] inetAddressArray = this.gdpa_lock;
        synchronized (this.gdpa_lock) {
            AESemaphore sem;
            long now = SystemTime.getMonotonousTime();
            if (this.gdpa_sem == null) {
                boolean do_lookup = true;
                if (peek && this.gdpa_last_lookup != 0L && now - this.gdpa_last_lookup <= 60000L) {
                    do_lookup = false;
                }
                if (do_lookup) {
                    this.gdpa_last_lookup = now;
                    this.gdpa_sem = sem = new AESemaphore("getDefaultPublicAddress");
                    new AEThread2("getDefaultPublicAddress"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            block18: {
                                InetAddress address = null;
                                try {
                                    try {
                                        Utilities utils = PluginInitializer.getDefaultInterface().getUtilities();
                                        address = utils.getPublicAddress();
                                        if (address == null) {
                                            address = utils.getPublicAddress(true);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        InetAddress[] inetAddressArray = NetworkAdminImpl.this.gdpa_lock;
                                        synchronized (inetAddressArray) {
                                            InetAddress old_address = NetworkAdminImpl.this.gdpa_lock[0];
                                            if (old_address == null || !old_address.equals(address)) {
                                                NetworkAdminImpl.this.updateRecentPublicAddresses(address);
                                            }
                                            ((NetworkAdminImpl)NetworkAdminImpl.this).gdpa_lock[0] = address;
                                            sem.releaseForever();
                                            NetworkAdminImpl.this.gdpa_sem = null;
                                            NetworkAdminImpl.this.gdpa_initial_sem.releaseForever();
                                            break block18;
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    InetAddress[] inetAddressArray = NetworkAdminImpl.this.gdpa_lock;
                                    synchronized (inetAddressArray) {
                                        InetAddress old_address = NetworkAdminImpl.this.gdpa_lock[0];
                                        if (old_address == null || !old_address.equals(address)) {
                                            NetworkAdminImpl.this.updateRecentPublicAddresses(address);
                                        }
                                        ((NetworkAdminImpl)NetworkAdminImpl.this).gdpa_lock[0] = address;
                                        sem.releaseForever();
                                        NetworkAdminImpl.this.gdpa_sem = null;
                                        NetworkAdminImpl.this.gdpa_initial_sem.releaseForever();
                                    }
                                    throw throwable;
                                }
                                InetAddress[] inetAddressArray = NetworkAdminImpl.this.gdpa_lock;
                                synchronized (inetAddressArray) {
                                    InetAddress old_address = NetworkAdminImpl.this.gdpa_lock[0];
                                    if (old_address == null || !old_address.equals(address)) {
                                        NetworkAdminImpl.this.updateRecentPublicAddresses(address);
                                    }
                                    ((NetworkAdminImpl)NetworkAdminImpl.this).gdpa_lock[0] = address;
                                    sem.releaseForever();
                                    NetworkAdminImpl.this.gdpa_sem = null;
                                    NetworkAdminImpl.this.gdpa_initial_sem.releaseForever();
                                }
                            }
                        }
                    }.start();
                } else {
                    sem = null;
                }
            } else {
                sem = this.gdpa_sem;
            }
            if (this.gdpa_last_fail != 0L && SystemTime.getMonotonousTime() - this.gdpa_last_fail < 300000L) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return this.gdpa_lock[0];
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (peek) {
                this.gdpa_initial_sem.reserve(10000L);
                inetAddressArray = this.gdpa_lock;
                synchronized (this.gdpa_lock) {
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return this.gdpa_lock[0];
                }
            }
            boolean worked = sem.reserve(10000L);
            InetAddress[] inetAddressArray2 = this.gdpa_lock;
            synchronized (this.gdpa_lock) {
                if (worked) {
                    this.gdpa_last_fail = 0L;
                } else {
                    this.gdpa_initial_sem.releaseForever();
                    this.gdpa_last_fail = SystemTime.getMonotonousTime();
                }
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return this.gdpa_lock[0];
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public InetAddress getDefaultPublicAddressV6() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasDHTIPV4() {
        return !this.ignoreIPv4;
    }

    @Override
    public boolean hasDHTIPV6() {
        if (this.hasIPV6Potential(false)) {
            InetAddress v6 = this.getDefaultPublicAddressV6();
            if (v6 == null) {
                return false;
            }
            if (Constants.IS_CVS_VERSION) {
                return true;
            }
            return !AddressUtils.isTeredo(v6);
        }
        return false;
    }

    protected void firePropertyChange(String property) {
        for (NetworkAdminPropertyChangeListener l : this.listeners) {
            try {
                l.propertyChanged(property);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public NetworkAdminNetworkInterface[] getInterfaces() {
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return new NetworkAdminNetworkInterface[0];
        }
        NetworkAdminNetworkInterface[] res = new NetworkAdminNetworkInterface[interfaces.size()];
        Iterator<NetworkInterface> it = interfaces.iterator();
        int pos = 0;
        while (it.hasNext()) {
            NetworkInterface ni = it.next();
            res[pos++] = new networkInterface(ni);
        }
        return res;
    }

    @Override
    public NetworkAdminProtocol[] getOutboundProtocols(Core core) {
        NetworkAdminProtocol[] res = new NetworkAdminProtocol[]{new NetworkAdminProtocolImpl(core, 1), new NetworkAdminProtocolImpl(core, 2), new NetworkAdminProtocolImpl(core, 3)};
        return res;
    }

    @Override
    public NetworkAdminProtocol createInboundProtocol(Core core, int type, int port) {
        return new NetworkAdminProtocolImpl(core, type, port);
    }

    @Override
    public NetworkAdminProtocol[] getInboundProtocols(Core core) {
        HTTPNetworkManager http_manager;
        int port;
        ArrayList<NetworkAdminProtocolImpl> protocols = new ArrayList<NetworkAdminProtocolImpl>();
        TCPNetworkManager tcp_manager = TCPNetworkManager.getSingleton();
        if (tcp_manager.isDefaultTCPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(core, 2, tcp_manager.getDefaultTCPListeningPortNumber()));
        }
        UDPNetworkManager udp_manager = UDPNetworkManager.getSingleton();
        int done_udp = -1;
        if (udp_manager.isUDPListenerEnabled()) {
            done_udp = udp_manager.getUDPListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(core, 3, done_udp));
        }
        if (udp_manager.isUDPNonDataListenerEnabled() && (port = udp_manager.getUDPNonDataListeningPortNumber()) != done_udp) {
            done_udp = udp_manager.getUDPNonDataListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(core, 3, done_udp));
        }
        if ((http_manager = HTTPNetworkManager.getSingleton()).isHTTPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(core, 1, http_manager.getHTTPListeningPortNumber()));
        }
        return protocols.toArray(new NetworkAdminProtocol[protocols.size()]);
    }

    @Override
    public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
        return protocol.test(null);
    }

    @Override
    public boolean isSocksActive() {
        Proxy proxy = AEProxySelectorFactory.getSelector().getActiveProxy();
        return proxy != null && proxy.type() == Proxy.Type.SOCKS;
    }

    @Override
    public NetworkAdminSocksProxy createSocksProxy(String host, int port, String username, String password) {
        return new NetworkAdminSocksProxyImpl(host, "" + port, username, password);
    }

    @Override
    public NetworkAdminSocksProxy[] getSocksProxies() {
        boolean enable_proxy = COConfigurationManager.getBooleanParameter("Enable.Proxy");
        boolean enable_socks = COConfigurationManager.getBooleanParameter("Enable.SOCKS");
        ArrayList<NetworkAdminSocksProxyImpl> res = new ArrayList<NetworkAdminSocksProxyImpl>();
        if (enable_proxy && enable_socks) {
            NetworkAdminSocksProxyImpl p2;
            String password;
            String user;
            String port;
            String host = System.getProperty("socksProxyHost", "").trim();
            NetworkAdminSocksProxyImpl p1 = new NetworkAdminSocksProxyImpl(host, port = System.getProperty("socksProxyPort", "").trim(), user = System.getProperty("java.net.socks.username", "").trim(), password = System.getProperty("java.net.socks.password", "").trim());
            if (p1.isConfigured()) {
                res.add(p1);
            }
            host = COConfigurationManager.getStringParameter("Proxy.Host");
            port = COConfigurationManager.getStringParameter("Proxy.Port");
            user = COConfigurationManager.getStringParameter("Proxy.Username");
            if (user.trim().equalsIgnoreCase("<none>")) {
                user = "";
            }
            if (!(!(p2 = new NetworkAdminSocksProxyImpl(host, port, user, password = COConfigurationManager.getStringParameter("Proxy.Password"))).isConfigured() || p1.isConfigured() && p1.sameAs(p2))) {
                res.add(p2);
            }
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && !COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
            int i = 1;
            while (i <= 3) {
                String password;
                NetworkAdminSocksProxyImpl pn;
                String suffix = i == 1 ? "" : "." + i;
                String host = COConfigurationManager.getStringParameter("Proxy.Data.Host" + suffix);
                String port = COConfigurationManager.getStringParameter("Proxy.Data.Port" + suffix);
                String user = COConfigurationManager.getStringParameter("Proxy.Data.Username" + suffix);
                if (user.trim().equalsIgnoreCase("<none>")) {
                    user = "";
                }
                if ((pn = new NetworkAdminSocksProxyImpl(host, port, user, password = COConfigurationManager.getStringParameter("Proxy.Data.Password" + suffix))).isConfigured()) {
                    res.add(pn);
                }
                ++i;
            }
        }
        return res.toArray(new NetworkAdminSocksProxy[res.size()]);
    }

    @Override
    public NetworkAdminHTTPProxy getHTTPProxy() {
        NetworkAdminHTTPProxyImpl res = new NetworkAdminHTTPProxyImpl();
        if (!res.isConfigured()) {
            res = null;
        }
        return res;
    }

    @Override
    public NetworkAdminNATDevice[] getNATDevices(Core core) {
        ArrayList<NetworkAdminNATDeviceImpl> devices = new ArrayList<NetworkAdminNATDeviceImpl>();
        try {
            PluginInterface upnp_pi = core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (upnp_pi != null) {
                UPnPPluginService[] services;
                UPnPPlugin upnp = (UPnPPlugin)upnp_pi.getPlugin();
                UPnPPluginService[] uPnPPluginServiceArray = services = upnp.getServices();
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    UPnPPluginService service = uPnPPluginServiceArray[n2];
                    NetworkAdminNATDeviceImpl dev = new NetworkAdminNATDeviceImpl(service);
                    boolean same = false;
                    for (NetworkAdminNATDeviceImpl d : devices) {
                        if (!d.sameAs(dev)) continue;
                        same = true;
                        break;
                    }
                    if (!same) {
                        devices.add(dev);
                    }
                    ++n2;
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return devices.toArray(new NetworkAdminNATDevice[devices.size()]);
    }

    @Override
    public NetworkAdminASN getCurrentASN() {
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        if (asns.size() > 0) {
            Map m = (Map)asns.get(0);
            return this.ASNFromMap(m);
        }
        return new NetworkAdminASNImpl(true, "", "", "");
    }

    protected Map ASNToMap(NetworkAdminASNImpl x) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        byte[] as = new byte[]{};
        byte[] asn = new byte[]{};
        byte[] bgp = new byte[]{};
        try {
            as = x.getAS().getBytes("UTF-8");
            asn = x.getASName().getBytes("UTF-8");
            bgp = x.getBGPPrefix().getBytes("UTF-8");
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        m.put("as", as);
        m.put("name", asn);
        m.put("bgp", bgp);
        m.put("v", x.isIPv4() ? 4 : 6);
        return m;
    }

    protected NetworkAdminASNImpl ASNFromMap(Map m) {
        boolean ipv4 = true;
        String as = "";
        String asn = "";
        String bgp = "";
        try {
            as = new String((byte[])m.get("as"), "UTF-8");
            asn = new String((byte[])m.get("name"), "UTF-8");
            bgp = new String((byte[])m.get("bgp"), "UTF-8");
            if (m.containsKey("v")) {
                ipv4 = ((Number)m.get("v")).intValue() == 4;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return new NetworkAdminASNImpl(ipv4, as, asn, bgp);
    }

    @Override
    public NetworkAdminASN lookupCurrentASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN current = this.getCurrentASN();
        if (current.matchesCIDR(address)) {
            return current;
        }
        List asns = COConfigurationManager.getListParameter("ASN Details", new ArrayList());
        int i = 0;
        while (i < asns.size()) {
            Map m = (Map)asns.get(i);
            NetworkAdminASNImpl x = this.ASNFromMap(m);
            if (x.matchesCIDR(address)) {
                asns.remove(i);
                asns.add(0, m);
                this.firePropertyChange("AS");
                return x;
            }
            ++i;
        }
        if (this.asn_ips_checked.contains(address)) {
            return current;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.last_asn_lookup_time || now - this.last_asn_lookup_time > 1800000L) {
            this.last_asn_lookup_time = now;
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
            NetworkAdminASNImpl x = lookup.lookup();
            this.asn_ips_checked.add(address);
            asns.add(0, this.ASNToMap(x));
            this.firePropertyChange("AS");
            return x;
        }
        return current;
    }

    @Override
    public NetworkAdminASN lookupASN(InetAddress address) throws NetworkAdminException {
        NetworkAdminASN existing = this.getFromASHistory(address);
        if (existing != null) {
            return existing;
        }
        NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
        NetworkAdminASNImpl result = lookup.lookup();
        this.addToASHistory(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lookupASN(final InetAddress address, final NetworkAdminASNListener listener) {
        Map<InetAddress, NetworkAdminASN> map = this.async_asn_history;
        synchronized (map) {
            NetworkAdminASN existing = this.async_asn_history.get(address);
            if (existing != null) {
                listener.success(existing);
            }
        }
        int queue_size = this.async_asn_dispacher.getQueueSize();
        if (queue_size >= 1024) {
            listener.failed(new NetworkAdminException("Too many outstanding lookups"));
        } else {
            this.async_asn_dispacher.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void runSupport() {
                    Map<InetAddress, NetworkAdminASN> map = NetworkAdminImpl.this.async_asn_history;
                    synchronized (map) {
                        NetworkAdminASN existing = NetworkAdminImpl.this.async_asn_history.get(address);
                        if (existing != null) {
                            listener.success(existing);
                            return;
                        }
                    }
                    try {
                        NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(address);
                        NetworkAdminASNImpl result = lookup.lookup();
                        Map<InetAddress, NetworkAdminASN> map2 = NetworkAdminImpl.this.async_asn_history;
                        synchronized (map2) {
                            NetworkAdminImpl.this.async_asn_history.put(address, result);
                        }
                        listener.success(result);
                    }
                    catch (NetworkAdminException e) {
                        listener.failed(e);
                    }
                    catch (Throwable e) {
                        listener.failed(new NetworkAdminException("lookup failed", e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToASHistory(NetworkAdminASN asn) {
        List list = this.as_history;
        synchronized (list) {
            boolean found = false;
            int i = 0;
            while (i < this.as_history.size()) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (asn.getAS().equals(x.getAS())) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                this.as_history.add(asn);
                if (this.as_history.size() > 256) {
                    this.as_history.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NetworkAdminASN getFromASHistory(InetAddress address) {
        List list = this.as_history;
        synchronized (list) {
            int i = 0;
            while (i < this.as_history.size()) {
                NetworkAdminASN x = (NetworkAdminASN)this.as_history.get(i);
                if (x.matchesCIDR(address)) {
                    return x;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void runInitialChecks(Core core) {
        ClientInstanceManager i_man = core.getInstanceManager();
        final ClientInstance my_instance = i_man.getMyInstance();
        i_man.addListener(new ClientInstanceManagerListener(){
            private InetAddress external_address;

            @Override
            public void instanceFound(ClientInstance instance) {
            }

            @Override
            public void instanceChanged(ClientInstance instance) {
                if (instance == my_instance) {
                    InetAddress address = instance.getExternalAddress();
                    if (this.external_address == null || !this.external_address.equals(address)) {
                        this.external_address = address;
                        if (!address.isLoopbackAddress()) {
                            try {
                                NetworkAdminImpl.this.lookupCurrentASN(address);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                }
            }

            @Override
            public void instanceLost(ClientInstance instance) {
            }

            @Override
            public void instanceTracked(ClientInstanceTracked instance) {
            }
        });
        if (COConfigurationManager.getBooleanParameter("Proxy.Check.On.Start")) {
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            int i = 0;
            while (i < socks.length) {
                NetworkAdminSocksProxy sock = socks[i];
                try {
                    sock.getVersionsSupported();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "Socks proxy " + sock.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
                ++i;
            }
            NetworkAdminHTTPProxy http_proxy = this.getHTTPProxy();
            if (http_proxy != null) {
                try {
                    http_proxy.getDetails();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "HTTP proxy " + http_proxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
        }
        if (COConfigurationManager.getBooleanParameter("Check Bind IP On Start")) {
            this.checkBindAddresses(true);
        }
        NetworkAdminSpeedTestScheduler nast = NetworkAdminSpeedTestSchedulerImpl.getInstance();
        nast.initialise();
    }

    @Override
    public boolean canTraceRoute() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability);
    }

    public NetworkAdminNode[] getRoute(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canTraceRoute()) {
            throw new NetworkAdminException("No trace-route capability on platform");
        }
        final ArrayList nodes = new ArrayList();
        try {
            pm.traceRoute(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                @Override
                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean result;
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes.add(node);
                    }
                    return (result = listener == null ? true : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis))) && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("trace-route failed", e);
        }
        return nodes.toArray(new NetworkAdminNode[nodes.size()]);
    }

    @Override
    public boolean canPing() {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        return pm.hasCapability(PlatformManagerCapabilities.PingAvailability);
    }

    public NetworkAdminNode pingTarget(InetAddress interface_address, InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
        PlatformManager pm = PlatformManagerFactory.getPlatformManager();
        if (!this.canPing()) {
            throw new NetworkAdminException("No ping capability on platform");
        }
        final NetworkAdminNode[] nodes = new NetworkAdminNode[1];
        try {
            pm.ping(interface_address, target, new PlatformManagerPingCallback(){
                private long start_time = SystemTime.getCurrentTime();

                @Override
                public boolean reportNode(int distance, InetAddress address, int millis) {
                    boolean result;
                    boolean timeout = false;
                    if (max_millis >= 0) {
                        long now = SystemTime.getCurrentTime();
                        if (now < this.start_time) {
                            this.start_time = now;
                        }
                        if (now - this.start_time >= (long)max_millis) {
                            timeout = true;
                        }
                    }
                    networkNode node = null;
                    if (address != null) {
                        node = new networkNode(address, distance, millis);
                        nodes[0] = node;
                    }
                    return (result = listener == null ? false : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis))) && !timeout;
                }
            });
        }
        catch (PlatformManagerException e) {
            throw new NetworkAdminException("ping failed", e);
        }
        return nodes[0];
    }

    @Override
    public void getRoutes(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            int j = 0;
            while (j < addresses.length) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (!ia.isLoopbackAddress() && !(ia instanceof Inet6Address)) {
                    final AESemaphore sem = new AESemaphore("parallelRouter");
                    final ArrayList trace = new ArrayList();
                    sems.add(sem);
                    traces.add(trace);
                    new AEThread2("parallelRouter", true){

                        @Override
                        public void run() {
                            try {
                                try {
                                    address.getRoute(target, 30000, new NetworkAdminRouteListener(){

                                        @Override
                                        public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                            trace.add(node);
                                            NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                            trace.toArray(route);
                                            return listener.foundNode(address, route, distance, rtt);
                                        }

                                        @Override
                                        public boolean timeout(int distance) {
                                            NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                            trace.toArray(route);
                                            return listener.timeout(address, route, distance);
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    sem.release();
                                }
                            }
                            finally {
                                sem.release();
                            }
                        }
                    }.start();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sems.size()) {
            ((AESemaphore)sems.get(i)).reserve();
            ++i;
        }
    }

    @Override
    public void pingTargets(final InetAddress target, int max_millis, final NetworkAdminRoutesListener listener) throws NetworkAdminException {
        ArrayList<AESemaphore> sems = new ArrayList<AESemaphore>();
        ArrayList traces = new ArrayList();
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            NetworkAdminNetworkInterface interf = interfaces[i];
            NetworkAdminNetworkInterfaceAddress[] addresses = interf.getAddresses();
            int j = 0;
            while (j < addresses.length) {
                final NetworkAdminNetworkInterfaceAddress address = addresses[j];
                InetAddress ia = address.getAddress();
                if (!ia.isLoopbackAddress() && !(ia instanceof Inet6Address)) {
                    final AESemaphore sem = new AESemaphore("parallelPinger");
                    final ArrayList trace = new ArrayList();
                    sems.add(sem);
                    traces.add(trace);
                    new AEThread2("parallelPinger", true){

                        @Override
                        public void run() {
                            try {
                                try {
                                    address.pingTarget(target, 30000, new NetworkAdminRouteListener(){

                                        @Override
                                        public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
                                            trace.add(node);
                                            NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                            trace.toArray(route);
                                            return listener.foundNode(address, route, distance, rtt);
                                        }

                                        @Override
                                        public boolean timeout(int distance) {
                                            NetworkAdminNode[] route = new NetworkAdminNode[trace.size()];
                                            trace.toArray(route);
                                            return listener.timeout(address, route, distance);
                                        }
                                    });
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                    sem.release();
                                }
                            }
                            finally {
                                sem.release();
                            }
                        }
                    }.start();
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < sems.size()) {
            ((AESemaphore)sems.get(i)).reserve();
            ++i;
        }
    }

    @Override
    public boolean mustBind() {
        return this.forceBind;
    }

    @Override
    public boolean hasMissingForcedBind() {
        Object[] status = this.getBindingStatus();
        return (Integer)status[0] == 3;
    }

    @Override
    public String getBindStatus() {
        Object[] status = this.getBindingStatus();
        int state = (Integer)status[0];
        if (state == 0) {
            return "No binding configured";
        }
        String str = "";
        str = state == 1 ? "Binding OK" : (state == 2 ? "Binding warning" : "Binding error");
        String status_str = (String)status[1];
        if (status_str.length() > 0) {
            str = String.valueOf(str) + ": " + status_str;
        }
        return str;
    }

    public Object[] getBindingStatus() {
        long now = SystemTime.getMonotonousTime();
        if (this.bs_last_value != null && now - this.bs_last_calc < 30000L) {
            return this.bs_last_value;
        }
        String bind_ips = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        if (bind_ips.length() == 0) {
            return new Object[]{0, ""};
        }
        boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
        String missing = this.checkBindAddresses(false);
        InetAddress[] binds = this.getAllBindAddresses(false);
        ArrayList<InetAddress> bindable = new ArrayList<InetAddress>();
        ArrayList<InetAddress> unbindable = new ArrayList<InetAddress>();
        InetAddress[] inetAddressArray = binds;
        int n = binds.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress b = inetAddressArray[n2];
            if (this.canBind(b)) {
                bindable.add(b);
            } else if (!b.isLoopbackAddress() && !b.isLinkLocalAddress()) {
                unbindable.add(b);
            }
            ++n2;
        }
        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
        HashMap<InetAddress, int[]> public_lookup_map = new HashMap<InetAddress, int[]>();
        HashMap<String, int[]> non_public_lookup_map = new HashMap<String, int[]>();
        boolean ignore_bind_for_lan_addresses = COConfigurationManager.getBooleanParameter("Ignore Bind For LAN");
        for (NetworkConnectionBase connection : connections) {
            TransportBase tb = connection.getTransportBase();
            if (!(tb instanceof Transport)) continue;
            Transport transport = (Transport)tb;
            InetSocketAddress notional_address = connection.getEndpoint().getNotionalAddress();
            String ip = AddressUtils.getHostAddress(notional_address);
            String network = AENetworkClassifier.categoriseAddress(ip);
            if (network == "Public") {
                InetSocketAddress socket_address;
                TransportStartpoint start = transport.getTransportStartpoint();
                if (start == null || (socket_address = start.getProtocolStartpoint().getAddress()) == null) continue;
                InetAddress address = socket_address.getAddress();
                int[] counts = (int[])public_lookup_map.get(address);
                if (counts == null) {
                    counts = new int[3];
                    public_lookup_map.put(address, counts);
                }
                if (connection.isIncoming()) {
                    counts[0] = counts[0] + 1;
                    continue;
                }
                counts[1] = counts[1] + 1;
                if (!ignore_bind_for_lan_addresses || AddressUtils.isLANLocalAddress(notional_address) != 1 || AddressUtils.isExplicitLANRateLimitAddress(notional_address)) continue;
                counts[2] = counts[2] + 1;
                continue;
            }
            int[] counts = (int[])non_public_lookup_map.get(network);
            if (counts == null) {
                counts = new int[2];
                non_public_lookup_map.put(network, counts);
            }
            if (connection.isIncoming()) {
                counts[0] = counts[0] + 1;
                continue;
            }
            counts[1] = counts[1] + 1;
        }
        int status = 1;
        if (unbindable.size() > 0 || missing != null) {
            status = enforceBind ? 3 : 2;
        }
        String str = MessageText.getString("network.admin.binding.state", new String[]{this.getString(bindable), MessageText.getString(enforceBind ? "GeneralView.yes" : "GeneralView.no").toLowerCase()});
        if (unbindable.size() > 0) {
            str = String.valueOf(str) + "\nUnbindable: " + this.getString(unbindable);
        }
        if (missing != null) {
            str = String.valueOf(str) + "\n" + MessageText.getString("label.missing") + ": " + missing;
        }
        boolean bad_connections = false;
        if (public_lookup_map.size() + non_public_lookup_map.size() == 0) {
            str = String.valueOf(str) + "\n" + MessageText.getString("label.no.connections");
        } else {
            String s;
            int[] counts;
            HashSet<InetAddress> extra = new HashSet<InetAddress>();
            InetAddress[] asb = this.additionalServiceBindIPs;
            if (asb != null) {
                extra.addAll(Arrays.asList(asb));
            }
            String con_str = "";
            for (Map.Entry entry : public_lookup_map.entrySet()) {
                InetAddress address = (InetAddress)entry.getKey();
                counts = (int[])entry.getValue();
                if (address.isLoopbackAddress()) continue;
                s = address.isAnyLocalAddress() ? "*" : address.getHostAddress();
                if (!bindable.contains(address) && (counts[1] != counts[2] || counts[0] != 0 && !extra.contains(address))) {
                    bad_connections = true;
                }
                s = String.valueOf(s) + " - " + MessageText.getString("label.in") + "=" + counts[0] + ", " + MessageText.getString("label.out") + "=" + counts[1];
                con_str = String.valueOf(con_str) + (con_str.length() == 0 ? "" : "; ") + s.toLowerCase();
            }
            for (Map.Entry entry : non_public_lookup_map.entrySet()) {
                String net = (String)entry.getKey();
                counts = (int[])entry.getValue();
                s = net;
                s = String.valueOf(s) + " - " + MessageText.getString("label.in") + "=" + counts[0] + ", " + MessageText.getString("label.out") + "=" + counts[1];
                con_str = String.valueOf(con_str) + (con_str.length() == 0 ? "" : "; ") + s.toLowerCase();
            }
            str = String.valueOf(str) + "\n" + MessageText.getString("label.connections") + ": " + con_str;
        }
        if (bad_connections) {
            status = enforceBind ? 3 : 2;
        }
        this.bs_last_value = new Object[]{status, str};
        this.bs_last_calc = now;
        return this.bs_last_value;
    }

    private String getString(List<InetAddress> addresses) {
        if (addresses.size() == 0) {
            return "<none>";
        }
        String str = "";
        for (InetAddress address : addresses) {
            str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + address.getHostAddress();
        }
        return str;
    }

    void checkConnectionRoutes() {
        if (this.getAllBindAddresses(false).length > 0) {
            return;
        }
        this.checkActiveConnections();
        this.checkIPV6Routing();
    }

    /*
     * WARNING - void declaration
     */
    void checkActiveConnections() {
        InetAddress address;
        Object socket_address;
        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
        boolean found_wildcard = false;
        int tcp_found = 0;
        HashMap<InetAddress, Object[]> lookup_map = new HashMap<InetAddress, Object[]>();
        HashMap<String, Object[]> bind_map = new HashMap<String, Object[]>();
        for (NetworkConnectionBase connection : connections) {
            TransportStartpoint transportStartpoint;
            Transport transport;
            TransportBase tb;
            if (connection.isIncoming() || !((tb = connection.getTransportBase()) instanceof Transport) || !(transport = (Transport)tb).isTCP() || (transportStartpoint = transport.getTransportStartpoint()) == null || (socket_address = transportStartpoint.getProtocolStartpoint().getAddress()) == null) continue;
            ++tcp_found;
            address = ((InetSocketAddress)socket_address).getAddress();
            if (address.isAnyLocalAddress()) {
                found_wildcard = true;
                continue;
            }
            Object[] details = (Object[])lookup_map.get(address);
            if (details == null && !lookup_map.containsKey(address)) {
                details = this.getInterfaceForAddress(address);
                lookup_map.put(address, details);
            }
            if (details == null || !(details[0] instanceof NetworkInterface)) continue;
            NetworkInterface intf = (NetworkInterface)details[0];
            InetAddress intf_address = details.length == 1 ? null : (InetAddress)details[1];
            String key = String.valueOf(intf.getName()) + "/" + intf_address;
            Object[] entry = (Object[])bind_map.get(key);
            if (entry == null) {
                entry = new Object[]{new int[1], details};
                bind_map.put(key, entry);
            }
            int[] nArray = (int[])entry[0];
            nArray[0] = nArray[0] + 1;
        }
        if (tcp_found > 8) {
            InetAddress[] bindable_addresses;
            Object[] bound_details;
            NetworkInterface bound_intf;
            int bound_type;
            if (found_wildcard && bind_map.size() == 0) {
                InetAddress[] bindable_addresses2 = this.getBindableAddresses(true, true);
                if (bindable_addresses2.length > 1) {
                    HashMap<String, NetworkInterface> intf_map = new HashMap<String, NetworkInterface>();
                    socket_address = bindable_addresses2;
                    int n = bindable_addresses2.length;
                    int transport = 0;
                    while (transport < n) {
                        Object address2 = socket_address[transport];
                        Object[] details = this.getInterfaceForAddress((InetAddress)address2);
                        if (details != null && details[0] instanceof NetworkInterface) {
                            NetworkInterface intf = (NetworkInterface)details[0];
                            intf_map.put(intf.getName(), intf);
                        }
                        ++transport;
                    }
                    if (intf_map.size() > 1) {
                        int eth_like = 0;
                        HashMap<String, NetworkInterface> vpn_like = new HashMap<String, NetworkInterface>();
                        for (Map.Entry entry : intf_map.entrySet()) {
                            int type = this.categoriseIntf((NetworkInterface)entry.getValue());
                            if (type == 1) {
                                ++eth_like;
                                continue;
                            }
                            if (type != 2) continue;
                            vpn_like.put((String)entry.getKey(), (NetworkInterface)entry.getValue());
                        }
                        if (vpn_like.size() == 1 && eth_like > 0) {
                            this.maybeVPN((NetworkInterface)vpn_like.values().iterator().next());
                        }
                    }
                }
            } else if (!found_wildcard && bind_map.size() == 1 && (bound_type = this.categoriseIntf(bound_intf = (NetworkInterface)(bound_details = (Object[])((Object[])bind_map.values().iterator().next())[1])[0])) == 2 && !this.maybeVPNDone(bound_intf) && (bindable_addresses = this.getBindableAddresses(true, true)).length > 1) {
                void var10_18;
                boolean bl = false;
                int vpn_like = 0;
                InetAddress[] inetAddressArray = bindable_addresses;
                int n = bindable_addresses.length;
                int n2 = 0;
                while (n2 < n) {
                    NetworkInterface intf;
                    address = inetAddressArray[n2];
                    Object[] details = this.getInterfaceForAddress(address);
                    if (details != null && details[0] instanceof NetworkInterface && (intf = (NetworkInterface)details[0]) != bound_intf) {
                        int type = this.categoriseIntf(intf);
                        if (type == 1) {
                            ++var10_18;
                        } else if (type == 2) {
                            ++vpn_like;
                        }
                    }
                    ++n2;
                }
                if (vpn_like == 0 && var10_18 > 0) {
                    this.maybeVPN(bound_intf);
                }
            }
        }
    }

    void checkIPV6Routing() {
        if (this.isIPV6Enabled()) {
            return;
        }
        if (this.testedIPv6Routing) {
            return;
        }
        if (COConfigurationManager.getBooleanParameter("IPV6 Enable Support Auto Done")) {
            this.testedIPv6Routing = true;
            return;
        }
        try {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            for (NetworkInterface ni : this.old_network_interfaces) {
                try {
                    for (InterfaceAddress ia : ni.getInterfaceAddresses()) {
                        InetAddress a = ia.getAddress();
                        if (!AddressUtils.isGlobalAddressV6(a) || AddressUtils.isTeredo(a) || AddressUtils.is6to4(a)) continue;
                        addresses.add(a);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!addresses.isEmpty()) {
                this.testedIPv6Routing = true;
                AEThread2.createAndStartDaemon("IPv6RouteTest", () -> {
                    for (InetAddress address : addresses) {
                        if (FeatureAvailability.isAutoIPV6EnableDisabled() && !this.canConnectWithBind(address, 30000)) continue;
                        COConfigurationManager.setParameter("IPV6 Enable Support Auto Done", true);
                        COConfigurationManager.setParameter("IPV6 Enable Support", true);
                        Logger.log(new LogAlert(true, 0, MessageText.getString("network.admin.ipv6.auto.enabled", new String[]{address.toString()})));
                        break;
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    void clearMaybeVPNs() {
        Set<String> keys = COConfigurationManager.getDefinedParameters();
        for (String key : keys) {
            if (!key.startsWith("network.admin.maybe.vpn.done.")) continue;
            COConfigurationManager.removeParameter(key);
        }
    }

    private boolean maybeVPNDone(NetworkInterface intf) {
        if (COConfigurationManager.getBooleanParameter("network.admin.maybe.vpn.enable")) {
            return COConfigurationManager.getBooleanParameter("network.admin.maybe.vpn.done." + this.getConfigKey(intf), false);
        }
        return true;
    }

    private void maybeVPN(final NetworkInterface intf) {
        final UIManager ui_manager = StaticUtilities.getUIManager(5000L);
        if (ui_manager == null) {
            return;
        }
        if (this.maybeVPNDone(intf)) {
            return;
        }
        COConfigurationManager.setParameter("network.admin.maybe.vpn.done." + this.getConfigKey(intf), true);
        new AEThread2("NetworkAdmin:vpn?"){

            @Override
            public void run() {
                String msg_details = MessageText.getString("network.admin.maybe.vpn.msg", new String[]{String.valueOf(intf.getName()) + " - " + intf.getDisplayName()});
                long res = ui_manager.showMessageBox("network.admin.maybe.vpn.title", "!" + msg_details + "!", 36L);
                if (res == 4L) {
                    COConfigurationManager.setParameter("User Mode", 2);
                    COConfigurationManager.setParameter("Bind IP", intf.getName());
                    COConfigurationManager.setParameter("Enforce Bind IP", true);
                    COConfigurationManager.setParameter("Check Bind IP On Start", true);
                    COConfigurationManager.save();
                    try {
                        Set<NetworkConnectionBase> connections = NetworkManager.getSingleton().getConnections();
                        HashMap<InetAddress, Object[]> lookup_map = new HashMap<InetAddress, Object[]>();
                        for (NetworkConnectionBase connection : connections) {
                            InetAddress address;
                            Object[] details;
                            InetSocketAddress socket_address;
                            TransportStartpoint start;
                            TransportBase tb = connection.getTransportBase();
                            if (!(tb instanceof Transport)) continue;
                            boolean ok = false;
                            Transport transport = (Transport)tb;
                            if (transport.isTCP() && (start = transport.getTransportStartpoint()) != null && (socket_address = start.getProtocolStartpoint().getAddress()) != null && (details = (Object[])lookup_map.get(address = socket_address.getAddress())) == null) {
                                if (!lookup_map.containsKey(address)) {
                                    details = NetworkAdminImpl.this.getInterfaceForAddress(address);
                                    lookup_map.put(address, details);
                                }
                                if (details[0] == intf) {
                                    ok = true;
                                }
                            }
                            if (ok) continue;
                            transport.close("Explicit bind IP set, disconnecting incompatible connections");
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    NetworkAdminImpl.this.bs_last_calc = 0L;
                    ui_manager.showMessageBox("settings.updated.title", "settings.updated.msg", 1L);
                }
            }
        }.start();
    }

    private String getConfigKey(NetworkInterface intf) {
        try {
            return Base32.encode(intf.getName().getBytes("UTF-8"));
        }
        catch (Throwable e) {
            Debug.out(e);
            return "derp";
        }
    }

    private int categoriseIntf(NetworkInterface intf) {
        String name = intf.getName().toLowerCase();
        String desc = intf.getDisplayName().toLowerCase();
        if (desc.startsWith("tap-") || desc.contains("vpn")) {
            return 2;
        }
        if (name.startsWith("ppp")) {
            return 2;
        }
        if (name.startsWith("tun")) {
            return 2;
        }
        if (name.startsWith("eth") || name.startsWith("en")) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String classifyRoute(InetAddress address) {
        Map<String, AddressHistoryRecord> map = this.address_history;
        synchronized (map) {
            AddressHistoryRecord best_entry;
            block10: {
                block9: {
                    if (this.address_history_update_time != 0L) break block9;
                    return "Initializing";
                }
                byte[] address_bytes = address.getAddress();
                best_entry = null;
                int best_prefix = 0;
                for (AddressHistoryRecord entry : this.address_history.values()) {
                    InetAddress other_address = entry.getAddress();
                    byte[] other_bytes = other_address.getAddress();
                    if (other_bytes.length != address_bytes.length) continue;
                    int prefix_len = 0;
                    int i = 0;
                    block6: while (i < other_bytes.length) {
                        byte b1 = address_bytes[i];
                        byte b2 = other_bytes[i];
                        if (b1 != b2) {
                            int j = 7;
                            while (j >= 1) {
                                if ((b1 >> j & 1) != (b2 >> j & 1)) break block6;
                                ++prefix_len;
                                --j;
                            }
                            break;
                        }
                        prefix_len += 8;
                        ++i;
                    }
                    if (prefix_len <= best_prefix) continue;
                    best_prefix = prefix_len;
                    best_entry = entry;
                }
                if (best_entry != null) break block10;
                return "Unknown";
            }
            return best_entry.getName(this.address_history_update_time);
        }
    }

    @Override
    public Object[] getInterfaceForAddress(InetAddress address) {
        byte[] address_bytes = address.getAddress();
        Set<NetworkInterface> interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return null;
        }
        NetworkInterface best_intf = null;
        InetAddress best_addr = null;
        int best_prefix = 0;
        for (NetworkInterface intf : interfaces) {
            Enumeration<InetAddress> addresses = intf.getInetAddresses();
            int num_addresses = 0;
            InetAddress derp = null;
            while (addresses.hasMoreElements()) {
                InetAddress other_address = addresses.nextElement();
                byte[] other_bytes = other_address.getAddress();
                if (other_bytes.length != address_bytes.length) continue;
                ++num_addresses;
                int prefix_len = 0;
                int i = 0;
                block2: while (i < other_bytes.length) {
                    byte b1 = address_bytes[i];
                    byte b2 = other_bytes[i];
                    if (b1 != b2) {
                        int j = 7;
                        while (j >= 1) {
                            if ((b1 >> j & 1) != (b2 >> j & 1)) break block2;
                            ++prefix_len;
                            --j;
                        }
                        break;
                    }
                    prefix_len += 8;
                    ++i;
                }
                if (prefix_len <= best_prefix) continue;
                best_prefix = prefix_len;
                best_intf = intf;
                best_addr = null;
                derp = other_address;
            }
            if (derp == null || num_addresses <= true) continue;
            best_addr = derp;
        }
        if (best_addr != null) {
            return new Object[]{best_intf, best_addr};
        }
        if (best_intf != null) {
            return new Object[]{best_intf};
        }
        return new Object[]{address};
    }

    @Override
    public void addPropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void addAndFirePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
        int i = 0;
        while (i < NetworkAdmin.PR_NAMES.length) {
            try {
                listener.propertyChanged(PR_NAMES[i]);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            ++i;
        }
    }

    @Override
    public void removePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Network Admin");
        try {
            writer.indent();
            try {
                writer.println("Binding Details");
                writer.indent();
                boolean enforceBind = COConfigurationManager.getBooleanParameter("Enforce Bind IP");
                writer.println("bind to: " + this.getString(this.getAllBindAddresses(false)) + ", enforce=" + enforceBind);
                writer.println("bindable: " + this.getString(this.getBindableAddresses()));
                writer.println("ipv6_enabled=" + this.IPv6_enabled);
                writer.println("ipv4_potential=" + this.hasIPV4Potential());
                writer.println("ipv6_potential=" + this.hasIPV6Potential(false) + "/" + this.hasIPV6Potential(true));
                try {
                    writer.println("single homed: " + this.getSingleHomedServiceBindAddress());
                }
                catch (Throwable e) {
                    writer.println("single homed: none");
                }
                try {
                    writer.println("single homed (4): " + this.getSingleHomedServiceBindAddress(1));
                }
                catch (Throwable e) {
                    writer.println("single homed (4): none");
                }
                try {
                    writer.println("single homed (6): " + this.getSingleHomedServiceBindAddress(2));
                }
                catch (Throwable e) {
                    writer.println("single homed (6): none");
                }
                writer.println("multi homed, nio=false: " + this.getString(this.getMultiHomedServiceBindAddresses(false)));
                writer.println("multi homed, nio=true:  " + this.getString(this.getMultiHomedServiceBindAddresses(true)));
            }
            finally {
                writer.exdent();
            }
            NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
            if (proxy == null) {
                writer.println("HTTP proxy: none");
            } else {
                writer.println("HTTP proxy: " + proxy.getName());
                try {
                    NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                    writer.println("    name: " + details.getServerName());
                    writer.println("    resp: " + details.getResponse());
                    writer.println("    auth: " + details.getAuthenticationType());
                }
                catch (NetworkAdminException e) {
                    writer.println("    failed: " + e.getLocalizedMessage());
                }
            }
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            if (socks.length == 0) {
                writer.println("Socks proxy: none");
            } else {
                int i = 0;
                while (i < socks.length) {
                    NetworkAdminSocksProxy sock = socks[i];
                    writer.println("Socks proxy: " + sock.getName());
                    try {
                        String[] versions = sock.getVersionsSupported();
                        String str = "";
                        int j = 0;
                        while (j < versions.length) {
                            str = String.valueOf(str) + (j == 0 ? "" : ",") + versions[j];
                            ++j;
                        }
                        writer.println("   version: " + str);
                    }
                    catch (NetworkAdminException e) {
                        writer.println("    failed: " + e.getLocalizedMessage());
                    }
                    ++i;
                }
            }
            try {
                NetworkAdminNATDevice[] nat_devices = this.getNATDevices(CoreFactory.getSingleton());
                writer.println("NAT Devices: " + nat_devices.length);
                int i = 0;
                while (i < nat_devices.length) {
                    NetworkAdminNATDevice device = nat_devices[i];
                    writer.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
                    ++i;
                }
            }
            catch (Exception e) {
                writer.println("Nat Devices: Can't get -> " + e.toString());
            }
            writer.println("Interfaces");
            writer.println("   " + this.getNetworkInterfacesAsString());
        }
        finally {
            writer.exdent();
        }
    }

    private String getString(InetAddress[] addresses) {
        String str = "";
        InetAddress[] inetAddressArray = addresses;
        int n = addresses.length;
        int n2 = 0;
        while (n2 < n) {
            InetAddress address = inetAddressArray[n2];
            str = String.valueOf(str) + (str.length() == 0 ? "" : ", ") + address.getHostAddress();
            ++n2;
        }
        return str;
    }

    @Override
    public void generateDiagnostics(IndentWriter iw) {
        HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
        NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
        if (proxy == null) {
            iw.println("HTTP proxy: none");
        } else {
            iw.println("HTTP proxy: " + proxy.getName());
            try {
                NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                iw.println("    name: " + details.getServerName());
                iw.println("    resp: " + details.getResponse());
                iw.println("    auth: " + details.getAuthenticationType());
            }
            catch (NetworkAdminException e) {
                iw.println("    failed: " + e.getLocalizedMessage());
            }
        }
        NetworkAdminSocksProxy[] socks = this.getSocksProxies();
        if (socks.length == 0) {
            iw.println("Socks proxy: none");
        } else {
            int i = 0;
            while (i < socks.length) {
                NetworkAdminSocksProxy sock = socks[i];
                iw.println("Socks proxy: " + sock.getName());
                try {
                    String[] versions = sock.getVersionsSupported();
                    String str = "";
                    int j = 0;
                    while (j < versions.length) {
                        str = String.valueOf(str) + (j == 0 ? "" : ",") + versions[j];
                        ++j;
                    }
                    iw.println("   version: " + str);
                }
                catch (NetworkAdminException e) {
                    iw.println("    failed: " + e.getLocalizedMessage());
                }
                ++i;
            }
        }
        try {
            NetworkAdminNATDevice[] nat_devices = this.getNATDevices(CoreFactory.getSingleton());
            iw.println("NAT Devices: " + nat_devices.length);
            int i = 0;
            while (i < nat_devices.length) {
                NetworkAdminNATDevice device = nat_devices[i];
                iw.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
                public_addresses.add(device.getExternalAddress());
                ++i;
            }
        }
        catch (Exception e) {
            iw.println("Nat Devices: Can't get -> " + e.toString());
        }
        iw.println("Interfaces");
        NetworkAdminNetworkInterface[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            networkInterface interf = (networkInterface)interfaces[i];
            iw.indent();
            try {
                interf.generateDiagnostics(iw, public_addresses);
            }
            finally {
                iw.exdent();
            }
            ++i;
        }
        iw.println("Inbound protocols: default routing");
        if (CoreFactory.isCoreRunning()) {
            InetAddress ext_addr;
            Core core = CoreFactory.getSingleton();
            NetworkAdminProtocol[] protocols = this.getInboundProtocols(core);
            int i2 = 0;
            while (i2 < protocols.length) {
                NetworkAdminProtocol protocol = protocols[i2];
                try {
                    ext_addr = this.testProtocol(protocol);
                    if (ext_addr != null) {
                        public_addresses.add(ext_addr);
                    }
                    iw.println("    " + protocol.getName() + " - " + ext_addr);
                }
                catch (NetworkAdminException e) {
                    iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                }
                ++i2;
            }
            iw.println("Outbound protocols: default routing");
            protocols = this.getOutboundProtocols(core);
            i2 = 0;
            while (i2 < protocols.length) {
                NetworkAdminProtocol protocol = protocols[i2];
                try {
                    ext_addr = this.testProtocol(protocol);
                    if (ext_addr != null) {
                        public_addresses.add(ext_addr);
                    }
                    iw.println("    " + protocol.getName() + " - " + ext_addr);
                }
                catch (NetworkAdminException e) {
                    iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                }
                ++i2;
            }
        }
        Iterator it = public_addresses.iterator();
        iw.println("Public Addresses");
        while (it.hasNext()) {
            InetAddress pub_address = (InetAddress)it.next();
            try {
                NetworkAdminASN res = this.lookupCurrentASN(pub_address);
                iw.println("    " + pub_address.getHostAddress() + " -> " + res.getAS() + "/" + res.getASName());
            }
            catch (Throwable e) {
                iw.println("    " + pub_address.getHostAddress() + " -> " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void generateDiagnostics(IndentWriter iw, NetworkAdminProtocol[] protocols) {
        int i = 0;
        while (i < protocols.length) {
            NetworkAdminProtocol protocol = protocols[i];
            iw.println("Testing " + protocol.getName());
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                iw.println("    -> OK, public address=" + ext_addr);
            }
            catch (NetworkAdminException e) {
                iw.println("    -> Failed: " + Debug.getNestedExceptionMessage(e));
            }
            ++i;
        }
    }

    @Override
    public void logNATStatus(IndentWriter iw) {
        if (CoreFactory.isCoreRunning()) {
            this.generateDiagnostics(iw, this.getInboundProtocols(CoreFactory.getSingleton()));
        }
    }

    public static void main(String[] args) {
        boolean TEST_SOCKS_PROXY = false;
        boolean TEST_HTTP_PROXY = false;
        try {
            if (TEST_SOCKS_PROXY) {
                AESocksProxy proxy = AESocksProxyFactory.create(4567, 10000L, 10000L);
                proxy.setAllowExternalConnections(true);
                System.setProperty("socksProxyHost", "localhost");
                System.setProperty("socksProxyPort", "4567");
            }
            if (TEST_HTTP_PROXY) {
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "3128");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "3128");
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("fred", "bill".toCharArray());
                    }
                });
            }
            IndentWriter iw = new IndentWriter(new PrintWriter(System.out));
            iw.setForce(true);
            COConfigurationManager.initialise();
            CoreFactory.create();
            NetworkAdmin admin = NetworkAdminImpl.getSingleton();
            admin.generateDiagnostics(iw);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static class AddressHistoryRecord {
        private final String ni_name;
        private final boolean ni_has_multiple_addresses;
        private final InetAddress address;
        private long last_seen;

        AddressHistoryRecord(NetworkInterface _ni, InetAddress _a, long _now) {
            this.ni_name = _ni.getName();
            this.address = _a;
            this.last_seen = _now;
            Enumeration<InetAddress> addresses = _ni.getInetAddresses();
            int hits = 0;
            int len = this.address.getAddress().length;
            while (addresses.hasMoreElements()) {
                if (addresses.nextElement().getAddress().length != len) continue;
                ++hits;
            }
            this.ni_has_multiple_addresses = hits > 1;
        }

        void setLastSeen(long t) {
            this.last_seen = t;
        }

        long getLastSeen() {
            return this.last_seen;
        }

        InetAddress getAddress() {
            return this.address;
        }

        String getName(long last_update) {
            String result = this.ni_name;
            if (this.ni_has_multiple_addresses) {
                result = String.valueOf(result) + "/" + this.address.getHostAddress();
            }
            if (last_update > this.last_seen) {
                result = String.valueOf(result) + " (disconnected)";
            }
            return result;
        }
    }

    protected class networkInterface
    implements NetworkAdminNetworkInterface {
        private final NetworkInterface ni;

        protected networkInterface(NetworkInterface _ni) {
            this.ni = _ni;
        }

        @Override
        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        @Override
        public String getName() {
            return this.ni.getName();
        }

        @Override
        public NetworkAdminNetworkInterfaceAddress[] getAddresses() {
            Enumeration<InetAddress> e = this.ni.getInetAddresses();
            ArrayList<networkAddress> addresses = new ArrayList<networkAddress>();
            while (e.hasMoreElements()) {
                InetAddress address = e.nextElement();
                if (address instanceof Inet6Address && !NetworkAdminImpl.this.IPv6_enabled) continue;
                addresses.add(new networkAddress(address));
            }
            return addresses.toArray(new NetworkAdminNetworkInterfaceAddress[addresses.size()]);
        }

        @Override
        public String getString() {
            String str = String.valueOf(this.getDisplayName()) + "/" + this.getName() + " [";
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            int i = 0;
            while (i < addresses.length) {
                networkAddress addr = (networkAddress)addresses[i];
                str = String.valueOf(str) + (i == 0 ? "" : ",") + addr.getAddress().getHostAddress();
                ++i;
            }
            return String.valueOf(str) + "]";
        }

        public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
            iw.println(String.valueOf(this.getDisplayName()) + "/" + this.getName());
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            int i = 0;
            while (i < addresses.length) {
                networkAddress addr = (networkAddress)addresses[i];
                iw.indent();
                try {
                    addr.generateDiagnostics(iw, public_addresses);
                }
                finally {
                    iw.exdent();
                }
                ++i;
            }
        }

        protected class networkAddress
        implements NetworkAdminNetworkInterfaceAddress {
            private final InetAddress address;

            protected networkAddress(InetAddress _address) {
                this.address = _address;
            }

            @Override
            public NetworkAdminNetworkInterface getInterface() {
                return networkInterface.this;
            }

            @Override
            public InetAddress getAddress() {
                return this.address;
            }

            @Override
            public boolean isLoopback() {
                return this.address.isLoopbackAddress();
            }

            @Override
            public NetworkAdminNode[] getRoute(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.getRoute(this.address, target, max_millis, listener);
            }

            @Override
            public NetworkAdminNode pingTarget(InetAddress target, int max_millis, NetworkAdminRouteListener listener) throws NetworkAdminException {
                return NetworkAdminImpl.this.pingTarget(this.address, target, max_millis, listener);
            }

            @Override
            public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
                return protocol.test(this);
            }

            public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
                block12: {
                    iw.println("" + this.getAddress());
                    try {
                        InetAddress res;
                        NetworkAdminProtocol protocol;
                        iw.indent();
                        if (this.isLoopback()) {
                            iw.println("Loopback - ignoring");
                            break block12;
                        }
                        iw.println("Outbound protocols: bound");
                        Core core = CoreFactory.getSingleton();
                        NetworkAdminProtocol[] protocols = NetworkAdminImpl.this.getOutboundProtocols(core);
                        int i = 0;
                        while (i < protocols.length) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                            ++i;
                        }
                        iw.println("Inbound protocols: bound");
                        protocols = NetworkAdminImpl.this.getInboundProtocols(core);
                        i = 0;
                        while (i < protocols.length) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                            ++i;
                        }
                    }
                    finally {
                        iw.exdent();
                    }
                }
            }
        }
    }

    protected static class networkNode
    implements NetworkAdminNode {
        private final InetAddress address;
        private final int distance;
        private final int rtt;

        protected networkNode(InetAddress _address, int _distance, int _millis) {
            this.address = _address;
            this.distance = _distance;
            this.rtt = _millis;
        }

        @Override
        public InetAddress getAddress() {
            return this.address;
        }

        @Override
        public boolean isLocalAddress() {
            return this.address.isLinkLocalAddress() || this.address.isSiteLocalAddress();
        }

        @Override
        public int getDistance() {
            return this.distance;
        }

        @Override
        public int getRTT() {
            return this.rtt;
        }

        protected String getString() {
            if (this.address == null) {
                return "" + this.distance;
            }
            return String.valueOf(this.distance) + "," + this.address + "[local=" + this.isLocalAddress() + "]," + this.rtt;
        }
    }
}

