/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.networkmanager.EventWaiter;
import com.biglybt.core.networkmanager.impl.RateControlledEntity;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEDiagnosticsEvidenceGenerator;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.IndentWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReadController
implements CoreStatsProvider,
AEDiagnosticsEvidenceGenerator {
    static int IDLE_SLEEP_TIME = 50;
    static boolean AGGRESIVE_READ = false;
    volatile ArrayList<RateControlledEntity> normal_priority_entities = new ArrayList();
    volatile ArrayList<RateControlledEntity> high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("ReadController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private long loop_count;
    private long wait_count;
    private long non_progress_count;
    private long progress_count;
    private long entity_check_count;
    private long last_entity_check_count;
    private final EventWaiter read_waiter = new EventWaiter();
    private int entity_count;

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.control.read.idle.time", "network.control.read.aggressive"}, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter("network.control.read.idle.time");
                AGGRESIVE_READ = COConfigurationManager.getBooleanParameter("network.control.read.aggressive");
            }
        });
    }

    public ReadController() {
        AEThread2 read_processor_thread = new AEThread2("ReadController:ReadProcessor"){

            @Override
            public void run() {
                ReadController.this.readProcessorLoop();
            }
        };
        read_processor_thread.setPriority(9);
        read_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.read.control.loop.count");
        types.add("net.read.control.np.count");
        types.add("net.read.control.p.count");
        types.add("net.read.control.wait.count");
        types.add("net.read.control.entity.count");
        types.add("net.read.control.con.count");
        types.add("net.read.control.ready.con.count");
        CoreStats.registerProvider(types, this);
        AEDiagnostics.addWeakEvidenceGenerator(this);
    }

    @Override
    public void generate(IndentWriter writer) {
        writer.println("Read Controller");
        try {
            RateControlledEntity entity;
            writer.indent();
            ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
            writer.println("normal - " + ref.size());
            int i = 0;
            while (i < ref.size()) {
                entity = ref.get(i);
                writer.println(entity.getString());
                ++i;
            }
            ref = this.high_priority_entities;
            writer.println("priority - " + ref.size());
            i = 0;
            while (i < ref.size()) {
                entity = ref.get(i);
                writer.println(entity.getString());
                ++i;
            }
        }
        finally {
            writer.exdent();
        }
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.read.control.loop.count")) {
            values.put("net.read.control.loop.count", new Long(this.loop_count));
        }
        if (types.contains("net.read.control.np.count")) {
            values.put("net.read.control.np.count", new Long(this.non_progress_count));
        }
        if (types.contains("net.read.control.p.count")) {
            values.put("net.read.control.p.count", new Long(this.progress_count));
        }
        if (types.contains("net.read.control.wait.count")) {
            values.put("net.read.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.read.control.entity.count")) {
            values.put("net.read.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.read.control.con.count") || types.contains("net.read.control.ready.con.count")) {
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            int i = 0;
            while (i < refs.length) {
                ArrayList ref = refs[i];
                int j = 0;
                while (j < ref.size()) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount(this.read_waiter);
                    ready_connections += entity.getReadyConnectionCount(this.read_waiter);
                    ++j;
                }
                ++i;
            }
            values.put("net.read.control.con.count", new Long(connections));
            values.put("net.read.control.ready.con.count", new Long(ready_connections));
        }
    }

    void readProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            ++this.loop_count;
            try {
                if (check_high_first) {
                    check_high_first = false;
                    if (this.doHighPriorityRead() || this.doNormalPriorityRead() || !this.read_waiter.waitForEvent(this.hasConnections() ? IDLE_SLEEP_TIME : 1000)) continue;
                    ++this.wait_count;
                    continue;
                }
                check_high_first = true;
                if (this.doNormalPriorityRead() || this.doHighPriorityRead() || !this.read_waiter.waitForEvent(this.hasConnections() ? IDLE_SLEEP_TIME : 1000)) continue;
                ++this.wait_count;
                continue;
            }
            catch (Throwable t) {
                Debug.out("readProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean hasConnections() {
        if (this.entity_count == 0) {
            return false;
        }
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.read_waiter) <= 0) continue;
            return true;
        }
        ref = this.normal_priority_entities;
        for (RateControlledEntity e : ref) {
            if (e.getConnectionCount(this.read_waiter) <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean doNormalPriorityRead() {
        return this.doRead(this.getNextReadyNormalPriorityEntity());
    }

    private boolean doHighPriorityRead() {
        return this.doRead(this.getNextReadyHighPriorityEntity());
    }

    private boolean doRead(RateControlledEntity ready_entity) {
        if (ready_entity != null) {
            if (AGGRESIVE_READ) {
                if (ready_entity.doProcessing(this.read_waiter, 0) > 0) {
                    ++this.progress_count;
                    return true;
                }
                ++this.non_progress_count;
                if (this.entity_check_count - this.last_entity_check_count >= (long)(this.normal_priority_entities.size() + this.high_priority_entities.size())) {
                    this.last_entity_check_count = this.entity_check_count;
                    if (this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) {
                        ++this.wait_count;
                    }
                    return false;
                }
                return true;
            }
            return ready_entity.doProcessing(this.read_waiter, 0) > 0;
        }
        return false;
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            ++this.entity_check_count;
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledEntity entity = ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList<RateControlledEntity> ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            ++this.entity_check_count;
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    public void addReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
        this.read_waiter.eventOccurred();
    }

    public boolean removeReadEntity(RateControlledEntity entity) {
        boolean found = false;
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities);
                if (high_new.remove(entity)) {
                    this.high_priority_entities = high_new;
                    found = true;
                } else {
                    Debug.out("entity not found");
                }
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities);
                if (norm_new.remove(entity)) {
                    this.normal_priority_entities = norm_new;
                    found = true;
                } else {
                    Debug.out("entity not found");
                }
            }
            this.entity_count = this.normal_priority_entities.size() + this.high_priority_entities.size();
        }
        finally {
            this.entities_mon.exit();
        }
        return found;
    }

    public int getEntityCount() {
        return this.entity_count;
    }
}

