/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.ProtocolEndpoint;
import com.biglybt.core.networkmanager.ProtocolEndpointFactory;
import com.biglybt.core.networkmanager.ProtocolEndpointHandler;
import com.biglybt.core.networkmanager.Transport;
import com.biglybt.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.biglybt.core.util.AddressUtils;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class ProtocolEndpointTCP
implements ProtocolEndpoint {
    private ConnectionEndpoint ce;
    private final InetSocketAddress address;

    public static void register() {
        ProtocolEndpointFactory.registerHandler(new ProtocolEndpointHandler(){

            @Override
            public int getType() {
                return 1;
            }

            @Override
            public ProtocolEndpoint create(InetSocketAddress address) {
                return new ProtocolEndpointTCP(address);
            }

            @Override
            public ProtocolEndpoint create(ConnectionEndpoint connection_endpoint, InetSocketAddress address) {
                return new ProtocolEndpointTCP(connection_endpoint, address);
            }
        });
    }

    ProtocolEndpointTCP(ConnectionEndpoint _ce, InetSocketAddress _address) {
        this.ce = _ce;
        this.address = _address;
        this.ce.addProtocol(this);
    }

    ProtocolEndpointTCP(InetSocketAddress _address) {
        this.ce = new ConnectionEndpoint(_address);
        this.address = _address;
        this.ce.addProtocol(this);
    }

    @Override
    public void setConnectionEndpoint(ConnectionEndpoint _ce) {
        this.ce = _ce;
        this.ce.addProtocol(this);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public InetSocketAddress getAdjustedAddress(boolean to_lan) {
        return AddressUtils.adjustTCPAddress(this.address, to_lan);
    }

    @Override
    public Transport connectOutbound(boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets, ByteBuffer initial_data, int priority, Transport.ConnectListener listener) {
        TCPTransportImpl t = new TCPTransportImpl(this, connect_with_crypto, allow_fallback, shared_secrets);
        t.connectOutbound(initial_data, listener, priority);
        return t;
    }

    @Override
    public String getDescription() {
        return this.address.toString();
    }
}

