/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.VirtualServerChannelSelector;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AEThread;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;

public class VirtualBlockingServerChannelSelector
implements VirtualServerChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private ServerSocketChannel server_channel = null;
    private final InetSocketAddress bind_address;
    private final int receive_buffer_size;
    private final VirtualServerChannelSelector.SelectListener listener;
    protected final AEMonitor this_mon = new AEMonitor("VirtualServerChannelSelector");
    private long last_accept_time;
    private boolean alert_on_fail = true;

    public VirtualBlockingServerChannelSelector(InetSocketAddress _bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        this.bind_address = _bind_address;
        this.receive_buffer_size = so_rcvbuf_size;
        this.listener = listener;
    }

    @Override
    public void setAlertOnFail(boolean b) {
        this.alert_on_fail = b;
    }

    @Override
    public void startProcessing() {
        block8: {
            try {
                this.this_mon.enter();
                if (this.isRunning()) break block8;
                try {
                    this.server_channel = ServerSocketChannel.open();
                    this.server_channel.socket().setReuseAddress(true);
                    if (this.receive_buffer_size > 0) {
                        this.server_channel.socket().setReceiveBufferSize(this.receive_buffer_size);
                    }
                    this.server_channel.socket().bind(this.bind_address, 1024);
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "TCP incoming server socket " + this.bind_address));
                    }
                    AEDiagnostics.logWithStack("seltrace", "TCP blocking server channel bound: " + this.bind_address);
                    AEThread accept_thread = new AEThread("VServerSelector:port" + this.bind_address.getPort()){

                        @Override
                        public void runSupport() {
                            VirtualBlockingServerChannelSelector.this.accept_loop();
                        }
                    };
                    accept_thread.setDaemon(true);
                    accept_thread.start();
                }
                catch (Throwable t) {
                    if (this.alert_on_fail) {
                        Debug.out(t);
                        Logger.log(new LogAlert(false, "ERROR, unable to bind TCP incoming server socket to " + this.bind_address.getAddress() + ":" + this.bind_address.getPort(), t));
                    }
                    AEDiagnostics.logWithStack("seltrace", "TCP blocking server channel failed: " + this.bind_address + " - " + Debug.getNestedExceptionMessage(t));
                }
                this.last_accept_time = SystemTime.getCurrentTime();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void stopProcessing() {
        try {
            this.this_mon.enter();
            if (this.server_channel != null) {
                try {
                    this.server_channel.close();
                    this.server_channel = null;
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * Exception decompiling
     */
    protected void accept_loop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean isRunning() {
        return this.server_channel != null && this.server_channel.isOpen();
    }

    @Override
    public InetAddress getBoundToAddress() {
        if (this.server_channel != null) {
            return this.server_channel.socket().getInetAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.server_channel != null) {
            return this.server_channel.socket().getLocalPort();
        }
        return -1;
    }

    @Override
    public long getTimeOfLastAccept() {
        return this.last_accept_time;
    }
}

