/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.networkmanager.impl.tcp;

import com.biglybt.core.logging.LogAlert;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.VirtualServerChannelSelector;
import com.biglybt.core.networkmanager.impl.tcp.VirtualAcceptSelector;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;

public class VirtualNonBlockingServerChannelSelector
implements VirtualServerChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private final List server_channels = new ArrayList();
    private final InetAddress bind_address;
    private final int start_port;
    private final int num_ports;
    private final int receive_buffer_size;
    final VirtualServerChannelSelector.SelectListener listener;
    protected final AEMonitor this_mon = new AEMonitor("VirtualNonBlockingServerChannelSelector");
    private boolean alert_on_fail = true;
    long last_accept_time;

    public VirtualNonBlockingServerChannelSelector(InetSocketAddress bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        this(bind_address.getAddress(), bind_address.getPort(), 1, so_rcvbuf_size, listener);
    }

    public VirtualNonBlockingServerChannelSelector(InetAddress _bind_address, int _start_port, int _num_ports, int _so_rcvbuf_size, VirtualServerChannelSelector.SelectListener _listener) {
        this.bind_address = _bind_address;
        this.start_port = _start_port;
        this.num_ports = _num_ports;
        this.receive_buffer_size = _so_rcvbuf_size;
        this.listener = _listener;
    }

    @Override
    public void setAlertOnFail(boolean b) {
        this.alert_on_fail = b;
    }

    @Override
    public void startProcessing() {
        block9: {
            try {
                this.this_mon.enter();
                if (this.isRunning()) break block9;
                int i = this.start_port;
                while (i < this.start_port + this.num_ports) {
                    try {
                        final ServerSocketChannel server_channel = ServerSocketChannel.open();
                        this.server_channels.add(server_channel);
                        server_channel.socket().setReuseAddress(true);
                        if (this.receive_buffer_size > 0) {
                            server_channel.socket().setReceiveBufferSize(this.receive_buffer_size);
                        }
                        server_channel.socket().bind(new InetSocketAddress(this.bind_address, i), 1024);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TCP incoming server socket " + this.bind_address));
                        }
                        server_channel.configureBlocking(false);
                        AEDiagnostics.logWithStack("seltrace", "TCP non-blocking server channel bound: " + this.bind_address + ": " + i);
                        VirtualAcceptSelector.getSingleton().register(server_channel, new VirtualAcceptSelector.AcceptListener(){

                            @Override
                            public void newConnectionAccepted(SocketChannel channel2) {
                                VirtualNonBlockingServerChannelSelector.this.last_accept_time = SystemTime.getCurrentTime();
                                VirtualNonBlockingServerChannelSelector.this.listener.newConnectionAccepted(server_channel, channel2);
                            }
                        });
                    }
                    catch (Throwable t) {
                        if (this.alert_on_fail) {
                            Debug.out(t);
                            Logger.log(new LogAlert(false, "ERROR, unable to bind TCP incoming server socket to " + this.bind_address + ":" + i, t));
                        }
                        AEDiagnostics.logWithStack("seltrace", "TCP non-blocking server channel failed: " + this.bind_address + ": " + i + " - " + Debug.getNestedExceptionMessage(t));
                    }
                    ++i;
                }
                this.last_accept_time = SystemTime.getCurrentTime();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public void stopProcessing() {
        try {
            this.this_mon.enter();
            int i = 0;
            while (i < this.server_channels.size()) {
                try {
                    ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(i);
                    VirtualAcceptSelector.getSingleton().cancel(server_channel);
                    server_channel.close();
                    AEDiagnostics.logWithStack("seltrace", "TCP non-blocking server channel unbound: " + this.bind_address + ": " + i);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
                ++i;
            }
            this.server_channels.clear();
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean isRunning() {
        if (this.server_channels.size() == 0) {
            return false;
        }
        ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(0);
        return server_channel != null && server_channel.isOpen();
    }

    @Override
    public InetAddress getBoundToAddress() {
        if (this.server_channels.size() == 0) {
            return null;
        }
        ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(0);
        return server_channel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        if (this.server_channels.size() == 0) {
            return -1;
        }
        ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(0);
        return server_channel.socket().getLocalPort();
    }

    @Override
    public long getTimeOfLastAccept() {
        return this.last_accept_time;
    }
}

