/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer;

import com.biglybt.core.config.COConfigurationManager;
import java.util.ArrayList;

public class PEPeerSource {
    public static final String PS_BT_TRACKER = "Tracker";
    public static final String PS_DHT = "DHT";
    public static final String PS_OTHER_PEER = "PeerExchange";
    public static final String PS_PLUGIN = "Plugin";
    public static final String PS_INCOMING = "Incoming";
    public static final String PS_HOLE_PUNCH = "HolePunch";
    public static final String[] PS_SOURCES = new String[]{"Tracker", "DHT", "PeerExchange", "Plugin", "Incoming", "HolePunch"};

    public static String internalise(String str) {
        if (str == null) {
            return null;
        }
        String[] stringArray = PS_SOURCES;
        int n = PS_SOURCES.length;
        int n2 = 0;
        while (n2 < n) {
            String ps = stringArray[n2];
            if (str.equalsIgnoreCase(ps)) {
                return ps;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isPeerSourceEnabledByDefault(String ps) {
        return COConfigurationManager.getBooleanParameter("Peer Source Selection Default." + ps);
    }

    public static String[] getDefaultEnabledPeerSources() {
        ArrayList<String> res = new ArrayList<String>();
        int i = 0;
        while (i < PS_SOURCES.length) {
            if (COConfigurationManager.getBooleanParameter("Peer Source Selection Default." + PS_SOURCES[i])) {
                res.add(PS_SOURCES[i]);
            }
            ++i;
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }
}

