/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peer.impl;

import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.util.Average;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.network.Connection;
import com.biglybt.pifimpl.local.network.ConnectionImpl;

public class PEPeerStatsImpl
implements PEPeerStats {
    private PEPeer owner;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private final Average data_send_speed = Average.getInstance(1000, 5);
    private final Average protocol_send_speed = Average.getInstance(1000, 5);
    private final Average receive_speed_for_choking = Average.getInstance(1000, 20);
    private final Average estimated_download_speed = Average.getInstance(5000, 100);
    private final Average estimated_upload_speed = Average.getInstance(3000, 60);
    private long total_bytes_discarded = 0L;
    private long total_bytes_downloaded = 0L;
    private long disk_read_bytes = 0L;
    private int disk_read_count = 0;
    private int disk_aggregated_read_count = 0;
    private long last_new_piece_time;

    public PEPeerStatsImpl(PEPeer _owner) {
        this.owner = _owner;
    }

    @Override
    public PEPeer getPeer() {
        return this.owner;
    }

    @Override
    public void setPeer(PEPeer peer) {
        this.owner = peer;
    }

    @Override
    public void dataBytesSent(int num_bytes) {
        this.total_data_bytes_sent += (long)num_bytes;
        this.data_send_speed.addValue(num_bytes);
    }

    @Override
    public void protocolBytesSent(int num_bytes) {
        this.total_protocol_bytes_sent += (long)num_bytes;
        this.protocol_send_speed.addValue(num_bytes);
    }

    @Override
    public void dataBytesReceived(int num_bytes) {
        this.total_data_bytes_received += (long)num_bytes;
        this.data_receive_speed.addValue(num_bytes);
        this.receive_speed_for_choking.addValue(num_bytes);
    }

    @Override
    public void protocolBytesReceived(int num_bytes) {
        this.total_protocol_bytes_received += (long)num_bytes;
        this.protocol_receive_speed.addValue(num_bytes);
    }

    @Override
    public void bytesDiscarded(int num_bytes) {
        this.total_bytes_discarded += (long)num_bytes;
    }

    @Override
    public void hasNewPiece(int piece_size) {
        this.total_bytes_downloaded += (long)piece_size;
        long connected_at = this.owner.getConnectionEstablishedMonoTime();
        if (connected_at >= 0L && SystemTime.getMonotonousTime() - connected_at > 5000L) {
            this.estimated_download_speed.addValue(piece_size);
            this.last_new_piece_time = SystemTime.getCurrentTime();
        }
    }

    @Override
    public long getEstimatedSecondsToCompletion() {
        long secs_remaining;
        long our_send_rate;
        long remaining = this.owner.getBytesRemaining();
        if (remaining == 0L) {
            return 0L;
        }
        long download_rate = this.estimated_download_speed.getAverage();
        if (download_rate < (our_send_rate = this.getDataSendRate())) {
            download_rate = our_send_rate;
        }
        if (download_rate == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.last_new_piece_time > 0L) {
            long elapsed_secs = (SystemTime.getCurrentTime() - this.last_new_piece_time) / 1000L;
            remaining -= elapsed_secs * download_rate;
        }
        if ((secs_remaining = remaining / download_rate) <= 0L) {
            secs_remaining = 1L;
        }
        return secs_remaining;
    }

    @Override
    public void statisticalSentPiece(int piece_size) {
        this.estimated_upload_speed.addValue(piece_size);
    }

    @Override
    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    @Override
    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    @Override
    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    @Override
    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    @Override
    public long getSmoothDataReceiveRate() {
        return this.receive_speed_for_choking.getAverage();
    }

    @Override
    public long getTotalBytesDiscarded() {
        return this.total_bytes_discarded;
    }

    @Override
    public long getTotalBytesDownloadedByPeer() {
        return this.total_bytes_downloaded;
    }

    @Override
    public long getEstimatedDownloadRateOfPeer() {
        return this.estimated_download_speed.getAverage();
    }

    @Override
    public long getEstimatedUploadRateOfPeer() {
        return this.estimated_upload_speed.getAverage();
    }

    @Override
    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    @Override
    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    @Override
    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    @Override
    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    @Override
    public void diskReadComplete(long bytes) {
        this.disk_read_bytes += bytes;
        ++this.disk_read_count;
        if (bytes > 0L) {
            ++this.disk_aggregated_read_count;
        }
    }

    @Override
    public int getTotalDiskReadCount() {
        return this.disk_read_count;
    }

    @Override
    public int getAggregatedDiskReadCount() {
        return this.disk_aggregated_read_count;
    }

    @Override
    public long getTotalDiskReadBytes() {
        return this.disk_read_bytes;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int bytes) {
        this.owner.setUploadRateLimitBytesPerSecond(bytes);
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int bytes) {
        this.owner.setDownloadRateLimitBytesPerSecond(bytes);
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return this.owner.getUploadRateLimitBytesPerSecond();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return this.owner.getDownloadRateLimitBytesPerSecond();
    }

    @Override
    public int getPermittedBytesToSend() {
        Connection plugin_con = this.owner.getPluginConnection();
        if (plugin_con instanceof ConnectionImpl) {
            return NetworkManager.getSingleton().getRateHandler(((ConnectionImpl)plugin_con).getCoreConnection(), true).getCurrentNumBytesAllowed()[0];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void permittedSendBytesUsed(int num) {
        Connection plugin_con = this.owner.getPluginConnection();
        if (plugin_con instanceof ConnectionImpl) {
            NetworkManager.getSingleton().getRateHandler(((ConnectionImpl)plugin_con).getCoreConnection(), true).bytesProcessed(num, 0);
        }
    }

    @Override
    public int getPermittedBytesToReceive() {
        Connection plugin_con = this.owner.getPluginConnection();
        if (plugin_con instanceof ConnectionImpl) {
            return NetworkManager.getSingleton().getRateHandler(((ConnectionImpl)plugin_con).getCoreConnection(), false).getCurrentNumBytesAllowed()[0];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void permittedReceiveBytesUsed(int num) {
        Connection plugin_con = this.owner.getPluginConnection();
        if (plugin_con instanceof ConnectionImpl) {
            NetworkManager.getSingleton().getRateHandler(((ConnectionImpl)plugin_con).getCoreConnection(), false).bytesProcessed(num, 0);
        }
    }
}

