/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.disk.DiskManager;
import com.biglybt.core.disk.DiskManagerReadRequest;
import com.biglybt.core.logging.LogEvent;
import com.biglybt.core.logging.LogIDs;
import com.biglybt.core.logging.Logger;
import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.LimitedRateGroup;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.IncomingConnectionManager;
import com.biglybt.core.networkmanager.impl.TransportHelper;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerListener;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.peer.PEPeerManagerAdapter;
import com.biglybt.core.peer.PEPeerManagerListener;
import com.biglybt.core.peer.PEPeerManagerStats;
import com.biglybt.core.peer.PEPeerStats;
import com.biglybt.core.peer.PEPiece;
import com.biglybt.core.peer.impl.PEPeerControl;
import com.biglybt.core.peer.impl.PEPeerControlHashHandler;
import com.biglybt.core.peer.impl.PEPeerStatsImpl;
import com.biglybt.core.peer.impl.PEPeerTransport;
import com.biglybt.core.peer.impl.PEPeerTransportFactory;
import com.biglybt.core.peer.util.PeerIdentityDataID;
import com.biglybt.core.peer.util.PeerIdentityManager;
import com.biglybt.core.peermanager.PeerManagerRegistration;
import com.biglybt.core.peermanager.PeerManagerRegistrationAdapter;
import com.biglybt.core.peermanager.PeerManagerRoutingListener;
import com.biglybt.core.peermanager.messaging.MessageManager;
import com.biglybt.core.peermanager.messaging.MessageStreamDecoder;
import com.biglybt.core.peermanager.messaging.MessageStreamEncoder;
import com.biglybt.core.peermanager.messaging.MessageStreamFactory;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.biglybt.core.peermanager.peerdb.PeerExchangerItem;
import com.biglybt.core.peermanager.peerdb.PeerItem;
import com.biglybt.core.peermanager.piecepicker.PiecePicker;
import com.biglybt.core.peermanager.piecepicker.util.BitFlags;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.torrent.TOTorrentFile;
import com.biglybt.core.tracker.TrackerPeerSource;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponse;
import com.biglybt.core.util.AEGenericCallback;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunStateHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.AddressUtils;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.IndentWriter;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.bloom.BloomFilter;
import com.biglybt.core.util.bloom.BloomFilterFactory;
import com.biglybt.pif.peers.PeerDescriptor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PeerManager
implements CoreStatsProvider {
    private static final LogIDs LOGID = LogIDs.PEER;
    private static final Object KEY_TRANSPORT_PROBE = new Object();
    private static final PeerManager instance = new PeerManager();
    private static final int PENDING_TIMEOUT = 10000;
    private static final AEMonitor timer_mon = new AEMonitor("PeerManager:timeouts");
    private static AEThread2 timer_thread;
    static final Set<PeerManagerRegistrationImpl> timer_targets;
    private static boolean enable_public_tcp_peers;
    private static boolean enable_public_udp_peers;
    private static boolean socks_data;
    private final Map<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>> registered_legacy_managers = new HashMap<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>>();
    private final Map<String, PeerManagerRegistrationImpl> registered_links = new HashMap<String, PeerManagerRegistrationImpl>();
    private final ByteBuffer legacy_handshake_header = ByteBuffer.allocate(20);

    static {
        timer_targets = new HashSet<PeerManagerRegistrationImpl>();
        enable_public_tcp_peers = true;
        enable_public_udp_peers = true;
        socks_data = false;
        COConfigurationManager.addAndFireParameterListeners(new String[]{"peercontrol.tcp.public.enable", "peercontrol.udp.public.enable", "Proxy.Data.Enable"}, ignore -> {
            enable_public_tcp_peers = COConfigurationManager.getBooleanParameter("peercontrol.tcp.public.enable");
            enable_public_udp_peers = COConfigurationManager.getBooleanParameter("peercontrol.udp.public.enable");
            socks_data = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable");
        });
    }

    protected static void registerForTimeouts(PeerManagerRegistrationImpl reg) {
        try {
            timer_mon.enter();
            timer_targets.add(reg);
            if (timer_thread == null) {
                timer_thread = new AEThread2("PeerManager:timeouts", true){

                    @Override
                    public void run() {
                        int idle_time = 0;
                        block6: while (true) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                timer_mon.enter();
                                if (timer_targets.size() == 0) {
                                    if ((idle_time += 1000) < 30000) continue;
                                    timer_thread = null;
                                    break;
                                }
                                idle_time = 0;
                                Iterator<PeerManagerRegistrationImpl> it = timer_targets.iterator();
                                while (true) {
                                    if (!it.hasNext()) continue block6;
                                    PeerManagerRegistrationImpl registration = it.next();
                                    if (registration.timeoutCheck()) continue;
                                    it.remove();
                                }
                            }
                            finally {
                                timer_mon.exit();
                                continue;
                            }
                            break;
                        }
                    }
                };
                timer_thread.start();
            }
        }
        finally {
            timer_mon.exit();
        }
    }

    public static PeerManager getSingleton() {
        return instance;
    }

    private PeerManager() {
        this.legacy_handshake_header.put((byte)"BitTorrent protocol".length());
        this.legacy_handshake_header.put("BitTorrent protocol".getBytes());
        this.legacy_handshake_header.flip();
        HashSet<String> types = new HashSet<String>();
        types.add("peer.manager.count");
        types.add("peer.manager.peer.count");
        types.add("peer.manager.peer.snubbed.count");
        types.add("peer.manager.peer.stalled.disk.count");
        CoreStats.registerProvider(types, this);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStats(Set types, Map values) {
        if (types.contains("peer.manager.count")) {
            values.put("peer.manager.count", new Long(this.registered_legacy_managers.size()));
        }
        if (types.contains("peer.manager.peer.count") || types.contains("peer.manager.peer.snubbed.count") || types.contains("peer.manager.peer.stalled.disk.count")) {
            long total_peers = 0L;
            long total_snubbed_peers = 0L;
            long total_stalled_pending_load = 0L;
            Map<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>> map = this.registered_legacy_managers;
            synchronized (map) {
                for (CopyOnWriteList<PeerManagerRegistrationImpl> registrations : this.registered_legacy_managers.values()) {
                    for (PeerManagerRegistrationImpl reg : registrations) {
                        PEPeerControl control = reg.getActiveControl();
                        if (control == null) continue;
                        total_peers += (long)(control.getNbPeers() + control.getNbSeeds());
                        total_snubbed_peers += (long)control.getNbPeersSnubbed();
                        total_stalled_pending_load += (long)control.getNbPeersStalledPendingLoad();
                    }
                }
            }
            if (types.contains("peer.manager.peer.count")) {
                values.put("peer.manager.peer.count", new Long(total_peers));
            }
            if (types.contains("peer.manager.peer.snubbed.count")) {
                values.put("peer.manager.peer.snubbed.count", new Long(total_snubbed_peers));
            }
            if (types.contains("peer.manager.peer.stalled.disk.count")) {
                values.put("peer.manager.peer.stalled.disk.count", new Long(total_stalled_pending_load));
            }
        }
    }

    protected void init() {
        MessageManager.getSingleton().initialize();
        NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            @Override
            public int matchThisSizeOrBigger() {
                return 48;
            }

            @Override
            public int maxSize() {
                return 48;
            }

            @Override
            public int minSize() {
                return 20;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object matches(TransportHelper transport, ByteBuffer to_compare, int local_port) {
                InetSocketAddress address = transport.getAddress();
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                PeerManagerRegistrationImpl routing_data = null;
                PeerManagerRegistrationRoutingFailed routing_failed = null;
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    CopyOnWriteList registrations;
                    to_compare.limit(old_position + 48);
                    to_compare.position(old_position + 28);
                    byte[] hash = new byte[to_compare.remaining()];
                    to_compare.get(hash);
                    HashWrapper hash_wrapper = new HashWrapper(hash);
                    Map map = PeerManager.this.registered_legacy_managers;
                    synchronized (map) {
                        registrations = (CopyOnWriteList)PeerManager.this.registered_legacy_managers.get(hash_wrapper);
                    }
                    if (registrations != null) {
                        routing_data = (PeerManagerRegistrationImpl)registrations.get(0);
                        if (registrations.size() > 1) {
                            for (PeerManagerRegistrationImpl r : registrations) {
                                PeerManagerRegistrationAdapter adapter = r.getAdapter();
                                if (adapter.getHashOverride() != null) {
                                    if (local_port != adapter.getHashOverrideLocalPort(true)) continue;
                                    routing_data = r;
                                    break;
                                }
                                routing_data = r;
                            }
                        }
                    }
                    if (routing_data == null) {
                        routing_failed = new PeerManagerRegistrationRoutingFailed(hash_wrapper);
                    }
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                if (routing_failed != null) {
                    return routing_failed;
                }
                if (routing_data != null && !routing_data.isActive()) {
                    if (routing_data.isKnownSeed(address)) {
                        String reason = "Activation request from " + address + " denied as known seed";
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, reason));
                        }
                        transport.close(reason);
                        routing_data = null;
                    } else {
                        int at = routing_data.getAdapter().activateRequest(address);
                        if (at == 0) {
                            String reason = "Activation request from " + address + " denied by rules";
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, reason));
                            }
                            transport.close(reason);
                            routing_data = null;
                        } else if (at == 2) {
                            transport.setUserData(KEY_TRANSPORT_PROBE, "");
                        }
                    }
                }
                return routing_data;
            }

            @Override
            public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                boolean matches = false;
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                to_compare.limit(old_position + 20);
                if (to_compare.equals(PeerManager.this.legacy_handshake_header)) {
                    matches = true;
                }
                to_compare.limit(old_limit);
                to_compare.position(old_position);
                return matches ? "" : null;
            }

            @Override
            public byte[][] getSharedSecrets() {
                return null;
            }

            @Override
            public int getSpecificPort() {
                return -1;
            }

            @Override
            public String getDescription() {
                return "PeerManager";
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            @Override
            public void connectionRouted(NetworkConnection connection, Object routing_data) {
                PeerManagerRegistration registration = (PeerManagerRegistration)routing_data;
                registration.route(connection, null);
            }

            @Override
            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            @Override
            public MessageStreamEncoder createEncoder() {
                return new BTMessageEncoder();
            }

            @Override
            public MessageStreamDecoder createDecoder() {
                return new BTMessageDecoder();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration manualMatchHash(InetSocketAddress address, byte[] hash) {
        PeerManagerRegistrationImpl routing_data = null;
        Map<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>> map = this.registered_legacy_managers;
        synchronized (map) {
            CopyOnWriteList<PeerManagerRegistrationImpl> registrations = this.registered_legacy_managers.get(new HashWrapper(hash));
            if (registrations != null) {
                routing_data = registrations.get(0);
            }
        }
        if (routing_data != null && !routing_data.isActive()) {
            if (routing_data.isKnownSeed(address)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Activation request from " + address + " denied as known seed"));
                }
                routing_data = null;
            } else if (routing_data.getAdapter().activateRequest(address) == 0) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Activation request from " + address + " denied by rules"));
                }
                routing_data = null;
            }
        }
        return routing_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration manualMatchLink(InetSocketAddress address, String link) {
        byte[] hash;
        Map<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>> map = this.registered_legacy_managers;
        synchronized (map) {
            PeerManagerRegistrationImpl registration;
            block4: {
                registration = this.registered_links.get(link);
                if (registration != null) break block4;
                return null;
            }
            hash = registration.getHash();
        }
        return this.manualMatchHash(address, hash);
    }

    public void manualRoute(PeerManagerRegistration _registration, NetworkConnection _connection, PeerManagerRoutingListener _listener) {
        _registration.route(_connection, _listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerManagerRegistration registerLegacyManager(HashWrapper hash, PeerManagerRegistrationAdapter adapter) {
        Map<HashWrapper, CopyOnWriteList<PeerManagerRegistrationImpl>> map = this.registered_legacy_managers;
        synchronized (map) {
            CopyOnWriteList<PeerManagerRegistrationImpl> registrations = this.registered_legacy_managers.get(hash);
            byte[][] secrets = adapter.getSecrets();
            if (registrations == null) {
                registrations = new CopyOnWriteList(1);
                this.registered_legacy_managers.put(hash, registrations);
                IncomingConnectionManager.getSingleton().addSharedSecrets(adapter.getDescription(), secrets);
            }
            PeerManagerRegistrationImpl registration = new PeerManagerRegistrationImpl(hash, adapter);
            registrations.add(registration);
            byte[] override = adapter.getHashOverride();
            if (override != null) {
                HashWrapper ov_hw = new HashWrapper(override);
                CopyOnWriteList<PeerManagerRegistrationImpl> ov_registrations = this.registered_legacy_managers.get(ov_hw);
                if (ov_registrations == null) {
                    ov_registrations = new CopyOnWriteList(1);
                    this.registered_legacy_managers.put(ov_hw, ov_registrations);
                }
                ov_registrations.add(registration);
            }
            return registration;
        }
    }

    private class PeerManagerRegistrationImpl
    implements PeerManagerRegistration {
        private final HashWrapper hash;
        private final PeerManagerRegistrationAdapter adapter;
        private final ProbeControl probe_control;
        private PEPeerControl download;
        private volatile PEPeerControl active_control;
        private List<Object[]> pending_connections;
        private BloomFilter known_seeds;
        private Map<String, TOTorrentFile> links;

        protected PeerManagerRegistrationImpl(HashWrapper _hash, PeerManagerRegistrationAdapter _adapter) {
            this.hash = _hash;
            this.adapter = _adapter;
            this.probe_control = new ProbeControl();
        }

        protected PeerManagerRegistrationAdapter getAdapter() {
            return this.adapter;
        }

        protected byte[] getHash() {
            return this.hash.getBytes();
        }

        @Override
        public int getHashOverrideLocalPort(boolean only_if_allocated) {
            return this.adapter.getHashOverrideLocalPort(only_if_allocated);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<PeerManagerRegistration> getOtherRegistrationsForHash() {
            ArrayList<PeerManagerRegistration> result = new ArrayList<PeerManagerRegistration>();
            byte[] ho_b = this.adapter.getHashOverride();
            HashWrapper hw = ho_b == null ? this.hash : new HashWrapper(ho_b);
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                CopyOnWriteList ov_registrations = (CopyOnWriteList)PeerManager.this.registered_legacy_managers.get(hw);
                if (ov_registrations != null) {
                    for (PeerManagerRegistrationImpl r : ov_registrations) {
                        if (r == this) continue;
                        result.add(r);
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TOTorrentFile getLink(String target) {
            PeerManagerRegistrationImpl peerManagerRegistrationImpl = this;
            synchronized (peerManagerRegistrationImpl) {
                block4: {
                    if (this.links != null) break block4;
                    return null;
                }
                return this.links.get(target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addLink(String link, TOTorrentFile target) throws Exception {
            Object object = PeerManager.this.registered_legacy_managers;
            synchronized (object) {
                if (PeerManager.this.registered_links.get(link) != null) {
                    throw new Exception("Duplicate link '" + link + "'");
                }
                PeerManager.this.registered_links.put(link, this);
            }
            object = this;
            synchronized (object) {
                if (this.links == null) {
                    this.links = new HashMap<String, TOTorrentFile>();
                }
                this.links.put(link, target);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeLink(String link) {
            Object object = PeerManager.this.registered_legacy_managers;
            synchronized (object) {
                PeerManager.this.registered_links.remove(link);
            }
            object = this;
            synchronized (object) {
                if (this.links != null) {
                    this.links.remove(link);
                }
            }
        }

        public boolean isActive() {
            return this.active_control != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void activate(PEPeerControl _active_control) {
            List<Object[]> connections = null;
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                this.active_control = _active_control;
                if (this.download != null) {
                    Debug.out("Already activated");
                }
                this.download = _active_control;
                connections = this.pending_connections;
                this.pending_connections = null;
            }
            if (connections != null) {
                int i = 0;
                while (i < connections.size()) {
                    Object[] entry = connections.get(i);
                    NetworkConnection nc = (NetworkConnection)entry[0];
                    PeerManagerRoutingListener listener = (PeerManagerRoutingListener)entry[2];
                    this.route(_active_control, nc, true, listener);
                    ++i;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deactivate() {
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                if (this.download == null) {
                    Debug.out("Already deactivated");
                } else {
                    this.download = null;
                }
                this.active_control = null;
                if (this.pending_connections != null) {
                    int i = 0;
                    while (i < this.pending_connections.size()) {
                        Object[] entry = this.pending_connections.get(i);
                        NetworkConnection connection = (NetworkConnection)entry[0];
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] closed due to deactivation"));
                        }
                        connection.close("deactivated");
                        ++i;
                    }
                    this.pending_connections = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregister() {
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                CopyOnWriteList registrations;
                if (this.active_control != null) {
                    Debug.out("Not deactivated");
                    this.deactivate();
                }
                if ((registrations = (CopyOnWriteList)PeerManager.this.registered_legacy_managers.get(this.hash)) == null) {
                    Debug.out("manager already deregistered");
                } else if (registrations.remove(this)) {
                    if (registrations.size() == 0) {
                        IncomingConnectionManager.getSingleton().removeSharedSecrets(this.adapter.getSecrets());
                        PeerManager.this.registered_legacy_managers.remove(this.hash);
                    }
                } else {
                    Debug.out("manager already deregistered");
                }
                byte[] override = this.adapter.getHashOverride();
                if (override != null) {
                    HashWrapper ov_hw = new HashWrapper(override);
                    CopyOnWriteList ov_registrations = (CopyOnWriteList)PeerManager.this.registered_legacy_managers.get(ov_hw);
                    if (ov_registrations == null) {
                        Debug.out("manager already deregistered");
                    } else if (!ov_registrations.remove(this)) {
                        Debug.out("manager already deregistered");
                    }
                }
                PeerManagerRegistrationImpl peerManagerRegistrationImpl = this;
                synchronized (peerManagerRegistrationImpl) {
                    if (this.links != null) {
                        Iterator<String> it = this.links.keySet().iterator();
                        while (it.hasNext()) {
                            PeerManager.this.registered_links.remove(it.next());
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean isKnownSeed(InetSocketAddress address) {
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                block4: {
                    if (this.known_seeds != null) break block4;
                    return false;
                }
                return this.known_seeds.contains(AddressUtils.getAddressBytes(address));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setKnownSeed(InetSocketAddress address) {
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                if (this.known_seeds == null) {
                    this.known_seeds = BloomFilterFactory.createAddOnly(1024);
                }
                this.known_seeds.add(AddressUtils.getAddressBytes(address));
            }
        }

        protected PEPeerControl getActiveControl() {
            return this.active_control;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void route(NetworkConnection connection, PeerManagerRoutingListener listener) {
            PEPeerControl control;
            if (this.adapter.manualRoute(connection)) {
                return;
            }
            if (!this.adapter.isPeerSourceEnabled("Incoming")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] to " + this.adapter.getDescription() + " dropped as peer source disabled"));
                }
                connection.close("peer source disabled");
                return;
            }
            boolean register_for_timeouts = false;
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                control = this.active_control;
                if (control == null) {
                    if (this.pending_connections != null && this.pending_connections.size() > 10) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] to " + this.adapter.getDescription() + " dropped too many pending activations"));
                        }
                        connection.close("too many pending activations");
                        return;
                    }
                    if (this.pending_connections == null) {
                        this.pending_connections = new ArrayList<Object[]>();
                    }
                    this.pending_connections.add(new Object[]{connection, new Long(SystemTime.getMonotonousTime()), listener});
                    if (this.pending_connections.size() == 1) {
                        register_for_timeouts = true;
                    }
                }
            }
            if (register_for_timeouts) {
                PeerManager.registerForTimeouts(this);
            }
            if (control != null) {
                this.route(control, connection, false, listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean timeoutCheck() {
            Map map = PeerManager.this.registered_legacy_managers;
            synchronized (map) {
                block8: {
                    if (this.pending_connections != null) break block8;
                    return false;
                }
                Iterator<Object[]> it = this.pending_connections.iterator();
                long now = SystemTime.getMonotonousTime();
                while (it.hasNext()) {
                    NetworkConnection connection;
                    Object[] entry = it.next();
                    long start_time = (Long)entry[1];
                    if (now - start_time > 10000L) {
                        it.remove();
                        connection = (NetworkConnection)entry[0];
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] to " + this.adapter.getDescription() + " closed due to activation timeout"));
                        }
                        connection.close("activation timeout");
                        continue;
                    }
                    connection = (NetworkConnection)entry[0];
                    Object obj = connection.getTransport().getUserData(KEY_TRANSPORT_PROBE);
                    if (obj == null) continue;
                    connection.getTransport().setUserData(KEY_TRANSPORT_PROBE, null);
                    PEPeerTransport pt = PEPeerTransportFactory.createTransport(this.probe_control, "Incoming", connection, null);
                    pt.start();
                }
                if (this.pending_connections.size() == 0) {
                    this.pending_connections = null;
                }
                return this.pending_connections != null;
            }
        }

        protected void route(PEPeerControl control, final NetworkConnection connection, boolean is_activation, PeerManagerRoutingListener listener) {
            boolean same_allowed;
            ConnectionEndpoint ep;
            InetSocketAddress is_address;
            String host_address;
            String net_cat;
            Object callback = connection.getUserData("RoutedCallback");
            if (callback instanceof AEGenericCallback) {
                try {
                    ((AEGenericCallback)callback).invoke(control);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            if (!control.isNetworkEnabled(net_cat = AENetworkClassifier.categoriseAddress(host_address = AddressUtils.getHostAddress(is_address = (ep = connection.getEndpoint()).getNotionalAddress())))) {
                connection.close("Network '" + net_cat + "' is not enabled");
                return;
            }
            if (net_cat == "Public" && socks_data) {
                boolean socks_active = NetworkAdmin.getSingleton().isSocksActive();
                boolean lan_local = connection.isLANLocal();
                if (socks_active && !lan_local) {
                    connection.close("Incoming connections not supported when SOCKS data proxy enabled");
                    return;
                }
            }
            InetAddress address_mbn = is_address.getAddress();
            boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || address_mbn != null && address_mbn.isLoopbackAddress();
            if (!same_allowed && PeerIdentityManager.containsIPAddress(control.getPeerIdentityDataID(), host_address)) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] dropped as IP address already " + "connected for [" + control.getDisplayName() + "]"));
                }
                connection.close("already connected to peer");
                return;
            }
            if (AERunStateHandler.isUDPNetworkOnly() && connection.getTransport().getTransportEndpoint().getProtocolEndpoint().getType() == 1 && !connection.isLANLocal()) {
                connection.close("limited network mode: tcp disabled");
                return;
            }
            if (!enable_public_tcp_peers && connection.getTransport().getTransportEndpoint().getProtocolEndpoint().getType() == 1) {
                boolean socks_active = NetworkAdmin.getSingleton().isSocksActive();
                boolean lan_local = connection.isLANLocal();
                if (net_cat == "Public" && !socks_active && !lan_local) {
                    connection.close("TCP public peer protocol disabled");
                    return;
                }
            }
            if (!enable_public_udp_peers && connection.getTransport().getTransportEndpoint().getProtocolEndpoint().getType() == 2) {
                connection.close("UDP public peer protocol disabled");
                return;
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Incoming connection from [" + connection + "] routed to legacy download [" + control.getDisplayName() + "]"));
            }
            PEPeerTransport pt = PEPeerTransportFactory.createTransport(control, "Incoming", connection, null);
            if (listener != null) {
                boolean ok = false;
                try {
                    if (listener.routed(pt)) {
                        ok = true;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                if (!ok) {
                    connection.close("routing denied");
                    return;
                }
            }
            pt.start();
            if (is_activation) {
                pt.addListener(new PEPeerListener(){

                    @Override
                    public void stateChanged(PEPeer peer, int new_state) {
                        if (new_state == 40 && peer.isSeed()) {
                            InetSocketAddress address = connection.getEndpoint().getNotionalAddress();
                            PeerManagerRegistrationImpl.this.setKnownSeed(address);
                            PeerManagerRegistrationImpl.this.adapter.deactivateRequest(address);
                        }
                    }

                    @Override
                    public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                    }

                    @Override
                    public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                    }

                    @Override
                    public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                    }
                });
            }
            control.addPeerTransport(pt);
        }

        private class ProbeControl
        implements PEPeerControl {
            private final LimitedRateGroup upload_limited_rate_group = new LimitedRateGroup(){

                @Override
                public String getName() {
                    return "per_dl_up: " + ProbeControl.this.getDisplayName();
                }

                @Override
                public int getRateLimitBytesPerSecond() {
                    return -1;
                }

                @Override
                public boolean isDisabled() {
                    return false;
                }

                @Override
                public void updateBytesUsed(int used) {
                }
            };
            private final LimitedRateGroup download_limited_rate_group = new LimitedRateGroup(){

                @Override
                public String getName() {
                    return "per_dl_down: " + ProbeControl.this.getDisplayName();
                }

                @Override
                public int getRateLimitBytesPerSecond() {
                    return 0;
                }

                @Override
                public boolean isDisabled() {
                    return false;
                }

                @Override
                public void updateBytesUsed(int used) {
                }
            };

            private ProbeControl() {
            }

            @Override
            public int getUID() {
                this.log();
                return 0;
            }

            @Override
            public DiskManager getDiskManager() {
                return null;
            }

            @Override
            public PiecePicker getPiecePicker() {
                return null;
            }

            @Override
            public PEPeerManagerAdapter getAdapter() {
                this.log();
                return null;
            }

            @Override
            public void informFullyConnected(PEPeer peer) {
            }

            @Override
            public String getConnectHealth(boolean verbose) {
                this.log();
                return "";
            }

            @Override
            public void start() {
                this.log();
            }

            @Override
            public void stopAll() {
                this.log();
            }

            @Override
            public byte[] getHash() {
                return PeerManagerRegistrationImpl.this.hash.getBytes();
            }

            @Override
            public String getDisplayName() {
                this.log();
                return "probe";
            }

            @Override
            public PeerIdentityDataID getPeerIdentityDataID() {
                this.log();
                return null;
            }

            @Override
            public byte[] getPeerId() {
                return PeerManagerRegistrationImpl.this.adapter.getPeerID();
            }

            @Override
            public int[] getAvailability() {
                this.log();
                return null;
            }

            @Override
            public int getAvailability(int pieceNumber) {
                this.log();
                return 0;
            }

            @Override
            public float getAvgAvail() {
                this.log();
                return 0.0f;
            }

            @Override
            public float getMinAvailability() {
                this.log();
                return 0.0f;
            }

            @Override
            public float getMinAvailability(int file_index) {
                this.log();
                return 0.0f;
            }

            @Override
            public long getAvailWentBadTime() {
                this.log();
                return 0L;
            }

            @Override
            public long getBytesUnavailable() {
                this.log();
                return 0L;
            }

            @Override
            public boolean hasDownloadablePiece() {
                this.log();
                return false;
            }

            @Override
            public int getBytesQueuedForUpload() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPeersWithUploadQueued() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPeersWithUploadBlocked() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPeersUnchoked() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPeersUnchoking() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPieces() {
                return PeerManagerRegistrationImpl.this.adapter.getNbPieces();
            }

            @Override
            public PEPiece[] getPieces() {
                this.log();
                return null;
            }

            @Override
            public PEPiece getPiece(int pieceNumber) {
                this.log();
                return null;
            }

            @Override
            public PEPeerManagerStats getStats() {
                this.log();
                return null;
            }

            @Override
            public void processTrackerResponse(TRTrackerAnnouncerResponse response) {
                this.log();
            }

            @Override
            public int getNbPeers() {
                this.log();
                return 0;
            }

            @Override
            public int getNbSeeds() {
                this.log();
                return 0;
            }

            @Override
            public int getPieceLength(int pieceNumber) {
                this.log();
                return 0;
            }

            @Override
            public long getRemaining() {
                this.log();
                return 0L;
            }

            @Override
            public long getHiddenBytes() {
                this.log();
                return 0L;
            }

            @Override
            public long getETA(boolean smoothed) {
                this.log();
                return 0L;
            }

            @Override
            public String getElapsedTime() {
                this.log();
                return "";
            }

            @Override
            public long getTimeStarted(boolean mono_time) {
                this.log();
                return 0L;
            }

            @Override
            public long getTimeStartedSeeding(boolean mono_time) {
                this.log();
                return 0L;
            }

            @Override
            public void addListener(PEPeerManagerListener l) {
                this.log();
            }

            @Override
            public void removeListener(PEPeerManagerListener l) {
                this.log();
            }

            @Override
            public void addPiece(PEPiece piece, int pieceNumber, PEPeer for_peer) {
                this.log();
            }

            @Override
            public boolean needsMD5CheckOnCompletion(int pieceNumber) {
                this.log();
                return false;
            }

            @Override
            public boolean isSeeding() {
                this.log();
                return false;
            }

            @Override
            public boolean isMetadataDownload() {
                return false;
            }

            @Override
            public int getTorrentInfoDictSize() {
                this.log();
                return 0;
            }

            @Override
            public void setTorrentInfoDictSize(int size) {
                this.log();
            }

            @Override
            public boolean isSuperSeedMode() {
                this.log();
                return false;
            }

            @Override
            public boolean canToggleSuperSeedMode() {
                this.log();
                return false;
            }

            @Override
            public void setSuperSeedMode(boolean on) {
                this.log();
            }

            @Override
            public boolean seedPieceRecheck() {
                this.log();
                return false;
            }

            @Override
            public int getNbRemoteTCPConnections() {
                this.log();
                return 0;
            }

            @Override
            public int getNbRemoteUDPConnections() {
                this.log();
                return 0;
            }

            @Override
            public int getNbRemoteUTPConnections() {
                this.log();
                return 0;
            }

            @Override
            public long getLastRemoteConnectionTime() {
                this.log();
                return 0L;
            }

            @Override
            public int getMaxNewConnectionsAllowed(String network) {
                this.log();
                return 0;
            }

            @Override
            public boolean hasPotentialConnections() {
                this.log();
                return false;
            }

            @Override
            public void dataBytesReceived(PEPeer peer, int l) {
                this.log();
            }

            @Override
            public void dataBytesSent(PEPeer peer, int l) {
                this.log();
            }

            @Override
            public void protocolBytesSent(PEPeer peer, int length) {
            }

            @Override
            public void protocolBytesReceived(PEPeer peer, int length) {
            }

            @Override
            public void discarded(PEPeer peer, int l) {
                this.log();
            }

            @Override
            public PEPeerStats createPeerStats(PEPeer owner) {
                return new PEPeerStatsImpl(owner);
            }

            @Override
            public PEPeer getMyPeer() {
                this.log();
                return null;
            }

            @Override
            public List<PEPeer> getPeers() {
                this.log();
                return null;
            }

            @Override
            public List<PEPeer> getPeers(String address) {
                this.log();
                return null;
            }

            @Override
            public int getPendingPeerCount() {
                this.log();
                return 0;
            }

            @Override
            public PeerDescriptor[] getPendingPeers() {
                this.log();
                return null;
            }

            @Override
            public PeerDescriptor[] getPendingPeers(String address) {
                this.log();
                return null;
            }

            @Override
            public void addPeer(PEPeer peer) {
                this.log();
            }

            @Override
            public void addPeer(String ip_address, int tcp_port, int udp_port, boolean use_crypto, Map user_data) {
                this.log();
            }

            @Override
            public void peerDiscovered(String peer_source, String ip_address, int tcp_port, int udp_port, boolean use_crypto) {
                this.log();
            }

            public void removePeer(PEPeer peer) {
                this.log();
            }

            @Override
            public void removePeer(PEPeer peer, String reason, int reason_code) {
                this.log();
            }

            public void peerAdded(PEPeer pc) {
                this.log();
            }

            public void peerRemoved(PEPeer pc) {
                this.log();
            }

            @Override
            public DiskManagerReadRequest createDiskManagerRequest(int pieceNumber, int offset, int length) {
                this.log();
                return null;
            }

            @Override
            public void requestCanceled(DiskManagerReadRequest item) {
                this.log();
            }

            @Override
            public void requestAdded(PEPiece piece, PEPeerTransport peer, DiskManagerReadRequest request2) {
                this.log();
            }

            @Override
            public boolean requestExists(String peer_ip, int piece_number, int offset, int length) {
                this.log();
                return false;
            }

            @Override
            public boolean validatePieceReply(PEPeerTransport originator, int pieceNumber, int offset, DirectByteBuffer data) {
                this.log();
                return true;
            }

            @Override
            public void writeBlock(int pieceNumber, int offset, DirectByteBuffer data, Object sender, boolean cancel) {
                this.log();
            }

            @Override
            public boolean isWritten(int piece_number, int offset) {
                this.log();
                return false;
            }

            @Override
            public boolean isInEndGameMode() {
                this.log();
                return false;
            }

            @Override
            public void peerConnectionClosed(PEPeerTransport peer, boolean connect_failed, boolean network_failed) {
            }

            @Override
            public PeerExchangerItem createPeerExchangeConnection(PEPeerTransport base_peer) {
                this.log();
                return null;
            }

            @Override
            public void peerVerifiedAsSelf(PEPeerTransport self) {
                this.log();
            }

            @Override
            public LimitedRateGroup getUploadLimitedRateGroup() {
                return this.upload_limited_rate_group;
            }

            @Override
            public LimitedRateGroup getDownloadLimitedRateGroup() {
                return this.download_limited_rate_group;
            }

            @Override
            public int getEffectiveUploadRateLimitBytesPerSecond() {
                this.log();
                return 0;
            }

            @Override
            public int getUploadRateLimitBytesPerSecond() {
                this.log();
                return 0;
            }

            @Override
            public int getDownloadRateLimitBytesPerSecond() {
                this.log();
                return 0;
            }

            @Override
            public Object getData(String key) {
                this.log();
                return null;
            }

            @Override
            public void setData(String key, Object value) {
                this.log();
            }

            @Override
            public int getAverageCompletionInThousandNotation() {
                this.log();
                return 0;
            }

            @Override
            public int getMaxCompletionInThousandNotation(boolean never_include_seeds) {
                this.log();
                return 0;
            }

            @Override
            public PEPeerTransport getTransportFromIdentity(byte[] peer_id) {
                this.log();
                return null;
            }

            @Override
            public PEPeerTransport getTransportFromAddress(String peer) {
                this.log();
                return null;
            }

            @Override
            public boolean getPreferUDP() {
                this.log();
                return false;
            }

            @Override
            public void setPreferUDP(boolean prefer) {
                this.log();
            }

            @Override
            public void addRateLimiter(LimitedRateGroup group, boolean upload) {
                this.log();
            }

            @Override
            public void removeRateLimiter(LimitedRateGroup group, boolean upload) {
                this.log();
            }

            @Override
            public TrackerPeerSource getTrackerPeerSource() {
                this.log();
                return null;
            }

            @Override
            public boolean isPeerSourceEnabled(String peer_source) {
                this.log();
                return true;
            }

            @Override
            public boolean isNetworkEnabled(String network) {
                this.log();
                return true;
            }

            @Override
            public int getPartitionID() {
                this.log();
                return 0;
            }

            @Override
            public void setMaskDownloadCompletion(Boolean mask) {
                this.log();
            }

            @Override
            public void removeAllPeers(String reason, int reason_code) {
                this.log();
            }

            @Override
            public boolean isDestroyed() {
                this.log();
                return false;
            }

            @Override
            public void generateEvidence(IndentWriter writer) {
                this.log();
            }

            @Override
            public void setStatsReceiver(PEPeerManager.StatsReceiver receiver) {
                this.log();
            }

            @Override
            public boolean validateReadRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
                this.log();
                return false;
            }

            @Override
            public boolean validateHintRequest(PEPeerTransport originator, int pieceNumber, int offset, int length) {
                this.log();
                return false;
            }

            @Override
            public void havePiece(int pieceNumber, int pieceLength, PEPeer pcOrigin) {
                this.log();
            }

            @Override
            public void updateSuperSeedPiece(PEPeer peer, int pieceNumber) {
                this.log();
            }

            @Override
            public int getTCPListeningPortNumber() {
                this.log();
                return 0;
            }

            @Override
            public byte[] getTargetHash() {
                return this.getHash();
            }

            @Override
            public boolean isPrivateTorrent() {
                this.log();
                return false;
            }

            @Override
            public int getExtendedMessagingMode() {
                return PeerManagerRegistrationImpl.this.adapter.getExtendedMessagingMode();
            }

            @Override
            public boolean isPeerExchangeEnabled() {
                this.log();
                return false;
            }

            @Override
            public byte[][] getSecrets(int crypto_level) {
                this.log();
                return null;
            }

            @Override
            public int getUploadPriority() {
                this.log();
                return 0;
            }

            @Override
            public int getHiddenPiece() {
                this.log();
                return 0;
            }

            @Override
            public void addPeerTransport(PEPeerTransport transport) {
                this.log();
            }

            @Override
            public int getConnectTimeout(int ct_def) {
                this.log();
                return 0;
            }

            @Override
            public int[] getMaxConnections() {
                this.log();
                return null;
            }

            @Override
            public boolean doOptimisticDisconnect(boolean pending_lan_local_peer, boolean force, String network) {
                this.log();
                return false;
            }

            @Override
            public int getNbActivePieces() {
                this.log();
                return 0;
            }

            @Override
            public int getNbPeersStalledPendingLoad() {
                this.log();
                return 0;
            }

            @Override
            public void incNbPeersSnubbed() {
                this.log();
            }

            @Override
            public void decNbPeersSnubbed() {
                this.log();
            }

            @Override
            public void setNbPeersSnubbed(int n) {
                this.log();
            }

            @Override
            public int getNbPeersSnubbed() {
                this.log();
                return 0;
            }

            @Override
            public void checkSnubbing(PEPeerTransport peer) {
                this.log();
            }

            @Override
            public void badPieceReported(PEPeerTransport originator, int piece_number) {
                this.log();
            }

            @Override
            public boolean isFastExtensionPermitted(PEPeerTransport originator) {
                this.log();
                return false;
            }

            @Override
            public void reportBadFastExtensionUse(PEPeerTransport originator) {
                this.log();
            }

            @Override
            public void statsRequest(PEPeerTransport originator, Map request2) {
                this.log();
            }

            @Override
            public void statsReply(PEPeerTransport originator, Map reply) {
                this.log();
            }

            @Override
            public boolean isRTA() {
                this.log();
                return false;
            }

            @Override
            public void peerDiscovered(PEPeerTransport finder, PeerItem pi) {
                this.log();
            }

            @Override
            public PEPeerControlHashHandler getHashHandler() {
                this.log();
                return null;
            }

            @Override
            public boolean isHolePunchOperationOK(PEPeerTransport peer, boolean is_connect) {
                this.log();
                return false;
            }

            @Override
            public void handleCloseReason(PEPeerTransport peer, boolean reason_out, int reason) {
            }

            private void log() {
                Debug.out("eh");
            }
        }
    }

    private class PeerManagerRegistrationRoutingFailed
    implements PeerManagerRegistration {
        private final HashWrapper hash;

        PeerManagerRegistrationRoutingFailed(HashWrapper _hash) {
            this.hash = _hash;
        }

        @Override
        public TOTorrentFile getLink(String link) {
            return null;
        }

        @Override
        public void removeLink(String link) {
        }

        @Override
        public void addLink(String link, TOTorrentFile target) throws Exception {
        }

        @Override
        public void route(NetworkConnection connection, PeerManagerRoutingListener listener) {
            String hash_str = ByteFormatter.nicePrint(this.hash.getHash(), true);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, 1, "Incoming connection from [" + connection + "] refused, hash " + hash_str + " unknown/inactive"));
            }
            connection.close("hash " + hash_str + " unknown/inactive");
        }

        @Override
        public void activate(PEPeerControl peer_control) {
            Debug.out("eh");
        }

        @Override
        public void deactivate() {
            Debug.out("eh");
        }

        @Override
        public void unregister() {
            Debug.out("eh");
        }

        @Override
        public List<PeerManagerRegistration> getOtherRegistrationsForHash() {
            Debug.out("eh");
            return Collections.emptyList();
        }

        @Override
        public int getHashOverrideLocalPort(boolean only_if_allocated) {
            Debug.out("eh");
            return 0;
        }
    }
}

