/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.control.impl;

import com.biglybt.core.peermanager.control.PeerControlInstance;
import com.biglybt.core.peermanager.control.SpeedTokenDispenser;
import com.biglybt.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.biglybt.core.peermanager.control.impl.SpeedTokenDispenserBasic;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PeerControlSchedulerBasic
extends PeerControlSchedulerImpl
implements CoreStatsProvider {
    private final Random random = new Random();
    private Map<PeerControlInstance, instanceWrapper> instance_map = new HashMap<PeerControlInstance, instanceWrapper>();
    private final List<instanceWrapper> pending_registrations = new ArrayList<instanceWrapper>();
    private volatile boolean registrations_changed;
    private final Object instance_lock = new Object();
    private final SpeedTokenDispenserBasic tokenDispenser = new SpeedTokenDispenserBasic();
    private long latest_time;
    private long last_lag_log;
    private long next_peer_count_time = SystemTime.getMonotonousTime();
    private long next_piece_count_time = SystemTime.getMonotonousTime();
    private volatile long peer_count_active_time = 0L;
    private volatile long piece_count_active_time = 0L;
    private volatile int[] last_peer_count = new int[2];
    private volatile int[] last_piece_count = new int[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void schedule() {
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(long time) {
                boolean count_peers = false;
                boolean count_pieces = false;
                PeerControlSchedulerBasic peerControlSchedulerBasic = PeerControlSchedulerBasic.this;
                synchronized (peerControlSchedulerBasic) {
                    if (PeerControlSchedulerBasic.this.peer_count_active_time > 0L && time >= PeerControlSchedulerBasic.this.next_peer_count_time) {
                        if (time - PeerControlSchedulerBasic.this.peer_count_active_time > 15000L) {
                            PeerControlSchedulerBasic.this.peer_count_active_time = 0L;
                        } else {
                            count_peers = true;
                            PeerControlSchedulerBasic.this.next_peer_count_time = time + 900L;
                        }
                    }
                    if (PeerControlSchedulerBasic.this.piece_count_active_time > 0L && time >= PeerControlSchedulerBasic.this.next_piece_count_time) {
                        if (time - PeerControlSchedulerBasic.this.piece_count_active_time > 15000L) {
                            PeerControlSchedulerBasic.this.piece_count_active_time = 0L;
                        } else {
                            count_pieces = true;
                            PeerControlSchedulerBasic.this.next_piece_count_time = time + 900L;
                        }
                    }
                    PeerControlSchedulerBasic.this.notify();
                }
                if (count_peers || count_pieces) {
                    int peer_count1 = 0;
                    int peer_count2 = 0;
                    int piece_count1 = 0;
                    int piece_count2 = 0;
                    Object object = PeerControlSchedulerBasic.this.instance_lock;
                    synchronized (object) {
                        for (PeerControlInstance i : PeerControlSchedulerBasic.this.instance_map.keySet()) {
                            int[] c;
                            if (count_peers) {
                                c = i.getPeerCount();
                                peer_count1 += c[0];
                                peer_count2 += c[1];
                            }
                            if (!count_pieces) continue;
                            c = i.getPieceCount();
                            piece_count1 += c[0];
                            piece_count2 += c[1];
                        }
                    }
                    if (count_peers) {
                        PeerControlSchedulerBasic.this.last_peer_count = new int[]{peer_count1, peer_count2};
                    }
                    if (count_pieces) {
                        PeerControlSchedulerBasic.this.last_piece_count = new int[]{piece_count1, piece_count2};
                    }
                }
            }
        });
        LinkedList<instanceWrapper> instances = new LinkedList<instanceWrapper>();
        long tick_count = 0L;
        long last_stats_time = SystemTime.getMonotonousTime();
        while (true) {
            if (this.registrations_changed) {
                Object object = this.instance_lock;
                synchronized (object) {
                    Iterator it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    instances.addAll(this.pending_registrations);
                    this.pending_registrations.clear();
                    this.registrations_changed = false;
                }
            }
            this.latest_time = SystemTime.getMonotonousTime();
            long current_schedule_count = this.schedule_count;
            for (instanceWrapper instanceWrapper2 : instances) {
                long target = instanceWrapper2.getNextTick();
                long diff = this.latest_time - target;
                if (diff < 0L) continue;
                ++tick_count;
                instanceWrapper2.schedule(this.latest_time);
                ++this.schedule_count;
                long new_target = target + (long)SCHEDULE_PERIOD_MILLIS;
                if (new_target <= this.latest_time) {
                    new_target = this.latest_time + target % (long)SCHEDULE_PERIOD_MILLIS;
                }
                instanceWrapper2.setNextTick(new_target);
            }
            PeerControlSchedulerBasic peerControlSchedulerBasic = this;
            synchronized (peerControlSchedulerBasic) {
                if (current_schedule_count == this.schedule_count) {
                    ++this.wait_count;
                    try {
                        long wait_start = SystemTime.getHighPrecisionCounter();
                        this.wait(SCHEDULE_PERIOD_MILLIS);
                        long wait_time = SystemTime.getHighPrecisionCounter() - wait_start;
                        this.total_wait_time += wait_time;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
            }
            long l = this.latest_time - last_stats_time;
            if (l <= 10000L) continue;
            last_stats_time = this.latest_time;
            tick_count = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper = new instanceWrapper(instance);
        wrapper.setNextTick(this.latest_time + (long)this.random.nextInt(SCHEDULE_PERIOD_MILLIS));
        Object object = this.instance_lock;
        synchronized (object) {
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper);
            this.registrations_changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(PeerControlInstance instance) {
        Object object = this.instance_lock;
        synchronized (object) {
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            instanceWrapper wrapper = (instanceWrapper)new_map.remove(instance);
            if (wrapper == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            wrapper.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
    }

    @Override
    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    @Override
    public void updateScheduleOrdering() {
    }

    @Override
    public int[] getPeerCount() {
        this.peer_count_active_time = SystemTime.getMonotonousTime();
        return this.last_peer_count;
    }

    @Override
    public int[] getPieceCount() {
        this.piece_count_active_time = SystemTime.getMonotonousTime();
        return this.last_piece_count;
    }

    protected class instanceWrapper {
        private final PeerControlInstance instance;
        private boolean unregistered;
        private long next_tick;
        private long last_schedule;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setNextTick(long t) {
            this.next_tick = t;
        }

        protected long getNextTick() {
            return this.next_tick;
        }

        protected String getName() {
            return this.instance.getName();
        }

        protected void schedule(long mono_now) {
            if (mono_now < 100000L) {
                Debug.out("eh?");
            }
            if (this.last_schedule > 0L && mono_now - this.last_schedule > 1000L && mono_now - PeerControlSchedulerBasic.this.last_lag_log > 1000L) {
                PeerControlSchedulerBasic.this.last_lag_log = mono_now;
                System.out.println("Scheduling lagging: " + (mono_now - this.last_schedule) + " - instances=" + PeerControlSchedulerBasic.this.instance_map.size());
            }
            this.last_schedule = mono_now;
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

