/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.control.impl;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.peermanager.control.PeerControlScheduler;
import com.biglybt.core.peermanager.control.impl.PeerControlSchedulerBasic;
import com.biglybt.core.peermanager.control.impl.PeerControlSchedulerPrioritised;
import com.biglybt.core.stats.CoreStats;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Debug;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class PeerControlSchedulerImpl
implements PeerControlScheduler,
CoreStatsProvider,
ParameterListener {
    private static final PeerControlSchedulerImpl[] singletons;
    protected boolean useWeights = true;
    protected long schedule_count;
    protected long wait_count;
    protected long yield_count;
    protected long total_wait_time;

    static {
        int num = COConfigurationManager.getIntParameter("peercontrol.scheduler.parallelism", 1);
        if (num < 1) {
            num = 1;
        } else if (num > 1) {
            if (COConfigurationManager.getBooleanParameter("peercontrol.scheduler.use.priorities")) {
                Debug.out("Multiple peer schedulers not supported for prioritised scheduling");
                num = 1;
            } else {
                System.out.println("Peer control scheduler parallelism=" + num);
            }
        }
        singletons = new PeerControlSchedulerImpl[num];
        int i = 0;
        while (i < singletons.length) {
            PeerControlSchedulerImpl singleton = COConfigurationManager.getBooleanParameter("peercontrol.scheduler.use.priorities") ? new PeerControlSchedulerPrioritised() : new PeerControlSchedulerBasic();
            PeerControlSchedulerImpl.singletons[i] = singleton;
            singleton.start();
            ++i;
        }
    }

    @Override
    public void parameterChanged(String parameterName) {
        this.useWeights = COConfigurationManager.getBooleanParameter("Use Request Limiting Priorities");
    }

    public static PeerControlScheduler getSingleton(int id) {
        return singletons[id % singletons.length];
    }

    public static void overrideAllWeightedPriorities(boolean b) {
        PeerControlSchedulerImpl[] peerControlSchedulerImplArray = singletons;
        int n = singletons.length;
        int n2 = 0;
        while (n2 < n) {
            PeerControlSchedulerImpl s = peerControlSchedulerImplArray[n2];
            s.overrideWeightedPriorities(b);
            ++n2;
        }
    }

    public static void updateAllScheduleOrdering() {
        PeerControlSchedulerImpl[] peerControlSchedulerImplArray = singletons;
        int n = singletons.length;
        int n2 = 0;
        while (n2 < n) {
            PeerControlSchedulerImpl s = peerControlSchedulerImplArray[n2];
            s.updateScheduleOrdering();
            ++n2;
        }
    }

    protected PeerControlSchedulerImpl() {
        COConfigurationManager.addAndFireParameterListener("Use Request Limiting Priorities", this);
        HashSet<String> types = new HashSet<String>();
        types.add("peer.control.schedule.count");
        types.add("peer.control.loop.count");
        types.add("peer.control.yield.count");
        types.add("peer.control.wait.count");
        types.add("peer.control.wait.time");
        CoreStats.registerProvider(types, this);
    }

    protected void start() {
        new AEThread2("PeerControlScheduler", true){

            @Override
            public void run() {
                PeerControlSchedulerImpl.this.schedule();
            }
        }.start();
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("peer.control.schedule.count")) {
            values.put("peer.control.schedule.count", new Long(this.schedule_count));
        }
        if (types.contains("peer.control.loop.count")) {
            values.put("peer.control.loop.count", new Long(this.wait_count + this.yield_count));
        }
        if (types.contains("peer.control.yield.count")) {
            values.put("peer.control.yield.count", new Long(this.yield_count));
        }
        if (types.contains("peer.control.wait.count")) {
            values.put("peer.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("peer.control.wait.time")) {
            values.put("peer.control.wait.time", new Long(this.total_wait_time));
        }
    }

    protected abstract void schedule();

    @Override
    public void overrideWeightedPriorities(boolean override) {
        if (override) {
            this.useWeights = false;
        } else {
            this.parameterChanged(null);
        }
    }
}

