/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.core.peermanager.control.impl;

import com.biglybt.core.peermanager.control.PeerControlInstance;
import com.biglybt.core.peermanager.control.SpeedTokenDispenser;
import com.biglybt.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.biglybt.core.peermanager.control.impl.SpeedTokenDispenserPrioritised;
import com.biglybt.core.stats.CoreStatsProvider;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.SystemTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PeerControlSchedulerPrioritised
extends PeerControlSchedulerImpl
implements CoreStatsProvider {
    private Map<PeerControlInstance, instanceWrapper> instance_map = new HashMap<PeerControlInstance, instanceWrapper>();
    final List<instanceWrapper> pending_registrations = new ArrayList<instanceWrapper>();
    private volatile boolean registrations_changed;
    private volatile long latest_time_mono;
    private final Object instance_lock = new Object();
    private final SpeedTokenDispenserPrioritised tokenDispenser = new SpeedTokenDispenserPrioritised();
    private long next_peer_count_time_mono = SystemTime.getMonotonousTime();
    private long next_piece_count_time_mono = SystemTime.getMonotonousTime();
    private volatile long peer_count_active_time_mono = 0L;
    private volatile long piece_count_active_time_mono = 0L;
    private volatile int[] last_peer_count = new int[2];
    private volatile int[] last_piece_count = new int[2];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void schedule() {
        this.latest_time_mono = SystemTime.getMonotonousTime();
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(long time_mono) {
                boolean count_peers = false;
                boolean count_pieces = false;
                PeerControlSchedulerPrioritised peerControlSchedulerPrioritised = PeerControlSchedulerPrioritised.this;
                synchronized (peerControlSchedulerPrioritised) {
                    if (PeerControlSchedulerPrioritised.this.peer_count_active_time_mono > 0L && time_mono >= PeerControlSchedulerPrioritised.this.next_peer_count_time_mono) {
                        if (time_mono - PeerControlSchedulerPrioritised.this.peer_count_active_time_mono > 15000L) {
                            PeerControlSchedulerPrioritised.this.peer_count_active_time_mono = 0L;
                        } else {
                            count_peers = true;
                            PeerControlSchedulerPrioritised.this.next_peer_count_time_mono = time_mono + 900L;
                        }
                    }
                    if (PeerControlSchedulerPrioritised.this.piece_count_active_time_mono > 0L && time_mono >= PeerControlSchedulerPrioritised.this.next_piece_count_time_mono) {
                        if (time_mono - PeerControlSchedulerPrioritised.this.piece_count_active_time_mono > 15000L) {
                            PeerControlSchedulerPrioritised.this.piece_count_active_time_mono = 0L;
                        } else {
                            count_pieces = true;
                            PeerControlSchedulerPrioritised.this.next_piece_count_time_mono = time_mono + 900L;
                        }
                    }
                    PeerControlSchedulerPrioritised.this.latest_time_mono = time_mono;
                    if (PeerControlSchedulerPrioritised.this.instance_map.size() > 0 || PeerControlSchedulerPrioritised.this.pending_registrations.size() > 0) {
                        PeerControlSchedulerPrioritised.this.notify();
                    }
                }
                if (count_peers || count_pieces) {
                    int peer_count1 = 0;
                    int peer_count2 = 0;
                    int piece_count1 = 0;
                    int piece_count2 = 0;
                    Object object = PeerControlSchedulerPrioritised.this.instance_lock;
                    synchronized (object) {
                        for (PeerControlInstance i : PeerControlSchedulerPrioritised.this.instance_map.keySet()) {
                            int[] c;
                            if (count_peers) {
                                c = i.getPeerCount();
                                peer_count1 += c[0];
                                peer_count2 += c[1];
                            }
                            if (!count_pieces) continue;
                            c = i.getPieceCount();
                            piece_count1 += c[0];
                            piece_count2 += c[1];
                        }
                    }
                    if (count_peers) {
                        PeerControlSchedulerPrioritised.this.last_peer_count = new int[]{peer_count1, peer_count2};
                    }
                    if (count_pieces) {
                        PeerControlSchedulerPrioritised.this.last_piece_count = new int[]{piece_count1, piece_count2};
                    }
                }
            }
        });
        ArrayList<instanceWrapper> instances = new ArrayList<instanceWrapper>();
        long latest_time_used_mono = 0L;
        int scheduledNext = 0;
        long currentScheduleStartMono = this.latest_time_mono;
        long last_stats_time_mono = this.latest_time_mono;
        while (true) {
            if (this.registrations_changed) {
                Object object = this.instance_lock;
                synchronized (object) {
                    Iterator it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    instances.addAll(this.pending_registrations);
                    this.pending_registrations.clear();
                    Collections.sort(instances);
                    if (instances.size() > 0) {
                        int i = 0;
                        while (i < instances.size()) {
                            ((instanceWrapper)instances.get(i)).setScheduleOffset(SCHEDULE_PERIOD_MILLIS * i / instances.size());
                            ++i;
                        }
                    }
                    scheduledNext = 0;
                    currentScheduleStartMono = this.latest_time_mono;
                    this.registrations_changed = false;
                }
            }
            this.tokenDispenser.update(this.latest_time_mono);
            int i22 = scheduledNext;
            while (i22 < instances.size()) {
                instanceWrapper inst = (instanceWrapper)instances.get(i22);
                if (currentScheduleStartMono + inst.getScheduleOffset() > latest_time_used_mono) break;
                if (i22 == 0 || !this.useWeights) {
                    this.tokenDispenser.refill();
                }
                inst.schedule();
                ++this.schedule_count;
                if (++scheduledNext >= instances.size()) {
                    scheduledNext = 0;
                    if (latest_time_used_mono - (currentScheduleStartMono += (long)SCHEDULE_PERIOD_MILLIS) > (long)SCHEDULE_PERIOD_MAX_CATCHUP) {
                        currentScheduleStartMono = latest_time_used_mono + (long)SCHEDULE_PERIOD_MILLIS;
                    }
                }
                ++i22;
            }
            PeerControlSchedulerPrioritised i22 = this;
            synchronized (i22) {
                if (this.latest_time_mono == latest_time_used_mono) {
                    ++this.wait_count;
                    try {
                        long wait_start = SystemTime.getHighPrecisionCounter();
                        this.wait(5000L);
                        long wait_time = SystemTime.getHighPrecisionCounter() - wait_start;
                        this.total_wait_time += wait_time;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
                latest_time_used_mono = this.latest_time_mono;
            }
            long stats_diff = latest_time_used_mono - last_stats_time_mono;
            if (stats_diff <= 10000L) continue;
            last_stats_time_mono = latest_time_used_mono;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper = new instanceWrapper(instance);
        Object object = this.instance_lock;
        synchronized (object) {
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper);
            this.registrations_changed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(PeerControlInstance instance) {
        Object object = this.instance_lock;
        synchronized (object) {
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            instanceWrapper wrapper = (instanceWrapper)new_map.remove(instance);
            if (wrapper == null) {
                Debug.out("instance wrapper not found");
                return;
            }
            wrapper.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
    }

    @Override
    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    @Override
    public void updateScheduleOrdering() {
        this.registrations_changed = true;
    }

    @Override
    public int[] getPeerCount() {
        this.peer_count_active_time_mono = SystemTime.getMonotonousTime();
        return this.last_peer_count;
    }

    @Override
    public int[] getPieceCount() {
        this.piece_count_active_time_mono = SystemTime.getMonotonousTime();
        return this.last_piece_count;
    }

    protected static class instanceWrapper
    implements Comparable<instanceWrapper> {
        private final PeerControlInstance instance;
        private boolean unregistered;
        private long offset;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setScheduleOffset(long t) {
            this.offset = t;
        }

        protected long getScheduleOffset() {
            return this.offset;
        }

        protected PeerControlInstance getInstance() {
            return this.instance;
        }

        protected void schedule() {
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }

        @Override
        public int compareTo(instanceWrapper o) {
            return this.instance.getSchedulePriority() - o.instance.getSchedulePriority();
        }
    }
}

